/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import megamek.common.Compute;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.common.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomArmyCreator {
    static Comparator<MechSummary> bvComparator = new Comparator<MechSummary>(){

        @Override
        public int compare(MechSummary mechSummary, MechSummary mechSummary2) {
            if (mechSummary.getBV() > mechSummary2.getBV()) {
                return 1;
            }
            if (mechSummary2.getBV() > mechSummary.getBV()) {
                return -1;
            }
            return 0;
        }
    };

    private static ArrayList<MechSummary> generateArmy(ArrayList<MechSummary> arrayList, int n, int n2, int n3) {
        int n4;
        int n5;
        ArrayList<MechSummary> arrayList2 = new ArrayList<MechSummary>();
        if (n < 1 || arrayList.size() < 1) {
            return arrayList2;
        }
        int[] nArray = new int[n];
        int n6 = 0;
        for (n5 = 0; n5 < n; ++n5) {
            nArray[n5] = Compute.randomInt(arrayList.size());
            n6 += arrayList.get(nArray[n5]).getBV();
        }
        Arrays.sort(nArray);
        n5 = 0;
        int n7 = arrayList.size() - 1;
        int n8 = 0;
        while ((n6 < n2 - n3 || n6 > n2) && n8++ < 40000 && n7 != n5) {
            if (n6 < n2 - n3) {
                n5 = Math.max(n5, nArray[0]);
                n6 = 0;
                for (n4 = 0; n4 < n; ++n4) {
                    nArray[n4] = Compute.randomInt(n7 - n5) + n5;
                    n6 += arrayList.get(nArray[n4]).getBV();
                }
            } else if (n6 > n2) {
                n7 = Math.min(n7, nArray[nArray.length - 1]);
                n6 = 0;
                for (n4 = 0; n4 < n; ++n4) {
                    nArray[n4] = Compute.randomInt(n7 - n5) + n5;
                    n6 += arrayList.get(nArray[n4]).getBV();
                }
            }
            Arrays.sort(nArray);
        }
        for (n4 = 0; n4 < n; ++n4) {
            MechSummary mechSummary = arrayList.get(nArray[n4]);
            arrayList2.add(mechSummary);
        }
        return arrayList2;
    }

    private static int countBV(ArrayList<MechSummary> arrayList) {
        int n = 0;
        for (MechSummary mechSummary : arrayList) {
            n += mechSummary.getBV();
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Parameters parameters = new Parameters();
        parameters.mechs = 4;
        parameters.tanks = 4;
        parameters.infantry = 0;
        parameters.ba = 4;
        parameters.maxBV = 8000;
        parameters.minBV = 7600;
        parameters.minYear = 3050;
        parameters.maxYear = 3055;
        parameters.tech = 1;
        parameters.canon = true;
        parameters.padWithInfantry = true;
        ArrayList<MechSummary> arrayList = RandomArmyCreator.generateArmy(parameters);
        int n = 0;
        for (MechSummary mechSummary : arrayList) {
            n += mechSummary.getBV();
            System.out.print(mechSummary.getChassis());
            System.out.print(" ");
            System.out.print(mechSummary.getModel());
            System.out.print(" ");
            System.out.println(mechSummary.getBV());
        }
        System.out.print("Total: ");
        System.out.println(n);
    }

    public static ArrayList<MechSummary> generateArmy(Parameters parameters) {
        int n = Math.abs(parameters.maxBV - parameters.minBV);
        MechSummary[] mechSummaryArray = MechSummaryCache.getInstance().getAllMechs();
        ArrayList<MechSummary> arrayList = new ArrayList<MechSummary>();
        ArrayList<MechSummary> arrayList2 = new ArrayList<MechSummary>();
        ArrayList<MechSummary> arrayList3 = new ArrayList<MechSummary>();
        ArrayList<MechSummary> arrayList4 = new ArrayList<MechSummary>();
        for (MechSummary mechSummary : mechSummaryArray) {
            if (parameters.tech != 11 && parameters.tech != mechSummary.getType()) {
                if (parameters.tech == 6) {
                    if (mechSummary.getType() != 2) {
                        continue;
                    }
                } else if (parameters.tech == 5) {
                    if (mechSummary.getType() != 0 && mechSummary.getType() != 1) {
                        continue;
                    }
                } else if (parameters.tech == 1) {
                    if (mechSummary.getType() != 0) {
                        continue;
                    }
                } else if (parameters.tech != 4 ? parameters.tech != 3 || mechSummary.getType() != 0 && mechSummary.getType() != 1 : mechSummary.getType() != 0 && mechSummary.getType() != 1 && mechSummary.getType() != 2) continue;
            }
            if ((mechSummary.getYear() < parameters.minYear || mechSummary.getYear() > parameters.maxYear) && !mechSummary.getUnitType().equals(UnitType.getTypeName(3)) || parameters.canon && !mechSummary.isCanon()) continue;
            if (mechSummary.getUnitType().equals(UnitType.getTypeName(0))) {
                arrayList.add(mechSummary);
                continue;
            }
            if (mechSummary.getUnitType().equals(UnitType.getTypeName(1)) || mechSummary.getUnitType().equals(UnitType.getTypeName(5))) {
                arrayList2.add(mechSummary);
                continue;
            }
            if (mechSummary.getUnitType().equals(UnitType.getTypeName(2))) {
                arrayList4.add(mechSummary);
                continue;
            }
            if (!mechSummary.getUnitType().equals(UnitType.getTypeName(3))) continue;
            arrayList3.add(mechSummary);
        }
        Collections.sort(arrayList, bvComparator);
        Collections.sort(arrayList2, bvComparator);
        Collections.sort(arrayList3, bvComparator);
        Collections.sort(arrayList4, bvComparator);
        int n2 = RandomArmyCreator.countBV(arrayList) / Math.max(1, arrayList.size());
        int n3 = RandomArmyCreator.countBV(arrayList2) / Math.max(1, arrayList2.size());
        int n4 = RandomArmyCreator.countBV(arrayList3) / Math.max(1, arrayList3.size());
        int n5 = RandomArmyCreator.countBV(arrayList4) / Math.max(1, arrayList4.size());
        int n6 = Math.max(1, parameters.mechs * n2 + parameters.tanks * n3 + parameters.infantry * n4 + parameters.tanks * n3);
        int n7 = parameters.ba * n5 * parameters.maxBV / n6;
        if (parameters.ba > 0 && arrayList4.size() > 0) {
            n7 = Math.max(n7, parameters.ba * arrayList4.get(0).getBV());
            n7 = Math.min(n7, parameters.ba * arrayList4.get(arrayList4.size() - 1).getBV());
        } else {
            n7 = 0;
        }
        int n8 = parameters.mechs * n2 * parameters.maxBV / n6;
        if (parameters.mechs > 0 && arrayList.size() > 0) {
            n8 = Math.max(n8, parameters.mechs * arrayList.get(0).getBV());
            n8 = Math.min(n8, parameters.mechs * arrayList.get(arrayList.size() - 1).getBV());
        } else {
            n8 = 0;
        }
        int n9 = parameters.tanks * n3 * parameters.maxBV / n6;
        if (parameters.tanks > 0 && arrayList2.size() > 0) {
            n9 = Math.max(n9, parameters.tanks * arrayList2.get(0).getBV());
            n9 = Math.min(n9, parameters.tanks * arrayList2.get(arrayList2.size() - 1).getBV());
        } else {
            n9 = 0;
        }
        ArrayList<MechSummary> arrayList5 = RandomArmyCreator.generateArmy(arrayList4, parameters.ba, n7, n);
        arrayList5.addAll(RandomArmyCreator.generateArmy(arrayList2, parameters.tanks, n9 + n7 - RandomArmyCreator.countBV(arrayList5), n));
        arrayList5.addAll(RandomArmyCreator.generateArmy(arrayList, parameters.mechs, n8 + n9 + n7 - RandomArmyCreator.countBV(arrayList5), n));
        if (parameters.padWithInfantry) {
            int n10 = (parameters.maxBV - RandomArmyCreator.countBV(arrayList5)) / n4;
            arrayList5.addAll(RandomArmyCreator.generateArmy(arrayList3, n10, parameters.maxBV - RandomArmyCreator.countBV(arrayList5), n));
        } else {
            arrayList5.addAll(RandomArmyCreator.generateArmy(arrayList3, parameters.infantry, parameters.maxBV - RandomArmyCreator.countBV(arrayList5), n));
        }
        return arrayList5;
    }

    public static class Parameters {
        public int mechs;
        public int tanks;
        public int ba;
        public int infantry;
        public int maxBV;
        public int minBV;
        public int maxYear = 9999;
        public int minYear = 0;
        public int tech;
        public boolean canon;
        public boolean padWithInfantry;
    }
}

