/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.HitData;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACAPHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = -4251291510045646817L;
    protected int generalDamageType = -6;

    public ACAPHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected int calcDamagePerHit() {
        double d = this.wtype.getDamage();
        if (this.ae instanceof BattleArmor && this.weapon.getLocation() == 0 && this.ae.getSwarmTargetId() == this.target.getTargetId()) {
            d *= (double)((BattleArmor)this.ae).getShootingStrength();
        }
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            d = Compute.directBlowInfantryDamage(d, this.bDirect ? this.toHit.getMoS() / 3 : 0, 0, ((Infantry)this.target).isMechanized());
        } else if (this.bDirect) {
            d = Math.min(d + (double)(this.toHit.getMoS() / 3), d * 2.0);
        }
        if (this.bGlancing) {
            d = (int)Math.floor(d / 2.0);
        }
        if (this.game.getOptions().booleanOption("tacops_range") && this.nRange > this.wtype.getRanges(this.weapon)[3]) {
            d = (int)Math.floor(d * 0.75);
        }
        return (int)d;
    }

    @Override
    protected void handleEntityDamage(Entity entity, Vector<Report> vector, Building building, int n, int n2, int n3, int n4) {
        int n5;
        AmmoType ammoType = (AmmoType)this.weapon.getLinked().getType();
        HitData hitData = entity.rollHitLocation(this.toHit.getHitTable(), this.toHit.getSideTable(), this.waa.getAimedLocation(), this.waa.getAimingMode());
        hitData.setGeneralDamageType(this.generalDamageType);
        this.r = new Report(3405);
        this.r.subject = this.subjectId;
        this.r.add(this.toHit.getTableDesc());
        this.r.add(entity.getLocationAbbr(hitData));
        this.r.newlines = 0;
        vector.addElement(this.r);
        if (hitData.hitAimedLocation()) {
            this.r = new Report(3410);
            this.r.subject = this.subjectId;
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        int n6 = n3 * Math.min(n2, n);
        if (this.bDirect && (!(this.target instanceof Infantry) || this.target instanceof BattleArmor)) {
            hitData.makeDirectBlow(this.toHit.getMoS() / 3);
        }
        if (n4 > 0) {
            n5 = Math.min(n4, n6);
            n6 -= n5;
            Report.addNewline(vector);
            Vector<Report> vector2 = this.server.damageBuilding(building, n5, entity.getPosition());
            for (Report report : vector2) {
                report.subject = this.subjectId;
            }
            vector.addAll(vector2);
        }
        if ((n6 = this.checkTerrain(n6, entity, vector)) == 0) {
            this.r = new Report(3415);
            this.r.subject = this.subjectId;
            this.r.indent(2);
            this.r.addDesc(entity);
            this.r.newlines = 0;
            vector.addElement(this.r);
        } else {
            n5 = 0;
            if (this.bGlancing) {
                hitData.makeGlancingBlow();
                n5 -= 2;
            } else if (this.bDirect) {
                n5 += this.toHit.getMoS() / 3;
            }
            hitData.makeArmorPiercing(ammoType, n5);
            vector.addAll(this.server.damageEntity(entity, hitData, n6, false, this.ae.getSwarmTargetId() == entity.getId() ? Server.DamageType.IGNORE_PASSENGER : this.damageType, false, false, this.throughFront));
        }
    }
}

