/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.AmmoType;
import megamek.common.IGame;
import megamek.common.Mounted;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.ACAPHandler;
import megamek.common.weapons.ACFlakHandler;
import megamek.common.weapons.ACFlechetteHandler;
import megamek.common.weapons.ACIncendiaryHandler;
import megamek.common.weapons.ACTracerHandler;
import megamek.common.weapons.ACWeaponHandler;
import megamek.common.weapons.AmmoWeapon;
import megamek.common.weapons.AttackHandler;
import megamek.common.weapons.RapidfireACWeaponHandler;
import megamek.server.Server;

public abstract class ACWeapon
extends AmmoWeapon {
    private static final long serialVersionUID = 1537808266032711407L;

    public ACWeapon() {
        this.flags |= 0x10001L;
        this.ammoType = 1;
        this.explosive = true;
        this.atClass = 7;
    }

    protected AttackHandler getCorrectHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        AmmoType ammoType = (AmmoType)iGame.getEntity(weaponAttackAction.getEntityId()).getEquipment(weaponAttackAction.getWeaponId()).getLinked().getType();
        Mounted mounted = iGame.getEntity(weaponAttackAction.getEntityId()).getEquipment(weaponAttackAction.getWeaponId());
        if (mounted.curMode().equals("Rapid")) {
            return new RapidfireACWeaponHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 2L) {
            return new ACAPHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 4L) {
            return new ACFlechetteHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 8L) {
            return new ACIncendiaryHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 32L) {
            return new ACTracerHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 64L) {
            return new ACFlakHandler(toHitData, weaponAttackAction, iGame, server);
        }
        return new ACWeaponHandler(toHitData, weaponAttackAction, iGame, server);
    }
}

