/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.HitData;
import megamek.common.IGame;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.MGHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MGAWeaponHandler
extends MGHandler {
    private static final long serialVersionUID = 8675420566952393440L;
    int howManyShots;
    HitData hit;

    public MGAWeaponHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected void useAmmo() {
        this.setDone();
        this.checkAmmo();
        this.howManyShots = this.weapon.getCurrentShots();
        int n = this.ae.getTotalAmmoOfType(this.ammo.getType());
        if (n <= this.howManyShots) {
            this.howManyShots = n;
        }
        int n2 = this.howManyShots;
        if (this.ammo.getShotsLeft() == 0) {
            this.ae.loadWeapon(this.weapon);
            this.ammo = this.weapon.getLinked();
        }
        while (n2 > this.ammo.getShotsLeft()) {
            n2 -= this.ammo.getShotsLeft();
            this.ammo.setShotsLeft(0);
            this.ae.loadWeapon(this.weapon);
            this.ammo = this.weapon.getLinked();
        }
        this.ammo.setShotsLeft(this.ammo.getShotsLeft() - n2);
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        int n;
        int n2 = 0;
        if (this.game.getPlanetaryConditions().hasEMI()) {
            n2 -= 2;
        }
        switch (this.howManyShots) {
            case 1: {
                n = 1;
                break;
            }
            default: {
                n = this.allShotsHit() ? this.howManyShots : Compute.missilesHit(this.howManyShots, n2);
                this.r = new Report(3325);
                this.r.subject = this.subjectId;
                this.r.add(n);
                this.r.add(" shot(s) ");
                this.r.add(this.toHit.getTableDesc());
                this.r.newlines = 0;
                vector.addElement(this.r);
                this.r = new Report(3345);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            }
        }
        this.bSalvo = true;
        return n;
    }

    @Override
    protected void addHeat() {
        for (int i = 0; i < this.howManyShots; ++i) {
            super.addHeat();
        }
    }

    @Override
    protected void handleEntityDamage(Entity entity, Vector<Report> vector, Building building, int n, int n2, int n3, int n4) {
        if (this.hit == null) {
            this.hit = entity.rollHitLocation(this.toHit.getHitTable(), this.toHit.getSideTable(), this.waa.getAimedLocation(), this.waa.getAimingMode());
        }
        this.hit.setGeneralDamageType(this.generalDamageType);
        if (!this.bSalvo) {
            this.r = new Report(3405);
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getTableDesc());
            this.r.add(entity.getLocationAbbr(this.hit));
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        if (this.hit.hitAimedLocation()) {
            this.r = new Report(3410);
            this.r.subject = this.subjectId;
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        int n5 = n3 * Math.min(n2, n);
        if (n4 > 0) {
            int n6 = Math.min(n4, n5);
            n5 -= n6;
            Report.addNewline(vector);
            Vector<Report> vector2 = this.server.damageBuilding(building, n6, entity.getPosition());
            for (Report report : vector2) {
                report.subject = this.subjectId;
            }
            vector.addAll(vector2);
        }
        if ((n5 = this.checkTerrain(n5, entity, vector)) == 0) {
            this.r = new Report(3415);
            this.r.subject = this.subjectId;
            this.r.indent(2);
            this.r.addDesc(entity);
            this.r.newlines = 0;
            vector.addElement(this.r);
        } else {
            if (this.bGlancing) {
                this.hit.makeGlancingBlow();
            }
            vector.addAll(this.server.damageEntity(entity, this.hit, n5, false, this.ae.getSwarmTargetId() == entity.getId() ? Server.DamageType.IGNORE_PASSENGER : this.damageType, false, false, this.throughFront));
        }
    }
}

