/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.Aero;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.RangeType;
import megamek.common.Report;
import megamek.common.TargetRoll;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.common.weapons.AttackHandler;
import megamek.common.weapons.Weapon;
import megamek.common.weapons.WeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissileWeaponHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = -4801130911083653548L;
    String sSalvoType = " missile(s) ";
    boolean amsEnganged = false;
    int nSalvoBonus = 0;
    boolean advancedAMS = false;

    public MissileWeaponHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
        this.generalDamageType = -4;
        this.advancedAMS = iGame.getOptions().booleanOption("tacops_ams");
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        int n;
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            if (this.ae instanceof BattleArmor) {
                this.bSalvo = true;
                this.r = new Report(3325);
                this.r.subject = this.subjectId;
                this.r.add(this.wtype.getRackSize() * ((BattleArmor)this.ae).getShootingStrength());
                this.r.add(this.sSalvoType);
                this.r.add(" ");
                this.r.newlines = 0;
                vector.add(this.r);
                return ((BattleArmor)this.ae).getShootingStrength();
            }
            this.r = new Report(3325);
            this.r.subject = this.subjectId;
            this.r.add(this.wtype.getRackSize());
            this.r.add(this.sSalvoType);
            this.r.add(" ");
            this.r.newlines = 0;
            vector.add(this.r);
            return 1;
        }
        Entity entity = this.target.getTargetType() == 0 ? (Entity)this.target : null;
        int n2 = this.nSalvoBonus;
        boolean bl = this.game.getOptions().booleanOption("tacops_clusterhitpen");
        int[] nArray = this.wtype.getRanges(this.weapon);
        if (bl) {
            n2 = this.nRange <= 1 ? ++n2 : (this.nRange <= nArray[2] ? (n2 += 0) : --n2);
        }
        if (this.game.getOptions().booleanOption("tacops_range") && this.nRange > nArray[3]) {
            n2 -= 2;
        }
        boolean bl2 = false;
        if (this.ae instanceof Mech) {
            bl2 = this.ae.isStealthActive();
        }
        Mounted mounted = this.weapon.getLinkedBy();
        AmmoType ammoType = (AmmoType)this.ammo.getType();
        boolean bl3 = false;
        if (Compute.isAffectedByECM(this.ae, this.ae.getPosition(), this.target.getPosition())) {
            bl3 = true;
        }
        if (mounted != null && mounted.getType() instanceof MiscType && !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached() && mounted.getType().hasFlag(512L) && ammoType.getMunitionType() == 8192L) {
            if (bl3) {
                this.r = new Report(3330);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else if (bl2) {
                this.r = new Report(3335);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else {
                n2 += 2;
            }
        } else if (mounted != null && mounted.getType() instanceof MiscType && !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached() && mounted.getType().hasFlag(0x1000000000000L) && ammoType.getAmmoType() == 12) {
            --n2;
        } else if (ammoType.getAmmoType() == 28) {
            if (bl3) {
                this.r = new Report(3330);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else if (bl2) {
                this.r = new Report(3335);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else {
                n2 += 2;
            }
        } else if (entity != null && (entity.isNarcedBy(this.ae.getOwner().getTeam()) || entity.isINarcedBy(this.ae.getOwner().getTeam()))) {
            boolean bl4 = false;
            bl4 = Compute.isAffectedByECM(this.ae, this.target.getPosition(), this.target.getPosition());
            if (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 9 || ammoType.getAmmoType() == 45 && ammoType.getMunitionType() == 4096L && (this.weapon.curMode() == null || !this.weapon.curMode().equals("Indirect"))) {
                if (bl4) {
                    this.r = new Report(3330);
                    this.r.subject = this.subjectId;
                    this.r.newlines = 0;
                    vector.addElement(this.r);
                } else {
                    n2 += 2;
                }
            }
        }
        if (this.bGlancing) {
            n2 -= 4;
        }
        if (this.bDirect) {
            n2 += this.toHit.getMoS() / 3 * 2;
        }
        if (this.game.getPlanetaryConditions().hasEMI()) {
            n2 -= 2;
        }
        if ((n = this.allShotsHit() ? this.wtype.getRackSize() : (this.ae instanceof BattleArmor ? Compute.missilesHit(this.wtype.getRackSize() * ((BattleArmor)this.ae).getShootingStrength(), n2, this.weapon.isHotLoaded(), false, this.advancedAMS) : Compute.missilesHit(this.wtype.getRackSize(), n2 += this.getAMSHitsMod(vector), this.weapon.isHotLoaded(), false, this.advancedAMS))) > 0) {
            this.r = new Report(3325);
            this.r.subject = this.subjectId;
            this.r.add(n);
            this.r.add(this.sSalvoType);
            this.r.add(this.toHit.getTableDesc());
            this.r.newlines = 0;
            vector.addElement(this.r);
            if (n2 != 0) {
                this.r = n2 > 0 ? new Report(3340) : new Report(3341);
                this.r.subject = this.subjectId;
                this.r.add(n2);
                this.r.newlines = 0;
                vector.addElement(this.r);
            }
        }
        this.r = new Report(3345);
        this.r.subject = this.subjectId;
        this.r.newlines = 0;
        vector.addElement(this.r);
        this.bSalvo = true;
        return n;
    }

    @Override
    protected int calcnCluster() {
        return 5;
    }

    @Override
    protected int calcDamagePerHit() {
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            double d = Compute.directBlowInfantryDamage(this.wtype.getRackSize(), this.bDirect ? this.toHit.getMoS() / 3 : 0, 3, ((Infantry)this.target).isMechanized());
            if (this.bGlancing) {
                d /= 2.0;
            }
            return (int)Math.floor(d);
        }
        return 1;
    }

    @Override
    protected int calcAttackValue() {
        int n = this.ae.getPosition().distance(this.target.getPosition());
        int n2 = 0;
        int n3 = RangeType.rangeBracket(n, this.wtype.getATRanges(), true);
        if (n3 == 1) {
            n2 = this.wtype.getRoundShortAV();
        } else if (n3 == 2) {
            n2 = this.wtype.getRoundMedAV();
        } else if (n3 == 3) {
            n2 = this.wtype.getRoundLongAV();
        } else if (n3 == 4) {
            n2 = this.wtype.getRoundExtAV();
        }
        Mounted mounted = this.weapon.getLinkedBy();
        AmmoType ammoType = (AmmoType)this.ammo.getType();
        int n4 = 0;
        if (mounted != null && mounted.getType() instanceof MiscType && !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached() && mounted.getType().hasFlag(512L) && ammoType.getMunitionType() == 8192L) {
            n4 = (int)Math.ceil((double)ammoType.getRackSize() / 5.0);
            if (ammoType.getAmmoType() == 9) {
                n4 = 2;
            }
        }
        n2 += n4;
        if (ammoType.getAmmoType() == 45 && !ammoType.hasFlag(32L)) {
            n2 *= 2;
        }
        return n2;
    }

    @Override
    protected boolean handleSpecialMiss(Entity entity, boolean bl, Building building, Vector<Report> vector) {
        if (entity != null && building == null && this.wtype.getFireTN() != Integer.MAX_VALUE) {
            this.server.tryIgniteHex(this.target.getPosition(), this.subjectId, false, false, new TargetRoll(this.wtype.getFireTN(), this.wtype.getName()), 3, vector);
        }
        this.server.checkExplodeIndustrialZone(this.target.getPosition(), vector);
        if (this.amsEnganged) {
            this.r = new Report(3230);
            this.r.indent();
            this.r.subject = this.subjectId;
            vector.addElement(this.r);
        }
        return bl && this.toHit.getValue() != 0x7FFFFFFE;
    }

    protected int getAMSHitsMod(Vector<Report> vector) {
        ArrayList<Mounted> arrayList;
        Entity entity;
        Entity entity2 = entity = this.target.getTargetType() == 0 ? (Entity)this.target : null;
        if (entity != null && null != (arrayList = this.waa.getCounterEquipment())) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Mounted mounted = arrayList.get(i);
                if (!mounted.getType().hasFlag(0x800000L) || this.amsEnganged) continue;
                Mounted mounted2 = mounted.getLinked();
                Entity entity3 = this.waa.getEntity(this.game);
                if (!(mounted.getType() instanceof WeaponType) || !mounted.isReady() || mounted.isMissing() || entity.hasShield() && entity.hasActiveShield(mounted.getLocation(), false) || entity.isShutDown() || !Compute.isInArc(this.game, entity.getId(), entity.getEquipmentNum(mounted), entity3)) continue;
                entity.heatBuildup = mounted.getType().hasFlag(0x400000L) ? (entity.heatBuildup += Compute.d6(((WeaponType)mounted.getType()).getHeat())) : (entity.heatBuildup += ((WeaponType)mounted.getType()).getHeat());
                if (mounted2 != null) {
                    mounted2.setShotsLeft(Math.max(0, mounted2.getShotsLeft() - 1));
                }
                mounted.setUsedThisRound(true);
                this.amsEnganged = true;
                this.r = new Report(3350);
                this.r.newlines = 0;
                vector.add(this.r);
                return -4;
            }
        }
        return 0;
    }

    @Override
    public boolean handle(IGame.Phase phase, Vector<Report> vector) {
        if (!this.cares(phase)) {
            return true;
        }
        Entity entity = this.target.getTargetType() == 0 ? (Entity)this.target : null;
        boolean bl = Compute.isInBuilding(this.game, entity);
        boolean bl2 = this.isNemesisConfusable();
        if (entity != null) {
            this.ae.setLastTarget(entity.getId());
        }
        Building building = this.game.getBoard().getBuildingAt(this.target.getPosition());
        String string = this.nweapons > 1 ? " (" + this.nweapons + ")" : "";
        this.r = new Report(3115);
        this.r.indent();
        this.r.newlines = 0;
        this.r.subject = this.subjectId;
        this.r.add(this.wtype.getName() + string);
        if (entity != null) {
            this.r.addDesc(entity);
        } else {
            this.r.messageId = 3120;
            this.r.add(this.target.getDisplayName(), true);
        }
        vector.addElement(this.r);
        boolean bl3 = false;
        if (bl2 && !this.waa.isNemesisConfused()) {
            Enumeration<Entity> enumeration = this.game.getNemesisTargets(this.ae, this.target.getPosition());
            while (enumeration.hasMoreElements()) {
                Entity entity2 = enumeration.nextElement();
                this.r = new Report(3125);
                this.r.subject = this.subjectId;
                vector.addElement(this.r);
                this.weapon.setUsedThisRound(false);
                WeaponAttackAction weaponAttackAction = new WeaponAttackAction(this.ae.getId(), entity2.getTargetId(), this.waa.getWeaponId());
                weaponAttackAction.setNemesisConfused(true);
                Entity entity3 = this.game.getEntity(this.waa.getEntityId());
                Mounted mounted = entity3.getEquipment(this.waa.getWeaponId());
                Weapon weapon = (Weapon)mounted.getType();
                AttackHandler attackHandler = weapon.fire(weaponAttackAction, this.game, this.server);
                this.weapon.getLinked().setShotsLeft(this.weapon.getLinked().getShotsLeft() + 1);
                WeaponHandler weaponHandler = (WeaponHandler)attackHandler;
                weaponHandler.handle(phase, vector);
                if (!weaponHandler.bMissed) {
                    return false;
                }
                bl3 = true;
            }
            if (bl3) {
                this.r = new Report(3130);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                this.r.indent();
                vector.addElement(this.r);
            }
        }
        if (this.toHit.getValue() == Integer.MAX_VALUE) {
            this.r = new Report(3135);
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
            return false;
        }
        if (this.toHit.getValue() == 0x7FFFFFFE) {
            this.r = new Report(3140);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
        } else if (this.toHit.getValue() == Integer.MIN_VALUE) {
            this.r = new Report(3145);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
        } else {
            this.r = new Report(3150);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getValue());
            vector.addElement(this.r);
        }
        this.r = new Report(3155);
        this.r.newlines = 0;
        this.r.subject = this.subjectId;
        this.r.add(this.roll);
        vector.addElement(this.r);
        boolean bl4 = this.bMissed = this.roll < this.toHit.getValue();
        if (this.game.getOptions().booleanOption("tacops_glancing_blows")) {
            if (this.roll == this.toHit.getValue()) {
                this.bGlancing = true;
                this.r = new Report(3186);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else {
                this.bGlancing = false;
            }
        } else {
            this.bGlancing = false;
        }
        this.toHit.setMoS(this.roll - Math.max(2, this.toHit.getValue()));
        boolean bl5 = this.bDirect = this.game.getOptions().booleanOption("tacops_direct_blow") && this.toHit.getMoS() / 3 >= 1 && entity != null;
        if (this.bDirect) {
            this.r = new Report(3189);
            this.r.subject = this.ae.getId();
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        if (!bl3) {
            this.addHeat();
        }
        boolean bl6 = this.doChecks(vector);
        this.nDamPerHit = this.calcDamagePerHit();
        if (this.specialResolution(vector, entity, this.bMissed)) {
            return false;
        }
        if (this.bMissed && !bl6) {
            this.reportMiss(vector);
            if (!this.handleSpecialMiss(entity, bl, building, vector)) {
                return false;
            }
        }
        int n = 1;
        if (!(this.ae instanceof Aero)) {
            n = this.calcHits(vector);
        }
        int n2 = this.calcnCluster();
        if (this.ae instanceof Aero && this.target instanceof Aero) {
            if (this.ae.isCapitalFighter()) {
                this.bSalvo = true;
                int n3 = 1;
                if (this.nweapons > 1) {
                    n3 = Compute.missilesHit(this.nweapons);
                    this.r = new Report(3325);
                    this.r.subject = this.subjectId;
                    this.r.add(n3);
                    this.r.add(" weapon(s) ");
                    this.r.add(" ");
                    this.r.newlines = 0;
                    vector.add(this.r);
                }
                this.nDamPerHit = this.attackValue * n3;
                n = 1;
                n2 = 1;
            } else if (this.usesClusterTable() && entity != null && !entity.isCapitalScale()) {
                this.bSalvo = true;
                this.nDamPerHit = 1;
                n = this.attackValue;
                n2 = 5;
            } else {
                this.nDamPerHit = this.attackValue;
                n = 1;
                n2 = 1;
            }
        }
        if (this.bMissed) {
            return false;
        }
        int n4 = 0;
        if (bl && building != null) {
            n4 = (int)Math.ceil((double)building.getPhaseCF(this.target.getPosition()) / 10.0);
        }
        if (n == 0) {
            this.r = new Report(3365);
            this.r.subject = this.subjectId;
            vector.addElement(this.r);
        }
        while (n > 0) {
            if (this.target.getTargetType() == 2 || this.target.getTargetType() == 4) {
                this.handleIgnitionDamage(vector, building, this.bSalvo, n);
                return false;
            }
            if (this.target.getTargetType() == 1) {
                int n5 = this.nDamPerHit * n;
                this.handleClearDamage(vector, building, n5, this.bSalvo);
                return false;
            }
            if (this.target.getTargetType() == 3) {
                int n6 = this.nDamPerHit * n;
                this.handleBuildingDamage(vector, building, n6, this.bSalvo, this.target.getPosition());
                return false;
            }
            if (entity == null) continue;
            this.handleEntityDamage(entity, vector, building, n, n2, this.nDamPerHit, n4);
            this.server.creditKill(entity, this.ae);
            n -= n2;
        }
        Report.addNewline(vector);
        return false;
    }

    protected boolean isNemesisConfusable() {
        boolean bl = false;
        AmmoType ammoType = (AmmoType)this.weapon.getLinked().getType();
        Mounted mounted = this.weapon.getLinkedBy();
        if (this.wtype.getAmmoType() == 28 || mounted != null && mounted.getType() instanceof MiscType && !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached() && mounted.getType().hasFlag(512L)) {
            if (!(this.weapon.getType().hasModes() && this.weapon.curMode().equals("Indirect") || (ammoType.getAmmoType() != 28 || ammoType.getMunitionType() != 0L && ammoType.getMunitionType() != 128L && ammoType.getMunitionType() != 256L) && (ammoType.getAmmoType() != 7 && ammoType.getAmmoType() != 9 || ammoType.getMunitionType() != 8192L))) {
                bl = true;
            }
        } else if (!(this.wtype.getAmmoType() != 7 && this.wtype.getAmmoType() != 9 || ammoType.getMunitionType() != 4096L && ammoType.getMunitionType() != 1024L)) {
            bl = true;
        }
        return bl;
    }

    @Override
    protected boolean usesClusterTable() {
        return true;
    }

    @Override
    protected boolean canDoDirectBlowDamage() {
        return false;
    }
}

