/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Report;
import megamek.common.TargetRoll;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.SRMHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SRMInfernoHandler
extends SRMHandler {
    private static final long serialVersionUID = 826674238068613732L;

    public SRMInfernoHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
        this.sSalvoType = " inferno missile(s) ";
        this.bSalvo = false;
    }

    @Override
    protected boolean handleSpecialMiss(Entity entity, boolean bl, Building building, Vector<Report> vector) {
        if (entity != null && building == null && this.wtype.getFireTN() != Integer.MAX_VALUE) {
            this.server.tryIgniteHex(this.target.getPosition(), this.subjectId, false, true, new TargetRoll(this.wtype.getFireTN(), this.wtype.getName()), 3, vector);
        }
        this.server.checkExplodeIndustrialZone(this.target.getPosition(), vector);
        if (this.amsEnganged) {
            this.r = new Report(3230);
            this.r.indent();
            this.r.subject = this.subjectId;
            vector.addElement(this.r);
        }
        return bl && this.toHit.getValue() != 0x7FFFFFFE;
    }

    @Override
    protected int calcDamagePerHit() {
        return 0;
    }

    @Override
    public boolean handle(IGame.Phase phase, Vector<Report> vector) {
        if (!this.cares(phase)) {
            return true;
        }
        Entity entity = this.target.getTargetType() == 0 ? (Entity)this.target : null;
        boolean bl = Compute.isInBuilding(this.game, entity);
        Building building = this.game.getBoard().getBuildingAt(this.target.getPosition());
        this.r = new Report(3115);
        this.r.indent();
        this.r.newlines = 0;
        this.r.subject = this.subjectId;
        this.r.add(this.wtype.getName());
        if (entity != null) {
            this.r.addDesc(entity);
        } else {
            this.r.messageId = 3120;
            this.r.add(this.target.getDisplayName(), true);
        }
        vector.addElement(this.r);
        if (this.toHit.getValue() == Integer.MAX_VALUE) {
            this.r = new Report(3135);
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
            return false;
        }
        if (this.toHit.getValue() == 0x7FFFFFFE) {
            this.r = new Report(3140);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
        } else if (this.toHit.getValue() == Integer.MIN_VALUE) {
            this.r = new Report(3145);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
        } else {
            this.r = new Report(3150);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getValue());
            vector.addElement(this.r);
        }
        this.r = new Report(3155);
        this.r.newlines = 0;
        this.r.subject = this.subjectId;
        this.r.add(this.roll);
        vector.addElement(this.r);
        boolean bl2 = this.bMissed = this.roll < this.toHit.getValue();
        if (this.game.getOptions().booleanOption("tacops_glancing_blows")) {
            if (this.roll == this.toHit.getValue()) {
                this.bGlancing = true;
                this.r = new Report(3186);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else {
                this.bGlancing = false;
            }
        } else {
            this.bGlancing = false;
        }
        this.toHit.setMoS(this.roll - Math.max(2, this.toHit.getValue()));
        boolean bl3 = this.bDirect = this.game.getOptions().booleanOption("tacops_direct_blow") && this.toHit.getMoS() / 3 >= 1 && entity != null;
        if (this.bDirect) {
            this.r = new Report(3189);
            this.r.subject = this.ae.getId();
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        this.addHeat();
        boolean bl4 = this.doChecks(vector);
        if (bl4) {
            this.bMissed = true;
        }
        if (this.bMissed && !bl4) {
            this.reportMiss(vector);
            if (!this.handleSpecialMiss(entity, bl, building, vector)) {
                return false;
            }
        }
        int n = this.calcHits(vector);
        Report.addNewline(vector);
        if (this.bMissed) {
            return false;
        }
        if (!this.bMissed) {
            vector.addAll(this.server.deliverInfernoMissiles(this.ae, this.target, n));
        }
        return false;
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        int n;
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            if (this.ae instanceof BattleArmor) {
                this.bSalvo = true;
                this.r = new Report(3325);
                this.r.subject = this.subjectId;
                this.r.add(this.wtype.getRackSize() * ((BattleArmor)this.ae).getShootingStrength());
                this.r.add(this.sSalvoType);
                this.r.add(this.toHit.getTableDesc());
                this.r.newlines = 0;
                vector.add(this.r);
                return ((BattleArmor)this.ae).getShootingStrength() * this.wtype.getRackSize();
            }
            this.r = new Report(3325);
            this.r.subject = this.subjectId;
            this.r.add(this.wtype.getRackSize());
            this.r.add(this.sSalvoType);
            this.r.add(this.toHit.getTableDesc());
            this.r.newlines = 0;
            vector.add(this.r);
            return this.wtype.getRackSize();
        }
        Entity entity = this.target.getTargetType() == 0 ? (Entity)this.target : null;
        int n2 = this.nSalvoBonus;
        boolean bl = this.game.getOptions().booleanOption("tacops_clusterhitpen");
        if (bl) {
            n2 = this.nRange <= 1 ? ++n2 : (this.nRange <= this.wtype.getMediumRange() ? (n2 += 0) : --n2);
        }
        if (this.game.getOptions().booleanOption("tacops_range") && this.nRange > this.wtype.getRanges(this.weapon)[3]) {
            n2 -= 2;
        }
        boolean bl2 = false;
        if (this.ae instanceof Mech) {
            bl2 = this.ae.isStealthActive();
        }
        Mounted mounted = this.weapon.getLinkedBy();
        AmmoType ammoType = (AmmoType)this.ammo.getType();
        boolean bl3 = false;
        if (Compute.isAffectedByECM(this.ae, this.ae.getPosition(), this.target.getPosition())) {
            bl3 = true;
        }
        if (mounted != null && mounted.getType() instanceof MiscType && !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached() && mounted.getType().hasFlag(512L) && ammoType.getMunitionType() == 8192L) {
            if (bl3) {
                this.r = new Report(3330);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else if (bl2) {
                this.r = new Report(3335);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else {
                n2 += 2;
            }
        } else if (ammoType.getAmmoType() == 28) {
            if (bl3) {
                this.r = new Report(3330);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else if (bl2) {
                this.r = new Report(3335);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else {
                n2 += 2;
            }
        } else if (entity != null && (entity.isNarcedBy(this.ae.getOwner().getTeam()) || entity.isINarcedBy(this.ae.getOwner().getTeam()))) {
            boolean bl4 = false;
            bl4 = Compute.isAffectedByECM(this.ae, this.target.getPosition(), this.target.getPosition());
            if (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 9 || ammoType.getAmmoType() == 45 && ammoType.getMunitionType() == 4096L && (this.weapon.curMode() == null || !this.weapon.curMode().equals("Indirect"))) {
                if (bl4) {
                    this.r = new Report(3330);
                    this.r.subject = this.subjectId;
                    this.r.newlines = 0;
                    vector.addElement(this.r);
                } else {
                    n2 += 2;
                }
            }
        }
        if (this.bGlancing) {
            n2 -= 4;
        }
        if (this.bDirect) {
            n2 += this.toHit.getMoS() / 3 * 2;
        }
        if (this.game.getPlanetaryConditions().hasEMI()) {
            n2 -= 2;
        }
        if ((n = this.allShotsHit() ? this.wtype.getRackSize() : (this.ae instanceof BattleArmor ? Compute.missilesHit(this.wtype.getRackSize() * ((BattleArmor)this.ae).getShootingStrength(), n2, this.weapon.isHotLoaded()) : Compute.missilesHit(this.wtype.getRackSize(), n2 += this.getAMSHitsMod(vector), this.weapon.isHotLoaded()))) > 0) {
            this.r = new Report(3325);
            this.r.subject = this.subjectId;
            this.r.add(n);
            this.r.add(this.sSalvoType);
            this.r.add(this.toHit.getTableDesc());
            this.r.newlines = 0;
            vector.addElement(this.r);
            if (n2 != 0) {
                this.r = n2 > 0 ? new Report(3340) : new Report(3341);
                this.r.subject = this.subjectId;
                this.r.add(n2);
                this.r.newlines = 0;
                vector.addElement(this.r);
            }
        }
        this.r = new Report(3345);
        this.r.newlines = 0;
        this.r.subject = this.subjectId;
        vector.addElement(this.r);
        this.bSalvo = true;
        return n;
    }

    @Override
    protected void handleClearDamage(Vector<Report> vector, Building building, int n, boolean bl) {
        if (!bl) {
            this.r = new Report(2270);
            this.r.subject = this.subjectId;
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        this.r = new Report(3385);
        this.r.indent();
        this.r.subject = this.subjectId;
        this.r.add(n);
        vector.addElement(this.r);
        if (building != null && this.server.tryIgniteHex(this.target.getPosition(), this.subjectId, false, true, new TargetRoll(this.wtype.getFireTN(), this.wtype.getName()), 5, vector)) {
            return;
        }
        vector.addAll(this.server.tryClearHex(this.target.getPosition(), n, this.subjectId));
    }
}

