/*
 * Decompiled with CFR 0.152.
 */
package megamek.server;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Report;
import megamek.common.TargetRoll;
import megamek.server.DynamicTerrainProcessor;
import megamek.server.Server;
import megamek.server.SmokeCloud;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FireProcessor
extends DynamicTerrainProcessor {
    private IGame game;
    Vector<Report> vPhaseReport;

    public FireProcessor(Server server) {
        super(server);
    }

    @Override
    void doEndPhaseChanges(Vector<Report> vector) {
        this.game = this.server.getGame();
        if (this.game.getOptions().booleanOption("tacops_start_fire")) {
            this.vPhaseReport = vector;
            this.resolveFire();
            this.vPhaseReport = null;
        }
    }

    private void debugTime(String string, boolean bl) {
    }

    private void resolveFire() {
        int n;
        Report report;
        Coords coords;
        IBoard iBoard = this.game.getBoard();
        int n2 = iBoard.getWidth();
        int n3 = iBoard.getHeight();
        int n4 = this.game.getPlanetaryConditions().getWindDirection();
        int n5 = this.game.getPlanetaryConditions().getWindStrength();
        Hashtable<Coords, Vector<Entity>> hashtable = this.game.getPositionMap();
        this.resolveSmoke();
        Enumeration<Building> enumeration = this.game.getBoard().getBuildings();
        while (enumeration.hasMoreElements()) {
            Building building = enumeration.nextElement();
            Enumeration<Coords> enumeration2 = building.getCoords();
            while (enumeration2.hasMoreElements()) {
                coords = enumeration2.nextElement();
                if (!building.isBurning(coords)) continue;
                int n6 = Math.max(building.getCurrentCF(coords) - 2, 0);
                building.setCurrentCF(n6, coords);
                if (n6 == 0) {
                    report = new Report(5120, 0);
                    report.add(building.getName());
                    this.vPhaseReport.addElement(report);
                    continue;
                }
                if (this.server.checkForCollapse(building, hashtable, coords)) continue;
                building.setPhaseCF(n6, coords);
            }
        }
        this.debugTime("resolve fire 1", true);
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                coords = new Coords(n, i);
                IHex iHex = iBoard.getHex(n, i);
                if (!iHex.containsTerrain(19)) continue;
                if (iHex.terrainLevel(19) == 1 && !iHex.isIgnitable()) {
                    this.server.removeFire(coords, "lack of fuel");
                    continue;
                }
                if (iHex.getFireTurn() <= 0) continue;
                if ((iHex.containsTerrain(1) || iHex.containsTerrain(5)) && this.game.getOptions().booleanOption("woods_burn_down")) {
                    this.burnDownWoods(coords);
                }
                report = new Report(5125, 0);
                if (iHex.terrainLevel(19) == 2) {
                    report.messageId = 5130;
                }
                report.add(coords.getBoardNum());
                this.vPhaseReport.addElement(report);
                this.spreadFire(n, i, n4, n5);
            }
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                boolean bl;
                coords = new Coords(n, i);
                IHex iHex = iBoard.getHex(n, i);
                if (!iHex.containsTerrain(19)) continue;
                if (iHex.getFireTurn() == 0) {
                    report = new Report(5135, 0);
                    report.add(coords.getBoardNum());
                    this.vPhaseReport.addElement(report);
                    Building building = this.game.getBoard().getBuildingAt(coords);
                    if (building != null) {
                        building.setBurning(true, coords);
                    }
                }
                this.server.checkExplodeIndustrialZone(coords, this.vPhaseReport);
                boolean bl2 = bl = iHex.terrainLevel(19) == 2;
                if (this.game.getPlanetaryConditions().getWindStrength() < 5) {
                    ArrayList<Coords> arrayList = new ArrayList<Coords>();
                    arrayList.add(new Coords(Coords.xInDir(n, i, n4), Coords.yInDir(n, i, n4)));
                    arrayList.add(new Coords(Coords.xInDir(n, i, (n4 + 1) % 6), Coords.yInDir(n, i, (n4 + 1) % 6)));
                    arrayList.add(new Coords(Coords.xInDir(n, i, (n4 + 5) % 6), Coords.yInDir(n, i, (n4 + 5) % 6)));
                    this.server.addSmoke(arrayList, n4, bl);
                    iBoard.initializeAround(n, i);
                }
                iHex.incrementFireTurn();
                this.server.sendChangedHex(coords);
            }
        }
    }

    public void burnDownWoods(Coords coords) {
        int n = 5;
        try {
            n = this.game.getOptions().intOption("woods_burn_down_amount");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.vPhaseReport.addAll(this.server.tryClearHex(coords, n, -1));
    }

    public void spreadFire(int n, int n2, int n3, int n4) {
        Coords coords = new Coords(n, n2);
        Coords coords2 = coords.translated(n3);
        int n5 = this.game.getBoard().getHex(coords).ceiling();
        TargetRoll targetRoll = new TargetRoll(9, "spread downwind");
        TargetRoll targetRoll2 = new TargetRoll(11, "spread 60 degrees to downwind");
        if (n4 > 0 && n4 < 3) {
            targetRoll.addModifier(-2, "light/moderate gale");
            targetRoll2.addModifier(-1, "light/moderate gale");
        } else if (n4 > 2) {
            targetRoll.addModifier(-3, "strong gale+");
            targetRoll.addModifier(-2, "strong gale+");
        }
        this.spreadFire(coords2, targetRoll, n5);
        IHex iHex = this.game.getBoard().getHex(coords2);
        IHex iHex2 = this.game.getBoard().getHex(coords2.translated(n3));
        if (!(iHex == null || iHex2 == null || iHex.containsTerrain(19) || n5 < iHex.ceiling() && iHex2.ceiling() < iHex.ceiling())) {
            targetRoll.addModifier(3, "crossing non-burning hex");
            this.spreadFire(coords2.translated(n3), targetRoll, n5);
        }
        this.spreadFire(coords.translated((n3 + 1) % 6), targetRoll2, n5);
        this.spreadFire(coords.translated((n3 + 5) % 6), targetRoll2, n5);
    }

    public void spreadFire(Coords coords, TargetRoll targetRoll, int n) {
        IHex iHex = this.game.getBoard().getHex(coords);
        if (iHex == null) {
            return;
        }
        if (Math.abs(iHex.ceiling() - n) > 4) {
            return;
        }
        if (!iHex.containsTerrain(19) && this.server.checkIgnition(coords, targetRoll)) {
            Report report = new Report(5150, 0);
            report.add(coords.getBoardNum());
            this.vPhaseReport.addElement(report);
        }
    }

    private void resolveSmoke() {
        ArrayList arrayList;
        IBoard iBoard = this.game.getBoard();
        int n = this.game.getPlanetaryConditions().getWindDirection();
        int n2 = this.game.getPlanetaryConditions().getWindStrength();
        HashMap<SmokeCloud, ArrayList> hashMap = new HashMap<SmokeCloud, ArrayList>();
        for (SmokeCloud smokeCloud : this.server.getSmokeCloudList()) {
            arrayList = new ArrayList();
            for (Coords coords : smokeCloud.getCoordsList()) {
                Report report;
                Coords coords2 = this.driftAddSmoke(coords, n, n2);
                if (coords2 == null) {
                    report = new Report(5220, 0);
                    report.add(coords.getBoardNum());
                    this.vPhaseReport.addElement(report);
                    report = new Report(5222, 0);
                    this.vPhaseReport.addElement(report);
                    continue;
                }
                if (iBoard.contains(coords2) && !coords.equals(coords2)) {
                    arrayList.add(coords2);
                    smokeCloud.setDrift(true);
                    continue;
                }
                if (iBoard.contains(coords2)) continue;
                report = new Report(5230, 0);
                report.add(coords.getBoardNum());
                this.vPhaseReport.addElement(report);
            }
            if (arrayList.size() <= 0) continue;
            hashMap.put(smokeCloud, arrayList);
        }
        for (SmokeCloud smokeCloud : hashMap.keySet()) {
            arrayList = (ArrayList)hashMap.get(smokeCloud);
            this.server.updateSmoke(smokeCloud, arrayList);
        }
        for (SmokeCloud smokeCloud : this.server.getSmokeCloudList()) {
            int n3;
            boolean bl = this.driftSmokeDissipate(smokeCloud, n3 = Compute.d6(2), n2);
            if (bl || smokeCloud.didDrift()) {
                this.driftSmokeReport(smokeCloud, bl);
                if (bl) {
                    smokeCloud.setSmokeLevel(smokeCloud.getSmokeLevel() - 1);
                }
            }
            smokeCloud.setDrift(false);
        }
    }

    public Coords driftAddSmoke(Coords coords, int n, int n2) {
        return this.driftAddSmoke(coords, n, n2, 0);
    }

    public Coords driftAddSmoke(Coords coords, int n, int n2, int n3) {
        Coords coords2 = coords.translated(n);
        IBoard iBoard = this.game.getBoard();
        if (n2 == 0) {
            return coords;
        }
        if (!iBoard.contains(coords2)) {
            return coords2;
        }
        int n4 = iBoard.getHex(coords).getElevation();
        int n5 = iBoard.getHex(coords2).getElevation();
        if (iBoard.getHex(coords2).containsTerrain(22)) {
            n5 += iBoard.getHex(coords2).terrainLevel(24);
        }
        if (iBoard.getHex(coords).containsTerrain(22)) {
            n4 += iBoard.getHex(coords).terrainLevel(24);
        }
        if (n4 - n5 > 4) {
            return null;
        }
        if (n4 - n5 < -4) {
            if (n3 == 0) {
                return this.driftAddSmoke(coords, (n + 1) % 6, n2, ++n3);
            }
            if (n3 == 1) {
                return this.driftAddSmoke(coords, (n - 2) % 6, n2, ++n3);
            }
            return coords;
        }
        if (n2 > 2) {
            return this.driftAddSmoke(coords2, n, --n2);
        }
        return coords2;
    }

    public boolean driftSmokeDissipate(SmokeCloud smokeCloud, int n, int n2) {
        if (smokeCloud.getDuration() > 0 && smokeCloud.getDuration() - 1 == 0) {
            smokeCloud.setDuration(0);
            smokeCloud.setSmokeLevel(0);
            return true;
        }
        if (smokeCloud.getDuration() > 0 && smokeCloud.getDuration() - 1 > 0) {
            smokeCloud.setDuration(smokeCloud.getDuration() - 1);
        }
        if (n > 10 || n > 9 && n2 == 2 || n > 7 && n2 == 3 || n > 5 && n2 == 4) {
            return true;
        }
        if (n2 > 4) {
            smokeCloud.setSmokeLevel(0);
            return true;
        }
        return false;
    }

    public void driftSmokeReport(SmokeCloud smokeCloud, boolean bl) {
        int n = smokeCloud.getSmokeLevel();
        if (n == 2 && bl) {
            Report report;
            for (int i = 0; i < smokeCloud.getCoordsList().size(); ++i) {
                report = i == 0 ? new Report(5210, 0) : new Report(5211, 0);
                report.add(smokeCloud.getCoordsList().get(i).getBoardNum());
                report.newlines = 0;
                this.vPhaseReport.addElement(report);
            }
            report = new Report(5212, 0);
            this.vPhaseReport.addElement(report);
        } else if (n == 2 && !bl) {
            Report report;
            for (int i = 0; i < smokeCloud.getCoordsList().size(); ++i) {
                report = i == 0 ? new Report(5210, 0) : new Report(5211, 0);
                report.add(smokeCloud.getCoordsList().get(i).getBoardNum());
                report.newlines = 0;
                this.vPhaseReport.addElement(report);
            }
            report = new Report(5213, 0);
            this.vPhaseReport.addElement(report);
        } else if (n == 1 && bl) {
            Report report;
            for (int i = 0; i < smokeCloud.getCoordsList().size(); ++i) {
                report = i == 0 ? new Report(5220, 0) : new Report(5211, 0);
                report.add(smokeCloud.getCoordsList().get(i).getBoardNum());
                report.newlines = 0;
                this.vPhaseReport.addElement(report);
            }
            report = new Report(5222, 0);
            this.vPhaseReport.addElement(report);
        } else if (n == 1 && !bl) {
            Report report;
            for (int i = 0; i < smokeCloud.getCoordsList().size(); ++i) {
                report = i == 0 ? new Report(5220, 0) : new Report(5211, 0);
                report.add(smokeCloud.getCoordsList().get(i).getBoardNum());
                report.newlines = 0;
                this.vPhaseReport.addElement(report);
            }
            report = new Report(5213, 0);
            this.vPhaseReport.addElement(report);
        } else if (n < 1) {
            Report report;
            for (int i = 0; i < smokeCloud.getCoordsList().size(); ++i) {
                report = i == 0 ? new Report(5223, 0) : new Report(5211, 0);
                report.add(smokeCloud.getCoordsList().get(i).getBoardNum());
                report.newlines = 0;
                this.vPhaseReport.addElement(report);
            }
            report = new Report(5224, 0);
            this.vPhaseReport.addElement(report);
        }
    }
}

