/*
 * MegaMek - Copyright (C) 2005 Ben Mazur (bmazur@sev.org)
 * 
 *  This program is free software; you can redistribute it and/or modify it 
 *  under the terms of the GNU General Public License as published by the Free 
 *  Software Foundation; either version 2 of the License, or (at your option) 
 *  any later version.
 * 
 *  This program is distributed in the hope that it will be useful, but 
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 *  for more details.
 */

package megamek.common.actions;

public class LayMinefieldAction extends AbstractEntityAction {
    /**
     * 
     */
    private static final long serialVersionUID = -5213526937050576813L;
    /** Save the equipment ID of the mine being laid. */
    int mineId;

    /**
     * Lay the indicated mine with the entity with the given entity ID.
     * 
     * @param entityId the <code>int</code> ID of the minelaying entity.
     * @param equipId the <code>int</code> ID of the mine.
     */
    public LayMinefieldAction(int entityId, int equipId) {
        super(entityId);
        this.mineId = equipId;
    }

    /**
     * Get the equipment ID of the mine being laid.
     * 
     * @return the <code>int</code> equipment ID of the mine.
     */
    public int getMineId() {
        return this.mineId;
    }
}
