/*
 * Decompiled with CFR 0.152.
 */
package updaters;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ProgressMonitor;
import updaters.FileDiff;
import updaters.FileInfo;
import updaters.Repository;
import updaters.SplashWindow;
import updaters.Version;
import updaters.VersionManifest;
import updaters.utils.IOUtil;
import updaters.utils.Terminator;
import updaters.utils.VoidFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoUpdater {
    public static final String UPDATE_TMP_DIR = "update-tmp";
    protected SplashWindow splash = null;
    protected File localDir_;
    protected Hashtable<String, File> copyMap_ = new Hashtable();
    protected ProgressMonitor progressMonitor_;

    public AutoUpdater(String localDir, SplashWindow splash) {
        this.localDir_ = new File(localDir);
        this.splash = splash;
    }

    public void updateToLatestVersion(Repository repository) throws IOException {
        Version latest = repository.getLatestVersion();
        this.updateToSpecificVersion(repository, latest);
    }

    public void updateToSpecificVersion(Repository repository, Version version) throws IOException {
        int stepsCompleted = 0;
        this.setMaximumSteps(1);
        this.setProgress(stepsCompleted);
        this.setProgressNote("Updating to version " + version.getName());
        this.setProgressNote("Retrieving remote manifest");
        VersionManifest manifest = version.getManifest();
        List<FileInfo> fileDiffInfos = manifest.getDiffInfos(this);
        this.setMaximumSteps(fileDiffInfos.size() + ++stepsCompleted);
        this.setProgress(stepsCompleted);
        for (FileInfo nextFileInfo : fileDiffInfos) {
            FileDiff diff = repository.getDiff(nextFileInfo, version);
            diff.setTempFileUpToDate(nextFileInfo.getTempFileUpToDate());
            diff.apply(this, repository);
            this.setProgress(++stepsCompleted);
        }
        this.cleanUpLocalFiles(manifest);
    }

    public void cleanUpLocalFiles(VersionManifest manifest) {
        List<String> dirsToCleanUp = manifest.getDirectoriesToCleanUp();
        System.err.println("Begining Clean up.");
        List<File> expectedFileStructure = this.getExpectedClientFileStructure(manifest);
        for (String dirName : dirsToCleanUp) {
            this.setProgressNote("Cleaning up file directory");
            List<File> localFiles = IOUtil.getTree(new File(this.localDir_, dirName));
            for (File localFile : localFiles) {
                if (expectedFileStructure.contains(localFile) || localFile.isDirectory()) continue;
                System.err.println("Deleting " + localFile);
                localFile.deleteOnExit();
            }
        }
    }

    public List<File> getExpectedClientFileStructure(VersionManifest manifest) {
        List<String> expectedOffsetStructure = manifest.getClientFileStructure();
        ArrayList<File> expectedFileStructure = new ArrayList<File>(expectedOffsetStructure.size());
        for (String offset : expectedOffsetStructure) {
            expectedFileStructure.add(new File(this.localDir_, offset));
        }
        return expectedFileStructure;
    }

    public InputStream getLocalFileStream(FileInfo fileInfo) throws IOException {
        String[] urlParts = IOUtil.parseJarURL(fileInfo.getLocalOffset());
        if (urlParts.length > 1) {
            File tempJarFile;
            if (urlParts.length > 2) {
                throw new IOException("Do not understand jars within jars");
            }
            File originalJarFile = new File(this.getLocalDir() + File.separator + urlParts[0]);
            String originalJarFileName = originalJarFile.getAbsolutePath();
            if (!this.copyMap_.containsKey(originalJarFileName)) {
                tempJarFile = File.createTempFile("copy", ".jar");
                String tempJarFileName = tempJarFile.getAbsolutePath();
                IOUtil.copy(originalJarFileName, tempJarFileName);
                this.copyMap_.put(originalJarFileName, tempJarFile);
                final File finalTempJarFile = tempJarFile;
                Terminator.instance().runOnExit(new VoidFunction(){
                    private static final long serialVersionUID = 1L;

                    public Object execute() {
                        finalTempJarFile.delete();
                        return null;
                    }
                });
            } else {
                tempJarFile = this.copyMap_.get(originalJarFileName);
            }
            String completeURL = tempJarFile.toURL().toString() + "!" + urlParts[1];
            completeURL = IOUtil.fixJarURL(completeURL);
            System.err.println("Reading from jarfile: " + completeURL);
            return new BufferedInputStream(new URL(completeURL).openStream());
        }
        System.err.println("Reading from file " + urlParts[0]);
        return new FileInputStream(this.getLocalDir() + File.separator + urlParts[0]);
    }

    public String getLocalDir() {
        return this.localDir_.getAbsolutePath();
    }

    public static void main(String[] args) throws IOException {
        String repositoryName = "http://www.navtools.com/cosm-client";
        String localDir = ".";
        if (args.length > 2) {
            AutoUpdater.usage();
            System.exit(0);
        } else if (args.length > 0) {
            localDir = args[0];
            if (args.length == 2) {
                repositoryName = args[1];
            }
        }
        AutoUpdater.update(localDir, repositoryName, null);
        Terminator.instance().exit(0);
    }

    public static void usage() {
        System.out.println("AutoUpdater: Update a local application from a remote repository.");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("java com.navtools.autoupdate.AutoUpdater [local directory=.] [repository=www.navtools.com/cosm-client]");
    }

    public static void update(String localDir, String repositoryName, SplashWindow splash) throws IOException {
        AutoUpdater updater = new AutoUpdater(localDir, splash);
        Repository repository = new Repository(repositoryName);
        updater.updateToLatestVersion(repository);
    }

    public void setMaximumSteps(int max) {
    }

    public void setProgressNote(String note) {
        if (this.splash != null) {
            this.splash.getAnimator().setLabelText(note);
        }
    }

    public void setProgress(int stepsCompleted) {
    }
}

