/*
 * Decompiled with CFR 0.152.
 */
package updaters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import updaters.Repository;
import updaters.VersionManifest;
import updaters.utils.IOUtil;

public class Version {
    protected Repository repository_;
    protected String version_;
    protected VersionManifest manifest_;

    public Version(Repository repository, String version) {
        this.repository_ = repository;
        this.version_ = IOUtil.trimFileSeparator(version);
    }

    public VersionManifest getManifest() throws IOException {
        if (this.manifest_ == null) {
            this.manifest_ = new VersionManifest(this.getCharFile("Manifest.txt.jar!/Manifest.txt"));
        }
        return this.manifest_;
    }

    public InputStream getBinaryFile(String filename) throws IOException {
        filename = filename.replaceAll(" ", "%20");
        return this.repository_.getBinaryFile(this.version_ + "/" + filename);
    }

    public BufferedReader getCharFile(String filename) throws IOException {
        return this.repository_.getCharFile(this.version_ + "/" + filename);
    }

    public String getName() {
        return this.version_;
    }
}

