/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.bot.TestBot;
import megamek.client.event.BoardViewListener;
import megamek.client.ui.AWT.AlertDialog;
import megamek.client.ui.AWT.BoardSelectionDialog;
import megamek.client.ui.AWT.BoardView1;
import megamek.client.ui.AWT.ChatLounge;
import megamek.client.ui.AWT.ChatterBox;
import megamek.client.ui.AWT.ChoiceDialog;
import megamek.client.ui.AWT.CommonAboutDialog;
import megamek.client.ui.AWT.CommonHelpDialog;
import megamek.client.ui.AWT.CommonMenuBar;
import megamek.client.ui.AWT.CommonSettingsDialog;
import megamek.client.ui.AWT.ConfirmDialog;
import megamek.client.ui.AWT.CustomBattleArmorDialog;
import megamek.client.ui.AWT.DeployMinefieldDisplay;
import megamek.client.ui.AWT.DeploymentDisplay;
import megamek.client.ui.AWT.DoneButtoned;
import megamek.client.ui.AWT.FiringDisplay;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.GameOptionsDialog;
import megamek.client.ui.AWT.IBoardView;
import megamek.client.ui.AWT.LOSDialog;
import megamek.client.ui.AWT.MechDisplay;
import megamek.client.ui.AWT.MechSelectorDialog;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.MiniMap;
import megamek.client.ui.AWT.MiniReportDisplay;
import megamek.client.ui.AWT.MovementDisplay;
import megamek.client.ui.AWT.PhysicalDisplay;
import megamek.client.ui.AWT.PlayerListDialog;
import megamek.client.ui.AWT.RandomArmyDialog;
import megamek.client.ui.AWT.ReportDisplay;
import megamek.client.ui.AWT.Ruler;
import megamek.client.ui.AWT.SelectArtyAutoHitHexDisplay;
import megamek.client.ui.AWT.StartingPositionDialog;
import megamek.client.ui.AWT.TargetingPhaseDisplay;
import megamek.client.ui.AWT.UnitLoadingDialog;
import megamek.client.ui.AWT.UnitOverview;
import megamek.client.ui.AWT.util.PlayerColors;
import megamek.client.ui.AWT.widget.BufferedPanel;
import megamek.common.BuildingTarget;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.EntityListFile;
import megamek.common.HexTarget;
import megamek.common.MechSummaryCache;
import megamek.common.MinefieldTarget;
import megamek.common.Player;
import megamek.common.Targetable;
import megamek.common.event.GameEndEvent;
import megamek.common.event.GameListener;
import megamek.common.event.GameListenerAdapter;
import megamek.common.event.GameMapQueryEvent;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GamePlayerChatEvent;
import megamek.common.event.GamePlayerConnectedEvent;
import megamek.common.event.GamePlayerDisconnectedEvent;
import megamek.common.event.GameReportEvent;
import megamek.common.event.GameSettingsChangeEvent;
import megamek.common.util.Distractable;
import megamek.common.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientGUI
extends Panel
implements MouseListener,
WindowListener,
ActionListener,
KeyListener {
    public static final String VIEW_MEK_DISPLAY = "viewMekDisplay";
    public static final String VIEW_MINI_MAP = "viewMiniMap";
    public static final String VIEW_LOS_SETTING = "viewLOSSetting";
    public static final String VIEW_UNIT_OVERVIEW = "viewUnitOverview";
    public static final String VIEW_ZOOM_IN = "viewZoomIn";
    public static final String VIEW_ZOOM_OUT = "viewZoomOut";
    public Frame frame;
    protected CommonMenuBar menuBar = null;
    private CommonAboutDialog about = null;
    private CommonHelpDialog help = null;
    private CommonSettingsDialog setdlg = null;
    private String helpFileName = "readme.txt";
    private ChatterBox cb;
    public BoardView1 bv;
    private Panel scroller;
    public Dialog mechW;
    public MechDisplay mechD;
    public Dialog minimapW;
    public MiniMap minimap;
    public PopupMenu popup = new PopupMenu(Messages.getString("ClientGUI.BoardPopup"));
    private UnitOverview uo;
    public Ruler ruler;
    protected Component curPanel;
    public ChatLounge chatlounge = null;
    private BoardSelectionDialog boardSelectionDialog;
    private GameOptionsDialog gameOptionsDialog;
    private MechSelectorDialog mechSelectorDialog;
    private CustomBattleArmorDialog customBADialog;
    private StartingPositionDialog startingPositionDialog;
    private PlayerListDialog playerListDialog;
    private RandomArmyDialog randomArmyDialog;
    private FileDialog dlgLoadList = null;
    private FileDialog dlgSaveList = null;
    public Client client;
    AudioClip bingClip = null;
    private HashMap<String, String> mainNames = new HashMap();
    private Panel panMain = new Panel();
    private CardLayout cardsMain = new CardLayout();
    private HashMap<String, String> secondaryNames = new HashMap();
    private Panel panSecondary = new Panel();
    private CardLayout cardsSecondary = new CardLayout();
    private HashMap<String, Component> phaseComponents = new HashMap();
    private Map<String, Client> bots = new TreeMap<String, Client>(StringUtil.stringComparator());
    int selectedEntityNum = -1;
    protected GameListener gameListener = new GameListenerAdapter(){

        public void gamePlayerDisconnected(GamePlayerDisconnectedEvent gamePlayerDisconnectedEvent) {
            AlertDialog alertDialog = new AlertDialog(ClientGUI.this.frame, Messages.getString("ClientGUI.Disconnected.title"), Messages.getString("ClientGUI.Disconnected.message"));
            alertDialog.setVisible(true);
            ClientGUI.this.frame.setVisible(false);
            ClientGUI.this.die();
        }

        public void gamePlayerChat(GamePlayerChatEvent gamePlayerChatEvent) {
            ClientGUI.this.bing();
        }

        public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
            if (ClientGUI.this.bv.getLocalPlayer() == null) {
                ClientGUI.this.bv.setLocalPlayer(ClientGUI.this.client.getLocalPlayer());
            }
            ClientGUI.this.switchPanel(ClientGUI.this.client.game.getPhase());
            ClientGUI.this.bv.hideTooltip();
            switch (gamePhaseChangeEvent.getNewPhase()) {
                case 1: {
                    ReportDisplay reportDisplay = (ReportDisplay)ClientGUI.this.phaseComponents.get(String.valueOf(6));
                    if (reportDisplay == null) break;
                    reportDisplay.resetTabs();
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 20: {
                    if (!GUIPreferences.getInstance().getMinimapEnabled() || ClientGUI.this.minimapW.isVisible()) break;
                    ClientGUI.this.setMapVisible(true);
                    break;
                }
                case 6: 
                case 9: 
                case 11: 
                case 13: 
                case 16: 
                case 18: {
                    ClientGUI.this.setMapVisible(false);
                    ClientGUI.this.mechW.setVisible(false);
                }
            }
            ClientGUI.this.menuBar.setPhase(ClientGUI.this.client.game.getPhase());
            ClientGUI.this.cb.getComponent().setVisible(true);
            ClientGUI.this.validate();
            ClientGUI.this.doLayout();
            ClientGUI.this.cb.moveToEnd();
        }

        public void gamePlayerConnected(GamePlayerConnectedEvent gamePlayerConnectedEvent) {
            System.err.println("gamePlayerConnected");
            System.err.flush();
            if (ClientGUI.this.curPanel instanceof ReportDisplay) {
                ((ReportDisplay)ClientGUI.this.curPanel).resetReadyButton();
                System.err.println("resetReadyButton");
                System.err.flush();
            }
        }

        public void gameReport(GameReportEvent gameReportEvent) {
            if (gameReportEvent.getReport() == null && ClientGUI.this.curPanel instanceof ReportDisplay) {
                ((ReportDisplay)ClientGUI.this.curPanel).appendReportTab(ClientGUI.this.client.phaseReport);
                ((ReportDisplay)ClientGUI.this.curPanel).resetReadyButton();
                if (ClientGUI.this.client.game.hasTacticalGenius(ClientGUI.this.client.getLocalPlayer()) && !((ReportDisplay)ClientGUI.this.curPanel).hasRerolled()) {
                    ((ReportDisplay)ClientGUI.this.curPanel).resetRerollButton();
                }
            } else if (!(ClientGUI.this.client instanceof TestBot)) {
                ClientGUI.this.doAlertDialog("Movement Report", gameReportEvent.getReport());
            }
        }

        public void gameEnd(GameEndEvent gameEndEvent) {
            ClientGUI.this.bv.clearMovementData();
            Object object = ClientGUI.this.getBots().values().iterator();
            while (object.hasNext()) {
                object.next().die();
            }
            ClientGUI.this.getBots().clear();
            object = ClientGUI.this.client.game.getPlayerEntities(ClientGUI.this.client.getLocalPlayer());
            Enumeration<Entity> enumeration = ClientGUI.this.client.game.getRetreatedEntities();
            while (enumeration.hasMoreElements()) {
                ((Vector)object).addElement(enumeration.nextElement());
            }
            if (!((Vector)object).isEmpty() && ClientGUI.this.doYesNoDialog(Messages.getString("ClientGUI.SaveUnitsDialog.title"), Messages.getString("ClientGUI.SaveUnitsDialog.message"))) {
                ClientGUI.this.saveListFile((Vector<Entity>)object);
            }
        }

        public void gameSettingsChange(GameSettingsChangeEvent gameSettingsChangeEvent) {
            if (ClientGUI.this.boardSelectionDialog != null && ClientGUI.this.boardSelectionDialog.isVisible()) {
                ClientGUI.this.boardSelectionDialog.update(ClientGUI.this.client.getMapSettings(), true);
            }
            if (ClientGUI.this.gameOptionsDialog != null && ClientGUI.this.gameOptionsDialog.isVisible()) {
                ClientGUI.this.gameOptionsDialog.update(ClientGUI.this.client.game.getOptions());
            }
            if (ClientGUI.this.curPanel instanceof ChatLounge) {
                ChatLounge chatLounge = (ChatLounge)ClientGUI.this.curPanel;
                boolean bl = ClientGUI.this.client.game.getOptions().booleanOption("minefields");
                chatLounge.enableMinefields(bl);
                if (!bl) {
                    ClientGUI.this.client.getLocalPlayer().setNbrMFConventional(0);
                    ClientGUI.this.client.getLocalPlayer().setNbrMFCommand(0);
                    ClientGUI.this.client.getLocalPlayer().setNbrMFVibra(0);
                    ClientGUI.this.client.sendPlayerInfo();
                }
            }
        }

        public void gameMapQuery(GameMapQueryEvent gameMapQueryEvent) {
            if (ClientGUI.this.boardSelectionDialog != null && ClientGUI.this.boardSelectionDialog.isVisible()) {
                ClientGUI.this.boardSelectionDialog.update(gameMapQueryEvent.getSettings(), false);
            }
        }
    };

    public ClientGUI(Client client) {
        super(new BorderLayout());
        this.client = client;
        this.loadSoundClip();
        this.panMain.setLayout(this.cardsMain);
        this.panSecondary.setLayout(this.cardsSecondary);
        Panel panel = new Panel(new BorderLayout());
        panel.add((Component)this.panMain, "Center");
        panel.add((Component)this.panSecondary, "South");
        this.add((Component)panel, "Center");
    }

    public IBoardView getBoardView() {
        return this.bv;
    }

    public void loadSoundClip() {
        if (GUIPreferences.getInstance().getSoundBingFilename() == null) {
            return;
        }
        try {
            File file = new File(GUIPreferences.getInstance().getSoundBingFilename());
            if (!file.exists()) {
                System.err.println("Failed to load audio file: " + GUIPreferences.getInstance().getSoundBingFilename());
                return;
            }
            this.bingClip = Applet.newAudioClip(file.toURL());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 34: {
                this.bv.zoomIn();
                break;
            }
            case 33: {
                this.bv.zoomOut();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public void systemMessage(String string) {
        this.cb.systemMessage(string);
    }

    private void initializeFrame() {
        int n;
        int n2;
        this.frame = new Frame(Messages.getString("ClientGUI.title"));
        this.menuBar.setGame(this.client.game);
        this.frame.setMenuBar(this.menuBar);
        Rectangle rectangle = new Rectangle();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (n2 = 0; n2 < graphicsDeviceArray.length; ++n2) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[n2];
            GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
            for (n = 0; n < graphicsConfigurationArray.length; ++n) {
                rectangle = rectangle.union(graphicsConfigurationArray[n].getBounds());
            }
        }
        if (GUIPreferences.getInstance().getWindowSizeHeight() != 0) {
            n2 = GUIPreferences.getInstance().getWindowPosX();
            int n3 = GUIPreferences.getInstance().getWindowPosY();
            int n4 = GUIPreferences.getInstance().getWindowSizeWidth();
            n = GUIPreferences.getInstance().getWindowSizeHeight();
            if ((double)n2 < rectangle.getMinX() || (double)(n2 + n4) > rectangle.getMaxX()) {
                n2 = 0;
            }
            if ((double)n3 < rectangle.getMinY() || (double)(n3 + n) > rectangle.getMaxY()) {
                n3 = 0;
            }
            if ((double)n4 > rectangle.getWidth()) {
                n4 = (int)rectangle.getWidth();
            }
            if ((double)n > rectangle.getHeight()) {
                n = (int)rectangle.getHeight();
            }
            this.frame.setLocation(n2, n3);
            this.frame.setSize(n4, n);
        } else {
            this.frame.setSize(800, 600);
        }
        this.frame.setBackground(SystemColor.menu);
        this.frame.setForeground(SystemColor.menuText);
        this.frame.setIconImage(this.frame.getToolkit().getImage("data/images/misc/megamek-icon.gif"));
    }

    private void layoutFrame() {
        this.frame.setTitle(this.client.getName() + Messages.getString("ClientGUI.clientTitleSuffix"));
        this.frame.setLayout(new BorderLayout());
        this.frame.add((Component)this, "Center");
        this.frame.validate();
    }

    public void initialize() {
        Serializable serializable;
        Component component;
        this.menuBar = new CommonMenuBar(this.getClient());
        this.initializeFrame();
        try {
            this.client.game.addGameListener(this.gameListener);
            this.bv = new BoardView1(this.client.game, this.frame, this);
            this.scroller = new Panel();
            this.scroller.setLayout(new BorderLayout());
            component = new Scrollbar(1);
            serializable = new Scrollbar(0);
            this.scroller.add((Component)this.bv, "Center");
            if (System.getProperty("megamek.client.clientgui.hidescrollbars", "false").equals("false")) {
                this.scroller.add(component, "East");
                this.scroller.add((Component)serializable, "South");
                this.bv.setScrollbars((Scrollbar)component, (Scrollbar)serializable);
            }
        }
        catch (IOException iOException) {
            this.doAlertDialog(Messages.getString("ClientGUI.FatalError.title"), Messages.getString("ClientGUI.FatalError.message") + iOException);
            this.die();
        }
        this.layoutFrame();
        this.frame.setVisible(true);
        this.menuBar.addActionListener(this);
        this.frame.addKeyListener(this);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ClientGUI.this.frame.setVisible(false);
                ClientGUI.this.saveSettings();
                ClientGUI.this.die();
            }
        });
        component = new UnitLoadingDialog(this.frame);
        if (!MechSummaryCache.getInstance().isInitialized()) {
            ((Dialog)component).setVisible(true);
        }
        this.uo = new UnitOverview(this);
        this.bv.addDisplayable(this.uo);
        this.bv.addMouseListener(this);
        this.bv.addKeyListener(this);
        this.bv.add(this.popup);
        serializable = this.frame.getToolkit().getScreenSize();
        this.mechW = new Dialog(this.frame, Messages.getString("ClientGUI.MechDisplay"), false);
        int n = GUIPreferences.getInstance().getDisplayPosX();
        int n2 = GUIPreferences.getInstance().getDisplayPosY();
        int n3 = GUIPreferences.getInstance().getDisplaySizeHeight();
        int n4 = GUIPreferences.getInstance().getDisplaySizeWidth();
        if (n + n4 > ((Dimension)serializable).width) {
            n = 0;
            n4 = Math.min(n4, ((Dimension)serializable).width);
        }
        if (n2 + n3 > ((Dimension)serializable).height) {
            n2 = 0;
            n3 = Math.min(n3, ((Dimension)serializable).height);
        }
        this.mechW.setLocation(n, n2);
        this.mechW.setSize(n4, n3);
        this.mechW.setResizable(true);
        this.mechW.addWindowListener(this);
        this.mechW.addKeyListener(this);
        this.mechD = new MechDisplay(this);
        this.mechD.addMechDisplayListener(this.bv);
        this.mechW.add(this.mechD);
        Ruler.color1 = GUIPreferences.getInstance().getRulerColor1();
        Ruler.color2 = GUIPreferences.getInstance().getRulerColor2();
        this.ruler = new Ruler(this.frame, this.client, this.bv);
        n = GUIPreferences.getInstance().getRulerPosX();
        n2 = GUIPreferences.getInstance().getRulerPosY();
        n3 = GUIPreferences.getInstance().getRulerSizeHeight();
        n4 = GUIPreferences.getInstance().getRulerSizeWidth();
        if (n + n4 > ((Dimension)serializable).width) {
            n = 0;
            n4 = Math.min(n4, ((Dimension)serializable).width);
        }
        if (n2 + n3 > ((Dimension)serializable).height) {
            n2 = 0;
            n3 = Math.min(n3, ((Dimension)serializable).height);
        }
        this.ruler.setLocation(n, n2);
        this.ruler.setSize(n4, n3);
        this.minimapW = new Dialog(this.frame, Messages.getString("ClientGUI.MiniMap"), false);
        n = GUIPreferences.getInstance().getMinimapPosX();
        n2 = GUIPreferences.getInstance().getMinimapPosY();
        try {
            this.minimap = new MiniMap(this.minimapW, this, this.bv);
        }
        catch (IOException iOException) {
            this.doAlertDialog(Messages.getString("ClientGUI.FatalError.title"), Messages.getString("ClientGUI.FatalError.message1") + iOException);
            this.die();
        }
        this.minimap.addKeyListener(this);
        n3 = this.minimap.getSize().height;
        n4 = this.minimap.getSize().width;
        if (n + 10 >= ((Dimension)serializable).width || n + n4 < 10) {
            n = ((Dimension)serializable).width - n4;
        }
        if (n2 + 10 > ((Dimension)serializable).height || n2 + n3 < 10) {
            n2 = ((Dimension)serializable).height - n3;
        }
        this.minimapW.setLocation(n, n2);
        this.minimapW.addWindowListener(this);
        this.minimapW.addKeyListener(this);
        this.minimapW.add(this.minimap);
        this.cb = new ChatterBox(this);
        this.add(this.cb.getComponent(), "South");
        this.client.changePhase(-1);
        this.mechSelectorDialog = new MechSelectorDialog(this, (UnitLoadingDialog)component);
        this.randomArmyDialog = new RandomArmyDialog(this);
        this.customBADialog = new CustomBattleArmorDialog(this);
        new Thread((Runnable)this.mechSelectorDialog, "Mech Selector Dialog").start();
        new Thread((Runnable)this.customBADialog, "Custom Battle Armor Dialog").start();
    }

    public CommonMenuBar getMenuBar() {
        return this.menuBar;
    }

    private void showAbout() {
        if (this.about == null) {
            this.about = new CommonAboutDialog(this.frame);
        }
        this.about.setVisible(true);
    }

    protected void setHelpFileName(String string) {
        if (null != string) {
            this.helpFileName = string;
        }
    }

    public void showHelp() {
        if (this.help == null) {
            this.help = new CommonHelpDialog(this.frame, new File(this.helpFileName));
        }
        this.help.setVisible(true);
    }

    private void showSettings() {
        if (this.setdlg == null) {
            this.setdlg = new CommonSettingsDialog(this.frame);
        }
        this.setdlg.setVisible(true);
    }

    private void showOptions() {
        if (this.client.game.getPhase() == 1) {
            this.getGameOptionsDialog().setEditable(true);
        } else {
            this.getGameOptionsDialog().setEditable(false);
        }
        this.getGameOptionsDialog().update(this.client.game.getOptions());
        this.getGameOptionsDialog().setVisible(true);
    }

    private void showPlayerList() {
        if (this.playerListDialog == null) {
            this.playerListDialog = new PlayerListDialog(this.frame, this.client);
        }
        this.playerListDialog.setVisible(true);
    }

    private void showRoundReport() {
        new MiniReportDisplay(this.frame, this.client.roundReport).setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equalsIgnoreCase("fileGameSave")) {
            FileDialog fileDialog = new FileDialog(this.frame, Messages.getString("ClientGUI.FileSaveDialog.title"), 0);
            fileDialog.setDirectory(".");
            fileDialog.setFilenameFilter(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return null != string && string.endsWith(".sav");
                }
            });
            fileDialog.setFile("*.sav");
            fileDialog.setVisible(true);
            if (null != fileDialog.getFile()) {
                this.client.sendChat("/save " + fileDialog.getFile());
            }
        }
        if (actionEvent.getActionCommand().equalsIgnoreCase("helpAbout")) {
            this.showAbout();
        }
        if (actionEvent.getActionCommand().equalsIgnoreCase("helpContents")) {
            this.showHelp();
        }
        if (actionEvent.getActionCommand().equalsIgnoreCase("viewClientSettings")) {
            this.showSettings();
        }
        if (actionEvent.getActionCommand().equalsIgnoreCase("viewGameOptions")) {
            this.showOptions();
        }
        if (actionEvent.getActionCommand().equalsIgnoreCase("viewPlayerList")) {
            this.showPlayerList();
        }
        if (actionEvent.getActionCommand().equalsIgnoreCase("viewRoundReport")) {
            this.showRoundReport();
        }
        if (actionEvent.getActionCommand().equals(VIEW_MEK_DISPLAY)) {
            this.toggleDisplay();
        } else if (actionEvent.getActionCommand().equals(VIEW_MINI_MAP)) {
            this.toggleMap();
        } else if (actionEvent.getActionCommand().equals(VIEW_UNIT_OVERVIEW)) {
            this.toggleUnitOverview();
        } else if (actionEvent.getActionCommand().equals(VIEW_ZOOM_IN)) {
            this.bv.zoomIn();
        } else if (actionEvent.getActionCommand().equals(VIEW_ZOOM_OUT)) {
            this.bv.zoomOut();
        } else if (actionEvent.getActionCommand().equals(VIEW_LOS_SETTING)) {
            this.showLOSSettingDialog();
        }
    }

    public void saveSettings() {
        GUIPreferences.getInstance().setWindowPosX(this.frame.getLocation().x);
        GUIPreferences.getInstance().setWindowPosY(this.frame.getLocation().y);
        GUIPreferences.getInstance().setWindowSizeWidth(this.frame.getSize().width);
        GUIPreferences.getInstance().setWindowSizeHeight(this.frame.getSize().height);
        if (this.minimapW != null && this.minimapW.getSize().width * this.minimapW.getSize().height > 0) {
            GUIPreferences.getInstance().setMinimapPosX(this.minimapW.getLocation().x);
            GUIPreferences.getInstance().setMinimapPosY(this.minimapW.getLocation().y);
            GUIPreferences.getInstance().setMinimapZoom(this.minimap.getZoom());
        }
        if (this.mechW != null && this.mechW.getSize().width * this.mechW.getSize().height > 0) {
            GUIPreferences.getInstance().setDisplayPosX(this.mechW.getLocation().x);
            GUIPreferences.getInstance().setDisplayPosY(this.mechW.getLocation().y);
            GUIPreferences.getInstance().setDisplaySizeWidth(this.mechW.getSize().width);
            GUIPreferences.getInstance().setDisplaySizeHeight(this.mechW.getSize().height);
        }
        if (this.ruler != null && this.ruler.getSize().width != 0 && this.ruler.getSize().height != 0) {
            GUIPreferences.getInstance().setRulerPosX(this.ruler.getLocation().x);
            GUIPreferences.getInstance().setRulerPosY(this.ruler.getLocation().y);
            GUIPreferences.getInstance().setRulerSizeWidth(this.ruler.getSize().width);
            GUIPreferences.getInstance().setRulerSizeHeight(this.ruler.getSize().height);
        }
    }

    public void die() {
        boolean bl = false;
        for (Component component : this.phaseComponents.values()) {
            if (component instanceof ReportDisplay) {
                if (bl) continue;
                bl = true;
            }
            if (!(component instanceof Distractable)) continue;
            ((Distractable)((Object)component)).removeAllListeners();
        }
        this.frame.removeAll();
        this.frame.setVisible(false);
        try {
            this.frame.dispose();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.client.die();
        this.bv.die();
        if (this.chatlounge != null) {
            this.chatlounge.die();
        }
    }

    public BoardSelectionDialog getBoardSelectionDialog() {
        if (this.boardSelectionDialog == null) {
            this.boardSelectionDialog = new BoardSelectionDialog(this);
        }
        return this.boardSelectionDialog;
    }

    public GameOptionsDialog getGameOptionsDialog() {
        if (this.gameOptionsDialog == null) {
            this.gameOptionsDialog = new GameOptionsDialog(this);
        }
        return this.gameOptionsDialog;
    }

    public MechSelectorDialog getMechSelectorDialog() {
        return this.mechSelectorDialog;
    }

    public CustomBattleArmorDialog getCustomBADialog() {
        return this.customBADialog;
    }

    public StartingPositionDialog getStartingPositionDialog() {
        if (this.startingPositionDialog == null) {
            this.startingPositionDialog = new StartingPositionDialog(this);
        }
        return this.startingPositionDialog;
    }

    private void switchPanel(int n) {
        if (this.curPanel instanceof BoardViewListener) {
            this.bv.removeBoardViewListener((BoardViewListener)((Object)this.curPanel));
        }
        if (this.curPanel instanceof ActionListener) {
            this.menuBar.removeActionListener((ActionListener)((Object)this.curPanel));
        }
        if (this.curPanel instanceof Distractable) {
            ((Distractable)((Object)this.curPanel)).setIgnoringEvents(true);
        }
        String string = String.valueOf(n);
        this.curPanel = this.phaseComponents.get(string);
        if (null == this.curPanel) {
            this.curPanel = this.initializePanel(n);
        }
        this.cardsMain.show(this.panMain, this.mainNames.get(string).toString());
        this.cardsSecondary.show(this.panSecondary, this.secondaryNames.get(string).toString());
        if (this.curPanel instanceof BoardViewListener) {
            this.bv.addBoardViewListener((BoardViewListener)((Object)this.curPanel));
        }
        if (this.curPanel instanceof ActionListener) {
            this.menuBar.addActionListener((ActionListener)((Object)this.curPanel));
        }
        if (this.curPanel instanceof Distractable) {
            ((Distractable)((Object)this.curPanel)).setIgnoringEvents(false);
        }
        if (this.curPanel instanceof DoneButtoned) {
            Button button = ((DoneButtoned)((Object)this.curPanel)).getDoneButton();
            this.cb.setDoneButton(button);
            button.setVisible(true);
        }
        if (GUIPreferences.getInstance().getFocus() && !(this.client instanceof TestBot)) {
            this.curPanel.requestFocus();
        }
    }

    private Component initializePanel(int n) {
        String string = String.valueOf(n);
        Component component = null;
        String string2 = null;
        String string3 = null;
        switch (n) {
            case 1: {
                component = new ChatLounge(this);
                this.chatlounge = component;
                string2 = string3 = "ChatLounge";
                this.panMain.add(string3, component);
                this.panSecondary.add(string2, ((ChatLounge)component).getSecondaryDisplay());
                break;
            }
            case 21: {
                component = new Label(Messages.getString("ClientGUI.StartingScenario"));
                string2 = string3 = "Label-StartingScenario";
                this.panMain.add(string3, component);
                this.panSecondary.add(string2, new Label(""));
                break;
            }
            case 3: {
                component = new Label(Messages.getString("ClientGUI.TransmittingData"));
                string2 = string3 = "Label-Exchange";
                this.panMain.add(string3, component);
                this.panSecondary.add(string2, new Label(""));
                break;
            }
            case 22: {
                component = new SelectArtyAutoHitHexDisplay(this);
                string3 = "BoardView";
                string2 = "SelectArtyAutoHitHexDisplay";
                if (!this.mainNames.keySet().contains(string3)) {
                    this.panMain.add(string3, this.scroller);
                }
                this.panSecondary.add(string2, component);
                break;
            }
            case 20: {
                component = new DeployMinefieldDisplay(this);
                string3 = "BoardView";
                string2 = "DeployMinefieldDisplay";
                if (!this.mainNames.keySet().contains(string3)) {
                    this.panMain.add(string3, this.scroller);
                }
                this.panSecondary.add(string2, component);
                break;
            }
            case 4: {
                component = new DeploymentDisplay(this);
                string3 = "BoardView";
                string2 = "DeploymentDisplay";
                if (!this.mainNames.keySet().contains(string3)) {
                    this.panMain.add(string3, this.scroller);
                }
                this.panSecondary.add(string2, component);
                break;
            }
            case 7: {
                component = new TargetingPhaseDisplay(this, false);
                ((TargetingPhaseDisplay)component).initializeListeners();
                string3 = "BoardView";
                string2 = "TargetingPhaseDisplay";
                if (!this.mainNames.keySet().contains(string3)) {
                    this.panMain.add(string3, this.scroller);
                }
                this.panSecondary.add(string2, component);
                break;
            }
            case 8: {
                component = new MovementDisplay(this);
                string3 = "BoardView";
                string2 = "MovementDisplay";
                if (!this.mainNames.keySet().contains(string3)) {
                    this.panMain.add(string3, this.scroller);
                }
                this.panSecondary.add(string2, component);
                break;
            }
            case 10: {
                component = new TargetingPhaseDisplay(this, true);
                ((TargetingPhaseDisplay)component).initializeListeners();
                string3 = "BoardView";
                string2 = "OffboardDisplay";
                if (!this.mainNames.keySet().contains(string3)) {
                    this.panMain.add(string3, this.scroller);
                }
                this.panSecondary.add(string2, component);
                break;
            }
            case 12: {
                component = new FiringDisplay(this);
                string3 = "BoardView";
                string2 = "FiringDisplay";
                if (!this.mainNames.keySet().contains(string3)) {
                    this.panMain.add(string3, this.scroller);
                }
                this.panSecondary.add(string2, component);
                break;
            }
            case 14: {
                component = new PhysicalDisplay(this);
                string3 = "BoardView";
                string2 = "PhysicalDisplay";
                if (!this.mainNames.keySet().contains(string3)) {
                    this.panMain.add(string3, this.scroller);
                }
                this.panSecondary.add(string2, component);
                break;
            }
            case 6: {
                component = new ReportDisplay(this.client);
                string2 = string3 = "ReportDisplay";
                this.panMain.add(string3, component);
                this.panSecondary.add(string2, ((ReportDisplay)component).getSecondaryDisplay());
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                component = this.phaseComponents.get(String.valueOf(6));
                if (null == component) {
                    component = this.initializePanel(6);
                }
                string2 = string3 = "ReportDisplay";
                break;
            }
            default: {
                component = new Label(Messages.getString("ClientGUI.waitingOnTheServer"));
                string2 = string3 = "Label-Default";
                this.panMain.add(string3, component);
                this.panSecondary.add(string2, new Label(""));
            }
        }
        this.phaseComponents.put(string, component);
        this.mainNames.put(string, string3);
        this.secondaryNames.put(string, string2);
        return component;
    }

    protected void addBag(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    protected void showBoardPopup(Point point) {
        if (!this.bv.mayDrawPopup()) {
            return;
        }
        this.fillPopup(this.bv.getCoordsAt(point));
        if (this.popup.getItemCount() > 0) {
            this.popup.show(this.bv, point.x, point.y);
        }
    }

    private boolean canTargetEntities() {
        return this.client.isMyTurn() && (this.curPanel instanceof FiringDisplay || this.curPanel instanceof PhysicalDisplay || this.curPanel instanceof TargetingPhaseDisplay);
    }

    private boolean canSelectEntities() {
        return this.client.isMyTurn() && (this.curPanel instanceof FiringDisplay || this.curPanel instanceof PhysicalDisplay || this.curPanel instanceof MovementDisplay || this.curPanel instanceof TargetingPhaseDisplay);
    }

    public void toggleDisplay() {
        this.mechW.setVisible(!this.mechW.isVisible());
        if (this.mechW.isVisible()) {
            this.frame.requestFocus();
        }
    }

    public void setDisplayVisible(boolean bl) {
        this.mechW.setVisible(bl);
        if (bl) {
            this.frame.requestFocus();
        }
    }

    public void toggleUnitOverview() {
        this.uo.setVisible(!this.uo.isVisible());
        this.bv.repaint();
    }

    public void toggleMap() {
        if (this.minimapW.isVisible()) {
            GUIPreferences.getInstance().setMinimapEnabled(false);
        } else {
            GUIPreferences.getInstance().setMinimapEnabled(true);
        }
        this.minimapW.setVisible(!this.minimapW.isVisible());
        if (this.minimapW.isVisible()) {
            this.frame.requestFocus();
        }
    }

    public void setMapVisible(boolean bl) {
        this.minimapW.setVisible(bl);
        if (bl) {
            this.frame.requestFocus();
        }
    }

    protected void fillPopup(Coords coords) {
        Entity entity;
        Object object;
        this.popup.removeAll();
        if (this.canSelectEntities()) {
            object = this.client.game.getEntities(coords);
            while (object.hasMoreElements()) {
                entity = object.nextElement();
                if (!this.client.game.getTurn().isValidEntity(entity, this.client.game)) continue;
                this.popup.add(new SelectMenuItem(entity));
            }
        }
        if (this.popup.getItemCount() > 0) {
            this.popup.addSeparator();
        }
        object = this.client.game.getEntities(coords);
        while (object.hasMoreElements()) {
            entity = object.nextElement();
            this.popup.add(new ViewMenuItem(entity));
        }
        if (this.canTargetEntities()) {
            if (this.popup.getItemCount() > 0) {
                this.popup.addSeparator();
            }
            object = this.client.game.getEntities(coords);
            while (object.hasMoreElements()) {
                entity = object.nextElement();
                this.popup.add(new TargetMenuItem(entity));
            }
            if (this.curPanel instanceof FiringDisplay || this.curPanel instanceof PhysicalDisplay || this.curPanel instanceof TargetingPhaseDisplay) {
                object = this.client.game.getBoard().getHex(coords);
                if (object != null && this.curPanel instanceof FiringDisplay) {
                    this.popup.add(new TargetMenuItem(new HexTarget(coords, this.client.game.getBoard(), 1)));
                    if (this.client.game.getOptions().booleanOption("fire")) {
                        this.popup.add(new TargetMenuItem(new HexTarget(coords, this.client.game.getBoard(), 2)));
                    }
                } else if (object != null && object.containsTerrain(32)) {
                    this.popup.add(new TargetMenuItem(new BuildingTarget(coords, this.client.game.getBoard(), false)));
                    if (this.client.game.getOptions().booleanOption("fire")) {
                        this.popup.add(new TargetMenuItem(new BuildingTarget(coords, this.client.game.getBoard(), true)));
                    }
                } else if (object != null && object.containsTerrain(10)) {
                    this.popup.add(new TargetMenuItem(new BuildingTarget(coords, this.client.game.getBoard(), false)));
                    if (this.client.game.getOptions().booleanOption("fire")) {
                        this.popup.add(new TargetMenuItem(new BuildingTarget(coords, this.client.game.getBoard(), true)));
                    }
                }
                if (object != null && this.client.game.containsMinefield(coords) && this.curPanel instanceof FiringDisplay) {
                    this.popup.add(new TargetMenuItem(new MinefieldTarget(coords, this.client.game.getBoard())));
                }
                if (object != null && this.curPanel instanceof FiringDisplay) {
                    this.popup.add(new TargetMenuItem(new HexTarget(coords, this.client.game.getBoard(), 6)));
                    this.popup.add(new TargetMenuItem(new HexTarget(coords, this.client.game.getBoard(), 13)));
                    this.popup.add(new TargetMenuItem(new HexTarget(coords, this.client.game.getBoard(), 14)));
                    this.popup.add(new TargetMenuItem(new HexTarget(coords, this.client.game.getBoard(), 7)));
                    if (this.client.game.getOptions().booleanOption("fire") && object.containsTerrain(7)) {
                        this.popup.add(new TargetMenuItem(new HexTarget(coords, this.client.game.getBoard(), 8)));
                    }
                }
                if (object != null && this.curPanel instanceof TargetingPhaseDisplay) {
                    this.popup.add(new TargetMenuItem(new HexTarget(coords, this.client.game.getBoard(), 7)));
                }
            }
        }
    }

    public int[] doChoiceDialog(String string, String string2, String[] stringArray) {
        ChoiceDialog choiceDialog = new ChoiceDialog(this.frame, string, string2, stringArray);
        choiceDialog.setVisible(true);
        return choiceDialog.getChoices();
    }

    public void doAlertDialog(String string, String string2) {
        AlertDialog alertDialog = new AlertDialog(this.frame, string, string2);
        alertDialog.setVisible(true);
    }

    public boolean doYesNoDialog(String string, String string2) {
        ConfirmDialog confirmDialog = new ConfirmDialog(this.frame, string, string2);
        confirmDialog.setVisible(true);
        return confirmDialog.getAnswer();
    }

    public ConfirmDialog doYesNoBotherDialog(String string, String string2) {
        ConfirmDialog confirmDialog = new ConfirmDialog(this.frame, string, string2, true);
        confirmDialog.setVisible(true);
        return confirmDialog;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showBoardPopup(mouseEvent.getPoint());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showBoardPopup(mouseEvent.getPoint());
        }
    }

    protected void loadListFile() {
        if (null == this.dlgLoadList) {
            this.dlgLoadList = new FileDialog(this.frame, Messages.getString("ClientGUI.openUnitListFileDialog.title"), 0);
            this.dlgLoadList.setFilenameFilter(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return null != string && string.endsWith(".mul");
                }
            });
            this.dlgLoadList.setDirectory(".");
            this.dlgLoadList.setFile("*.mul");
        }
        this.dlgLoadList.setVisible(true);
        String string = this.dlgLoadList.getDirectory();
        String string2 = this.dlgLoadList.getFile();
        if (null != string2) {
            try {
                Vector vector = EntityListFile.loadFrom(new File(string, string2));
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Entity entity = (Entity)enumeration.nextElement();
                    entity.setOwner(this.client.getLocalPlayer());
                    this.client.sendAddEntity(entity);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
                this.doAlertDialog(Messages.getString("ClientGUI.errorLoadingFile"), iOException.getMessage());
            }
        }
    }

    protected void saveListFile(Vector<Entity> vector) {
        if (null == vector || vector.isEmpty()) {
            return;
        }
        if (null == this.dlgSaveList) {
            this.dlgSaveList = new FileDialog(this.frame, Messages.getString("ClientGUI.saveUnitListFileDialog.title"), 1);
            this.dlgSaveList.setFilenameFilter(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return null != string && string.endsWith(".mul");
                }
            });
            this.dlgSaveList.setDirectory(".");
            this.dlgSaveList.setFile(this.client.getLocalPlayer().getName() + ".mul");
        }
        this.dlgSaveList.setVisible(true);
        String string = this.dlgSaveList.getDirectory();
        String string2 = this.dlgSaveList.getFile();
        if (null != string2) {
            if (!string2.toLowerCase().endsWith(".mul") && !string2.toLowerCase().endsWith(".xml")) {
                string2 = string2 + ".mul";
            }
            try {
                EntityListFile.saveTo(new File(string, string2), vector);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
                this.doAlertDialog(Messages.getString("ClientGUI.errorSavingFile"), iOException.getMessage());
            }
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this.minimapW) {
            this.setMapVisible(false);
        } else if (windowEvent.getWindow() == this.mechW) {
            this.setDisplayVisible(false);
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void showLOSSettingDialog() {
        GUIPreferences gUIPreferences = GUIPreferences.getInstance();
        LOSDialog lOSDialog = new LOSDialog(this.frame, gUIPreferences.getMechInFirst(), gUIPreferences.getMechInSecond());
        lOSDialog.setVisible(true);
        gUIPreferences.setMechInFirst(lOSDialog.getMechInFirst());
        gUIPreferences.setMechInSecond(lOSDialog.getMechInSecond());
    }

    public void loadPreviewImage(BufferedPanel bufferedPanel, Entity entity) {
        Player player = this.client.game.getPlayer(entity.getOwnerId());
        this.loadPreviewImage(bufferedPanel, entity, player);
    }

    public void loadPreviewImage(BufferedPanel bufferedPanel, Entity entity, Player player) {
        Image image = this.bv.getTilesetManager().getPlayerCamo(player);
        int n = PlayerColors.getColorRGB(player.getColorIndex());
        this.bv.getTilesetManager().loadPreviewImage(entity, image, n, bufferedPanel);
    }

    public void bing() {
        if (!GUIPreferences.getInstance().getSoundMute() && null != this.bingClip) {
            this.bingClip.play();
        }
    }

    public Client getClient() {
        return this.client;
    }

    public Map<String, Client> getBots() {
        return this.bots;
    }

    public int getSelectedEntityNum() {
        return this.selectedEntityNum;
    }

    public void setSelectedEntityNum(int n) {
        this.selectedEntityNum = n;
    }

    public RandomArmyDialog getRandomArmyDialog() {
        return this.randomArmyDialog;
    }

    private class TargetMenuItem
    extends MenuItem
    implements ActionListener {
        Targetable target;

        public TargetMenuItem(Targetable targetable) {
            super(Messages.getString("ClientGUI.targetMenuItem") + targetable.getDisplayName());
            this.target = targetable;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ClientGUI.this.curPanel instanceof FiringDisplay) {
                ((FiringDisplay)ClientGUI.this.curPanel).target(this.target);
            } else if (ClientGUI.this.curPanel instanceof PhysicalDisplay) {
                ((PhysicalDisplay)ClientGUI.this.curPanel).target(this.target);
            } else if (ClientGUI.this.curPanel instanceof TargetingPhaseDisplay) {
                ((TargetingPhaseDisplay)ClientGUI.this.curPanel).target(this.target);
            }
        }
    }

    private class SelectMenuItem
    extends MenuItem
    implements ActionListener {
        Entity entity;

        public SelectMenuItem(Entity entity) {
            super(Messages.getString("ClientGUI.selectMenuItem") + entity.getDisplayName());
            this.entity = entity;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ClientGUI.this.curPanel instanceof MovementDisplay) {
                ((MovementDisplay)ClientGUI.this.curPanel).selectEntity(this.entity.getId());
            } else if (ClientGUI.this.curPanel instanceof FiringDisplay) {
                ((FiringDisplay)ClientGUI.this.curPanel).selectEntity(this.entity.getId());
            } else if (ClientGUI.this.curPanel instanceof PhysicalDisplay) {
                ((PhysicalDisplay)ClientGUI.this.curPanel).selectEntity(this.entity.getId());
            }
        }
    }

    private class ViewMenuItem
    extends MenuItem
    implements ActionListener {
        Entity entity;

        public ViewMenuItem(Entity entity) {
            super(Messages.getString("ClientGUI.viewMenuItem") + entity.getDisplayName() + (entity.isDone() ? " (" + Messages.getString("ClientGUI.doneMenuItem").trim() + ")" : ""));
            this.entity = entity;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ClientGUI.this.setDisplayVisible(true);
            ClientGUI.this.mechD.displayEntity(this.entity);
        }
    }
}

