/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import gov.nist.gui.TabPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import megamek.client.ui.AWT.ClientDialog;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.widget.AdvancedLabel;
import megamek.common.preference.IClientPreferences;
import megamek.common.preference.PreferenceManager;

public class CommonSettingsDialog
extends ClientDialog
implements ActionListener,
ItemListener,
FocusListener {
    private ScrollPane scrolledPane = new ScrollPane();
    private TabPanel panTabs = new TabPanel();
    private Checkbox minimapEnabled;
    private Checkbox autoEndFiring;
    private Checkbox autoDeclareSearchlight;
    private Checkbox nagForMASC;
    private Checkbox nagForPSR;
    private Checkbox nagForNoAction;
    private Checkbox animateMove;
    private Checkbox showWrecks;
    private Checkbox soundMute;
    private Checkbox showMapHexPopup;
    private TextField tooltipDelay;
    private Choice unitStartChar;
    private TextField maxPathfinderTime;
    private Checkbox getFocus;
    private Checkbox rightDragScroll;
    private Checkbox ctlScroll;
    private Checkbox clickEdgeScroll;
    private Checkbox alwaysRightClickScroll;
    private Checkbox autoEdgeScroll;
    private TextField scrollSensitivity;
    private Checkbox keepGameLog;
    private TextField gameLogFilename;
    private Checkbox stampFilenames;
    private TextField stampFormat;
    private Checkbox defaultAutoejectDisabled;
    private Checkbox useAverageSkills;
    private Checkbox showUnitId;
    private Choice locale;
    private Checkbox chatloungeTabs;
    private Checkbox showMapsheets;
    private Checkbox mouseWheelZoom;
    private List keys;
    private int keysIndex = 0;
    private TextField value;
    private Choice tileSetChoice;
    private File[] tileSets;
    private static final String CANCEL = "CANCEL";
    private static final String UPDATE = "UPDATE";
    private static final String[] LOCALE_CHOICES = new String[]{"en", "de", "ru"};

    public CommonSettingsDialog(Frame frame) {
        super(frame, Messages.getString("CommonSettingsDialog.title"));
        Panel panel = this.getSettingsPanel();
        this.scrolledPane.add(panel);
        this.panTabs.add("Main", (Component)this.scrolledPane);
        this.panTabs.add("Advanced", (Component)this.getAdvancedSettingsPanel());
        this.setLayout(new BorderLayout());
        this.add((Component)this.panTabs, "Center");
        this.add((Component)this.getButtonsPanel(), "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CommonSettingsDialog.this.cancel();
            }
        });
        this.pack();
        this.setLocationAndSize(panel.getPreferredSize().width + this.scrolledPane.getInsets().right + 10, panel.getPreferredSize().height);
    }

    private Panel getButtonsPanel() {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 0, 20, 5));
        Button button = new Button(Messages.getString("CommonSettingsDialog.Update"));
        button.setActionCommand(UPDATE);
        button.addActionListener(this);
        panel.add(button);
        Button button2 = new Button(Messages.getString("Cancel"));
        button2.setActionCommand(CANCEL);
        button2.addActionListener(this);
        panel.add(button2);
        return panel;
    }

    private Panel getSettingsPanel() {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 1));
        this.minimapEnabled = new Checkbox(Messages.getString("CommonSettingsDialog.minimapEnabled"));
        panel.add(this.minimapEnabled);
        this.autoEndFiring = new Checkbox(Messages.getString("CommonSettingsDialog.autoEndFiring"));
        panel.add(this.autoEndFiring);
        this.autoDeclareSearchlight = new Checkbox(Messages.getString("CommonSettingsDialog.autoDeclareSearchlight"));
        panel.add(this.autoDeclareSearchlight);
        this.nagForMASC = new Checkbox(Messages.getString("CommonSettingsDialog.nagForMASC"));
        panel.add(this.nagForMASC);
        this.mouseWheelZoom = new Checkbox(Messages.getString("CommonSettingsDialog.mouseWheelZoom"));
        panel.add(this.mouseWheelZoom);
        this.nagForPSR = new Checkbox(Messages.getString("CommonSettingsDialog.nagForPSR"));
        panel.add(this.nagForPSR);
        this.nagForNoAction = new Checkbox(Messages.getString("CommonSettingsDialog.nagForNoAction"));
        panel.add(this.nagForNoAction);
        this.animateMove = new Checkbox(Messages.getString("CommonSettingsDialog.animateMove"));
        panel.add(this.animateMove);
        this.showWrecks = new Checkbox(Messages.getString("CommonSettingsDialog.showWrecks"));
        panel.add(this.showWrecks);
        this.soundMute = new Checkbox(Messages.getString("CommonSettingsDialog.soundMute"));
        panel.add(this.soundMute);
        this.showMapHexPopup = new Checkbox(Messages.getString("CommonSettingsDialog.showMapHexPopup"));
        panel.add(this.showMapHexPopup);
        Panel panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label(Messages.getString("CommonSettingsDialog.tooltipDelay")));
        this.tooltipDelay = new TextField(4);
        panel2.add(this.tooltipDelay);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        this.unitStartChar = new Choice();
        this.unitStartChar.addItem("A, B, C, D...");
        this.unitStartChar.addItem("\u0391, \u0392, \u0393, \u0394...");
        this.unitStartChar.addItem("\u03b1, \u03b2, \u03b3, \u03b4...");
        panel2.add(this.unitStartChar);
        panel2.add(new Label(Messages.getString("CommonSettingsDialog.protoMechUnitCodes")));
        panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label(Messages.getString("CommonSettingsDialog.pathFiderTimeLimit")));
        this.maxPathfinderTime = new TextField(5);
        panel2.add(this.maxPathfinderTime);
        panel.add(panel2);
        this.getFocus = new Checkbox(Messages.getString("CommonSettingsDialog.getFocus"));
        panel.add(this.getFocus);
        panel.add(panel2);
        this.defaultAutoejectDisabled = new Checkbox(Messages.getString("CommonSettingsDialog.defaultAutoejectDisabled"));
        this.defaultAutoejectDisabled.addItemListener(this);
        panel.add(this.defaultAutoejectDisabled);
        this.useAverageSkills = new Checkbox(Messages.getString("CommonSettingsDialog.useAverageSkills"));
        this.useAverageSkills.addItemListener(this);
        panel.add(this.useAverageSkills);
        this.showUnitId = new Checkbox(Messages.getString("CommonSettingsDialog.showUnitId"));
        this.showUnitId.addItemListener(this);
        panel.add(this.showUnitId);
        this.keepGameLog = new Checkbox(Messages.getString("CommonSettingsDialog.keepGameLog"));
        this.keepGameLog.addItemListener(this);
        panel.add(this.keepGameLog);
        panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label(Messages.getString("CommonSettingsDialog.logFileName")));
        this.gameLogFilename = new TextField(15);
        panel2.add(this.gameLogFilename);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label(Messages.getString("CommonSettingsDialog.tileset")));
        this.tileSetChoice = new Choice();
        panel2.add(this.tileSetChoice);
        panel.add(panel2);
        this.stampFilenames = new Checkbox(Messages.getString("CommonSettingsDialog.stampFilenames"));
        this.stampFilenames.addItemListener(this);
        panel.add(this.stampFilenames);
        panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label(Messages.getString("CommonSettingsDialog.stampFormat")));
        this.stampFormat = new TextField(15);
        panel2.add(this.stampFormat);
        panel.add(panel2);
        panel.add(new AdvancedLabel(Messages.getString("CommonSettingsDialog.mapScrollText")));
        this.rightDragScroll = new Checkbox(Messages.getString("CommonSettingsDialog.rightDragScroll"));
        panel.add(this.rightDragScroll);
        this.ctlScroll = new Checkbox(Messages.getString("CommonSettingsDialog.ctlScroll"));
        panel.add(this.ctlScroll);
        this.clickEdgeScroll = new Checkbox(Messages.getString("CommonSettingsDialog.clickEdgeScroll"));
        panel.add(this.clickEdgeScroll);
        this.alwaysRightClickScroll = new Checkbox(Messages.getString("CommonSettingsDialog.alwaysRightClickScroll"));
        panel.add(this.alwaysRightClickScroll);
        this.autoEdgeScroll = new Checkbox(Messages.getString("CommonSettingsDialog.autoEdgeScroll"));
        panel.add(this.autoEdgeScroll);
        panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label(Messages.getString("CommonSettingsDialog.scrollSesitivity")));
        this.scrollSensitivity = new TextField(4);
        panel2.add(this.scrollSensitivity);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label(Messages.getString("CommonSettingsDialog.locale")));
        this.locale = new Choice();
        this.locale.add(Messages.getString("CommonSettingsDialog.locale.English"));
        this.locale.add(Messages.getString("CommonSettingsDialog.locale.Deutsch"));
        this.locale.add(Messages.getString("CommonSettingsDialog.locale.Russian"));
        panel2.add(this.locale);
        panel.add(panel2);
        this.chatloungeTabs = new Checkbox(Messages.getString("CommonSettingsDialog.chatloungeTabs"));
        panel.add(this.chatloungeTabs);
        this.showMapsheets = new Checkbox(Messages.getString("CommonSettingsDialog.showMapsheets"));
        panel.add(this.showMapsheets);
        return panel;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            int n;
            GUIPreferences gUIPreferences = GUIPreferences.getInstance();
            IClientPreferences iClientPreferences = PreferenceManager.getClientPreferences();
            this.minimapEnabled.setState(gUIPreferences.getMinimapEnabled());
            this.autoEndFiring.setState(gUIPreferences.getAutoEndFiring());
            this.autoDeclareSearchlight.setState(gUIPreferences.getAutoDeclareSearchlight());
            this.nagForMASC.setState(gUIPreferences.getNagForMASC());
            this.nagForPSR.setState(gUIPreferences.getNagForPSR());
            this.nagForNoAction.setState(gUIPreferences.getNagForNoAction());
            this.animateMove.setState(gUIPreferences.getShowMoveStep());
            this.showWrecks.setState(gUIPreferences.getShowWrecks());
            this.soundMute.setState(gUIPreferences.getSoundMute());
            this.showMapHexPopup.setState(gUIPreferences.getShowMapHexPopup());
            this.tooltipDelay.setText(Integer.toString(gUIPreferences.getTooltipDelay()));
            this.mouseWheelZoom.setState(gUIPreferences.getMouseWheelZoom());
            this.unitStartChar.select(0);
            for (n = 0; n < this.unitStartChar.getItemCount(); ++n) {
                if (this.unitStartChar.getItem(n).charAt(0) != PreferenceManager.getClientPreferences().getUnitStartChar()) continue;
                this.unitStartChar.select(n);
                break;
            }
            this.maxPathfinderTime.setText(Integer.toString(iClientPreferences.getMaxPathfinderTime()));
            this.rightDragScroll.setState(gUIPreferences.getRightDragScroll());
            this.ctlScroll.setState(gUIPreferences.getCtlScroll());
            this.clickEdgeScroll.setState(gUIPreferences.getClickEdgeScroll());
            this.alwaysRightClickScroll.setState(gUIPreferences.getAlwaysRightClickScroll());
            this.autoEdgeScroll.setState(gUIPreferences.getAutoEdgeScroll());
            this.scrollSensitivity.setText(Integer.toString(gUIPreferences.getScrollSensitivity()));
            this.keepGameLog.setState(iClientPreferences.keepGameLog());
            this.gameLogFilename.setEnabled(this.keepGameLog.getState());
            this.gameLogFilename.setText(iClientPreferences.getGameLogFilename());
            this.stampFilenames.setState(iClientPreferences.stampFilenames());
            this.stampFormat.setEnabled(this.stampFilenames.getState());
            this.stampFormat.setText(iClientPreferences.getStampFormat());
            this.defaultAutoejectDisabled.setState(iClientPreferences.defaultAutoejectDisabled());
            this.useAverageSkills.setState(iClientPreferences.useAverageSkills());
            this.showUnitId.setState(iClientPreferences.getShowUnitId());
            n = 0;
            if (iClientPreferences.getLocaleString().startsWith("de")) {
                n = 1;
            }
            if (iClientPreferences.getLocaleString().startsWith("ru")) {
                n = 2;
            }
            this.locale.select(n);
            this.chatloungeTabs.setState(gUIPreferences.getChatLoungeTabs());
            this.showMapsheets.setState(gUIPreferences.getShowMapsheets());
            File file = new File("data" + File.separator + "images" + File.separator + "hexes" + File.separator);
            this.tileSets = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".tileset");
                }
            });
            this.tileSetChoice.removeAll();
            for (int i = 0; i < this.tileSets.length; ++i) {
                String string = this.tileSets[i].getName();
                this.tileSetChoice.add(string.substring(0, string.length() - 8));
                if (!string.equals(iClientPreferences.getMapTileset())) continue;
                this.tileSetChoice.select(i);
            }
            this.getFocus.setState(gUIPreferences.getFocus());
        }
        super.setVisible(bl);
    }

    private void cancel() {
        this.setVisible(false);
    }

    private void update() {
        GUIPreferences gUIPreferences = GUIPreferences.getInstance();
        IClientPreferences iClientPreferences = PreferenceManager.getClientPreferences();
        gUIPreferences.setMinimapEnabled(this.minimapEnabled.getState());
        gUIPreferences.setAutoEndFiring(this.autoEndFiring.getState());
        gUIPreferences.setAutoDeclareSearchlight(this.autoDeclareSearchlight.getState());
        gUIPreferences.setNagForMASC(this.nagForMASC.getState());
        gUIPreferences.setNagForPSR(this.nagForPSR.getState());
        gUIPreferences.setNagForNoAction(this.nagForNoAction.getState());
        gUIPreferences.setShowMoveStep(this.animateMove.getState());
        gUIPreferences.setShowWrecks(this.showWrecks.getState());
        gUIPreferences.setSoundMute(this.soundMute.getState());
        gUIPreferences.setShowMapHexPopup(this.showMapHexPopup.getState());
        gUIPreferences.setTooltipDelay(Integer.parseInt(this.tooltipDelay.getText()));
        iClientPreferences.setUnitStartChar(this.unitStartChar.getSelectedItem().charAt(0));
        gUIPreferences.setRightDragScroll(this.rightDragScroll.getState());
        gUIPreferences.setCtlScroll(this.ctlScroll.getState());
        gUIPreferences.setClickEdgeScroll(this.clickEdgeScroll.getState());
        gUIPreferences.setAlwaysRightClickScroll(this.alwaysRightClickScroll.getState());
        gUIPreferences.setAutoEdgeScroll(this.autoEdgeScroll.getState());
        gUIPreferences.setScrollSensitivity(Integer.parseInt(this.scrollSensitivity.getText()));
        gUIPreferences.setMouseWheelZoom(this.mouseWheelZoom.getState());
        iClientPreferences.setMaxPathfinderTime(Integer.parseInt(this.maxPathfinderTime.getText()));
        gUIPreferences.setGetFocus(this.getFocus.getState());
        iClientPreferences.setKeepGameLog(this.keepGameLog.getState());
        iClientPreferences.setGameLogFilename(this.gameLogFilename.getText());
        iClientPreferences.setStampFilenames(this.stampFilenames.getState());
        iClientPreferences.setStampFormat(this.stampFormat.getText());
        iClientPreferences.setDefaultAutoejectDisabled(this.defaultAutoejectDisabled.getState());
        iClientPreferences.setUseAverageSkills(this.useAverageSkills.getState());
        iClientPreferences.setShowUnitId(this.showUnitId.getState());
        iClientPreferences.setLocale(LOCALE_CHOICES[this.locale.getSelectedIndex()]);
        gUIPreferences.setChatloungeTabs(this.chatloungeTabs.getState());
        gUIPreferences.setShowMapsheets(this.showMapsheets.getState());
        if (this.tileSetChoice.getSelectedIndex() >= 0) {
            iClientPreferences.setMapTileset(this.tileSets[this.tileSetChoice.getSelectedIndex()].getName());
        }
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (UPDATE.equalsIgnoreCase(string)) {
            this.update();
        } else if (CANCEL.equalsIgnoreCase(string)) {
            this.cancel();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable.equals(this.keepGameLog)) {
            this.gameLogFilename.setEnabled(this.keepGameLog.getState());
        }
        if (itemSelectable.equals(this.stampFilenames)) {
            this.stampFormat.setEnabled(this.stampFilenames.getState());
        }
        if (itemEvent.getSource() == this.keys && itemEvent.getStateChange() == 1) {
            this.value.setText(GUIPreferences.getInstance().getString("Advanced" + this.keys.getSelectedItem()));
            this.keysIndex = this.keys.getSelectedIndex();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        GUIPreferences.getInstance().setValue("Advanced" + this.keys.getItem(this.keysIndex), this.value.getText());
    }

    private Panel getAdvancedSettingsPanel() {
        Panel panel = new Panel();
        this.keys = new List(10, false);
        Object[] objectArray = GUIPreferences.getInstance().getAdvancedProperties();
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            this.keys.add(((String)objectArray[i]).substring(((String)objectArray[i]).indexOf("Advanced") + 8, ((String)objectArray[i]).length()));
        }
        this.keys.addItemListener(this);
        panel.add(this.keys);
        this.value = new TextField(10);
        this.value.addFocusListener(this);
        panel.add(this.value);
        return panel;
    }
}

