/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.util.Vector;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.widget.BackGroundDrawer;
import megamek.client.ui.AWT.widget.DisplayMapSet;
import megamek.client.ui.AWT.widget.PMAreasGroup;
import megamek.client.ui.AWT.widget.PMPicPolygonalArea;
import megamek.client.ui.AWT.widget.PMSimpleLabel;
import megamek.client.ui.AWT.widget.PMSimplePolygonArea;
import megamek.client.ui.AWT.widget.PMUtil;
import megamek.client.ui.AWT.widget.PMValueLabel;
import megamek.client.ui.AWT.widget.WidgetUtils;
import megamek.common.Entity;
import megamek.common.Mech;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadMapSet
implements DisplayMapSet {
    private static final String IMAGE_DIR = "data/images/widgets";
    private static final int REAR_AREA_OFFSET = 7;
    private static final int INT_STRUCTURE_OFFSET = 11;
    private PMSimplePolygonArea[] areas = new PMSimplePolygonArea[19];
    private PMSimpleLabel[] labels = new PMSimpleLabel[19];
    private PMValueLabel[] vLabels = new PMValueLabel[20];
    private PMPicPolygonalArea heatHotArea;
    private Vector<BackGroundDrawer> bgDrawers = new Vector();
    private PMAreasGroup content = new PMAreasGroup();
    private Component comp;
    private Polygon rightArm = new Polygon(new int[]{102, 102, 100, 95, 95, 100, 110, 120, 120, 125}, new int[]{120, 70, 65, 65, 50, 55, 55, 65, 115, 120}, 10);
    private Polygon leftArm = new Polygon(new int[]{0, 5, 5, 15, 25, 30, 30, 25, 23, 23}, new int[]{120, 115, 65, 55, 55, 50, 65, 65, 70, 120}, 10);
    private Polygon head = new Polygon(new int[]{50, 50, 55, 70, 75, 75}, new int[]{40, 25, 20, 20, 25, 40}, 6);
    private Polygon centralTorso = new Polygon(new int[]{50, 50, 75, 75}, new int[]{80, 40, 40, 80}, 4);
    private Polygon leftTorso = new Polygon(new int[]{50, 35, 30, 30, 35, 50}, new int[]{80, 80, 75, 45, 40, 40}, 6);
    private Polygon rightTorso = new Polygon(new int[]{75, 75, 90, 95, 95, 90}, new int[]{80, 40, 40, 45, 75, 80}, 6);
    private Polygon leftLeg = new Polygon(new int[]{30, 30, 35, 50, 50, 55}, new int[]{120, 85, 80, 80, 115, 120}, 6);
    private Polygon rightLeg = new Polygon(new int[]{70, 75, 75, 90, 95, 95}, new int[]{120, 115, 80, 80, 85, 120}, 6);
    private Polygon rearLeftTorso = new Polygon(new int[]{142, 142, 148, 139, 123, 123, 142}, new int[]{14, 43, 76, 76, 44, 17, 14}, 7);
    private Polygon rearCentralTorso = new Polygon(new int[]{142, 148, 162, 168, 168, 142}, new int[]{44, 76, 76, 44, 14, 14}, 6);
    private Polygon rearRightTorso = new Polygon(new int[]{168, 168, 162, 171, 187, 187, 168}, new int[]{14, 43, 76, 76, 44, 17, 14}, 7);
    private Polygon inStRightArm = new Polygon(new int[]{102, 102, 100, 95, 95, 100, 110, 120, 120, 125}, new int[]{232, 182, 177, 177, 162, 167, 167, 177, 227, 232}, 10);
    private Polygon inStLeftArm = new Polygon(new int[]{0, 5, 5, 15, 25, 30, 30, 25, 23, 23}, new int[]{232, 227, 177, 167, 167, 162, 177, 177, 182, 232}, 10);
    private Polygon intStHead = new Polygon(new int[]{50, 50, 55, 70, 75, 75}, new int[]{152, 137, 132, 132, 137, 152}, 6);
    private Polygon inStCentralTorso = new Polygon(new int[]{50, 50, 75, 75}, new int[]{192, 152, 152, 192}, 4);
    private Polygon inStLeftTorso = new Polygon(new int[]{50, 35, 30, 30, 35, 50}, new int[]{192, 192, 187, 157, 152, 152}, 6);
    private Polygon inStRightTorso = new Polygon(new int[]{75, 75, 90, 95, 95, 90}, new int[]{192, 152, 152, 157, 187, 192}, 6);
    private Polygon inStLeftLeg = new Polygon(new int[]{30, 30, 35, 50, 50, 55}, new int[]{232, 197, 192, 192, 227, 232}, 6);
    private Polygon inStRightLeg = new Polygon(new int[]{70, 75, 75, 90, 95, 95}, new int[]{232, 227, 192, 192, 197, 232}, 6);
    private Polygon heatControl = new Polygon(new int[]{149, 159, 159, 149}, new int[]{100, 100, 220, 220}, 4);
    private Image heatImage;
    private static final Font FONT_LABEL = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorSmallFontSize"));
    private static final Font FONT_VALUE = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorLargeFontSize"));

    public QuadMapSet(Component component) {
        this.comp = component;
        this.setAreas();
        this.setLabels();
        this.setGroups();
        this.setBackGround();
    }

    @Override
    public PMAreasGroup getContentGroup() {
        return this.content;
    }

    @Override
    public Vector<BackGroundDrawer> getBackgroundDrawers() {
        return this.bgDrawers;
    }

    @Override
    public void setEntity(Entity entity) {
        Mech mech = (Mech)entity;
        boolean bl = false;
        if (entity.getGame() != null && entity.getGame().getOptions().booleanOption("maxtech_heat")) {
            bl = true;
        }
        int n = 1;
        int n2 = 1;
        for (int i = 0; i < mech.locations(); ++i) {
            n = mech.getArmor(i);
            n2 = mech.getOArmor(i);
            this.vLabels[i].setValue(mech.getArmorString(i));
            WidgetUtils.setAreaColor(this.areas[i], this.vLabels[i], (double)n / (double)n2);
            if (mech.hasRearArmor(i)) {
                n = mech.getArmor(i, true);
                n2 = mech.getOArmor(i, true);
                this.vLabels[i + 7].setValue(mech.getArmorString(i, true));
                WidgetUtils.setAreaColor(this.areas[i + 7], this.vLabels[i + 7], (double)n / (double)n2);
            }
            n = mech.getInternal(i);
            n2 = mech.getOInternal(i);
            this.vLabels[i + 11].setValue(mech.getInternalString(i));
            WidgetUtils.setAreaColor(this.areas[i + 11], this.vLabels[i + 11], (double)n / (double)n2);
        }
        this.vLabels[19].setValue(Integer.toString(mech.heat));
        this.drawHeatControl(mech.heat, bl);
    }

    private void setAreas() {
        this.areas[0] = new PMSimplePolygonArea(this.head);
        this.areas[1] = new PMSimplePolygonArea(this.centralTorso);
        this.areas[2] = new PMSimplePolygonArea(this.rightTorso);
        this.areas[3] = new PMSimplePolygonArea(this.leftTorso);
        this.areas[4] = new PMSimplePolygonArea(this.rightArm);
        this.areas[5] = new PMSimplePolygonArea(this.leftArm);
        this.areas[6] = new PMSimplePolygonArea(this.rightLeg);
        this.areas[7] = new PMSimplePolygonArea(this.leftLeg);
        this.areas[8] = new PMSimplePolygonArea(this.rearCentralTorso);
        this.areas[9] = new PMSimplePolygonArea(this.rearRightTorso);
        this.areas[10] = new PMSimplePolygonArea(this.rearLeftTorso);
        this.areas[11] = new PMSimplePolygonArea(this.intStHead);
        this.areas[12] = new PMSimplePolygonArea(this.inStCentralTorso);
        this.areas[13] = new PMSimplePolygonArea(this.inStRightTorso);
        this.areas[14] = new PMSimplePolygonArea(this.inStLeftTorso);
        this.areas[15] = new PMSimplePolygonArea(this.inStRightArm);
        this.areas[16] = new PMSimplePolygonArea(this.inStLeftArm);
        this.areas[17] = new PMSimplePolygonArea(this.inStRightLeg);
        this.areas[18] = new PMSimplePolygonArea(this.inStLeftLeg);
        this.heatImage = this.comp.createImage(10, 120);
        this.drawHeatControl(0);
        this.heatHotArea = new PMPicPolygonalArea(this.heatControl, this.heatImage);
    }

    private void setLabels() {
        FontMetrics fontMetrics = this.comp.getFontMetrics(FONT_LABEL);
        this.labels[0] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_H"), fontMetrics, Color.black, 58, 29);
        this.labels[5] = WidgetUtils.createLabel(Messages.getString("QuadMapSet.L_LA"), fontMetrics, Color.black, 14, 69);
        this.labels[3] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_LT"), fontMetrics, Color.black, 41, 52);
        this.labels[1] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_CT"), fontMetrics, Color.black, 62, 45);
        this.labels[2] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_RT"), fontMetrics, Color.black, 84, 52);
        this.labels[4] = WidgetUtils.createLabel(Messages.getString("QuadMapSet.L_RA"), fontMetrics, Color.black, 111, 69);
        this.labels[7] = WidgetUtils.createLabel(Messages.getString("QuadMapSet.L_LL"), fontMetrics, Color.black, 39, 87);
        this.labels[6] = WidgetUtils.createLabel(Messages.getString("QuadMapSet.L_RL"), fontMetrics, Color.black, 85, 87);
        this.labels[10] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_LT"), fontMetrics, Color.black, 133, 39);
        this.labels[8] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_CT"), fontMetrics, Color.black, 156, 25);
        this.labels[9] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_RT"), fontMetrics, Color.black, 178, 39);
        this.labels[11] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_H"), fontMetrics, Color.black, 63, 130);
        this.labels[16] = WidgetUtils.createLabel(Messages.getString("QuadMapSet.L_LA"), fontMetrics, Color.black, 14, 179);
        this.labels[14] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_LT"), fontMetrics, Color.black, 42, 166);
        this.labels[12] = WidgetUtils.createLabel(Messages.getString("MechMapSet.L_CT"), fontMetrics, Color.black, 63, 160);
        this.labels[13] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_RT"), fontMetrics, Color.black, 85, 166);
        this.labels[15] = WidgetUtils.createLabel(Messages.getString("QuadMapSet.L_RA"), fontMetrics, Color.black, 111, 179);
        this.labels[18] = WidgetUtils.createLabel(Messages.getString("QuadMapSet.L_LL"), fontMetrics, Color.black, 39, 200);
        this.labels[17] = WidgetUtils.createLabel(Messages.getString("QuadMapSet.L_RL"), fontMetrics, Color.black, 85, 200);
        fontMetrics = this.comp.getFontMetrics(FONT_VALUE);
        this.vLabels[0] = WidgetUtils.createValueLabel(68, 30, "", fontMetrics);
        this.vLabels[5] = WidgetUtils.createValueLabel(13, 82, "", fontMetrics);
        this.vLabels[3] = WidgetUtils.createValueLabel(40, 66, "", fontMetrics);
        this.vLabels[1] = WidgetUtils.createValueLabel(62, 60, "", fontMetrics);
        this.vLabels[2] = WidgetUtils.createValueLabel(85, 66, "", fontMetrics);
        this.vLabels[4] = WidgetUtils.createValueLabel(112, 82, "", fontMetrics);
        this.vLabels[7] = WidgetUtils.createValueLabel(39, 103, "", fontMetrics);
        this.vLabels[6] = WidgetUtils.createValueLabel(85, 103, "", fontMetrics);
        this.vLabels[10] = WidgetUtils.createValueLabel(132, 28, "", fontMetrics);
        this.vLabels[8] = WidgetUtils.createValueLabel(156, 39, "", fontMetrics);
        this.vLabels[9] = WidgetUtils.createValueLabel(177, 28, "", fontMetrics);
        this.vLabels[11] = WidgetUtils.createValueLabel(63, 142, "", fontMetrics);
        this.vLabels[16] = WidgetUtils.createValueLabel(15, 192, "", fontMetrics);
        this.vLabels[14] = WidgetUtils.createValueLabel(42, 180, "", fontMetrics);
        this.vLabels[12] = WidgetUtils.createValueLabel(63, 175, "", fontMetrics);
        this.vLabels[13] = WidgetUtils.createValueLabel(85, 180, "", fontMetrics);
        this.vLabels[15] = WidgetUtils.createValueLabel(111, 192, "", fontMetrics);
        this.vLabels[18] = WidgetUtils.createValueLabel(39, 215, "", fontMetrics);
        this.vLabels[17] = WidgetUtils.createValueLabel(85, 215, "", fontMetrics);
        this.vLabels[19] = WidgetUtils.createValueLabel(155, 90, "", fontMetrics);
    }

    private void setGroups() {
        int n;
        PMAreasGroup pMAreasGroup = new PMAreasGroup();
        PMAreasGroup pMAreasGroup2 = new PMAreasGroup();
        PMAreasGroup pMAreasGroup3 = new PMAreasGroup();
        PMAreasGroup pMAreasGroup4 = new PMAreasGroup();
        for (n = 0; n < 8; ++n) {
            pMAreasGroup.addArea(this.areas[n]);
            pMAreasGroup.addArea(this.labels[n]);
            pMAreasGroup.addArea(this.vLabels[n]);
        }
        for (n = 0; n < 3; ++n) {
            pMAreasGroup2.addArea(this.areas[8 + n]);
            pMAreasGroup2.addArea(this.labels[8 + n]);
            pMAreasGroup2.addArea(this.vLabels[8 + n]);
        }
        for (n = 0; n < 8; ++n) {
            pMAreasGroup3.addArea(this.areas[11 + n]);
            pMAreasGroup3.addArea(this.labels[11 + n]);
            pMAreasGroup3.addArea(this.vLabels[11 + n]);
        }
        pMAreasGroup4.addArea(this.heatHotArea);
        pMAreasGroup4.addArea(this.vLabels[19]);
        pMAreasGroup.translate(7, 18);
        pMAreasGroup2.translate(19, 20);
        pMAreasGroup3.translate(6, 42);
        pMAreasGroup4.translate(20, 52);
        for (n = 0; n < 19; ++n) {
            this.content.addArea(this.areas[n]);
            this.content.addArea(this.labels[n]);
            this.content.addArea(this.vLabels[n]);
        }
        this.content.addArea(this.heatHotArea);
        this.content.addArea(this.vLabels[19]);
    }

    private void setBackGround() {
        Image image = this.comp.getToolkit().getImage("data/images/widgets/tile.gif");
        PMUtil.setImage(image, this.comp);
        int n = 8;
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        image = this.comp.getToolkit().getImage("data/images/widgets/bg_mech.gif");
        PMUtil.setImage(image, this.comp);
        n = 545;
        BackGroundDrawer backGroundDrawer = new BackGroundDrawer(image, n);
        this.bgDrawers.addElement(backGroundDrawer);
    }

    private void drawHeatControl(int n) {
        this.drawHeatControl(n, false);
    }

    private void drawHeatControl(int n, boolean bl) {
        int n2;
        int n3;
        int n4 = 0;
        if (bl) {
            n3 = 50;
            n2 = 2;
        } else {
            n3 = 30;
            n2 = 4;
        }
        Graphics graphics = this.heatImage.getGraphics();
        for (int i = 0; i < n3; ++i) {
            n4 = 120 - (i + 1) * n2;
            if (i < n) {
                graphics.setColor(Color.red);
            } else {
                graphics.setColor(Color.lightGray);
            }
            graphics.fillRect(0, n4, 10, n2);
            graphics.setColor(Color.black);
            graphics.drawRect(0, n4, 10, n2);
        }
    }
}

