/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Polygon;
import java.util.Vector;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.widget.BackGroundDrawer;
import megamek.client.ui.AWT.widget.DisplayMapSet;
import megamek.client.ui.AWT.widget.PMAreasGroup;
import megamek.client.ui.AWT.widget.PMSimpleLabel;
import megamek.client.ui.AWT.widget.PMSimplePolygonArea;
import megamek.client.ui.AWT.widget.PMUtil;
import megamek.client.ui.AWT.widget.PMValueLabel;
import megamek.client.ui.AWT.widget.WidgetUtils;
import megamek.common.Entity;
import megamek.common.VTOL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VTOLMapSet
implements DisplayMapSet {
    private static final String IMAGE_DIR = "data/images/widgets";
    private Component comp;
    private PMSimplePolygonArea[] areas = new PMSimplePolygonArea[16];
    private PMSimpleLabel[] labels = new PMSimpleLabel[22];
    private PMValueLabel[] vLabels = new PMValueLabel[16];
    private Vector<BackGroundDrawer> bgDrawers = new Vector();
    private PMAreasGroup content = new PMAreasGroup();
    private static final int INT_STR_OFFSET = 8;
    private Polygon frontArmor = new Polygon(new int[]{30, 60, 90, 120}, new int[]{30, 0, 0, 30}, 4);
    private Polygon frontIS = new Polygon(new int[]{30, 120, 90, 60}, new int[]{30, 30, 45, 45}, 4);
    private Polygon leftArmor1 = new Polygon(new int[]{30, 30, 60, 60}, new int[]{75, 30, 45, 75}, 4);
    private Polygon leftArmor2 = new Polygon(new int[]{30, 30, 60, 60}, new int[]{135, 90, 90, 150}, 4);
    private Polygon leftIS1 = new Polygon(new int[]{60, 60, 75, 75}, new int[]{75, 45, 45, 75}, 4);
    private Polygon leftIS2 = new Polygon(new int[]{60, 60, 75, 75}, new int[]{150, 90, 90, 150}, 4);
    private Polygon rightArmor1 = new Polygon(new int[]{90, 90, 120, 120}, new int[]{75, 45, 30, 75}, 4);
    private Polygon rightArmor2 = new Polygon(new int[]{90, 90, 120, 120}, new int[]{150, 90, 90, 135}, 4);
    private Polygon rightIS1 = new Polygon(new int[]{75, 75, 90, 90}, new int[]{75, 45, 45, 75}, 4);
    private Polygon rightIS2 = new Polygon(new int[]{75, 75, 90, 90}, new int[]{150, 90, 90, 150}, 4);
    private Polygon rearArmor = new Polygon(new int[]{67, 67, 83, 83}, new int[]{180, 150, 150, 180}, 4);
    private Polygon rearIS = new Polygon(new int[]{67, 67, 83, 83}, new int[]{240, 180, 180, 240}, 4);
    private Polygon rotorArmor1 = new Polygon(new int[]{0, 0, 45, 45}, new int[]{90, 75, 75, 90}, 4);
    private Polygon rotorArmor2 = new Polygon(new int[]{105, 105, 150, 150}, new int[]{90, 75, 75, 90}, 4);
    private Polygon rotorIS = new Polygon(new int[]{45, 45, 105, 105}, new int[]{90, 75, 75, 90}, 4);
    private static final Font FONT_LABEL = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorSmallFontSize"));
    private static final Font FONT_VALUE = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorLargeFontSize"));

    public VTOLMapSet(Component component) {
        this.comp = component;
        this.setAreas();
        this.setLabels();
        this.setBackGround();
        this.translateAreas();
        this.setContent();
    }

    public void setRest() {
    }

    @Override
    public PMAreasGroup getContentGroup() {
        return this.content;
    }

    @Override
    public Vector<BackGroundDrawer> getBackgroundDrawers() {
        return this.bgDrawers;
    }

    @Override
    public void setEntity(Entity entity) {
        int n;
        VTOL vTOL = (VTOL)entity;
        int n2 = 1;
        int n3 = 1;
        int n4 = 0;
        for (n = 1; n <= 8; ++n) {
            switch (n) {
                case 1: {
                    n4 = 1;
                    break;
                }
                case 2: {
                    n4 = 2;
                    break;
                }
                case 3: {
                    n4 = 2;
                    break;
                }
                case 4: {
                    n4 = 3;
                    break;
                }
                case 5: {
                    n4 = 3;
                    break;
                }
                case 6: {
                    n4 = 4;
                    break;
                }
                case 7: {
                    n4 = 5;
                    break;
                }
                case 8: {
                    n4 = 5;
                }
            }
            n2 = vTOL.getArmor(n4);
            n3 = vTOL.getOArmor(n4);
            this.vLabels[n].setValue(vTOL.getArmorString(n4));
            WidgetUtils.setAreaColor(this.areas[n], this.vLabels[n], (double)n2 / (double)n3);
        }
        for (n = 9; n <= 15; ++n) {
            switch (n) {
                case 9: {
                    n4 = 1;
                    break;
                }
                case 10: {
                    n4 = 2;
                    break;
                }
                case 11: {
                    n4 = 2;
                    break;
                }
                case 12: {
                    n4 = 3;
                    break;
                }
                case 13: {
                    n4 = 3;
                    break;
                }
                case 14: {
                    n4 = 4;
                    break;
                }
                case 15: {
                    n4 = 5;
                }
            }
            n2 = vTOL.getInternal(n4);
            n3 = vTOL.getOInternal(n4);
            this.vLabels[n].setValue(vTOL.getInternalString(n4));
            WidgetUtils.setAreaColor(this.areas[n], this.vLabels[n], (double)n2 / (double)n3);
        }
    }

    private void setContent() {
        int n;
        for (n = 1; n <= 15; ++n) {
            this.content.addArea(this.areas[n]);
            this.content.addArea(this.vLabels[n]);
        }
        for (n = 1; n <= 21; ++n) {
            this.content.addArea(this.labels[n]);
        }
    }

    private void setAreas() {
        this.areas[1] = new PMSimplePolygonArea(this.frontArmor);
        this.areas[2] = new PMSimplePolygonArea(this.rightArmor1);
        this.areas[3] = new PMSimplePolygonArea(this.rightArmor2);
        this.areas[4] = new PMSimplePolygonArea(this.leftArmor1);
        this.areas[5] = new PMSimplePolygonArea(this.leftArmor2);
        this.areas[6] = new PMSimplePolygonArea(this.rearArmor);
        this.areas[7] = new PMSimplePolygonArea(this.rotorArmor1);
        this.areas[8] = new PMSimplePolygonArea(this.rotorArmor2);
        this.areas[9] = new PMSimplePolygonArea(this.frontIS);
        this.areas[10] = new PMSimplePolygonArea(this.rightIS1);
        this.areas[11] = new PMSimplePolygonArea(this.rightIS2);
        this.areas[12] = new PMSimplePolygonArea(this.leftIS1);
        this.areas[13] = new PMSimplePolygonArea(this.leftIS2);
        this.areas[14] = new PMSimplePolygonArea(this.rearIS);
        this.areas[15] = new PMSimplePolygonArea(this.rotorIS);
    }

    private void setLabels() {
        FontMetrics fontMetrics = this.comp.getFontMetrics(FONT_LABEL);
        this.labels[1] = WidgetUtils.createLabel(Messages.getString("VTOLMapSet.FrontArmor"), fontMetrics, Color.black, 68, 20);
        this.labels[2] = WidgetUtils.createLabel(Messages.getString("VTOLMapSet.LS"), fontMetrics, Color.black, 44, 50);
        this.labels[3] = WidgetUtils.createLabel(Messages.getString("VTOLMapSet.LS"), fontMetrics, Color.black, 44, 100);
        this.labels[4] = WidgetUtils.createLabel(Messages.getString("VTOLMapSet.RS"), fontMetrics, Color.black, 104, 50);
        this.labels[5] = WidgetUtils.createLabel(Messages.getString("VTOLMapSet.RS"), fontMetrics, Color.black, 104, 100);
        this.labels[6] = WidgetUtils.createLabel(Messages.getString("VTOLMapSet.RearArmor1"), fontMetrics, Color.black, 76, 185);
        this.labels[7] = WidgetUtils.createLabel(Messages.getString("VTOLMapSet.RearArmor2"), fontMetrics, Color.black, 76, 195);
        this.labels[8] = WidgetUtils.createLabel(Messages.getString("VTOLMapSet.RotorArmor"), fontMetrics, Color.black, 18, 82);
        this.labels[9] = WidgetUtils.createLabel(Messages.getString("VTOLMapSet.RotorArmor"), fontMetrics, Color.black, 123, 82);
        this.labels[10] = WidgetUtils.createLabel(Messages.getString("VTOLMapSet.FrontIS"), fontMetrics, Color.black, 68, 35);
        this.labels[11] = WidgetUtils.createLabel(Messages.getString("VTOLMapSet.LIS1"), fontMetrics, Color.black, 68, 48);
        this.labels[12] = WidgetUtils.createLabel(Messages.getString("VTOLMapSet.LIS2"), fontMetrics, Color.black, 68, 57);
        this.labels[13] = WidgetUtils.createLabel(Messages.getString("VTOLMapSet.LIS1"), fontMetrics, Color.black, 68, 100);
        this.labels[14] = WidgetUtils.createLabel(Messages.getString("VTOLMapSet.LIS2"), fontMetrics, Color.black, 68, 110);
        this.labels[15] = WidgetUtils.createLabel(Messages.getString("VTOLMapSet.RIS1"), fontMetrics, Color.black, 84, 48);
        this.labels[16] = WidgetUtils.createLabel(Messages.getString("VTOLMapSet.RIS2"), fontMetrics, Color.black, 84, 57);
        this.labels[17] = WidgetUtils.createLabel(Messages.getString("VTOLMapSet.RIS1"), fontMetrics, Color.black, 84, 100);
        this.labels[18] = WidgetUtils.createLabel(Messages.getString("VTOLMapSet.RIS2"), fontMetrics, Color.black, 84, 110);
        this.labels[19] = WidgetUtils.createLabel(Messages.getString("VTOLMapSet.RearIS1"), fontMetrics, Color.black, 76, 152);
        this.labels[20] = WidgetUtils.createLabel(Messages.getString("VTOLMapSet.RearIS2"), fontMetrics, Color.black, 76, 161);
        this.labels[21] = WidgetUtils.createLabel(Messages.getString("VTOLMapSet.RotorIS"), fontMetrics, Color.black, 73, 82);
        fontMetrics = this.comp.getFontMetrics(FONT_VALUE);
        this.vLabels[1] = WidgetUtils.createValueLabel(101, 22, "", fontMetrics);
        this.vLabels[2] = WidgetUtils.createValueLabel(44, 65, "", fontMetrics);
        this.vLabels[3] = WidgetUtils.createValueLabel(44, 115, "", fontMetrics);
        this.vLabels[4] = WidgetUtils.createValueLabel(105, 65, "", fontMetrics);
        this.vLabels[5] = WidgetUtils.createValueLabel(105, 115, "", fontMetrics);
        this.vLabels[6] = WidgetUtils.createValueLabel(76, 207, "", fontMetrics);
        this.vLabels[7] = WidgetUtils.createValueLabel(38, 83, "", fontMetrics);
        this.vLabels[8] = WidgetUtils.createValueLabel(143, 83, "", fontMetrics);
        this.vLabels[9] = WidgetUtils.createValueLabel(94, 37, "", fontMetrics);
        this.vLabels[10] = WidgetUtils.createValueLabel(68, 68, "", fontMetrics);
        this.vLabels[11] = WidgetUtils.createValueLabel(68, 122, "", fontMetrics);
        this.vLabels[12] = WidgetUtils.createValueLabel(84, 68, "", fontMetrics);
        this.vLabels[13] = WidgetUtils.createValueLabel(84, 122, "", fontMetrics);
        this.vLabels[14] = WidgetUtils.createValueLabel(76, 172, "", fontMetrics);
        this.vLabels[15] = WidgetUtils.createValueLabel(98, 83, "", fontMetrics);
    }

    private void setBackGround() {
        Image image = this.comp.getToolkit().getImage("data/images/widgets/tile.gif");
        PMUtil.setImage(image, this.comp);
        int n = 8;
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 20;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 68;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 258;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1026;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 273;
        image = this.comp.getToolkit().getImage("data/images/widgets/tl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 321;
        image = this.comp.getToolkit().getImage("data/images/widgets/bl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1041;
        image = this.comp.getToolkit().getImage("data/images/widgets/tr_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1089;
        image = this.comp.getToolkit().getImage("data/images/widgets/br_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
    }

    private void translateAreas() {
    }
}

