/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import keypoint.PngEncoder;
import megamek.client.event.BoardViewEvent;
import megamek.client.event.BoardViewListenerAdapter;
import megamek.client.ui.swing.BoardView1;
import megamek.client.ui.swing.CommonAboutDialog;
import megamek.client.ui.swing.CommonHelpDialog;
import megamek.client.ui.swing.CommonMenuBar;
import megamek.client.ui.swing.CommonSettingsDialog;
import megamek.client.ui.swing.ConfirmDialog;
import megamek.client.ui.swing.ExitsDialog;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.IMapSettingsObserver;
import megamek.client.ui.swing.Messages;
import megamek.client.ui.swing.MiniMap;
import megamek.client.ui.swing.RandomMapDialog;
import megamek.client.ui.swing.TilesetManager;
import megamek.common.Coords;
import megamek.common.Game;
import megamek.common.Hex;
import megamek.common.IBoard;
import megamek.common.IHex;
import megamek.common.ITerrain;
import megamek.common.MapSettings;
import megamek.common.Terrains;
import megamek.common.util.BoardUtilities;

public class BoardEditor
extends JComponent
implements ItemListener,
ListSelectionListener,
ActionListener,
DocumentListener,
IMapSettingsObserver {
    private JFrame frame = new JFrame();
    private Game game = new Game();
    private IBoard board = this.game.getBoard();
    private BoardView1 bv;
    private CommonMenuBar menuBar = new CommonMenuBar();
    private CommonAboutDialog about;
    private CommonHelpDialog help;
    private CommonSettingsDialog setdlg;
    private IHex curHex = new Hex();
    private File curfileImage;
    private File curfile;
    private HexCanvas canHex;
    private JLabel labElev;
    private JTextField texElev;
    private JButton butElevUp;
    private JButton butElevDown;
    private JLabel labTerrain;
    private JList lisTerrain;
    private JButton butDelTerrain;
    private JPanel panTerrainType;
    private JComboBox choTerrainType;
    private JTextField texTerrainLevel;
    private JPanel panTerrExits;
    private JCheckBox cheTerrExitSpecified;
    private JTextField texTerrExits;
    private JButton butTerrExits;
    private JPanel panRoads;
    private JCheckBox cheRoadsAutoExit;
    private JLabel labTheme;
    private JTextField texTheme;
    private JButton butAddTerrain;
    private JLabel blankL;
    private JLabel labBoard;
    private JPanel panButtons;
    private JButton butBoardNew;
    private JButton butBoardLoad;
    private JButton butBoardSave;
    private JButton butBoardSaveAs;
    private JButton butBoardSaveAsImage;
    private JButton butMiniMap;
    private JDialog minimapW;
    private MiniMap minimap;
    private MapSettings mapSettings = new MapSettings();

    public BoardEditor() {
        try {
            this.bv = new BoardView1(this.game, this.frame);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.frame, Messages.getString("BoardEditor.CouldntInitialize") + iOException, Messages.getString("BoardEditor.FatalError"), 0);
            this.frame.dispose();
        }
        this.bv.addBoardViewListener(new BoardViewListenerAdapter(){

            public void hexMoused(BoardViewEvent boardViewEvent) {
                BoardEditor.this.bv.cursor(boardViewEvent.getCoords());
                if ((boardViewEvent.getModifiers() & 8) != 0) {
                    BoardEditor.this.setCurrentHex(BoardEditor.this.board.getHex(boardViewEvent.getCoords()));
                }
                if ((boardViewEvent.getModifiers() & 2) != 0 && !BoardEditor.this.board.getHex(boardViewEvent.getCoords()).equals(BoardEditor.this.curHex)) {
                    BoardEditor.this.paintHex(boardViewEvent.getCoords());
                }
            }
        });
        this.bv.setUseLOSTool(false);
        this.setupEditorPanel();
        this.setupFrame();
        this.frame.setVisible(true);
        if (GUIPreferences.getInstance().getNagForMapEdReadme()) {
            String string = Messages.getString("BoardEditor.readme.title");
            String string2 = Messages.getString("BoardEditor.readme.message");
            ConfirmDialog confirmDialog = new ConfirmDialog(this.frame, string, string2, true);
            confirmDialog.setVisible(true);
            if (!confirmDialog.getShowAgain()) {
                GUIPreferences.getInstance().setNagForMapEdReadme(false);
            }
            if (confirmDialog.getAnswer()) {
                this.showHelp();
            }
        }
    }

    private void setupFrame() {
        this.frame.setTitle(Messages.getString("BoardEditor.title"));
        this.frame.getContentPane().setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Scrollbar scrollbar = new Scrollbar(1);
        Scrollbar scrollbar2 = new Scrollbar(0);
        panel.add((Component)this.bv, "Center");
        panel.add((Component)scrollbar, "East");
        panel.add((Component)scrollbar2, "South");
        this.frame.add((Component)panel, "Center");
        this.frame.getContentPane().add((Component)this, "East");
        this.menuBar.addActionListener(this);
        this.frame.setJMenuBar(this.menuBar);
        this.frame.setBackground(SystemColor.menu);
        this.frame.setForeground(SystemColor.menuText);
        if (GUIPreferences.getInstance().getWindowSizeHeight() != 0) {
            this.frame.setLocation(GUIPreferences.getInstance().getWindowPosX(), GUIPreferences.getInstance().getWindowPosY());
            this.frame.setSize(GUIPreferences.getInstance().getWindowSizeWidth(), GUIPreferences.getInstance().getWindowSizeHeight());
        } else {
            this.frame.setSize(800, 600);
        }
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BoardEditor.this.frame.setVisible(false);
                BoardEditor.this.setMapVisible(false);
            }
        });
    }

    private void setupEditorPanel() {
        this.canHex = new HexCanvas();
        this.labElev = new JLabel(Messages.getString("BoardEditor.labElev"), 4);
        this.texElev = new JTextField("0", 1);
        this.texElev.addActionListener(this);
        this.texElev.getDocument().addDocumentListener(this);
        this.butElevUp = new JButton(Messages.getString("BoardEditor.butElevUp"));
        this.butElevUp.addActionListener(this);
        this.butElevDown = new JButton(Messages.getString("BoardEditor.butElevDown"));
        this.butElevDown.addActionListener(this);
        this.labTerrain = new JLabel(Messages.getString("BoardEditor.labTerrain"), 2);
        this.lisTerrain = new JList(new DefaultListModel());
        this.lisTerrain.addListSelectionListener(this);
        this.lisTerrain.setVisibleRowCount(6);
        this.refreshTerrainList();
        this.butDelTerrain = new JButton(Messages.getString("BoardEditor.butDelTerrain"));
        this.butDelTerrain.addActionListener(this);
        String[] stringArray = new String[Terrains.SIZE - 1];
        for (int i = 1; i < Terrains.SIZE; ++i) {
            stringArray[i - 1] = Terrains.getName(i);
        }
        this.choTerrainType = new JComboBox<String>(stringArray);
        this.texTerrainLevel = new JTextField("0", 1);
        this.butAddTerrain = new JButton(Messages.getString("BoardEditor.butAddTerrain"));
        this.butAddTerrain.addActionListener(this);
        this.butMiniMap = new JButton(Messages.getString("BoardEditor.butMiniMap"));
        this.butMiniMap.setActionCommand("viewMiniMap");
        this.butMiniMap.addActionListener(this);
        this.panTerrainType = new JPanel(new BorderLayout());
        this.panTerrainType.add((Component)this.choTerrainType, "West");
        this.panTerrainType.add((Component)this.texTerrainLevel, "Center");
        this.cheTerrExitSpecified = new JCheckBox(Messages.getString("BoardEditor.cheTerrExitSpecified"));
        this.butTerrExits = new JButton(Messages.getString("BoardEditor.butTerrExits"));
        this.texTerrExits = new JTextField("0", 1);
        this.butTerrExits.addActionListener(this);
        this.panTerrExits = new JPanel(new FlowLayout());
        this.panTerrExits.add(this.cheTerrExitSpecified);
        this.panTerrExits.add(this.butTerrExits);
        this.panTerrExits.add(this.texTerrExits);
        this.panRoads = new JPanel(new FlowLayout());
        this.cheRoadsAutoExit = new JCheckBox(Messages.getString("BoardEditor.cheRoadsAutoExit"));
        this.cheRoadsAutoExit.addItemListener(this);
        this.panRoads.add(this.cheRoadsAutoExit);
        this.labTheme = new JLabel(Messages.getString("BoardEditor.labTheme"), 2);
        this.texTheme = new JTextField("", 15);
        this.texTheme.getDocument().addDocumentListener(this);
        this.labBoard = new JLabel(Messages.getString("BoardEditor.labBoard"), 2);
        this.butBoardNew = new JButton(Messages.getString("BoardEditor.butBoardNew"));
        this.butBoardNew.setActionCommand("fileBoardNew");
        this.butBoardNew.addActionListener(this);
        this.butBoardLoad = new JButton(Messages.getString("BoardEditor.butBoardLoad"));
        this.butBoardLoad.setActionCommand("fileBoardOpen");
        this.butBoardLoad.addActionListener(this);
        this.butBoardSave = new JButton(Messages.getString("BoardEditor.butBoardSave"));
        this.butBoardSave.setActionCommand("fileBoardSave");
        this.butBoardSave.addActionListener(this);
        this.butBoardSaveAs = new JButton(Messages.getString("BoardEditor.butBoardSaveAs"));
        this.butBoardSaveAs.setActionCommand("fileBoardSaveAs");
        this.butBoardSaveAs.addActionListener(this);
        this.butBoardSaveAsImage = new JButton(Messages.getString("BoardEditor.butBoardSaveAsImage"));
        this.butBoardSaveAsImage.setActionCommand("fileBoardSaveAsImage");
        this.butBoardSaveAsImage.addActionListener(this);
        this.panButtons = new JPanel(new GridLayout(3, 2, 2, 2));
        this.panButtons.add(this.labBoard);
        this.panButtons.add(this.butBoardNew);
        this.panButtons.add(this.butBoardLoad);
        this.panButtons.add(this.butBoardSave);
        this.panButtons.add(this.butBoardSaveAs);
        this.panButtons.add(this.butBoardSaveAsImage);
        this.blankL = new JLabel("", 0);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 1, 1);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        this.addBag(this.canHex, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.addBag(this.labElev, gridBagLayout, gridBagConstraints);
        this.addBag(this.butElevUp, gridBagLayout, gridBagConstraints);
        this.addBag(this.butElevDown, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.texElev, gridBagLayout, gridBagConstraints);
        this.addBag(this.labTerrain, gridBagLayout, gridBagConstraints);
        this.addBag(new JScrollPane(this.lisTerrain), gridBagLayout, gridBagConstraints);
        this.addBag(this.butDelTerrain, gridBagLayout, gridBagConstraints);
        this.addBag(this.panTerrainType, gridBagLayout, gridBagConstraints);
        this.addBag(this.panTerrExits, gridBagLayout, gridBagConstraints);
        this.addBag(this.panRoads, gridBagLayout, gridBagConstraints);
        this.addBag(this.labTheme, gridBagLayout, gridBagConstraints);
        this.addBag(this.texTheme, gridBagLayout, gridBagConstraints);
        this.addBag(this.butAddTerrain, gridBagLayout, gridBagConstraints);
        this.addBag(this.butMiniMap, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addBag(this.blankL, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(this.panButtons, gridBagLayout, gridBagConstraints);
        this.minimapW = new JDialog(this.frame, Messages.getString("BoardEditor.minimapW"), false);
        this.minimapW.setLocation(GUIPreferences.getInstance().getMinimapPosX(), GUIPreferences.getInstance().getMinimapPosY());
        try {
            this.minimap = new MiniMap(this.minimapW, this.game, this.bv);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.frame, Messages.getString("BoardEditor.CouldNotInitialiseMinimap") + iOException, Messages.getString("BoardEditor.FatalError"), 0);
            this.frame.dispose();
        }
        this.minimapW.add(this.minimap);
        this.setMapVisible(true);
    }

    private void addBag(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
    }

    private void paintHex(Coords coords) {
        this.board.setHex(coords, this.curHex.duplicate());
    }

    private void setCurrentHex(IHex iHex) {
        this.curHex = iHex.duplicate();
        this.texElev.setText(Integer.toString(this.curHex.getElevation()));
        this.refreshTerrainList();
        if (this.lisTerrain.getModel().getSize() > 0) {
            this.lisTerrain.setSelectedIndex(0);
            this.refreshTerrainFromList();
        }
        this.texTheme.setText(this.curHex.getTheme());
        this.repaint();
        this.repaintWorkingHex();
    }

    private void repaintWorkingHex() {
        if (this.curHex != null) {
            TilesetManager tilesetManager = this.bv.getTilesetManager();
            tilesetManager.clearHex(this.curHex);
        }
        this.canHex.repaint();
    }

    private void refreshTerrainList() {
        ((DefaultListModel)this.lisTerrain.getModel()).removeAllElements();
        for (int i = 0; i < Terrains.SIZE; ++i) {
            ITerrain iTerrain = this.curHex.getTerrain(i);
            if (iTerrain == null) continue;
            ((DefaultListModel)this.lisTerrain.getModel()).addElement(iTerrain.toString());
        }
    }

    private ITerrain enteredTerrain() {
        int n = Terrains.getType((String)this.choTerrainType.getSelectedItem());
        int n2 = Integer.parseInt(this.texTerrainLevel.getText());
        boolean bl = this.cheTerrExitSpecified.isSelected();
        int n3 = Integer.parseInt(this.texTerrExits.getText());
        return Terrains.getTerrainFactory().createTerrain(n, n2, bl, n3);
    }

    private void addSetTerrain() {
        ITerrain iTerrain = this.enteredTerrain();
        this.curHex.addTerrain(iTerrain);
        this.refreshTerrainList();
        this.repaintWorkingHex();
    }

    private void refreshTerrainFromList() {
        if (this.lisTerrain.getSelectedIndex() == -1) {
            return;
        }
        ITerrain iTerrain = Terrains.getTerrainFactory().createTerrain((String)this.lisTerrain.getSelectedValue());
        iTerrain = this.curHex.getTerrain(iTerrain.getType());
        this.choTerrainType.setSelectedItem(Terrains.getName(iTerrain.getType()));
        this.texTerrainLevel.setText(Integer.toString(iTerrain.getLevel()));
        this.cheTerrExitSpecified.setSelected(iTerrain.hasExitsSpecified());
        this.texTerrExits.setText(Integer.toString(iTerrain.getExits()));
    }

    public void boardNew() {
        RandomMapDialog randomMapDialog = new RandomMapDialog(this.frame, this, this.mapSettings);
        randomMapDialog.setVisible(true);
        this.board = BoardUtilities.generateRandom(this.mapSettings);
        this.game.setBoard(this.board);
        this.curfile = null;
        this.frame.setTitle(Messages.getString("BoardEditor.title"));
        this.menuBar.setBoard(true);
    }

    public void updateMapSettings(MapSettings mapSettings) {
        this.mapSettings = mapSettings;
    }

    public void boardLoad() {
        JFileChooser jFileChooser = new JFileChooser("data" + File.separator + "boards");
        jFileChooser.setLocation(this.frame.getLocation().x + 150, this.frame.getLocation().y + 100);
        jFileChooser.setDialogTitle(Messages.getString("BoardEditor.loadBoard"));
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return null != file.getName() && file.getName().endsWith(".board");
            }

            public String getDescription() {
                return ".board";
            }
        });
        int n = jFileChooser.showOpenDialog(this.frame);
        if (n != 0 || jFileChooser.getSelectedFile() == null) {
            return;
        }
        this.curfile = jFileChooser.getSelectedFile();
        try {
            FileInputStream fileInputStream = new FileInputStream(jFileChooser.getSelectedFile());
            this.board.load(fileInputStream);
            ((InputStream)fileInputStream).close();
            this.menuBar.setBoard(true);
        }
        catch (IOException iOException) {
            System.err.println("error opening file to save!");
            System.err.println(iOException);
        }
        this.frame.setTitle(Messages.getString("BoardEditor.title0") + this.curfile);
        this.cheRoadsAutoExit.setSelected(this.board.getRoadsAutoExit());
        this.refreshTerrainList();
    }

    private void boardSave() {
        if (this.curfile == null) {
            this.boardSaveAs();
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.curfile);
            this.board.save(fileOutputStream);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            System.err.println("error opening file to save!");
            System.err.println(iOException);
        }
    }

    private void boardSaveImage() {
        if (this.curfileImage == null) {
            this.boardSaveAsImage();
            return;
        }
        JDialog jDialog = new JDialog((Frame)this.frame, Messages.getString("BoardEditor.waitDialog.title"));
        jDialog.add(new JLabel(Messages.getString("BoardEditor.waitDialog.message")));
        jDialog.setSize(250, 130);
        jDialog.setLocation(this.frame.getSize().width / 2 - jDialog.getSize().width / 2, this.frame.getSize().height / 2 - jDialog.getSize().height / 2);
        jDialog.setVisible(true);
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        jDialog.setCursor(Cursor.getPredefinedCursor(3));
        int n = 0;
        int n2 = 9;
        PngEncoder pngEncoder = new PngEncoder(this.bv.getEntireBoardImage(), false, n, n2);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.curfileImage);
            byte[] byArray = pngEncoder.pngEncode();
            if (byArray == null) {
                System.out.println("Failed to save board as image:Null image");
            } else {
                fileOutputStream.write(byArray);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        jDialog.setVisible(false);
        this.frame.setCursor(Cursor.getDefaultCursor());
    }

    private void boardSaveAs() {
        JFileChooser jFileChooser = new JFileChooser("data" + File.separator + "boards");
        jFileChooser.setLocation(this.frame.getLocation().x + 150, this.frame.getLocation().y + 100);
        jFileChooser.setDialogTitle(Messages.getString("BoardEditor.saveBoardAs"));
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return null != file.getName() && file.getName().endsWith(".board");
            }

            public String getDescription() {
                return ".board";
            }
        });
        int n = jFileChooser.showSaveDialog(this.frame);
        if (n != 0 || jFileChooser.getSelectedFile() == null) {
            return;
        }
        this.curfile = jFileChooser.getSelectedFile();
        if (!this.curfile.getName().toLowerCase().endsWith(".board")) {
            try {
                this.curfile = new File(this.curfile.getCanonicalPath() + ".board");
            }
            catch (IOException iOException) {
                return;
            }
        }
        this.frame.setTitle(Messages.getString("BoardEditor.title0") + this.curfile);
        this.boardSave();
    }

    private void boardSaveAsImage() {
        int n;
        JFileChooser jFileChooser = new JFileChooser(".");
        jFileChooser.setLocation(this.frame.getLocation().x + 150, this.frame.getLocation().y + 100);
        jFileChooser.setDialogTitle(Messages.getString("BoardEditor.saveAsImage"));
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return null != file.getName() && file.getName().endsWith(".png");
            }

            public String getDescription() {
                return ".png";
            }
        });
        if (this.curfile != null && this.curfile.length() > 0L) {
            String string = this.curfile.getName().toUpperCase();
            if (string.endsWith(".BOARD")) {
                n = string.length();
                string = string.substring(0, n - 6);
            }
            string = string.toLowerCase() + ".png";
            jFileChooser.setSelectedFile(new File(string));
        }
        if ((n = jFileChooser.showSaveDialog(this.frame)) != 0 || jFileChooser.getSelectedFile() == null) {
            return;
        }
        this.curfileImage = jFileChooser.getSelectedFile();
        if (!this.curfileImage.getName().toLowerCase().endsWith(".png")) {
            try {
                this.curfileImage = new File(this.curfileImage.getCanonicalPath() + ".png");
            }
            catch (IOException iOException) {
                return;
            }
        }
        this.frame.setTitle(Messages.getString("BoardEditor.title0") + this.curfileImage);
        this.boardSaveImage();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.cheRoadsAutoExit)) {
            this.board.setRoadsAutoExit(this.cheRoadsAutoExit.isSelected());
            this.bv.updateBoard();
            this.repaintWorkingHex();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().equals(this.texElev.getDocument())) {
            int n;
            try {
                n = Integer.parseInt(this.texElev.getText());
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            if (n != this.curHex.getElevation()) {
                this.curHex.setElevation(n);
                this.repaintWorkingHex();
            }
        } else if (documentEvent.getDocument().equals(this.texTheme.getDocument())) {
            this.curHex.setTheme(this.texTheme.getText());
            this.repaintWorkingHex();
        }
    }

    private void showAbout() {
        if (this.about == null) {
            this.about = new CommonAboutDialog(this.frame);
        }
        this.about.setVisible(true);
    }

    private void showHelp() {
        if (this.help == null) {
            File file = new File("docs", "editor-readme.txt");
            this.help = new CommonHelpDialog(this.frame, file);
        }
        this.help.setVisible(true);
    }

    private void showSettings() {
        if (this.setdlg == null) {
            this.setdlg = new CommonSettingsDialog(this.frame);
        }
        this.setdlg.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("fileBoardNew".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.boardNew();
        } else if ("fileBoardOpen".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.boardLoad();
        } else if ("fileBoardSave".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.boardSave();
        } else if ("fileBoardSaveAs".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.boardSaveAs();
        } else if ("fileBoardSaveAsImage".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.boardSaveAsImage();
        } else if (actionEvent.getSource().equals(this.butDelTerrain) && this.lisTerrain.getSelectedValue() != null) {
            ITerrain iTerrain = Terrains.getTerrainFactory().createTerrain((String)this.lisTerrain.getSelectedValue());
            this.curHex.removeTerrain(iTerrain.getType());
            this.refreshTerrainList();
            this.repaintWorkingHex();
        } else if (actionEvent.getSource().equals(this.butAddTerrain)) {
            this.addSetTerrain();
        } else if (actionEvent.getSource().equals(this.butElevUp) && this.curHex.getElevation() < 9) {
            this.curHex.setElevation(this.curHex.getElevation() + 1);
            this.texElev.setText(Integer.toString(this.curHex.getElevation()));
            this.repaintWorkingHex();
        } else if (actionEvent.getSource().equals(this.butElevDown) && this.curHex.getElevation() > -5) {
            this.curHex.setElevation(this.curHex.getElevation() - 1);
            this.texElev.setText(Integer.toString(this.curHex.getElevation()));
            this.repaintWorkingHex();
        } else if (actionEvent.getSource().equals(this.butTerrExits)) {
            ExitsDialog exitsDialog = new ExitsDialog(this.frame);
            this.cheTerrExitSpecified.setSelected(true);
            exitsDialog.setExits(Integer.parseInt(this.texTerrExits.getText()));
            exitsDialog.setVisible(true);
            this.texTerrExits.setText(Integer.toString(exitsDialog.getExits()));
            this.addSetTerrain();
        } else if ("viewMiniMap".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.toggleMap();
        } else if (actionEvent.getActionCommand().equals("viewZoomIn")) {
            this.bv.zoomIn();
        } else if (actionEvent.getActionCommand().equals("viewZoomOut")) {
            this.bv.zoomOut();
        } else if ("helpAbout".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.showAbout();
        } else if ("helpContents".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.showHelp();
        } else if ("viewClientSettings".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.showSettings();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.lisTerrain)) {
            this.refreshTerrainFromList();
        }
    }

    public JFrame getFrame() {
        return this.frame;
    }

    private void toggleMap() {
        this.setMapVisible(!this.minimapW.isVisible());
    }

    private void setMapVisible(boolean bl) {
        this.minimapW.setVisible(bl);
    }

    private class HexCanvas
    extends JPanel {
        HexCanvas() {
            this.setPreferredSize(new Dimension(90, 90));
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (BoardEditor.this.curHex != null) {
                TilesetManager tilesetManager = BoardEditor.this.bv.getTilesetManager();
                graphics.drawImage(tilesetManager.baseFor(BoardEditor.this.curHex), 0, 0, this);
                graphics.setColor(this.getForeground());
                if (tilesetManager.supersFor(BoardEditor.this.curHex) != null) {
                    for (Object e : tilesetManager.supersFor(BoardEditor.this.curHex)) {
                        graphics.drawImage((Image)e, 0, 0, this);
                        graphics.drawString(Messages.getString("BoardEditor.SUPER"), 0, 10);
                    }
                }
                graphics.setFont(new Font("SansSerif", 0, 9));
                graphics.drawString(Messages.getString("BoardEditor.LEVEL") + BoardEditor.this.curHex.getElevation(), 24, 70);
            } else {
                graphics.clearRect(0, 0, 72, 72);
            }
        }
    }
}

