/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import megamek.client.Client;
import megamek.client.ui.AWT.MechView;
import megamek.client.ui.swing.ClientGUI;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.Messages;
import megamek.client.ui.swing.UnitFailureDialog;
import megamek.client.ui.swing.UnitLoadingDialog;
import megamek.common.BattleArmor;
import megamek.common.Entity;
import megamek.common.EntityWeightClass;
import megamek.common.EquipmentType;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.common.MechSummaryComparator;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Tank;
import megamek.common.TechConstants;
import megamek.common.UnitType;
import megamek.common.WeaponType;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.preference.IClientPreferences;
import megamek.common.preference.PreferenceManager;
import megamek.common.verifier.EntityVerifier;
import megamek.common.verifier.TestEntity;
import megamek.common.verifier.TestMech;
import megamek.common.verifier.TestTank;

public class MechSelectorDialog
extends JDialog
implements ActionListener,
ItemListener,
KeyListener,
Runnable,
WindowListener,
ListSelectionListener {
    private static final int KEY_TIMEOUT = 1000;
    private String[] m_saSorts = new String[]{Messages.getString("MechSelectorDialog.0"), Messages.getString("MechSelectorDialog.1"), Messages.getString("MechSelectorDialog.2"), Messages.getString("MechSelectorDialog.3"), Messages.getString("MechSelectorDialog.4"), Messages.getString("MechSelectorDialog.5")};
    private MechSummary[] m_mechsCurrent = new MechSummary[0];
    private Client m_client;
    private ClientGUI m_clientgui;
    private UnitLoadingDialog unitLoadingDialog;
    private StringBuffer m_sbSearch = new StringBuffer();
    private long m_nLastSearch = 0L;
    private JLabel m_labelWeightClass = new JLabel(Messages.getString("MechSelectorDialog.m_labelWeightClass"), 4);
    private JComboBox m_chWeightClass = new JComboBox();
    private JLabel m_labelType = new JLabel(Messages.getString("MechSelectorDialog.m_labelType"), 4);
    private JComboBox m_chType = new JComboBox();
    private JLabel m_labelUnitType = new JLabel(Messages.getString("MechSelectorDialog.m_labelUnitType"), 4);
    private JComboBox m_chUnitType = new JComboBox();
    private JLabel m_labelSort = new JLabel(Messages.getString("MechSelectorDialog.m_labelSort"), 4);
    private JComboBox m_chSort = new JComboBox();
    private JPanel m_pParams = new JPanel();
    private JPanel m_pListOptions = new JPanel();
    private JLabel m_labelListOptions = new JLabel(Messages.getString("MechSelectorDialog.m_labelListOptions"));
    private JCheckBox m_cModel = new JCheckBox(Messages.getString("MechSelectorDialog.m_cModel"), GUIPreferences.getInstance().getMechSelectorIncludeModel());
    private JCheckBox m_cName = new JCheckBox(Messages.getString("MechSelectorDialog.m_cName"), GUIPreferences.getInstance().getMechSelectorIncludeName());
    private JCheckBox m_cTons = new JCheckBox(Messages.getString("MechSelectorDialog.m_cTons"), GUIPreferences.getInstance().getMechSelectorIncludeTons());
    private JCheckBox m_cBV = new JCheckBox(Messages.getString("MechSelectorDialog.m_cBV"), GUIPreferences.getInstance().getMechSelectorIncludeBV());
    private JCheckBox m_cYear = new JCheckBox(Messages.getString("MechSelectorDialog.m_cYear"), GUIPreferences.getInstance().getMechSelectorIncludeYear());
    private JCheckBox m_cLevel = new JCheckBox(Messages.getString("MechSelectorDialog.m_cLevel"), GUIPreferences.getInstance().getMechSelectorIncludeLevel());
    private JCheckBox m_cCost = new JCheckBox(Messages.getString("MechSelectorDialog.m_cCost"), GUIPreferences.getInstance().getMechSelectorIncludeCost());
    private JPanel m_pOpenAdvanced = new JPanel();
    private JButton m_bToggleAdvanced = new JButton("< Advanced Search >");
    private JPanel m_pSouthParams = new JPanel();
    JList m_mechList = new JList(new DefaultComboBoxModel());
    private JButton m_bPick = new JButton(Messages.getString("MechSelectorDialog.m_bPick"));
    private JButton m_bPickClose = new JButton(Messages.getString("MechSelectorDialog.m_bPickClose"));
    private JButton m_bCancel = new JButton(Messages.getString("Close"));
    private JPanel m_pButtons = new JPanel();
    private JTextArea m_mechView = new JTextArea("", 36, 35);
    private JPanel m_pLeft = new JPanel();
    private JComboBox m_cWalk = new JComboBox();
    private JTextField m_tWalk = new JTextField(2);
    private JComboBox m_cJump = new JComboBox();
    private JTextField m_tJump = new JTextField(2);
    private JComboBox m_cArmor = new JComboBox();
    private JTextField m_tWeapons1 = new JTextField(2);
    private JComboBox m_cWeapons1 = new JComboBox();
    private JComboBox m_cOrAnd = new JComboBox();
    private JTextField m_tWeapons2 = new JTextField(2);
    private JComboBox m_cWeapons2 = new JComboBox();
    private JCheckBox m_chkEquipment = new JCheckBox();
    private JComboBox m_cEquipment = new JComboBox();
    private JTextField m_tStartYear = new JTextField(4);
    private JTextField m_tEndYear = new JTextField(4);
    private JButton m_bSearch = new JButton(Messages.getString("MechSelectorDialog.Search.Search"));
    private JButton m_bReset = new JButton(Messages.getString("MechSelectorDialog.Search.Reset"));
    private JLabel m_lCount = new JLabel();
    private int m_count;
    private int m_old_nType;
    private int m_old_nUnitType;
    private JPanel m_pUpper = new JPanel();
    JLabel m_pPreview = new JLabel();
    private JLabel m_labelPlayer = new JLabel(Messages.getString("MechSelectorDialog.m_labelPlayer"), 4);
    private JComboBox m_chPlayer = new JComboBox();
    private boolean includeMaxTech;
    private EntityVerifier entityVerifier = new EntityVerifier(new File("data/mechfiles/UnitVerifierOptions.xml"));
    private static final String SPACES = "                        ";

    public MechSelectorDialog(ClientGUI clientGUI, UnitLoadingDialog unitLoadingDialog) {
        super(clientGUI.frame, Messages.getString("MechSelectorDialog.title"), true);
        this.m_client = clientGUI.getClient();
        this.m_clientgui = clientGUI;
        this.unitLoadingDialog = unitLoadingDialog;
        for (int i = 0; i < this.m_saSorts.length; ++i) {
            this.m_chSort.addItem(this.m_saSorts[i]);
        }
        this.updatePlayerChoice();
        this.m_pParams.setLayout(new GridLayout(4, 2));
        this.m_pParams.add(this.m_labelWeightClass);
        this.m_pParams.add(this.m_chWeightClass);
        this.m_pParams.add(this.m_labelType);
        this.m_pParams.add(this.m_chType);
        this.m_pParams.add(this.m_labelUnitType);
        this.m_pParams.add(this.m_chUnitType);
        this.m_pParams.add(this.m_labelSort);
        this.m_pParams.add(this.m_chSort);
        this.m_pListOptions.add(this.m_labelListOptions);
        this.m_cModel.addItemListener(this);
        this.m_pListOptions.add(this.m_cModel);
        this.m_cName.addItemListener(this);
        this.m_pListOptions.add(this.m_cName);
        this.m_cTons.addItemListener(this);
        this.m_pListOptions.add(this.m_cTons);
        this.m_cBV.addItemListener(this);
        this.m_pListOptions.add(this.m_cBV);
        this.m_cYear.addItemListener(this);
        this.m_pListOptions.add(this.m_cYear);
        this.m_cLevel.addItemListener(this);
        this.m_pListOptions.add(this.m_cLevel);
        this.m_cCost.addItemListener(this);
        this.m_pListOptions.add(this.m_cCost);
        if (GUIPreferences.getInstance().getMechSelectorShowAdvanced()) {
            this.buildSouthParams(true);
        } else {
            this.buildSouthParams(false);
        }
        this.m_pButtons.setLayout(new FlowLayout(1));
        this.m_pButtons.add(this.m_bPick);
        this.m_pButtons.add(this.m_bPickClose);
        this.m_pButtons.add(this.m_bCancel);
        this.m_pButtons.add(this.m_labelPlayer);
        this.m_pButtons.add(this.m_chPlayer);
        this.m_pUpper.setLayout(new BorderLayout());
        this.m_pPreview.setPreferredSize(new Dimension(84, 72));
        this.m_pUpper.add((Component)this.m_pParams, "West");
        this.m_pUpper.add((Component)this.m_pPreview, "Center");
        this.m_pUpper.add((Component)this.m_pSouthParams, "South");
        this.m_pLeft.setLayout(new BorderLayout());
        this.m_pLeft.add((Component)this.m_pUpper, "North");
        this.m_mechList.setFont(new Font("Monospaced", 0, 12));
        this.m_mechList.addKeyListener(this);
        this.m_pLeft.add((Component)new JScrollPane(this.m_mechList, 22, 30), "Center");
        this.m_pLeft.add((Component)this.m_pButtons, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.m_pLeft, "Center");
        this.m_mechView.setFont(new Font("Monospaced", 0, 12));
        this.m_mechView.setEditable(false);
        this.m_mechView.setOpaque(false);
        this.getContentPane().add((Component)this.m_mechView, "East");
        this.setSize(700, 350);
        this.setLocation(this.computeDesiredLocation());
        this.populateChoices();
        this.m_chWeightClass.addItemListener(this);
        this.m_chType.addItemListener(this);
        this.m_chUnitType.addItemListener(this);
        this.m_chSort.addItemListener(this);
        this.m_mechList.addListSelectionListener(this);
        this.m_bPick.addActionListener(this);
        this.m_bPickClose.addActionListener(this);
        this.m_bCancel.addActionListener(this);
        this.m_bSearch.addActionListener(this);
        this.m_bReset.addActionListener(this);
        this.m_bToggleAdvanced.addActionListener(this);
        this.addWindowListener(this);
        this.updateWidgetEnablements();
    }

    private void buildSouthParams(boolean bl) {
        if (bl) {
            this.m_bToggleAdvanced.setText(Messages.getString("MechSelectorDialog.Search.Hide"));
            this.m_pOpenAdvanced.add(this.m_bToggleAdvanced);
            this.m_pSouthParams.setLayout(new GridLayout(11, 1));
            this.m_pSouthParams.add(this.m_pListOptions);
            this.m_pSouthParams.add(this.m_pOpenAdvanced);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            jPanel.add(new JLabel(Messages.getString("MechSelectorDialog.Search.Walk")));
            jPanel.add(this.m_cWalk);
            jPanel.add(this.m_tWalk);
            this.m_pSouthParams.add(jPanel);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(0));
            jPanel2.add(new JLabel(Messages.getString("MechSelectorDialog.Search.Jump")));
            jPanel2.add(this.m_cJump);
            jPanel2.add(this.m_tJump);
            this.m_pSouthParams.add(jPanel2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout(0));
            jPanel3.add(new JLabel(Messages.getString("MechSelectorDialog.Search.Armor")));
            jPanel3.add(this.m_cArmor);
            this.m_pSouthParams.add(jPanel3);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new FlowLayout(0));
            jPanel4.add(new JLabel(Messages.getString("MechSelectorDialog.Search.Weapons")));
            this.m_pSouthParams.add(jPanel4);
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new FlowLayout(0));
            jPanel5.add(new JLabel(Messages.getString("MechSelectorDialog.Search.WeaponsAtLeast")));
            jPanel5.add(this.m_tWeapons1);
            jPanel5.add(this.m_cWeapons1);
            this.m_pSouthParams.add(jPanel5);
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new FlowLayout(0));
            jPanel6.add(this.m_cOrAnd);
            jPanel6.add(new JLabel(Messages.getString("MechSelectorDialog.Search.WeaponsAtLeast")));
            jPanel6.add(this.m_tWeapons2);
            jPanel6.add(this.m_cWeapons2);
            this.m_pSouthParams.add(jPanel6);
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout(new FlowLayout(0));
            jPanel7.add(new JLabel(Messages.getString("MechSelectorDialog.Search.Equipment")));
            jPanel7.add(this.m_chkEquipment);
            jPanel7.add(this.m_cEquipment);
            this.m_pSouthParams.add(jPanel7);
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout(new FlowLayout(0));
            jPanel8.add(new JLabel(Messages.getString("MechSelectorDialog.Search.Year")));
            jPanel8.add(this.m_tStartYear);
            jPanel8.add(new JLabel("-"));
            jPanel8.add(this.m_tEndYear);
            this.m_pSouthParams.add(jPanel8);
            JPanel jPanel9 = new JPanel();
            jPanel9.add(this.m_bSearch);
            jPanel9.add(this.m_bReset);
            jPanel9.add(this.m_lCount);
            this.m_pSouthParams.add(jPanel9);
        } else {
            this.m_bToggleAdvanced.setText(Messages.getString("MechSelectorDialog.Search.Show"));
            this.m_pOpenAdvanced.add(this.m_bToggleAdvanced);
            this.m_pSouthParams.setLayout(new GridLayout(2, 1));
            this.m_pSouthParams.add(this.m_pListOptions);
            this.m_pSouthParams.add(this.m_pOpenAdvanced);
        }
    }

    private void toggleAdvanced() {
        this.m_pUpper.remove(this.m_pSouthParams);
        this.m_pSouthParams = new JPanel();
        if (GUIPreferences.getInstance().getMechSelectorShowAdvanced()) {
            this.buildSouthParams(false);
            GUIPreferences.getInstance().setMechSelectorShowAdvanced(false);
        } else {
            this.buildSouthParams(true);
            GUIPreferences.getInstance().setMechSelectorShowAdvanced(true);
        }
        this.m_pUpper.add((Component)this.m_pSouthParams, "South");
        this.invalidate();
        this.pack();
    }

    private void updateTechChoice() {
        int n;
        boolean bl = this.m_client.game.getOptions().booleanOption("allow_level_3_units");
        int n2 = n = bl ? TechConstants.SIZE : 5;
        if (this.includeMaxTech == bl) {
            return;
        }
        this.includeMaxTech = bl;
        this.m_chType.removeAll();
        for (int i = 0; i < n; ++i) {
            this.m_chType.addItem(TechConstants.getLevelDisplayableName(i));
        }
    }

    private void updatePlayerChoice() {
        String string = (String)this.m_chPlayer.getSelectedItem();
        this.m_chPlayer.removeAllItems();
        this.m_chPlayer.setEnabled(true);
        this.m_chPlayer.addItem(this.m_clientgui.getClient().getName());
        Iterator<Client> iterator = this.m_clientgui.getBots().values().iterator();
        while (iterator.hasNext()) {
            this.m_chPlayer.addItem(iterator.next().getName());
        }
        if (this.m_chPlayer.getItemCount() == 1) {
            this.m_chPlayer.setEnabled(false);
        } else {
            this.m_chPlayer.setSelectedItem(string);
        }
    }

    public void run() {
        this.filterMechs(false);
        this.m_mechList.invalidate();
        this.pack();
        this.setLocation(this.computeDesiredLocation());
        this.unitLoadingDialog.setVisible(false);
        Hashtable hashtable = MechSummaryCache.getInstance().getFailedFiles();
        if (hashtable != null && hashtable.size() > 0) {
            new UnitFailureDialog(this.m_clientgui.frame, hashtable);
        }
    }

    private void populateChoices() {
        int n;
        int n2;
        for (n2 = 0; n2 < EntityWeightClass.SIZE; ++n2) {
            this.m_chWeightClass.addItem(EntityWeightClass.getClassName(n2));
        }
        this.m_chWeightClass.addItem(Messages.getString("MechSelectorDialog.All"));
        this.m_chWeightClass.setSelectedIndex(0);
        this.includeMaxTech = this.m_client.game.getOptions().booleanOption("allow_level_3_units");
        n2 = this.includeMaxTech ? TechConstants.SIZE : 5;
        for (n = 0; n < n2; ++n) {
            this.m_chType.addItem(TechConstants.getLevelDisplayableName(n));
        }
        this.m_chType.setSelectedIndex(0);
        for (n = 0; n < UnitType.SIZE; ++n) {
            this.m_chUnitType.addItem(UnitType.getTypeDisplayableName(n));
        }
        this.m_chUnitType.addItem(Messages.getString("MechSelectorDialog.All"));
        this.m_chUnitType.setSelectedIndex(0);
        this.m_cWalk.addItem(Messages.getString("MechSelectorDialog.Search.AtLeast"));
        this.m_cWalk.addItem(Messages.getString("MechSelectorDialog.Search.EqualTo"));
        this.m_cWalk.addItem(Messages.getString("MechSelectorDialog.Search.NoMoreThan"));
        this.m_cJump.addItem(Messages.getString("MechSelectorDialog.Search.AtLeast"));
        this.m_cJump.addItem(Messages.getString("MechSelectorDialog.Search.EqualTo"));
        this.m_cJump.addItem(Messages.getString("MechSelectorDialog.Search.NoMoreThan"));
        this.m_cArmor.addItem(Messages.getString("MechSelectorDialog.Search.Any"));
        this.m_cArmor.addItem(Messages.getString("MechSelectorDialog.Search.Armor25"));
        this.m_cArmor.addItem(Messages.getString("MechSelectorDialog.Search.Armor50"));
        this.m_cArmor.addItem(Messages.getString("MechSelectorDialog.Search.Armor75"));
        this.m_cArmor.addItem(Messages.getString("MechSelectorDialog.Search.Armor90"));
        this.m_cOrAnd.addItem(Messages.getString("MechSelectorDialog.Search.or"));
        this.m_cOrAnd.addItem(Messages.getString("MechSelectorDialog.Search.and"));
        this.populateWeaponsAndEquipmentChoices();
    }

    private void populateWeaponsAndEquipmentChoices() {
        this.m_cWeapons1.removeAll();
        this.m_cWeapons2.removeAll();
        this.m_cEquipment.removeAll();
        this.m_tWeapons1.setText("");
        this.m_tWeapons2.setText("");
        this.m_chkEquipment.setSelected(false);
        int n = this.m_chType.getSelectedIndex();
        int n2 = this.m_chUnitType.getSelectedIndex();
        Enumeration enumeration = EquipmentType.getAllTypes();
        while (enumeration.hasMoreElements()) {
            EquipmentType equipmentType = (EquipmentType)enumeration.nextElement();
            if (!(!(equipmentType instanceof WeaponType) || equipmentType.getTechLevel() != n && (n != 4 || equipmentType.getTechLevel() != 0 && equipmentType.getTechLevel() != 1 && equipmentType.getTechLevel() != 2) && (n != 3 && n != 1 || equipmentType.getTechLevel() != 0 && equipmentType.getTechLevel() != 1))) {
                if (!(n2 == UnitType.SIZE || !UnitType.getTypeName(n2).equals("Mek") && !UnitType.getTypeName(n2).equals("Tank") || !equipmentType.hasFlag(64L) && !equipmentType.hasFlag(2048L) && !equipmentType.hasFlag(4096L))) continue;
                this.m_cWeapons1.addItem(equipmentType.getName());
                this.m_cWeapons2.addItem(equipmentType.getName());
                if (equipmentType.hasFlag(0x10000000L) && (n == 4 || n == 1 || n == 3)) {
                    this.m_cEquipment.addItem(equipmentType.getName());
                }
            }
            if (!(equipmentType instanceof MiscType) || equipmentType.getTechLevel() != n && (n != 4 || equipmentType.getTechLevel() != 0 && equipmentType.getTechLevel() != 1 && equipmentType.getTechLevel() != 2) && (n != 3 && n != 1 || equipmentType.getTechLevel() != 0 && equipmentType.getTechLevel() != 1)) continue;
            this.m_cEquipment.addItem(equipmentType.getName());
        }
        this.m_cWeapons1.invalidate();
        this.m_cWeapons2.invalidate();
        this.m_cEquipment.invalidate();
        this.pack();
    }

    private void filterMechs(boolean bl) {
        ArrayList<MechSummary> arrayList = new ArrayList<MechSummary>();
        int n = this.m_chWeightClass.getSelectedIndex();
        int n2 = this.m_chType.getSelectedIndex();
        int n3 = this.m_chUnitType.getSelectedIndex();
        MechSummary[] mechSummaryArray = MechSummaryCache.getInstance().getAllMechs();
        if (mechSummaryArray == null) {
            System.err.println("No units to filter!");
            return;
        }
        for (int i = 0; i < mechSummaryArray.length; ++i) {
            if (n != EntityWeightClass.SIZE && mechSummaryArray[i].getWeightClass() != n || n2 != 7 && n2 != mechSummaryArray[i].getType() && (n2 != 4 || mechSummaryArray[i].getType() != 0 && mechSummaryArray[i].getType() != 1 && mechSummaryArray[i].getType() != 2) && (n2 != 3 || mechSummaryArray[i].getType() != 0 && mechSummaryArray[i].getType() != 1) || n3 != UnitType.SIZE && !mechSummaryArray[i].getUnitType().equals(UnitType.getTypeName(n3)) || this.m_client.game.getOptions().booleanOption("canon_only") && !mechSummaryArray[i].isCanon()) continue;
            arrayList.add(mechSummaryArray[i]);
        }
        this.m_mechsCurrent = arrayList.toArray(new MechSummary[0]);
        this.m_count = arrayList.size();
        if (!(bl || this.m_old_nType == n2 && this.m_old_nUnitType == n3)) {
            this.populateWeaponsAndEquipmentChoices();
        }
        this.m_old_nType = n2;
        this.m_old_nUnitType = n3;
        this.sortMechs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortMechs() {
        Arrays.sort(this.m_mechsCurrent, new MechSummaryComparator(this.m_chSort.getSelectedIndex()));
        ((DefaultComboBoxModel)this.m_mechList.getModel()).removeAllElements();
        try {
            this.m_mechList.setEnabled(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (int i = 0; i < this.m_mechsCurrent.length; ++i) {
                ((DefaultComboBoxModel)this.m_mechList.getModel()).addElement(this.formatMech(this.m_mechsCurrent[i]));
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            this.m_mechList.setEnabled(true);
            this.m_mechList.setFont(this.m_mechList.getFont());
        }
        this.updateWidgetEnablements();
        this.m_lCount.setText(this.m_mechsCurrent.length + "/" + this.m_count);
        this.m_mechList.setPreferredSize(new Dimension(180, this.m_mechsCurrent.length * 19));
        this.repaint();
    }

    private void searchFor(String string) {
        for (int i = 0; i < this.m_mechsCurrent.length; ++i) {
            if (!this.m_mechsCurrent[i].getName().toLowerCase().startsWith(string)) continue;
            this.m_mechList.setSelectedIndex(i);
            break;
        }
    }

    private void advancedSearch() {
        int n;
        String string = this.m_lCount.getText();
        int n2 = Integer.parseInt(string.substring(0, string.indexOf(47)));
        if (n2 != (n = Integer.parseInt(string.substring(string.indexOf(47) + 1)))) {
            this.filterMechs(true);
        }
        ArrayList<MechSummary> arrayList = new ArrayList<MechSummary>();
        for (int i = 0; i < this.m_mechsCurrent.length; ++i) {
            MechSummary mechSummary = this.m_mechsCurrent[i];
            try {
                Entity entity = new MechFileParser(mechSummary.getSourceFile(), mechSummary.getEntryName()).getEntity();
                if (!this.isMatch(entity)) continue;
                arrayList.add(mechSummary);
                continue;
            }
            catch (EntityLoadingException entityLoadingException) {
                // empty catch block
            }
        }
        this.m_mechsCurrent = arrayList.toArray(new MechSummary[0]);
        this.clearMechPreview();
        this.sortMechs();
    }

    private boolean isMatch(Entity entity) {
        int n;
        int n2;
        int n3 = -1;
        try {
            n3 = Integer.parseInt(this.m_tWalk.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n3 > -1 && (this.m_cWalk.getSelectedIndex() == 0 ? entity.getWalkMP() < n3 : (this.m_cWalk.getSelectedIndex() == 1 ? n3 != entity.getWalkMP() : this.m_cWalk.getSelectedIndex() == 2 && entity.getWalkMP() > n3))) {
            return false;
        }
        int n4 = -1;
        try {
            n4 = Integer.parseInt(this.m_tJump.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n4 > -1 && (this.m_cJump.getSelectedIndex() == 0 ? entity.getJumpMP() < n4 : (this.m_cJump.getSelectedIndex() == 1 ? n4 != entity.getJumpMP() : this.m_cJump.getSelectedIndex() == 2 && entity.getJumpMP() > n4))) {
            return false;
        }
        int n5 = this.m_cArmor.getSelectedIndex();
        if (n5 > 0) {
            n2 = entity.getTotalArmor();
            n = entity.getTotalInternal() * 2 + 3;
            if (n5 == 1 ? (double)n2 < (double)n * 0.25 : (n5 == 2 ? (double)n2 < (double)n * 0.5 : (n5 == 3 ? (double)n2 < (double)n * 0.75 : n5 == 4 && (double)n2 < (double)n * 0.9))) {
                return false;
            }
        }
        n2 = 0;
        n = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n6 = 0;
        int n7 = -1;
        try {
            n7 = Integer.parseInt(this.m_tWeapons1.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n7 > -1) {
            n2 = 1;
            for (int i = 0; i < entity.getWeaponList().size(); ++i) {
                WeaponType weaponType = (WeaponType)entity.getWeaponList().get(i).getType();
                if (!weaponType.getName().equals(this.m_cWeapons1.getSelectedItem())) continue;
                ++n6;
            }
            if (n6 >= n7) {
                bl = true;
            }
        }
        n6 = 0;
        int n8 = -1;
        try {
            n8 = Integer.parseInt(this.m_tWeapons2.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n8 > -1) {
            n = 1;
            for (int i = 0; i < entity.getWeaponList().size(); ++i) {
                WeaponType weaponType = (WeaponType)entity.getWeaponList().get(i).getType();
                if (!weaponType.getName().equals(this.m_cWeapons2.getSelectedItem())) continue;
                ++n6;
            }
            if (n6 >= n8) {
                bl2 = true;
            }
        }
        int n9 = Integer.MIN_VALUE;
        int n10 = Integer.MAX_VALUE;
        try {
            n9 = Integer.parseInt(this.m_tStartYear.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n10 = Integer.parseInt(this.m_tEndYear.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (entity.getYear() < n9 || entity.getYear() > n10) {
            return false;
        }
        if (n2 != 0 && n == 0 && !bl) {
            return false;
        }
        if (n != 0 && n2 == 0 && !bl2) {
            return false;
        }
        if (n2 != 0 && n != 0 && (this.m_cOrAnd.getSelectedIndex() == 0 ? !bl && !bl2 : !bl || !bl2)) {
            return false;
        }
        n6 = 0;
        if (this.m_chkEquipment.isSelected()) {
            for (Mounted mounted : entity.getMisc()) {
                MiscType miscType = (MiscType)mounted.getType();
                if (!miscType.getName().equals(this.m_cEquipment.getSelectedItem())) continue;
                ++n6;
            }
            if (n6 < 1) {
                return false;
            }
        }
        return true;
    }

    private void resetSearch() {
        this.m_cWalk.setSelectedIndex(0);
        this.m_tWalk.setText("");
        this.m_cJump.setSelectedIndex(0);
        this.m_tJump.setText("");
        this.m_cArmor.setSelectedIndex(0);
        this.m_tWeapons1.setText("");
        this.m_cWeapons1.setSelectedIndex(0);
        this.m_cOrAnd.setSelectedIndex(0);
        this.m_tWeapons2.setText("");
        this.m_cWeapons2.setSelectedIndex(0);
        this.m_chkEquipment.setSelected(false);
        this.m_cEquipment.setSelectedIndex(0);
        this.filterMechs(false);
    }

    private Point computeDesiredLocation() {
        int n;
        int n2 = this.m_clientgui.frame.getLocation().x + this.m_clientgui.frame.getSize().width / 2 - this.getSize().width / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = this.m_clientgui.frame.getLocation().y + this.m_clientgui.frame.getSize().height / 2 - this.getSize().height / 2) < 0) {
            n = 0;
        }
        return new Point(n2, n);
    }

    public void setVisible(boolean bl) {
        this.updatePlayerChoice();
        this.updateTechChoice();
        this.setLocation(this.computeDesiredLocation());
        super.setVisible(bl);
    }

    private String formatMech(MechSummary mechSummary) {
        String string = "";
        String string2 = !mechSummary.getLevel().equals("F") ? TechConstants.T_SIMPLE_LEVEL[mechSummary.getType()] : "F";
        if (GUIPreferences.getInstance().getMechSelectorIncludeModel()) {
            string = string + this.makeLength(mechSummary.getModel(), 10) + " ";
        }
        if (GUIPreferences.getInstance().getMechSelectorIncludeName()) {
            string = string + this.makeLength(mechSummary.getChassis(), 20) + " ";
        }
        if (GUIPreferences.getInstance().getMechSelectorIncludeTons()) {
            string = string + this.makeLength("" + mechSummary.getTons(), 3) + " ";
        }
        if (GUIPreferences.getInstance().getMechSelectorIncludeBV()) {
            string = string + this.makeLength("" + mechSummary.getBV(), 5) + " ";
        }
        if (GUIPreferences.getInstance().getMechSelectorIncludeYear()) {
            string = string + mechSummary.getYear() + " ";
        }
        if (GUIPreferences.getInstance().getMechSelectorIncludeLevel()) {
            string = string + string2 + " ";
        }
        if (GUIPreferences.getInstance().getMechSelectorIncludeCost()) {
            string = string + mechSummary.getCost() + " ";
        }
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.m_bCancel)) {
            this.setVisible(false);
        } else if (actionEvent.getSource().equals(this.m_bPick) || actionEvent.getSource().equals(this.m_bPickClose)) {
            int n = this.m_mechList.getSelectedIndex();
            if (n == -1) {
                return;
            }
            MechSummary mechSummary = this.m_mechsCurrent[this.m_mechList.getSelectedIndex()];
            try {
                Entity entity = new MechFileParser(mechSummary.getSourceFile(), mechSummary.getEntryName()).getEntity();
                Client client = null;
                if (this.m_chPlayer.getSelectedIndex() > 0) {
                    String string = (String)this.m_chPlayer.getSelectedItem();
                    client = this.m_clientgui.getBots().get(string);
                }
                if (client == null) {
                    client = this.m_client;
                }
                this.autoSetSkills(entity);
                entity.setOwner(client.getLocalPlayer());
                client.sendAddEntity(entity);
            }
            catch (EntityLoadingException entityLoadingException) {
                System.out.println("Unable to load mech: " + mechSummary.getSourceFile() + ": " + mechSummary.getEntryName() + ": " + entityLoadingException.getMessage());
                entityLoadingException.printStackTrace();
                return;
            }
            if (actionEvent.getSource().equals(this.m_bPickClose)) {
                this.setVisible(false);
            }
        } else if (actionEvent.getSource().equals(this.m_bSearch)) {
            this.advancedSearch();
        } else if (actionEvent.getSource().equals(this.m_bReset)) {
            this.resetSearch();
        } else if (actionEvent.getSource().equals(this.m_bToggleAdvanced)) {
            this.toggleAdvanced();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.m_chSort)) {
            this.clearMechPreview();
            this.sortMechs();
        } else if (itemEvent.getSource().equals(this.m_chWeightClass) || itemEvent.getSource().equals(this.m_chType) || itemEvent.getSource().equals(this.m_chUnitType)) {
            this.clearMechPreview();
            this.filterMechs(false);
        } else if (itemEvent.getSource().equals(this.m_cModel) || itemEvent.getSource().equals(this.m_cName) || itemEvent.getSource().equals(this.m_cTons) || itemEvent.getSource().equals(this.m_cBV) || itemEvent.getSource().equals(this.m_cYear) || itemEvent.getSource().equals(this.m_cLevel) || itemEvent.getSource().equals(this.m_cCost)) {
            GUIPreferences.getInstance().setMechSelectorIncludeModel(this.m_cModel.isSelected());
            GUIPreferences.getInstance().setMechSelectorIncludeName(this.m_cName.isSelected());
            GUIPreferences.getInstance().setMechSelectorIncludeTons(this.m_cTons.isSelected());
            GUIPreferences.getInstance().setMechSelectorIncludeBV(this.m_cBV.isSelected());
            GUIPreferences.getInstance().setMechSelectorIncludeYear(this.m_cYear.isSelected());
            GUIPreferences.getInstance().setMechSelectorIncludeLevel(this.m_cLevel.isSelected());
            GUIPreferences.getInstance().setMechSelectorIncludeCost(this.m_cCost.isSelected());
            this.clearMechPreview();
            this.sortMechs();
            this.m_mechList.invalidate();
            this.pack();
            this.setLocation(this.computeDesiredLocation());
        }
    }

    void clearMechPreview() {
        this.m_mechView.setEditable(false);
        this.m_mechView.setText("");
        if (MechSummaryCache.getInstance().isInitialized()) {
            this.m_pPreview.repaint();
        }
    }

    void previewMech(Entity entity) {
        MechView mechView = new MechView(entity);
        this.m_mechView.setEditable(false);
        String string = mechView.getMechReadout();
        StringBuffer stringBuffer = new StringBuffer(string);
        this.m_mechView.setText(string);
        if (entity instanceof Mech || entity instanceof Tank) {
            TestEntity testEntity = null;
            if (entity instanceof Mech) {
                testEntity = new TestMech((Mech)entity, this.entityVerifier.mechOption, null);
            }
            if (entity instanceof Tank) {
                testEntity = new TestTank((Tank)entity, this.entityVerifier.tankOption, null);
            }
            if (!((TestEntity)testEntity).correctEntity(stringBuffer, !this.m_clientgui.getClient().game.getOptions().booleanOption("is_eq_limits"))) {
                this.m_mechView.setText(stringBuffer.toString());
            }
        }
        this.m_mechView.setCaretPosition(0);
        this.m_clientgui.loadPreviewImage(this.m_pPreview, entity, this.m_client.getLocalPlayer());
        this.m_pPreview.repaint();
    }

    private String makeLength(String string, int n) {
        if (string.length() == n) {
            return string;
        }
        if (string.length() > n) {
            return string.substring(0, n - 2) + "..";
        }
        return string + SPACES.substring(0, n - string.length());
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        long l;
        if (keyEvent.getKeyCode() == 10) {
            ActionEvent actionEvent = new ActionEvent(this.m_bPick, 1001, "");
            this.actionPerformed(actionEvent);
        }
        if ((l = System.currentTimeMillis()) - this.m_nLastSearch > 1000L) {
            this.m_sbSearch = new StringBuffer();
        }
        this.m_nLastSearch = l;
        this.m_sbSearch.append(keyEvent.getKeyChar());
        this.searchFor(this.m_sbSearch.toString().toLowerCase());
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private void updateWidgetEnablements() {
        boolean bl = this.m_mechList.getSelectedIndex() != -1;
        this.m_bPick.setEnabled(bl);
        this.m_bPickClose.setEnabled(bl);
    }

    private void autoSetSkills(Entity entity) {
        IClientPreferences iClientPreferences = PreferenceManager.getClientPreferences();
        if (!iClientPreferences.useAverageSkills()) {
            return;
        }
        int n = 5;
        int n2 = 4;
        if (entity.isClan()) {
            if (entity instanceof Mech || entity instanceof BattleArmor) {
                n2 = 3;
                n = 4;
            } else if (entity instanceof Tank) {
                n2 = 5;
                n = 6;
            } else if (entity instanceof Infantry) {
                if (entity.getMovementMode() == 10) {
                    n2 = 5;
                    n = 5;
                } else {
                    n2 = 5;
                    n = 6;
                }
            }
        } else if (entity instanceof Infantry) {
            if (entity.getMovementMode() == 10 || entity instanceof BattleArmor) {
                n2 = 4;
                n = 5;
            } else {
                n2 = 4;
                n = 6;
            }
        }
        entity.getCrew().setGunnery(n2);
        entity.getCrew().setPiloting(n);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.m_mechList)) {
            this.updateWidgetEnablements();
            int n = this.m_mechList.getSelectedIndex();
            if (n == -1) {
                this.clearMechPreview();
                return;
            }
            MechSummary mechSummary = this.m_mechsCurrent[n];
            try {
                Entity entity = new MechFileParser(mechSummary.getSourceFile(), mechSummary.getEntryName()).getEntity();
                this.previewMech(entity);
            }
            catch (EntityLoadingException entityLoadingException) {
                System.out.println("Unable to load mech: " + mechSummary.getSourceFile() + ": " + mechSummary.getEntryName() + ": " + entityLoadingException.getMessage());
                entityLoadingException.printStackTrace();
                this.clearMechPreview();
                return;
            }
        }
    }
}

