/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import megamek.client.Client;
import megamek.client.ui.swing.Messages;
import megamek.common.Player;

public class PlayerListDialog
extends JDialog
implements ActionListener {
    private JButton butClose = new JButton(Messages.getString("PlayerListDialog.Close"));
    private JList playerList = new JList(new DefaultListModel());
    private Client client;

    public PlayerListDialog(JFrame jFrame, Client client) {
        super(jFrame, Messages.getString("PlayerListDialog.title"), false);
        this.client = client;
        this.butClose.addActionListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.playerList, "North");
        this.getContentPane().add((Component)this.butClose, "South");
        this.refreshPlayerList();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PlayerListDialog.this.setVisible(false);
            }
        });
        this.pack();
        this.setResizable(false);
        this.setLocation(jFrame.getLocation().x + jFrame.getSize().width / 2 - this.getSize().width / 2, jFrame.getLocation().y + jFrame.getSize().height / 2 - this.getSize().height / 2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public static void refreshPlayerList(JList jList, Client client) {
        ((DefaultListModel)jList.getModel()).removeAllElements();
        Enumeration<Player> enumeration = client.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            StringBuffer stringBuffer = new StringBuffer(player.getName());
            if (player.isGhost()) {
                stringBuffer.append(" [");
                stringBuffer.append(Messages.getString("PlayerListDialog.player_ghost"));
                stringBuffer.append(']');
            } else if (player.isObserver()) {
                stringBuffer.append(" [");
                stringBuffer.append(Messages.getString("PlayerListDialog.player_observer"));
                stringBuffer.append(']');
            } else if (player.isDone()) {
                stringBuffer.append(" (");
                stringBuffer.append(Messages.getString("PlayerListDialog.player_done"));
                stringBuffer.append(')');
            }
            ((DefaultListModel)jList.getModel()).addElement(stringBuffer.toString());
        }
    }

    private void refreshPlayerList() {
        PlayerListDialog.refreshPlayerList(this.playerList, this.client);
    }
}

