/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing.widget;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import megamek.client.ui.swing.widget.BackGroundDrawer;

public class BufferedPanel
extends JPanel
implements ComponentListener {
    private ArrayList<BackGroundDrawer> bgDrawers = new ArrayList();

    public BufferedPanel() {
        this.addComponentListener(this);
    }

    public BufferedPanel(LayoutManager layoutManager) {
        super(layoutManager);
        this.addComponentListener(this);
    }

    public void addBgDrawer(BackGroundDrawer backGroundDrawer) {
        this.bgDrawers.add(backGroundDrawer);
    }

    public void paintComponent(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Image image = this.createImage(this.getSize().width, this.getSize().height);
        Graphics graphics2 = image.getGraphics();
        graphics2.setClip(0, 0, this.getSize().width, this.getSize().height);
        this.clearGraphics(graphics2);
        for (BackGroundDrawer backGroundDrawer : this.bgDrawers) {
            backGroundDrawer.drawInto(graphics2, this.getSize().width, this.getSize().height);
        }
        super.paintComponent(graphics2);
        graphics.drawImage(image, 0, 0, null);
        graphics2.dispose();
    }

    private void clearGraphics(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.setColor(color);
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.repaint();
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.repaint();
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.repaint();
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.repaint();
    }
}

