/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.CriticalSlot;
import megamek.common.EquipmentType;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.PilotingRollData;

public class BipedMech
extends Mech {
    public static final String[] LOCATION_NAMES = new String[]{"Head", "Center Torso", "Right Torso", "Left Torso", "Right Arm", "Left Arm", "Right Leg", "Left Leg"};
    public static final String[] LOCATION_ABBRS = new String[]{"HD", "CT", "RT", "LT", "RA", "LA", "RL", "LL"};
    private static final int[] NUM_OF_SLOTS = new int[]{6, 12, 12, 12, 12, 12, 6, 6};

    public BipedMech(String string, String string2) {
        this(BipedMech.getGyroTypeForString(string), BipedMech.getCockpitTypeForString(string2));
    }

    public BipedMech() {
        this(0, 0);
    }

    public BipedMech(int n, int n2) {
        super(n, n2);
        this.movementMode = 1;
        this.setCritical(4, 0, new CriticalSlot(0, 7));
        this.setCritical(4, 1, new CriticalSlot(0, 8));
        this.setCritical(4, 2, new CriticalSlot(0, 9));
        this.setCritical(4, 3, new CriticalSlot(0, 10));
        this.setCritical(5, 0, new CriticalSlot(0, 7));
        this.setCritical(5, 1, new CriticalSlot(0, 8));
        this.setCritical(5, 2, new CriticalSlot(0, 9));
        this.setCritical(5, 3, new CriticalSlot(0, 10));
    }

    public boolean canFlipArms() {
        boolean bl;
        boolean bl2 = bl = !this.isProne();
        if (this.hasSystem(10, 5)) {
            bl = false;
        } else if (this.hasSystem(9, 5)) {
            bl = false;
        } else if (this.hasSystem(10, 4)) {
            bl = false;
        } else if (this.hasSystem(9, 4)) {
            bl = false;
        }
        return bl;
    }

    public int getWalkMP() {
        return this.getWalkMP(true);
    }

    public int getWalkMP(boolean bl) {
        int n = this.getOriginalWalkMP();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.locations(); ++i) {
            if (!this.locationIsLeg(i)) continue;
            if (!this.isLocationBad(i)) {
                if (this.legHasHipCrit(i)) {
                    ++n3;
                    if (this.game == null || !this.game.getOptions().booleanOption("maxtech_leg_damage")) continue;
                }
                n4 += this.countLegActuatorCrits(i);
                continue;
            }
            ++n2;
        }
        if (n2 > 0) {
            n = n2 == 1 ? 1 : 0;
        } else {
            if (n3 > 0) {
                n = this.game != null && this.game.getOptions().booleanOption("maxtech_leg_damage") ? (n3 >= 1 ? n - 2 * n3 : 0) : (n3 == 1 ? (int)Math.ceil((double)n / 2.0) : 0);
            }
            n -= n4;
        }
        if (this.hasShield()) {
            n -= this.getNumberOfShields(4096);
            n -= this.getNumberOfShields(2048);
        }
        n -= this.heat / 5;
        if (this.heat >= 9 && this.hasTSM()) {
            n += 2;
        }
        n = Math.max(n - this.getCargoMpReduction(), 0);
        if (bl) {
            n = this.applyGravityEffectsOnMP(n);
        }
        n = Math.max(0, n);
        return n;
    }

    public int getRunMP(boolean bl) {
        if (this.countBadLegs() == 0) {
            return super.getRunMP(bl);
        }
        return this.getWalkMP(bl);
    }

    public int getRunMPwithoutMASC(boolean bl) {
        if (this.countBadLegs() == 0) {
            return super.getRunMPwithoutMASC(bl);
        }
        return this.getWalkMP(bl);
    }

    public void setInternal(int n, int n2, int n3, int n4, int n5) {
        this.initializeInternal(n, 0);
        this.initializeInternal(n2, 1);
        this.initializeInternal(n3, 2);
        this.initializeInternal(n3, 3);
        this.initializeInternal(n4, 4);
        this.initializeInternal(n4, 5);
        this.initializeInternal(n5, 6);
        this.initializeInternal(n5, 7);
    }

    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        int[] nArray = new int[]{6, 7};
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (this.isLocationBad(n)) {
                pilotingRollData.addModifier(5, this.getLocationName(n) + " destroyed");
                continue;
            }
            if (this.getBadCriticals(0, 11, n) > 0) {
                pilotingRollData.addModifier(2, this.getLocationName(n) + " Hip Actuator destroyed");
                if (!this.game.getOptions().booleanOption("maxtech_leg_damage")) continue;
            }
            if (this.getBadCriticals(0, 12, n) > 0) {
                pilotingRollData.addModifier(1, this.getLocationName(n) + " Upper Leg Actuator destroyed");
            }
            if (this.getBadCriticals(0, 13, n) > 0) {
                pilotingRollData.addModifier(1, this.getLocationName(n) + " Lower Leg Actuator destroyed");
            }
            if (this.getBadCriticals(0, 14, n) <= 0) continue;
            pilotingRollData.addModifier(1, this.getLocationName(n) + " Foot Actuator destroyed");
        }
        return super.addEntityBonuses(pilotingRollData);
    }

    protected int[] getNoOfSlots() {
        return NUM_OF_SLOTS;
    }

    protected String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    protected String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    protected double getArmActuatorCost() {
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.hasSystem(10, 5)) {
            ++n3;
        }
        if (this.hasSystem(9, 5)) {
            ++n2;
        }
        if (this.hasSystem(8, 5)) {
            ++n;
        }
        if (this.hasSystem(10, 4)) {
            ++n3;
        }
        if (this.hasSystem(9, 4)) {
            ++n2;
        }
        if (this.hasSystem(8, 4)) {
            ++n;
        }
        d += (double)((float)n * this.weight * 100.0f);
        d += (double)((float)n2 * this.weight * 50.0f);
        return d += (double)((float)n3 * this.weight * 80.0f);
    }

    protected double getLegActuatorCost() {
        return this.weight * 150.0f * 2.0f + this.weight * 80.0f * 2.0f + this.weight * 120.0f * 2.0f;
    }

    public double getArmorWeight() {
        double d = 16.0 * EquipmentType.getArmorPointMultiplier(this.armorType, this.techLevel);
        double d2 = 0.0;
        while ((int)Math.round(d2 * d) < this.getTotalOArmor()) {
            d2 += 0.5;
        }
        return d2;
    }

    public boolean hasClaw(int n) {
        if (n != 4 && n != 5) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            Mounted mounted;
            EquipmentType equipmentType;
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.getType() != 1 || !((equipmentType = (mounted = this.getEquipment(criticalSlot.getIndex())).getType()) instanceof MiscType) || !equipmentType.hasFlag(0x10000000L) || !equipmentType.hasSubType(1)) continue;
            return !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached();
        }
        return false;
    }

    public boolean hasVibroblades() {
        int n = 0;
        if (this.hasVibrobladesInLocation(4)) {
            ++n;
        }
        if (this.hasVibrobladesInLocation(5)) {
            ++n;
        }
        return n > 0;
    }

    public boolean hasVibrobladesInLocation(int n) {
        if (n != 4 && n != 5) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            Mounted mounted;
            EquipmentType equipmentType;
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.getType() != 1 || !((equipmentType = (mounted = this.getEquipment(criticalSlot.getIndex())).getType()) instanceof MiscType) || !((MiscType)equipmentType).isVibroblade()) continue;
            return !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached();
        }
        return false;
    }

    public int getActiveVibrobladeHeat(int n) {
        if (n != 4 && n != 5) {
            return 0;
        }
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            Mounted mounted;
            EquipmentType equipmentType;
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.getType() != 1 || !((equipmentType = (mounted = this.getEquipment(criticalSlot.getIndex())).getType()) instanceof MiscType) || !((MiscType)equipmentType).isVibroblade() || !mounted.curMode().equals("Active") || mounted.isDestroyed() || mounted.isMissing() || mounted.isBreached()) continue;
            MiscType miscType = (MiscType)equipmentType;
            if (miscType.hasSubType(65536)) {
                return 7;
            }
            if (miscType.hasSubType(32768)) {
                return 5;
            }
            return 3;
        }
        return 0;
    }
}

