/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.ArtilleryTracker;
import megamek.common.BattleArmorHandles;
import megamek.common.BipedMech;
import megamek.common.Building;
import megamek.common.BuildingTarget;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.CriticalSlot;
import megamek.common.Engine;
import megamek.common.EntitySelector;
import megamek.common.EntityWeightClass;
import megamek.common.EquipmentType;
import megamek.common.HexTarget;
import megamek.common.HitData;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.INarcPod;
import megamek.common.Infantry;
import megamek.common.InfernoTracker;
import megamek.common.LocationFullException;
import megamek.common.Mech;
import megamek.common.MechWarrior;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.MoveStep;
import megamek.common.NarcPod;
import megamek.common.Pilot;
import megamek.common.PilotingRollData;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.RoundUpdated;
import megamek.common.Tank;
import megamek.common.TargetRoll;
import megamek.common.Targetable;
import megamek.common.Transporter;
import megamek.common.TroopSpace;
import megamek.common.TurnOrdered;
import megamek.common.WeaponResult;
import megamek.common.WeaponType;
import megamek.common.actions.AbstractAttackAction;
import megamek.common.actions.ChargeAttackAction;
import megamek.common.actions.DfaAttackAction;
import megamek.common.actions.DisplacementAttackAction;
import megamek.common.actions.EntityAction;
import megamek.common.actions.PushAttackAction;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.event.GameEntityChangeEvent;
import megamek.common.preference.PreferenceManager;
import megamek.common.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Entity
extends TurnOrdered
implements Serializable,
Transporter,
Targetable,
RoundUpdated {
    public static final int NONE = -1;
    public static final int LOC_NONE = -1;
    public static final int LOC_DESTROYED = -2;
    public static final int MAX_C3_NODES = 12;
    protected transient IGame game;
    protected int id = -1;
    protected int externalId = -1;
    protected float weight;
    protected boolean omni = false;
    protected String chassis;
    protected String model;
    protected String fluff = null;
    protected int year;
    protected int techLevel;
    protected Engine engine;
    protected boolean mixedTech = false;
    protected boolean designValid = true;
    protected String displayName = null;
    protected String shortName = null;
    public int duplicateMarker = 1;
    protected transient Player owner;
    protected int ownerId;
    public Pilot crew = new Pilot();
    protected boolean shutDown = false;
    protected boolean doomed = false;
    protected boolean destroyed = false;
    private Coords position = null;
    protected int facing = 0;
    protected int sec_facing = 0;
    protected int walkMP = 0;
    protected int jumpMP = 0;
    protected int targSys = 0;
    protected boolean done = false;
    protected boolean prone = false;
    protected boolean hullDown = false;
    protected boolean findingClub = false;
    protected boolean armsFlipped = false;
    protected boolean unjammingRAC = false;
    protected boolean hasSpotlight = false;
    protected boolean illuminated = false;
    protected boolean spotlightIsActive = false;
    protected boolean usedSearchlight = false;
    protected boolean stuckInSwamp = false;
    protected boolean canUnstickByJumping = false;
    protected int taggedBy = -1;
    protected boolean layingMines = false;
    protected boolean _isEMId = false;
    protected DisplacementAttackAction displacementAttack = null;
    public int heat = 0;
    public int heatBuildup = 0;
    public int heatFromExternal = 0;
    public int delta_distance = 0;
    public int mpUsed = 0;
    public int moved = 0;
    public boolean gotPavementBonus = false;
    public boolean hitThisRoundByAntiTSM = false;
    private int[] exposure;
    private int[] armor;
    private int[] internal;
    private int[] orig_armor;
    private int[] orig_internal;
    public int damageThisPhase;
    public int engineHitsThisRound;
    public boolean rolledForEngineExplosion = false;
    public boolean dodging;
    public boolean spotting;
    private boolean clearingMinefield = false;
    protected int killerId = -1;
    private int offBoardDistance = 0;
    private int offBoardDirection = -1;
    private int retreatedDirection = -1;
    public InfernoTracker infernos = new InfernoTracker();
    public ArtilleryTracker aTracker = new ArtilleryTracker();
    protected String C3NetIdString = null;
    protected int C3Master = -1;
    protected int C3CompanyMasterIndex = -2;
    protected int armorType = -1;
    protected int armorTechLevel = -1;
    protected int structureType = -1;
    protected ArrayList<Mounted> equipmentList = new ArrayList();
    protected ArrayList<Mounted> weaponList = new ArrayList();
    protected ArrayList<Mounted> ammoList = new ArrayList();
    protected ArrayList<Mounted> miscList = new ArrayList();
    protected Vector<INarcPod> pendingINarcPods = new Vector();
    protected Vector<INarcPod> iNarcPods = new Vector();
    protected ArrayList<NarcPod> pendingNarcPods = new ArrayList();
    protected ArrayList<NarcPod> narcPods = new ArrayList();
    protected Vector<String> failedEquipmentList = new Vector();
    protected long m_lNarcedBy = 0L;
    protected long m_lPendingNarc = 0L;
    protected CriticalSlot[][] crits;
    protected int movementMode = 0;
    protected boolean isHidden = false;
    protected boolean carcass = false;
    private Vector<Transporter> transports = new Vector();
    private Vector<Integer> pickedUpMechWarriors = new Vector();
    private int conveyance = -1;
    private boolean unloadedThisTurn = false;
    private int swarmTargetId = -1;
    private int swarmAttackerId = -1;
    private boolean salvageable = true;
    private int removalCondition = 0;
    private int deployRound = 0;
    private boolean deployed = false;
    private char unitNumber = (char)65535;
    private boolean seenByEnemy = false;
    private boolean visibleToEnemy = false;
    private boolean captured = false;
    protected int elevation = 0;
    private Vector<Integer> hitBySwarmsEntity = new Vector();
    private Vector<Integer> hitBySwarmsWeapon = new Vector();
    private boolean canon;
    private int assaultDropInProgress = 0;
    private boolean climbMode = false;
    protected int lastTarget = -1;
    private int spotTargetId = -1;

    public Entity() {
        this.armor = new int[this.locations()];
        this.internal = new int[this.locations()];
        this.orig_armor = new int[this.locations()];
        this.orig_internal = new int[this.locations()];
        this.crits = new CriticalSlot[this.locations()][];
        this.exposure = new int[this.locations()];
        for (int i = 0; i < this.locations(); ++i) {
            this.crits[i] = new CriticalSlot[this.getNumberOfCriticals(i)];
        }
        this.setC3NetId(this);
    }

    public void restore() {
        for (Mounted mounted : this.equipmentList) {
            mounted.restore();
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
        this.displayName = null;
        this.shortName = null;
    }

    public int getExternalId() {
        return this.externalId;
    }

    public void setExternalId(int n) {
        this.externalId = n;
    }

    public IGame getGame() {
        return this.game;
    }

    public void setGame(IGame iGame) {
        Serializable serializable;
        this.game = iGame;
        this.restore();
        if (null == this.owner) {
            if (-1 == this.ownerId) {
                throw new IllegalStateException("Entity doesn't know its owner's ID.");
            }
            serializable = iGame.getPlayer(this.ownerId);
            if (null == serializable) {
                System.err.println("Entity can't find player #" + this.ownerId);
            } else {
                this.setOwner((Player)serializable);
            }
        }
        serializable = this.getLoadedUnits();
        Enumeration<Entity> enumeration = serializable.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setGame(iGame);
        }
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String string) {
        this.model = string;
    }

    public String getChassis() {
        return this.chassis;
    }

    public void setChassis(String string) {
        this.chassis = string;
    }

    public String getFluff() {
        return this.fluff;
    }

    public void setFluff(String string) {
        this.fluff = string;
    }

    public int getTechLevel() {
        return this.techLevel;
    }

    public void setTechLevel(int n) {
        this.techLevel = n;
    }

    public boolean isClan() {
        return this.techLevel == 2 || this.techLevel == 6;
    }

    public boolean isClanArmor() {
        if (this.getArmorTechLevel() == -1) {
            return this.isClan();
        }
        return this.getArmorTechLevel() == 2 || this.getArmorTechLevel() == 6;
    }

    public boolean isMixedTech() {
        return this.mixedTech;
    }

    public void setMixedTech(boolean bl) {
        this.mixedTech = bl;
    }

    public boolean isDesignValid() {
        return this.designValid;
    }

    public void setDesignValid(boolean bl) {
        this.designValid = bl;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int n) {
        this.year = n;
    }

    public float getWeight() {
        return this.weight;
    }

    public int getWeightClass() {
        return EntityWeightClass.getWeightClass((int)this.getWeight());
    }

    public String getWeightClassName() {
        return EntityWeightClass.getClassName(this.getWeightClass());
    }

    public void setWeight(float f) {
        this.weight = f;
    }

    public boolean isOmni() {
        return this.omni;
    }

    public void setOmni(boolean bl) {
        this.omni = bl;
    }

    public abstract int locations();

    public Player getOwner() {
        return this.owner;
    }

    public void setOwner(Player player) {
        this.owner = player;
        this.ownerId = player.getId();
        this.generateDisplayName();
    }

    public int getOwnerId() {
        return this.ownerId;
    }

    public boolean isEnemyOf(Entity entity) {
        if (null == this.owner) {
            return this.id != entity.getId() && this.ownerId != entity.ownerId;
        }
        return this.id != entity.getId() && this.owner.isEnemyOf(entity.getOwner());
    }

    public Pilot getCrew() {
        return this.crew;
    }

    public void setCrew(Pilot pilot) {
        this.crew = pilot;
    }

    public boolean isShutDown() {
        return this.shutDown;
    }

    public void setShutDown(boolean bl) {
        this.shutDown = bl;
    }

    public boolean isDoomed() {
        return this.doomed;
    }

    public void setDoomed(boolean bl) {
        if (bl) {
            this.setRemovalCondition(512);
        }
        this.doomed = bl;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setDestroyed(boolean bl) {
        this.destroyed = bl;
    }

    @Override
    public int getTargetType() {
        return 0;
    }

    @Override
    public int getTargetId() {
        return this.getId();
    }

    @Override
    public int getHeight() {
        return this.height();
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean bl) {
        this.done = bl;
    }

    public void setUnloaded(boolean bl) {
        this.unloadedThisTurn = bl;
    }

    public boolean isActive() {
        return this.isActive(-1);
    }

    public boolean isActive(int n) {
        boolean bl;
        boolean bl2 = bl = !this.shutDown && !this.destroyed && this.getCrew().isActive() && !this.unloadedThisTurn;
        bl = n > -1 && bl ? !this.deployed && this.shouldDeploy(n) : bl && this.deployed;
        return bl;
    }

    public boolean isSelectableThisTurn() {
        return !this.done && this.conveyance == -1 && !this.unloadedThisTurn && !this.isClearingMinefield() && !this.isCarcass();
    }

    public boolean isLoadableThisTurn() {
        return this.delta_distance == 0 && this.conveyance == -1 && !this.unloadedThisTurn && !this.isClearingMinefield();
    }

    public boolean isUnloadedThisTurn() {
        return this.unloadedThisTurn;
    }

    public boolean isTargetable() {
        return !this.destroyed && !this.doomed && this.deployed && !this.isOffBoard();
    }

    public boolean isProne() {
        return this.prone;
    }

    public void setProne(boolean bl) {
        this.prone = bl;
        if (bl) {
            this.hullDown = false;
        }
    }

    public boolean isHullDown() {
        return this.hullDown;
    }

    public void setHullDown(boolean bl) {
        this.hullDown = bl;
    }

    @Override
    public boolean isImmobile() {
        return this.shutDown || this.crew.isUnconscious();
    }

    public boolean isCharging() {
        return this.displacementAttack instanceof ChargeAttackAction;
    }

    public boolean isPushing() {
        return this.displacementAttack instanceof PushAttackAction;
    }

    public boolean isMakingDfa() {
        return this.displacementAttack instanceof DfaAttackAction;
    }

    public boolean hasDisplacementAttack() {
        return this.displacementAttack != null;
    }

    public DisplacementAttackAction getDisplacementAttack() {
        return this.displacementAttack;
    }

    public void setDisplacementAttack(DisplacementAttackAction displacementAttackAction) {
        this.displacementAttack = displacementAttackAction;
    }

    public boolean isTargetOfDisplacementAttack() {
        return this.findTargetedDisplacement() != null;
    }

    public DisplacementAttackAction findTargetedDisplacement() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!entity.hasDisplacementAttack() || entity.getDisplacementAttack().getTargetId() != this.id) continue;
            return entity.getDisplacementAttack();
        }
        return null;
    }

    public boolean isUnjammingRAC() {
        return this.unjammingRAC;
    }

    public void setUnjammingRAC(boolean bl) {
        this.unjammingRAC = bl;
    }

    public boolean isFindingClub() {
        return this.findingClub;
    }

    public void setFindingClub(boolean bl) {
        this.findingClub = bl;
    }

    public void setArmsFlipped(boolean bl) {
        this.armsFlipped = bl;
        this.game.processGameEvent(new GameEntityChangeEvent((Object)this, this));
    }

    public boolean getArmsFlipped() {
        return this.armsFlipped;
    }

    @Override
    public Coords getPosition() {
        return this.position;
    }

    public void setPosition(Coords coords) {
        this.position = coords;
    }

    public void setElevation(int n) {
        this.elevation = n;
    }

    public int calcElevation(IHex iHex, IHex iHex2, int n, boolean bl) {
        int n2 = n;
        if (this.getMovementMode() == 9 || this.getMovementMode() == 18 && (iHex.containsTerrain(4) || iHex2.containsTerrain(4)) || this.getMovementMode() == 6 || this.getMovementMode() == 14 && this.hasUMU() || this.getMovementMode() == 13 && this.hasUMU()) {
            n2 += iHex.surface();
            n2 -= iHex2.surface();
        } else {
            int n3;
            int n4;
            if (this.getMovementMode() != 5 && this.getMovementMode() != 7 && this.getMovementMode() != 8) {
                n4 = 0;
                if (iHex.containsTerrain(4)) {
                    n4 = iHex.terrainLevel(4);
                    if (!iHex.containsTerrain(20) || n < 0) {
                        n2 += iHex.terrainLevel(4);
                    }
                }
                if (iHex2.containsTerrain(4)) {
                    n3 = iHex2.terrainLevel(4);
                    if (iHex2.containsTerrain(20) && (n3 == 1 && n4 == 1 || n4 <= 2 && bl || n >= 0)) {
                        n2 += n3;
                    }
                    n2 -= n3;
                }
            }
            if (iHex2.containsTerrain(10) || iHex.containsTerrain(10)) {
                n4 = Math.max(0, iHex.terrainLevel(12));
                n3 = Math.max(0, iHex2.terrainLevel(12));
                if (n == n4 && bl && this instanceof Mech || n2 > n3) {
                    n2 = n3;
                } else if (n3 + iHex2.surface() > n4 + iHex.surface()) {
                    n2 += iHex.surface();
                    n2 -= iHex2.surface();
                }
            }
            if (this.getMovementMode() != 7 && this.getMovementMode() != 8 && (iHex2.containsTerrain(14) || iHex.containsTerrain(14))) {
                n4 = Math.max(-iHex2.depth(), iHex2.terrainLevel(16));
                if (Math.abs(iHex2.surface() + n4 - (iHex.surface() + n)) <= this.getMaxElevationChange() && (bl || Math.abs(iHex2.surface() + n2 - (iHex.surface() + n)) > this.getMaxElevationChange() || !this.isElevationValid(n2, iHex2))) {
                    n2 = n4;
                }
            }
        }
        return n2;
    }

    public int calcElevation(IHex iHex, IHex iHex2) {
        return this.calcElevation(iHex, iHex2, this.elevation, false);
    }

    @Override
    public int getElevation() {
        if (-1 != this.getTransportId()) {
            return this.game.getEntity(this.getTransportId()).getElevation();
        }
        if (null == this.getPosition() && this.isDeployed()) {
            throw new IllegalStateException("Entity #" + this.getId() + " does not know its position.");
        }
        if (this.isOffBoard()) {
            return 0;
        }
        return this.elevation;
    }

    public boolean canGoDown() {
        return this.canGoDown(this.elevation, this.getPosition());
    }

    public boolean canGoDown(int n, Coords coords) {
        boolean bl = false;
        IHex iHex = this.getGame().getBoard().getHex(coords);
        int n2 = n + iHex.surface();
        int n3 = iHex.surface();
        if (iHex.containsTerrain(1) || iHex.containsTerrain(4) || iHex.containsTerrain(23)) {
            bl = true;
        }
        switch (this.getMovementMode()) {
            case 10: 
            case 11: 
            case 12: {
                n3 -= Math.max(0, iHex.terrainLevel(13));
                break;
            }
            case 6: {
                n3 = iHex.ceiling();
                if (!bl) break;
                ++n3;
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 18: {
                n3 = iHex.floor();
                break;
            }
            default: {
                return false;
            }
        }
        return n2 > n3;
    }

    public boolean canGoUp(int n, Coords coords) {
        IHex iHex = this.getGame().getBoard().getHex(coords);
        int n2 = n + iHex.surface();
        int n3 = iHex.surface();
        switch (this.getMovementMode()) {
            case 10: 
            case 11: 
            case 12: {
                n3 += Math.max(0, iHex.terrainLevel(12));
                break;
            }
            case 6: {
                n3 = iHex.surface() + 50;
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 18: {
                n3 = iHex.surface();
                break;
            }
            default: {
                return false;
            }
        }
        return n2 < n3;
    }

    public boolean isElevationValid(int n, IHex iHex) {
        int n2 = n + iHex.surface();
        if (this.getMovementMode() == 6) {
            if (this instanceof Infantry && (iHex.containsTerrain(10) || iHex.containsTerrain(1) || iHex.containsTerrain(23))) {
                return n <= 50 && n2 >= iHex.floor();
            }
            if (iHex.containsTerrain(1) || iHex.containsTerrain(4) || iHex.containsTerrain(23)) {
                return n <= 50 && n2 > iHex.ceiling();
            }
            return n <= 50 && n2 >= iHex.ceiling();
        }
        if (this.getMovementMode() == 9 || this.getMovementMode() == 18 && iHex.containsTerrain(4) || this.getMovementMode() == 14 && this.hasUMU() || this.getMovementMode() == 13 && this.hasUMU()) {
            return n2 >= iHex.floor() && n2 <= iHex.surface();
        }
        if (this.getMovementMode() == 8 || this.getMovementMode() == 7) {
            return n2 == iHex.surface();
        }
        if ((iHex.containsTerrain(20) || this.getMovementMode() == 5 && iHex.containsTerrain(4)) && n2 == iHex.surface()) {
            return true;
        }
        if (iHex.containsTerrain(4) && n2 < iHex.surface() && !(this instanceof Mech) && !(this instanceof Protomech)) {
            return false;
        }
        if (n2 == iHex.floor()) {
            return true;
        }
        if (iHex.containsTerrain(14) && n == iHex.terrainLevel(16)) {
            return true;
        }
        return iHex.containsTerrain(10) && (this instanceof Mech || this instanceof Protomech || this instanceof Infantry) && n2 >= iHex.floor() && n2 <= iHex.ceiling();
    }

    public int height() {
        return 0;
    }

    @Override
    public int absHeight() {
        return this.getElevation() + this.height();
    }

    @Override
    public String getDisplayName() {
        if (this.displayName == null) {
            this.generateDisplayName();
        }
        return this.displayName;
    }

    public void generateDisplayName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.chassis);
        if (this.model != null && this.model.length() > 0) {
            stringBuffer.append(" ").append(this.model);
        }
        if (PreferenceManager.getClientPreferences().getShowUnitId()) {
            stringBuffer.append(" ID:").append(this.getId());
        } else if (this.duplicateMarker > 1) {
            stringBuffer.append(" #" + this.duplicateMarker);
        }
        if (this.getOwner() != null) {
            stringBuffer.append(" (").append(this.getOwner().getName()).append(")");
        }
        if (PreferenceManager.getClientPreferences().getShowUnitId()) {
            stringBuffer.append(" ID:").append(this.getId());
        }
        this.displayName = stringBuffer.toString();
    }

    public String getShortName() {
        if (this.shortName == null) {
            this.generateShortName();
        }
        return this.shortName;
    }

    public void generateShortName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.chassis);
        if (this.model != null && this.model.length() > 0) {
            stringBuffer.append(" ").append(this.model);
        }
        if (PreferenceManager.getClientPreferences().getShowUnitId()) {
            stringBuffer.append(" ID:").append(this.getId());
        } else if (this.duplicateMarker > 1) {
            stringBuffer.append(" #" + this.duplicateMarker);
        }
        this.shortName = stringBuffer.toString();
    }

    public String getShortNameRaw() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.chassis);
        if (this.model != null && this.model.length() > 0) {
            stringBuffer.append(" ").append(this.model);
        }
        return stringBuffer.toString();
    }

    public int getFacing() {
        return this.facing;
    }

    public void setFacing(int n) {
        this.facing = n;
        if (this.game != null) {
            this.game.processGameEvent(new GameEntityChangeEvent((Object)this, this));
        }
    }

    public int getSecondaryFacing() {
        return this.sec_facing;
    }

    public void setSecondaryFacing(int n) {
        this.sec_facing = n;
        if (this.game != null) {
            this.game.processGameEvent(new GameEntityChangeEvent((Object)this, this));
        }
    }

    public abstract boolean canChangeSecondaryFacing();

    public abstract boolean isValidSecondaryFacing(int var1);

    public abstract int clipSecondaryFacing(int var1);

    public boolean hasRAC() {
        for (Mounted mounted : this.getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.getAmmoType() != 23) continue;
            return true;
        }
        return false;
    }

    public boolean canUnjamRAC() {
        for (Mounted mounted : this.getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.getAmmoType() != 23 || !mounted.isJammed() || mounted.isDestroyed()) continue;
            return true;
        }
        return false;
    }

    public boolean canFlipArms() {
        return false;
    }

    public int getOriginalWalkMP() {
        return this.walkMP;
    }

    public void setOriginalWalkMP(int n) {
        this.walkMP = n;
    }

    public int getWalkMP() {
        return this.getWalkMP(true);
    }

    public int getWalkMP(boolean bl) {
        int n = this.getOriginalWalkMP();
        if (this.game != null && this.game.getOptions().booleanOption("maxtech_heat")) {
            int n2 = this.heat < 30 ? this.heat / 5 : (this.heat >= 49 ? 9 : (this.heat >= 43 ? 8 : (this.heat >= 37 ? 7 : (this.heat >= 31 ? 6 : 5))));
            n = Math.max(n - n2, 0);
        } else {
            n = Math.max(n - this.heat / 5, 0);
        }
        n = Math.max(n - this.getCargoMpReduction(), 0);
        if (bl) {
            n = this.applyGravityEffectsOnMP(n);
        }
        return n;
    }

    public int getStandingHeat() {
        return 0;
    }

    public int getWalkHeat() {
        return 0;
    }

    protected int getOriginalRunMP() {
        return (int)Math.ceil((double)this.getOriginalWalkMP() * 1.5);
    }

    public int getRunMP() {
        return this.getRunMP(true);
    }

    public int getRunMP(boolean bl) {
        return (int)Math.ceil((double)this.getWalkMP(bl) * 1.5);
    }

    public int getRunMPwithoutMASC() {
        return this.getRunMPwithoutMASC(true);
    }

    public abstract int getRunMPwithoutMASC(boolean var1);

    public String getRunMPasString() {
        return Integer.toString(this.getRunMP());
    }

    public int getRunHeat() {
        return 0;
    }

    public int getOriginalJumpMP() {
        return this.jumpMP;
    }

    public void setOriginalJumpMP(int n) {
        this.jumpMP = n;
    }

    public int getJumpMP() {
        return this.applyGravityEffectsOnMP(this.getOriginalJumpMP());
    }

    public int getJumpType() {
        return 0;
    }

    public int getJumpHeat(int n) {
        return 0;
    }

    public int getJumpMPWithTerrain() {
        return this.getJumpMP();
    }

    public int elevationOccupied(IHex iHex) {
        if (iHex == null) {
            return 0;
        }
        if (this.movementMode == 6) {
            return iHex.surface() + this.elevation;
        }
        if ((this.movementMode == 5 || this.movementMode == 7 || this.movementMode == 8 || iHex.containsTerrain(20)) && iHex.containsTerrain(4)) {
            return iHex.surface();
        }
        return iHex.floor();
    }

    public boolean isHexProhibited(IHex iHex) {
        return iHex.containsTerrain(30);
    }

    public abstract String getMovementString(int var1);

    public abstract String getMovementAbbr(int var1);

    public String getLocationName(HitData hitData) {
        return this.getLocationName(hitData.getLocation());
    }

    protected abstract String[] getLocationNames();

    public String getLocationName(int n) {
        String[] stringArray = this.getLocationNames();
        if (null == stringArray || n >= stringArray.length) {
            return "";
        }
        return stringArray[n];
    }

    protected abstract String[] getLocationAbbrs();

    public String getLocationAbbr(HitData hitData) {
        return this.getLocationAbbr(hitData.getLocation()) + (hitData.isRear() && this.hasRearArmor(hitData.getLocation()) ? "R" : "") + (hitData.getEffect() == 1 ? " (critical)" : "");
    }

    public String getLocationAbbr(int n) {
        String[] stringArray = this.getLocationAbbrs();
        if (null == stringArray || n >= stringArray.length) {
            return "";
        }
        return stringArray[n];
    }

    public int getLocationFromAbbr(String string) {
        for (int i = 0; i < this.locations(); ++i) {
            if (!this.getLocationAbbr(i).equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public abstract HitData rollHitLocation(int var1, int var2, int var3, int var4);

    public abstract HitData rollHitLocation(int var1, int var2);

    public abstract HitData getTransferLocation(HitData var1);

    public int getTransferLocation(int n) {
        return this.getTransferLocation(new HitData(n)).getLocation();
    }

    public abstract int getDependentLocation(int var1);

    public abstract boolean hasRearArmor(int var1);

    public int getArmor(int n) {
        return this.getArmor(n, false);
    }

    public int getArmor(HitData hitData) {
        return this.getArmor(hitData.getLocation(), hitData.isRear());
    }

    public int getArmor(int n, boolean bl) {
        return this.armor[n];
    }

    public int getOArmor(int n) {
        return this.getOArmor(n, false);
    }

    public int getOArmor(HitData hitData) {
        return this.getOArmor(hitData.getLocation(), hitData.isRear());
    }

    public int getOArmor(int n, boolean bl) {
        return this.orig_armor[n];
    }

    public void setArmor(int n, HitData hitData) {
        this.setArmor(n, hitData.getLocation(), hitData.isRear());
    }

    public void setArmor(int n, int n2) {
        this.setArmor(n, n2, false);
    }

    public void setArmor(int n, int n2, boolean bl) {
        this.armor[n2] = n;
    }

    public void refreshLocations() {
        this.armor = new int[this.locations()];
        this.internal = new int[this.locations()];
        this.orig_armor = new int[this.locations()];
        this.orig_internal = new int[this.locations()];
        this.crits = new CriticalSlot[this.locations()][];
        this.exposure = new int[this.locations()];
        for (int i = 0; i < this.locations(); ++i) {
            this.crits[i] = new CriticalSlot[this.getNumberOfCriticals(i)];
        }
    }

    public void initializeArmor(int n, int n2) {
        this.orig_armor[n2] = n;
        this.setArmor(n, n2);
    }

    public int getTotalArmor() {
        int n = 0;
        for (int i = 0; i < this.locations(); ++i) {
            if (this.getArmor(i) > 0) {
                n += this.getArmor(i);
            }
            if (!this.hasRearArmor(i) || this.getArmor(i, true) <= 0) continue;
            n += this.getArmor(i, true);
        }
        return n;
    }

    public int getTotalOArmor() {
        int n = 0;
        for (int i = 0; i < this.locations(); ++i) {
            if (this.getOArmor(i) > 0) {
                n += this.getOArmor(i);
            }
            if (!this.hasRearArmor(i) || this.getOArmor(i, true) <= 0) continue;
            n += this.getOArmor(i, true);
        }
        return n;
    }

    public double getArmorRemainingPercent() {
        if (this.getTotalOArmor() == 0) {
            return -1.0;
        }
        return (double)this.getTotalArmor() / (double)this.getTotalOArmor();
    }

    public int getInternal(HitData hitData) {
        return this.getInternal(hitData.getLocation());
    }

    public int getInternal(int n) {
        return this.internal[n];
    }

    public int getOInternal(HitData hitData) {
        return this.getOInternal(hitData.getLocation());
    }

    public int getOInternal(int n) {
        return this.orig_internal[n];
    }

    public void setInternal(int n, HitData hitData) {
        this.setInternal(n, hitData.getLocation());
    }

    public void setInternal(int n, int n2) {
        this.internal[n2] = n;
    }

    public void initializeInternal(int n, int n2) {
        this.orig_internal[n2] = n;
        this.setInternal(n, n2);
    }

    public abstract void autoSetInternal();

    public int getTotalInternal() {
        int n = 0;
        for (int i = 0; i < this.locations(); ++i) {
            if (this.getInternal(i) <= 0) continue;
            n += this.getInternal(i);
        }
        return n;
    }

    public int getTotalOInternal() {
        int n = 0;
        for (int i = 0; i < this.locations(); ++i) {
            if (this.getOInternal(i) <= 0) continue;
            n += this.getOInternal(i);
        }
        return n;
    }

    public double getInternalRemainingPercent() {
        return (double)this.getTotalInternal() / (double)this.getTotalOInternal();
    }

    public boolean isLocationBad(int n) {
        return this.getInternal(n) == -3;
    }

    public int getLocationStatus(int n) {
        return this.exposure[n];
    }

    public void setLocationStatus(int n, int n2) {
        if (this.exposure[n] > -1) {
            this.exposure[n] = n2;
        }
    }

    public boolean locationIsLeg(int n) {
        return false;
    }

    public String getArmorString(int n) {
        return this.getArmorString(n, false);
    }

    public String getArmorString(int n, boolean bl) {
        return Entity.armorStringFor(this.getArmor(n, bl));
    }

    public String getInternalString(int n) {
        return Entity.armorStringFor(this.getInternal(n));
    }

    public static String armorStringFor(int n) {
        if (n == -1) {
            return "N/A";
        }
        if (n == -2 || n == -3) {
            return "***";
        }
        return Integer.toString(n);
    }

    public int getHeatFiringModifier() {
        boolean bl;
        int n = 0;
        if (this.heat >= 8) {
            ++n;
        }
        if (this.heat >= 13) {
            ++n;
        }
        if (this.heat >= 17) {
            ++n;
        }
        if (this.heat >= 24) {
            ++n;
        }
        if ((bl = this.game.getOptions().booleanOption("maxtech_heat")) && this.heat >= 33) {
            ++n;
        }
        if (bl && this.heat >= 41) {
            ++n;
        }
        if (bl && this.heat >= 48) {
            ++n;
        }
        return n;
    }

    public Mounted addEquipment(EquipmentType equipmentType, int n) throws LocationFullException {
        return this.addEquipment(equipmentType, n, false);
    }

    public Mounted addEquipment(EquipmentType equipmentType, int n, boolean bl) throws LocationFullException {
        Mounted mounted = new Mounted(this, equipmentType);
        this.addEquipment(mounted, n, bl);
        return mounted;
    }

    protected void addEquipment(Mounted mounted, int n, boolean bl) throws LocationFullException {
        mounted.setLocation(n, bl);
        this.equipmentList.add(mounted);
        if (mounted.getType() instanceof WeaponType) {
            this.weaponList.add(mounted);
            if (mounted.getType().hasFlag(65536L)) {
                this.aTracker.addWeapon(mounted);
            }
            if (mounted.getType().hasFlag(32768L)) {
                Mounted mounted2 = new Mounted(this, AmmoType.getOneshotAmmo(mounted));
                mounted2.setShotsLeft(1);
                mounted.setLinked(mounted2);
                this.addEquipment(mounted2, -1, false);
            }
        }
        if (mounted.getType() instanceof AmmoType) {
            this.ammoList.add(mounted);
        }
        if (mounted.getType() instanceof MiscType) {
            this.miscList.add(mounted);
        }
    }

    public void addFailedEquipment(String string) {
        this.failedEquipmentList.addElement(string);
    }

    public int getEquipmentNum(Mounted mounted) {
        if (mounted != null) {
            return this.equipmentList.indexOf(mounted);
        }
        return -1;
    }

    public ArrayList<Mounted> getEquipment() {
        return this.equipmentList;
    }

    public Mounted getEquipment(int n) {
        try {
            return this.equipmentList.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public EquipmentType getEquipmentType(CriticalSlot criticalSlot) {
        if (criticalSlot.getType() != 1) {
            return null;
        }
        Mounted mounted = this.equipmentList.get(criticalSlot.getIndex());
        return mounted.getType();
    }

    public Enumeration getFailedEquipment() {
        return this.failedEquipmentList.elements();
    }

    public int getTotalAmmoOfType(EquipmentType equipmentType) {
        int n = 0;
        for (Mounted mounted : this.getAmmo()) {
            if (mounted.getType() != equipmentType || mounted.isDumping()) continue;
            n += mounted.getShotsLeft();
        }
        return n;
    }

    public int getTotalMunitionsOfType(EquipmentType equipmentType) {
        int n = 0;
        for (Mounted mounted : this.getAmmo()) {
            if (!mounted.getType().equals(equipmentType) || mounted.isDumping()) continue;
            n += mounted.getShotsLeft();
        }
        return n;
    }

    public abstract int getWeaponArc(int var1);

    public abstract boolean isSecondaryArcWeapon(int var1);

    public Iterator<Mounted> getWeapons() {
        return this.weaponList.iterator();
    }

    public ArrayList<Mounted> getWeaponList() {
        return this.weaponList;
    }

    public int getFirstWeapon() {
        for (Mounted mounted : this.getWeaponList()) {
            if (!mounted.isReady()) continue;
            return this.getEquipmentNum(mounted);
        }
        return -1;
    }

    public int getNextWeapon(int n) {
        boolean bl = false;
        for (Mounted mounted : this.getWeaponList()) {
            if (bl && mounted != null && mounted.isReady() && !mounted.getType().hasFlag(0x1000000L) && (mounted.getLinked() == null || mounted.getLinked().getShotsLeft() > 0)) {
                if (mounted.getType().hasFlag(0x8000000L) && this.game.getPhase() == 12) continue;
                return this.getEquipmentNum(mounted);
            }
            if (this.getEquipmentNum(mounted) == n) {
                bl = true;
                continue;
            }
            if (!bl || this.getEquipmentNum(mounted) != n) continue;
            return this.getFirstWeapon();
        }
        return this.getFirstWeapon();
    }

    public void loadAllWeapons() {
        for (Mounted mounted : this.getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.getAmmoType() == -1) continue;
            this.loadWeapon(mounted);
        }
    }

    public void loadWeapon(Mounted mounted) {
        for (Mounted mounted2 : this.getAmmo()) {
            if (this.loadWeapon(mounted, mounted2)) break;
        }
    }

    public void loadWeaponWithSameAmmo(Mounted mounted) {
        for (Mounted mounted2 : this.getAmmo()) {
            if (!this.loadWeaponWithSameAmmo(mounted, mounted2)) continue;
            return;
        }
        this.loadWeapon(mounted);
    }

    public boolean loadWeapon(Mounted mounted, Mounted mounted2) {
        boolean bl = false;
        WeaponType weaponType = (WeaponType)mounted.getType();
        AmmoType ammoType = (AmmoType)mounted2.getType();
        if (mounted2.isAmmoUsable() && !weaponType.hasFlag(32768L) && ammoType.getAmmoType() == weaponType.getAmmoType() && ammoType.getRackSize() == weaponType.getRackSize()) {
            mounted.setLinked(mounted2);
            bl = true;
        }
        return bl;
    }

    public boolean loadWeaponWithSameAmmo(Mounted mounted, Mounted mounted2) {
        AmmoType ammoType = (AmmoType)mounted2.getType();
        Mounted mounted3 = mounted.getLinked();
        if (mounted3 != null && ((AmmoType)mounted3.getType()).getMunitionType() != ammoType.getMunitionType()) {
            return false;
        }
        return this.loadWeapon(mounted, mounted2);
    }

    public boolean weaponFiredFrom(int n) {
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            Mounted mounted;
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.getType() != 1 || !((mounted = this.getEquipment(criticalSlot.getIndex())).getType() instanceof WeaponType) || !mounted.isUsedThisRound()) continue;
            return true;
        }
        return false;
    }

    public ArrayList<Mounted> getAmmo() {
        return this.ammoList;
    }

    public ArrayList<Mounted> getMisc() {
        return this.miscList;
    }

    public void removeMisc(String string) {
        for (Mounted mounted : this.getMisc()) {
            if (!mounted.getName().equals(string)) continue;
            this.miscList.remove(mounted);
            this.equipmentList.remove(mounted);
            break;
        }
    }

    public List<Mounted> getClubs() {
        ArrayList<Mounted> arrayList = new ArrayList<Mounted>();
        for (Mounted mounted : this.getMisc()) {
            if (!mounted.getType().hasFlag(0x8000000L)) continue;
            arrayList.add(mounted);
        }
        return arrayList;
    }

    public boolean hasWorkingMisc(long l, int n) {
        for (Mounted mounted : this.miscList) {
            MiscType miscType;
            if (!(mounted.getType() instanceof MiscType) || !mounted.isReady() || !(miscType = (MiscType)mounted.getType()).hasFlag(l) || n != -1 && !miscType.hasSubType(n)) continue;
            return true;
        }
        return false;
    }

    public boolean hasWorkingMisc(long l, int n, int n2) {
        for (Mounted mounted : this.miscList) {
            MiscType miscType;
            if (!(mounted.getType() instanceof MiscType) || !mounted.isReady() || mounted.getLocation() != n2 || !(miscType = (MiscType)mounted.getType()).hasFlag(l) || n != -1 && !miscType.hasSubType(n)) continue;
            return true;
        }
        return false;
    }

    public abstract int getHeatCapacity();

    public abstract int getHeatCapacityWithWater();

    public abstract int getEngineCritHeat();

    public CriticalSlot getCritical(int n, int n2) {
        return this.crits[n][n2];
    }

    public void setCritical(int n, int n2, CriticalSlot criticalSlot) {
        this.crits[n][n2] = criticalSlot;
    }

    public boolean addCritical(int n, CriticalSlot criticalSlot) {
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            if (this.getCritical(n, i) != null) continue;
            this.crits[n][i] = criticalSlot;
            return true;
        }
        return false;
    }

    public boolean addCritical(int n, int n2, CriticalSlot criticalSlot) {
        if (this.getCritical(n, n2) == null) {
            this.setCritical(n, n2, criticalSlot);
            return true;
        }
        return this.addCritical(n, criticalSlot);
    }

    public void removeCriticals(int n, CriticalSlot criticalSlot) {
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            if (this.getCritical(n, i) == null || !this.getCritical(n, i).equals(criticalSlot)) continue;
            this.setCritical(n, i, null);
        }
    }

    public int getEmptyCriticals(int n) {
        int n2 = 0;
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            if (this.getCritical(n, i) != null) continue;
            ++n2;
        }
        return n2;
    }

    public int getHittableCriticals(int n) {
        int n2 = 0;
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            if (this.getCritical(n, i) == null || !this.getCritical(n, i).isHittable()) continue;
            ++n2;
        }
        return n2;
    }

    public boolean canTransferCriticals(int n) {
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.isDestroyed() || !criticalSlot.isEverHittable()) continue;
            return false;
        }
        return true;
    }

    public int getGyroType() {
        return -1;
    }

    public int getGoodCriticals(CriticalSlot criticalSlot, int n) {
        return this.getGoodCriticals(criticalSlot.getType(), criticalSlot.getIndex(), n);
    }

    public int getGoodCriticals(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = this.getNumberOfCriticals(n3);
        for (int i = 0; i < n5; ++i) {
            CriticalSlot criticalSlot = this.getCritical(n3, i);
            if (criticalSlot == null || criticalSlot.getType() != n || criticalSlot.getIndex() != n2 || criticalSlot.isDestroyed() || criticalSlot.isBreached()) continue;
            ++n4;
        }
        return n4;
    }

    public int getBadCriticals(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = this.getNumberOfCriticals(n3);
        for (int i = 0; i < n5; ++i) {
            CriticalSlot criticalSlot = this.getCritical(n3, i);
            if (criticalSlot == null || criticalSlot.getType() != n || criticalSlot.getIndex() != n2 || !criticalSlot.isDestroyed() && !criticalSlot.isBreached()) continue;
            ++n4;
        }
        return n4;
    }

    public int getHitCriticals(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = this.getNumberOfCriticals(n3);
        for (int i = 0; i < n5; ++i) {
            CriticalSlot criticalSlot = this.getCritical(n3, i);
            if (criticalSlot == null || criticalSlot.getType() != n || criticalSlot.getIndex() != n2 || !criticalSlot.isDamaged() && !criticalSlot.isBreached()) continue;
            ++n4;
        }
        return n4;
    }

    protected abstract int[] getNoOfSlots();

    public int getNumberOfCriticals(int n) {
        int[] nArray = this.getNoOfSlots();
        if (null == nArray || n >= nArray.length || n == -1) {
            return 0;
        }
        return nArray[n];
    }

    public int getNumberOfCriticals(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = this.getNumberOfCriticals(n3);
        for (int i = 0; i < n5; ++i) {
            CriticalSlot criticalSlot = this.getCritical(n3, i);
            if (criticalSlot == null || criticalSlot.getType() != n || criticalSlot.getIndex() != n2) continue;
            ++n4;
        }
        return n4;
    }

    public int getNumberOfCriticals(EquipmentType equipmentType, int n) {
        int n2 = 0;
        int n3 = this.getNumberOfCriticals(n);
        for (int i = 0; i < n3; ++i) {
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || this.getEquipmentType(criticalSlot) == null || !this.getEquipmentType(criticalSlot).equals(equipmentType)) continue;
            ++n2;
        }
        return n2;
    }

    public int getNumberOfCriticals(EquipmentType equipmentType) {
        int n = 0;
        int n2 = this.locations();
        for (int i = 0; i < n2; ++i) {
            n += this.getNumberOfCriticals(equipmentType, i);
        }
        return n;
    }

    public int getNumberOf(EquipmentType equipmentType) {
        int n = 0;
        for (Mounted mounted : this.equipmentList) {
            if (!mounted.getType().equals(equipmentType)) continue;
            ++n;
        }
        return n;
    }

    public boolean hasHipCrit() {
        return false;
    }

    public boolean hasLegActuatorCrit() {
        boolean bl = false;
        for (int i = 0; i < this.locations(); ++i) {
            if (!this.locationIsLeg(i) || this.getBadCriticals(0, 11, i) <= 0 && this.getBadCriticals(0, 12, i) <= 0 && this.getBadCriticals(0, 13, i) <= 0 && this.getBadCriticals(0, 14, i) <= 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean hasWorkingSystem(int n, int n2) {
        for (int i = 0; i < this.getNumberOfCriticals(n2); ++i) {
            CriticalSlot criticalSlot = this.getCritical(n2, i);
            if (criticalSlot == null || criticalSlot.getType() != 0 || criticalSlot.getIndex() != n || criticalSlot.isDestroyed() || criticalSlot.isBreached()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSystem(int n, int n2) {
        for (int i = 0; i < this.getNumberOfCriticals(n2); ++i) {
            CriticalSlot criticalSlot = this.getCritical(n2, i);
            if (criticalSlot == null || criticalSlot.getType() != 0 || criticalSlot.getIndex() != n) continue;
            return true;
        }
        return false;
    }

    public boolean hasVibroblades() {
        return false;
    }

    public int getActiveVibrobladeHeat(int n) {
        return 0;
    }

    public boolean hasShield() {
        int n = 0;
        if (!(this instanceof Mech)) {
            return false;
        }
        for (Mounted mounted : this.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!(equipmentType instanceof MiscType) || !((MiscType)equipmentType).isShield() || this.getInternal(mounted.getLocation()) <= 0) continue;
            ++n;
        }
        return n > 0;
    }

    public int getNumberOfShields(int n) {
        if (!(this instanceof Mech)) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        for (Mounted mounted : this.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(0x8000000L) || !equipmentType.hasSubType(n)) continue;
            if (mounted.getLocation() == 4) {
                n2 = 1;
            }
            if (mounted.getLocation() == 5) {
                n3 = 1;
            }
            if (n2 <= 0 || n3 <= 0) continue;
            return 2;
        }
        return n2 + n3;
    }

    public boolean hasActiveShield(int n, boolean bl) {
        if (!(this instanceof Mech)) {
            return false;
        }
        switch (n) {
            case 0: 
            case 1: {
                if (bl) {
                    return false;
                }
                return this.hasActiveShield(5) || this.hasActiveShield(4);
            }
            case 3: 
            case 5: 
            case 7: {
                return this.hasActiveShield(5);
            }
        }
        return this.hasActiveShield(4);
    }

    public boolean hasActiveShield(int n) {
        if (n != 4 && n != 5) {
            return false;
        }
        if (this.isShutDown() || this.getCrew().isKoThisRound() || this.getCrew().isUnconscious()) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            Mounted mounted;
            EquipmentType equipmentType;
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.getType() != 1 || criticalSlot.isDamaged() || !((equipmentType = (mounted = this.getEquipment(criticalSlot.getIndex())).getType()) instanceof MiscType) || !((MiscType)equipmentType).isShield() || !mounted.curMode().equals("Active")) continue;
            return mounted.getCurrentDamageCapacity(this, mounted.getLocation()) > 0;
        }
        return false;
    }

    public boolean hasPassiveShield(int n, boolean bl) {
        if (!(this instanceof Mech)) {
            return false;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 6: 
            case 7: {
                return false;
            }
            case 3: 
            case 5: {
                if (bl) {
                    return false;
                }
                return this.hasPassiveShield(5);
            }
        }
        if (bl) {
            return false;
        }
        return this.hasPassiveShield(4);
    }

    public boolean hasPassiveShield(int n) {
        if (this.isShutDown() || this.getCrew().isKoThisRound() || this.getCrew().isUnconscious()) {
            return false;
        }
        if (n != 4 && n != 5) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            Mounted mounted;
            EquipmentType equipmentType;
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.getType() != 1 || criticalSlot.isDamaged() || !((equipmentType = (mounted = this.getEquipment(criticalSlot.getIndex())).getType()) instanceof MiscType) || !((MiscType)equipmentType).isShield() || !mounted.curMode().equals("Passive")) continue;
            return mounted.getCurrentDamageCapacity(this, mounted.getLocation()) > 0;
        }
        return false;
    }

    public boolean hasNoDefenseShield(int n) {
        if (n != 4 && n != 5) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            Mounted mounted;
            EquipmentType equipmentType;
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.getType() != 1 || criticalSlot.isDamaged() || !((equipmentType = (mounted = this.getEquipment(criticalSlot.getIndex())).getType()) instanceof MiscType) || !((MiscType)equipmentType).isShield() || !mounted.curMode().equals("None") && !this.isShutDown() && !this.getCrew().isKoThisRound() && !this.getCrew().isUnconscious()) continue;
            return mounted.getCurrentDamageCapacity(this, mounted.getLocation()) > 0;
        }
        return false;
    }

    public boolean hasUMU() {
        if (!(this instanceof Mech)) {
            return false;
        }
        int n = this.getActiveUMUCount();
        return n > 0;
    }

    public int getActiveUMUCount() {
        int n = 0;
        if (this.hasShield() && this.getNumberOfShields(4096) > 0) {
            return 0;
        }
        for (Mounted mounted : this.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(0x100000000L) || mounted.isDestroyed() || mounted.isMissing() || mounted.isBreached()) continue;
            ++n;
        }
        return n;
    }

    public int getAllUMUCount() {
        int n = 0;
        if (!(this instanceof Mech)) {
            return 0;
        }
        if (this.hasShield() && this.getNumberOfShields(4096) > 0) {
            return 0;
        }
        for (Mounted mounted : this.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(0x100000000L)) continue;
            ++n;
        }
        return n;
    }

    public boolean hasActiveECM() {
        for (Mounted mounted : this.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(1024L) || !mounted.curMode().equals("ECM")) continue;
            return !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached() && !this.isShutDown() && !this.getCrew().isUnconscious();
        }
        return false;
    }

    public boolean hasActiveAngelECM() {
        for (Mounted mounted : this.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(4096L) || !mounted.curMode().equals("ECM")) continue;
            return !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached() && !this.isShutDown();
        }
        return false;
    }

    public boolean hasActiveECCM() {
        for (Mounted mounted : this.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(1024L) || !mounted.curMode().equals("ECCM")) continue;
            return !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached() && !this.isShutDown() && !this.getCrew().isUnconscious();
        }
        return false;
    }

    public boolean hasActiveAngelECCM() {
        for (Mounted mounted : this.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(4096L) || !mounted.curMode().equals("ECCM")) continue;
            return !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached() && !this.isShutDown();
        }
        return false;
    }

    public int getAngelECMRange() {
        for (Mounted mounted : this.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(1024L) || mounted.isDestroyed() || mounted.isMissing()) continue;
            return 6;
        }
        return -1;
    }

    public int getECMRange() {
        for (Mounted mounted : this.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(1024L) || mounted.isDestroyed() || mounted.isMissing()) continue;
            if ("Single-Hex ECM".equals(equipmentType.getInternalName())) {
                return 0;
            }
            return 6;
        }
        return -1;
    }

    public boolean hasBAP() {
        for (Mounted mounted : this.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(8192L)) continue;
            return !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached() && !this.isShutDown() && !Compute.isAffectedByECM(this, this.getPosition(), this.getPosition()) && !Compute.isAffectedByAngelECM(this, this.getPosition(), this.getPosition());
        }
        return false;
    }

    public int getBAPRange() {
        for (Mounted mounted : this.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(8192L) || mounted.isDestroyed() || mounted.isMissing()) continue;
            if (mounted.getName().equals("Bloodhound Active Probe (THB)") || mounted.getName().equals("Bloodhound Active Probe")) {
                return 8;
            }
            if (mounted.getType().getInternalName().equals("CLActiveProbe") || mounted.getType().getInternalName().equals("WatchdogECMSuite")) {
                return 5;
            }
            if (mounted.getType().getInternalName().equals("CLLightActiveProbe") || mounted.getType().getInternalName().equals("CLImprovedSensors")) {
                return 3;
            }
            if (mounted.getType().getInternalName().equals("ISImprovedSensors")) {
                return 2;
            }
            return 4;
        }
        return -1;
    }

    public boolean hasTargComp() {
        for (Mounted mounted : this.getMisc()) {
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(2048L)) continue;
            return !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached();
        }
        return false;
    }

    public boolean hasAimModeTargComp() {
        if (this.hasActiveEiCockpit()) {
            if (this instanceof Mech) {
                if (((Mech)this).getCockpitStatus() == 2) {
                    return true;
                }
            } else {
                return true;
            }
        }
        for (Mounted mounted : this.getMisc()) {
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(2048L) || !mounted.curMode().equals("Aimed shot")) continue;
            return !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached();
        }
        return false;
    }

    public boolean hasC3S() {
        if (this.isShutDown() || this.isOffBoard()) {
            return false;
        }
        for (Mounted mounted : this.getEquipment()) {
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(128L) || mounted.isDestroyed() || mounted.isBreached()) continue;
            return true;
        }
        return false;
    }

    public boolean hasC3M() {
        if (this.isShutDown() || this.isOffBoard()) {
            return false;
        }
        for (Mounted mounted : this.getEquipment()) {
            if (!(mounted.getType() instanceof WeaponType) || !mounted.getType().hasFlag(0x10000000L) || mounted.isDestroyed() || mounted.isBreached()) continue;
            return !this.C3MasterIs(this) || this.C3CompanyMasterIndex != this.getEquipmentNum(mounted);
        }
        return false;
    }

    public boolean hasC3MM() {
        Object object;
        if (this.isShutDown() || this.isOffBoard()) {
            return false;
        }
        if (this.C3CompanyMasterIndex == -1) {
            return false;
        }
        if (this.C3CompanyMasterIndex == -2) {
            object = this.getEquipment().iterator();
            while (this.C3CompanyMasterIndex == -2 && object.hasNext()) {
                Mounted mounted = (Mounted)object.next();
                if (!(mounted.getType() instanceof WeaponType) || !mounted.getType().hasFlag(0x10000000L) || mounted.isDestroyed() || mounted.isBreached()) continue;
                while (this.C3CompanyMasterIndex == -2 && object.hasNext()) {
                    mounted = (Mounted)object.next();
                    if (!(mounted.getType() instanceof WeaponType) || !mounted.getType().hasFlag(0x10000000L) || mounted.isDestroyed() || mounted.isBreached()) continue;
                    this.C3CompanyMasterIndex = this.getEquipmentNum(mounted);
                }
            }
            if (this.C3CompanyMasterIndex == -2) {
                this.C3CompanyMasterIndex = -1;
                return false;
            }
        }
        return !((Mounted)(object = this.getEquipment(this.C3CompanyMasterIndex))).isDestroyed() && !((Mounted)object).isBreached();
    }

    public boolean hasC3() {
        return this.hasC3S() | this.hasC3M() | this.hasC3MM();
    }

    public boolean hasC3i() {
        if (this.isShutDown() || this.isOffBoard()) {
            return false;
        }
        for (Mounted mounted : this.getEquipment()) {
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(256L) || mounted.isDestroyed() || mounted.isBreached()) continue;
            return true;
        }
        return false;
    }

    public String getC3NetId() {
        if (this.C3NetIdString == null) {
            if (this.hasC3()) {
                this.C3NetIdString = "C3." + this.getId();
            } else if (this.hasC3i()) {
                this.C3NetIdString = "C3i." + this.getId();
            }
        }
        return this.C3NetIdString;
    }

    public void setC3NetId(Entity entity) {
        if (this.isEnemyOf(entity)) {
            return;
        }
        this.C3NetIdString = entity.C3NetIdString;
    }

    public int calculateFreeC3MNodes() {
        int n;
        block7: {
            block6: {
                n = 0;
                if (!this.hasC3MM()) break block6;
                n = 2;
                if (this.game == null) break block7;
                Enumeration<Entity> enumeration = this.game.getEntities();
                while (enumeration.hasMoreElements()) {
                    Entity entity = enumeration.nextElement();
                    if (!entity.hasC3M() || entity == this) continue;
                    Entity entity2 = entity.getC3Master();
                    if (this.equals(entity2)) {
                        --n;
                    }
                    if (n > 0) continue;
                    return 0;
                }
                break block7;
            }
            if (this.hasC3M() && this.C3MasterIs(this)) {
                n = 3;
                if (this.game != null) {
                    Enumeration<Entity> enumeration = this.game.getEntities();
                    while (enumeration.hasMoreElements()) {
                        Entity entity = enumeration.nextElement();
                        if (!entity.hasC3() || entity == this) continue;
                        Entity entity3 = entity.getC3Master();
                        if (this.equals(entity3)) {
                            --n;
                        }
                        if (n > 0) continue;
                        return 0;
                    }
                }
            }
        }
        return n;
    }

    public int calculateFreeC3Nodes() {
        int n;
        block6: {
            block5: {
                n = 0;
                if (!this.hasC3i()) break block5;
                n = 5;
                if (this.game == null) break block6;
                Enumeration<Entity> enumeration = this.game.getEntities();
                while (enumeration.hasMoreElements()) {
                    Entity entity = enumeration.nextElement();
                    if (this.equals(entity) || !this.onSameC3NetworkAs(entity) || --n > 0) continue;
                    return 0;
                }
                break block6;
            }
            if (this.hasC3M()) {
                n = 3;
                if (this.game != null) {
                    Enumeration<Entity> enumeration = this.game.getEntities();
                    while (enumeration.hasMoreElements()) {
                        Entity entity = enumeration.nextElement();
                        if (!entity.hasC3() || this.equals(entity)) continue;
                        Entity entity2 = entity.getC3Master();
                        if (this.equals(entity2) && (!this.C3MasterIs(this) || !this.hasC3MM() || entity.hasC3S())) {
                            --n;
                        }
                        if (n > 0) continue;
                        return 0;
                    }
                }
            }
        }
        return n;
    }

    public Entity getC3Top() {
        Entity entity = this;
        Entity entity2 = entity.getC3Master();
        while (entity2 != null && !entity2.equals(entity) && entity2.hasC3() && !Compute.isAffectedByECM(entity, entity.getPosition(), entity2.getPosition()) && !Compute.isAffectedByECM(entity2, entity2.getPosition(), entity2.getPosition())) {
            entity = entity2;
            entity2 = entity.getC3Master();
        }
        return entity;
    }

    public Entity getC3Master() {
        if (this.C3Master == -1) {
            return null;
        }
        if (this.hasC3S() && this.C3Master > -1) {
            Entity entity = this.game.getEntity(this.C3Master);
            if (entity == null) {
                this.C3Master = -1;
            } else {
                if (entity.isShutDown()) {
                    return null;
                }
                if (entity.C3MasterIs(entity) && !entity.hasC3MM()) {
                    this.C3Master = -1;
                } else if (!entity.hasC3M()) {
                    this.C3Master = -1;
                }
            }
        } else if (this.hasC3M() && this.C3Master > -1) {
            Entity entity = this.game.getEntity(this.C3Master);
            if (entity == null) {
                this.C3Master = -1;
            } else {
                Entity entity2;
                if (entity.isShutDown()) {
                    return null;
                }
                if (entity.C3CompanyMasterIndex > -1 && !entity.hasC3MM() || entity.C3CompanyMasterIndex <= -1 && !entity.hasC3M()) {
                    this.C3Master = -1;
                } else if (entity != this && (entity2 = entity.getC3Master()) != null && entity2.getC3Master() != entity2) {
                    this.C3Master = -1;
                }
            }
        } else if (!this.isShutDown() && !this.hasC3MM() && this.C3Master > -1) {
            this.C3Master = -1;
        }
        if (this.C3Master == -1) {
            return null;
        }
        return this.game.getEntity(this.C3Master);
    }

    public int getC3MasterId() {
        this.getC3Master();
        return this.C3Master;
    }

    public boolean C3MasterIs(Entity entity) {
        if (entity == null && this.C3Master == -1) {
            return true;
        }
        return entity.id == this.C3Master;
    }

    public void setC3Master(Entity entity) {
        if (entity == null) {
            this.setC3Master(-1);
        } else {
            if (this.isEnemyOf(entity)) {
                return;
            }
            this.setC3Master(entity.id);
        }
    }

    public void setC3Master(int n) {
        Entity entity;
        Enumeration<Entity> enumeration;
        if (this.id == n != (this.id == this.C3Master)) {
            enumeration = this.game.getEntities();
            while (enumeration.hasMoreElements()) {
                entity = enumeration.nextElement();
                if (!entity.C3MasterIs(this) || this.equals(entity)) continue;
                entity.setC3Master(-1);
            }
        }
        if (this.hasC3()) {
            this.C3Master = n;
        }
        if (this.hasC3() && n == -1) {
            this.C3NetIdString = "C3." + this.id;
        } else if (this.hasC3i() && n == -1) {
            this.C3NetIdString = "C3i." + this.id;
        } else if (this.hasC3() || this.hasC3i()) {
            this.C3NetIdString = this.game.getEntity(n).getC3NetId();
        }
        enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            entity = enumeration.nextElement();
            if (!entity.C3MasterIs(this) || this.equals(entity)) continue;
            entity.C3NetIdString = this.C3NetIdString;
        }
    }

    public boolean onSameC3NetworkAs(Entity entity) {
        if (this.isEnemyOf(entity) || this.isShutDown() || entity.isShutDown() || this.isINarcedWith(2L)) {
            return false;
        }
        if (this instanceof Mech && this.isStealthActive()) {
            return false;
        }
        if (entity instanceof Mech && entity.isStealthActive()) {
            return false;
        }
        if (this.hasC3i() && entity.hasC3i() && this.getC3NetId().equals(entity.getC3NetId())) {
            return !Compute.isAffectedByECM(entity, entity.getPosition(), entity.getPosition()) && !Compute.isAffectedByECM(this, this.getPosition(), this.getPosition());
        }
        if (!this.hasC3() || !entity.hasC3()) {
            return false;
        }
        if (this.getC3Top() == null || entity.getC3Top() == null) {
            return false;
        }
        return this.getC3Top().equals(entity.getC3Top());
    }

    public boolean locationHasCase(int n) {
        for (Mounted mounted : this.getMisc()) {
            if (mounted.getLocation() != n || !mounted.getType().hasFlag(8L) || mounted.isDestroyed()) continue;
            return true;
        }
        return false;
    }

    public void hitAllCriticals(int n, int n2) {
        CriticalSlot criticalSlot = this.getCritical(n, n2);
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            CriticalSlot criticalSlot2 = this.getCritical(n, n2);
            if (criticalSlot2.getType() != criticalSlot.getType() || criticalSlot2.getIndex() != criticalSlot.getIndex()) continue;
            criticalSlot2.setHit(true);
        }
    }

    @Override
    public void newRound(int n) {
        this.unloadedThisTurn = false;
        this.done = false;
        this.delta_distance = 0;
        this.mpUsed = 0;
        if (this.assaultDropInProgress == 2) {
            this.assaultDropInProgress = 0;
        }
        this.moved = 0;
        this.gotPavementBonus = false;
        this.hitThisRoundByAntiTSM = false;
        this.hitBySwarmsEntity.clear();
        this.hitBySwarmsWeapon.clear();
        this.setTaggedBy(-1);
        this.setLayingMines(false);
        this.setArmsFlipped(false);
        this.setDisplacementAttack(null);
        this.setFindingClub(false);
        this.setSpotting(false);
        this.spotTargetId = -1;
        this.setClearingMinefield(false);
        this.setUnjammingRAC(false);
        this.crew.setKoThisRound(false);
        this.m_lNarcedBy |= this.m_lPendingNarc;
        if (this.pendingINarcPods.size() > 0) {
            this.iNarcPods.addAll(this.pendingINarcPods);
            this.pendingINarcPods = new Vector();
        }
        if (this.pendingNarcPods.size() > 0) {
            this.narcPods.addAll(this.pendingNarcPods);
            this.pendingNarcPods.clear();
        }
        for (Mounted mounted : this.getEquipment()) {
            mounted.newRound(n);
        }
        this.infernos.newRound(n);
    }

    public void applyDamage() {
        Serializable serializable;
        int n;
        for (Mounted mounted : this.getEquipment()) {
            if (!mounted.isHit() && !mounted.isMissing()) continue;
            mounted.setShotsLeft(0);
            mounted.setDestroyed(true);
        }
        for (n = 0; n < this.locations(); ++n) {
            for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
                serializable = this.getCritical(n, i);
                if (serializable == null) continue;
                ((CriticalSlot)serializable).setDestroyed(((CriticalSlot)serializable).isDamaged());
            }
        }
        for (n = 0; n < this.locations(); ++n) {
            if (this.getInternal(n) != -2) continue;
            this.setArmor(-3, n);
            this.setArmor(-3, n, true);
            this.setInternal(-3, n);
            Iterator<Serializable> iterator = this.narcPods.iterator();
            while (iterator.hasNext()) {
                serializable = iterator.next();
                if (((NarcPod)serializable).getLocation() != n) continue;
                iterator.remove();
            }
            iterator = this.iNarcPods.iterator();
            while (iterator.hasNext()) {
                serializable = (INarcPod)iterator.next();
                if (((INarcPod)serializable).getLocation() != n) continue;
                iterator.remove();
            }
            iterator = this.pendingNarcPods.iterator();
            while (iterator.hasNext()) {
                serializable = (NarcPod)iterator.next();
                if (((NarcPod)serializable).getLocation() != n) continue;
                iterator.remove();
            }
            iterator = this.pendingINarcPods.iterator();
            while (iterator.hasNext()) {
                serializable = (INarcPod)iterator.next();
                if (((INarcPod)serializable).getLocation() != n) continue;
                iterator.remove();
            }
        }
    }

    public void reloadEmptyWeapons() {
        for (Mounted mounted : this.getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.getAmmoType() == -1 || (weaponType.getFlags() & 0x800L) == 2048L || mounted.getLinked() != null && mounted.getLinked().getShotsLeft() > 0 && !mounted.getLinked().isDumping()) continue;
            this.loadWeaponWithSameAmmo(mounted);
        }
    }

    public void assignAMS(Vector<WeaponResult> vector) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Mounted mounted : this.getWeaponList()) {
            if (!mounted.getType().hasFlag(0x1000000L) || !mounted.isReady() || mounted.isMissing()) continue;
            Mounted mounted2 = mounted.getLinked();
            if (!mounted.getType().hasFlag(262144L) && (mounted2 == null || mounted2.getShotsLeft() == 0 || mounted2.isDumping())) {
                this.loadWeapon(mounted);
                mounted2 = mounted.getLinked();
            }
            if (!mounted.getType().hasFlag(262144L) && (mounted2 == null || mounted2.getShotsLeft() == 0 || mounted2.isDumping())) continue;
            Vector<WeaponAttackAction> vector2 = new Vector<WeaponAttackAction>(vector.size());
            for (WeaponResult weaponResult : vector) {
                if (hashSet.contains(weaponResult.waa) || !Compute.isInArc(this.game, this.getId(), this.getEquipmentNum(mounted), this.game.getEntity(weaponResult.waa.getEntityId()))) continue;
                vector2.addElement(weaponResult.waa);
            }
            WeaponAttackAction weaponAttackAction = Compute.getHighestExpectedDamage(this.game, vector2, true);
            if (weaponAttackAction == null) continue;
            weaponAttackAction.addCounterEquipment(mounted);
            hashSet.add(weaponAttackAction);
        }
    }

    public boolean isNarcedBy(int n) {
        for (NarcPod narcPod : this.narcPods) {
            if (narcPod.getTeam() != n) continue;
            return true;
        }
        return false;
    }

    public void attachNarcPod(NarcPod narcPod) {
        this.pendingNarcPods.add(narcPod);
    }

    public void attachINarcPod(INarcPod iNarcPod) {
        this.pendingINarcPods.addElement(iNarcPod);
    }

    public boolean isINarcedBy(int n) {
        Enumeration<INarcPod> enumeration = this.iNarcPods.elements();
        while (enumeration.hasMoreElements()) {
            INarcPod iNarcPod = enumeration.nextElement();
            if (iNarcPod.getTeam() != n || iNarcPod.getType() != 1) continue;
            return true;
        }
        return false;
    }

    public boolean isINarcedWith(long l) {
        Enumeration<INarcPod> enumeration = this.iNarcPods.elements();
        while (enumeration.hasMoreElements()) {
            INarcPod iNarcPod = enumeration.nextElement();
            if ((long)iNarcPod.getType() != l) continue;
            return true;
        }
        return false;
    }

    public void removeAllINarcPods() {
        this.iNarcPods.clear();
    }

    public boolean hasINarcPodsAttached() {
        return this.iNarcPods.size() > 0;
    }

    public Enumeration getINarcPodsAttached() {
        return this.iNarcPods.elements();
    }

    public boolean removeINarcPod(INarcPod iNarcPod) {
        return this.iNarcPods.removeElement(iNarcPod);
    }

    public abstract int calculateBattleValue();

    public int calculateBattleValue(boolean bl, boolean bl2) {
        return this.calculateBattleValue();
    }

    public abstract Vector victoryReport();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Entity entity = (Entity)object;
        return entity.getId() == this.id;
    }

    public int getMovementMode() {
        return this.movementMode;
    }

    public String getMovementModeAsString() {
        switch (this.getMovementMode()) {
            case 0: {
                return "None";
            }
            case 1: 
            case 13: {
                return "Biped";
            }
            case 2: 
            case 14: {
                return "Quad";
            }
            case 3: {
                return "Tracked";
            }
            case 4: {
                return "Wheeled";
            }
            case 5: {
                return "Hover";
            }
            case 6: {
                return "VTOL";
            }
            case 7: {
                return "Naval";
            }
            case 8: {
                return "Hydrofoil";
            }
            case 9: 
            case 18: {
                return "Submarine";
            }
            case 10: {
                return "Leg";
            }
            case 11: {
                return "Motorized";
            }
            case 12: {
                return "Jump";
            }
        }
        return "ERROR";
    }

    public void setMovementMode(int n) {
        this.movementMode = n;
    }

    public boolean entityIsBiped() {
        return this.getMovementMode() == 1;
    }

    public boolean entityIsQuad() {
        return this.getMovementMode() == 2;
    }

    public boolean needsRollToStand() {
        return true;
    }

    public PilotingRollData getBasePilotingRoll() {
        int n = this.getId();
        if (this.getCrew().isDead() || this.getCrew().isDoomed() || this.getCrew().getHits() >= 6) {
            return new PilotingRollData(n, 0x7FFFFFFE, "Pilot dead");
        }
        if (!this.getCrew().isActive()) {
            return new PilotingRollData(n, Integer.MAX_VALUE, "Pilot unconscious");
        }
        if (this.getBadCriticals(0, 4, 1) > 1 && this.getGyroType() != 3) {
            return new PilotingRollData(n, 0x7FFFFFFE, 3, "Gyro destroyed");
        }
        if (this.getBadCriticals(0, 4, 1) > 2 && this.getGyroType() == 3) {
            return new PilotingRollData(n, 0x7FFFFFFE, 3, "Gyro destroyed");
        }
        if (this instanceof BipedMech) {
            if (((BipedMech)this).countBadLegs() == 2) {
                return new PilotingRollData(n, 0x7FFFFFFE, 10, "Both legs destroyed");
            }
        } else if (this instanceof QuadMech && ((QuadMech)this).countBadLegs() >= 3) {
            return new PilotingRollData(n, 0x7FFFFFFE, 10, ((Mech)this).countBadLegs() + " legs destroyed");
        }
        if (this.isShutDown()) {
            return new PilotingRollData(n, 0x7FFFFFFE, 3, "Reactor shut down");
        }
        PilotingRollData pilotingRollData = new PilotingRollData(n, this.getCrew().getPiloting(), "Base piloting skill");
        pilotingRollData = this.addEntityBonuses(pilotingRollData);
        return pilotingRollData;
    }

    public abstract PilotingRollData addEntityBonuses(PilotingRollData var1);

    public PilotingRollData checkGetUp(MoveStep moveStep) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        if (moveStep == null || moveStep.getType() != 5) {
            pilotingRollData.addModifier(-2147483647, "Check false: Entity is not attempting to get up.");
            return pilotingRollData;
        }
        if (this.isHullDown()) {
            pilotingRollData.addModifier(Integer.MIN_VALUE, "getting up from hull down");
            return pilotingRollData;
        }
        if (!this.needsRollToStand() && this.getBadCriticals(0, 4, 1) < 2) {
            pilotingRollData.addModifier(Integer.MIN_VALUE, "\n" + this.getDisplayName() + " does not need to make a piloting skill check to stand up because it has all four of its legs.");
            return pilotingRollData;
        }
        pilotingRollData.append(new PilotingRollData(this.getId(), 0, "getting up"));
        this.addPilotingModifierForTerrain(pilotingRollData, moveStep);
        return pilotingRollData;
    }

    public PilotingRollData checkRunningWithDamage(int n) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        int n2 = this.getBadCriticals(0, 4, 1);
        if (this.getGyroType() == 3) {
            --n2;
        }
        if (n == 2 && !this.isProne() && (n2 > 0 || this.hasHipCrit())) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "running with damaged hip actuator or gyro"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: Entity is not attempting to run with damage");
        }
        this.addPilotingModifierForTerrain(pilotingRollData);
        return pilotingRollData;
    }

    public PilotingRollData checkLandingWithDamage() {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        if (this.getBadCriticals(0, 4, 1) > 0 && this.getGyroType() != 3 || this.getBadCriticals(0, 4, 1) > 1 && this.getGyroType() == 3 || this.hasLegActuatorCrit()) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "landing with damaged leg actuator or gyro"));
            this.addPilotingModifierForTerrain(pilotingRollData);
        } else {
            pilotingRollData.addModifier(-2147483647, "Entity does not have gyro or leg accutator damage -- checking for purposes of determining PSR after jump.");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkMovedTooFast(MoveStep moveStep) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        this.addPilotingModifierForTerrain(pilotingRollData, moveStep);
        switch (moveStep.getMovementType()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                if (moveStep.getMpUsed() > (int)Math.ceil((double)this.getOriginalWalkMP() * 1.5)) {
                    pilotingRollData.append(new PilotingRollData(this.getId(), 0, "used more MPs than at 1G possible"));
                    break;
                }
                pilotingRollData.addModifier(-2147483647, "Check false: Entity did not use more MPs walking/running than possible at 1G");
                break;
            }
            case 3: {
                if (moveStep.getMpUsed() > this.getOriginalJumpMP()) {
                    pilotingRollData.append(new PilotingRollData(this.getId(), 0, "used more MPs than at 1G possible"));
                    break;
                }
                pilotingRollData.addModifier(-2147483647, "Check false: Entity did not use more MPs jumping than possible at 1G");
            }
        }
        return pilotingRollData;
    }

    public PilotingRollData checkSkid(int n, IHex iHex, int n2, MoveStep moveStep, int n3, int n4, Coords coords, Coords coords2, boolean bl, int n5) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        this.addPilotingModifierForTerrain(pilotingRollData, coords);
        if (n != 3 && this.movementMode != 5 && this.movementMode != 15 && iHex != null && (moveStep.isPavementStep() && n2 == 2 || iHex.containsTerrain(20)) && n3 != n4 && !coords.equals(coords2) && !bl && !moveStep.isHasJustStood()) {
            if (moveStep.isPavementStep()) {
                if (this instanceof Mech) {
                    pilotingRollData.append(new PilotingRollData(this.getId(), this.getMovementBeforeSkidPSRModifier(n5), "running & turning on pavement"));
                } else {
                    pilotingRollData.append(new PilotingRollData(this.getId(), this.getMovementBeforeSkidPSRModifier(n5), "reckless driving on pavement"));
                }
            } else {
                pilotingRollData.append(new PilotingRollData(this.getId(), this.getMovementBeforeSkidPSRModifier(n5), "turning on ice"));
            }
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: Entity is not apparently skidding");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkRubbleMove(MoveStep moveStep, IHex iHex, Coords coords, Coords coords2) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        this.addPilotingModifierForTerrain(pilotingRollData, coords2);
        if (!coords.equals(coords2) && moveStep.getMovementType() != 3 && iHex.terrainLevel(3) > 0 && this instanceof Mech) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "entering Rubble"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: Entity is not entering rubble");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkSwampMove(MoveStep moveStep, IHex iHex, Coords coords, Coords coords2, boolean bl) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        if (!coords.equals(coords2) && moveStep.getMovementType() != 3 && this.getMovementMode() != 5 && this.getMovementMode() != 6 && moveStep.getElevation() == 0 && !bl) {
            if (iHex.containsTerrain(9)) {
                pilotingRollData.append(new PilotingRollData(this.getId(), 0, "entering Swamp"));
            } else if (iHex.terrainLevel(24) == 2) {
                pilotingRollData.append(new PilotingRollData(this.getId(), 0, "entering Liquid Magma"));
            } else if (iHex.containsTerrain(24) || iHex.containsTerrain(25) || iHex.containsTerrain(28) || iHex.containsTerrain(29)) {
                pilotingRollData.append(new PilotingRollData(this.getId(), -1, "avoid bogging down"));
            } else {
                pilotingRollData.addModifier(-2147483647, "Check false: no swamp-like terrain present");
            }
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: Not entering swamp, or jumping/hovering over the swamp");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkWaterMove(MoveStep moveStep, IHex iHex, Coords coords, Coords coords2, boolean bl) {
        if (iHex.terrainLevel(4) > 0 && moveStep.getElevation() < 0 && !coords.equals(coords2) && moveStep.getMovementType() != 3 && this.getMovementMode() != 5 && this.getMovementMode() != 6 && this.getMovementMode() != 7 && this.getMovementMode() != 8 && this.getMovementMode() != 9 && this.getMovementMode() != 18 && this.getMovementMode() != 13 && this.getMovementMode() != 14 && !bl) {
            return this.checkWaterMove(iHex.terrainLevel(4));
        }
        return this.checkWaterMove(0);
    }

    public PilotingRollData checkWaterMove(int n) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        int n2 = n == 1 ? -1 : (n == 2 ? 0 : 1);
        if (n > 0 && !this.hasUMU()) {
            pilotingRollData.append(new PilotingRollData(this.getId(), n2, "entering Depth " + n + " Water"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: No water here.");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkDislodgeSwarmers(MoveStep moveStep) {
        if (-1 == this.getSwarmAttackerId()) {
            return new PilotingRollData(this.getId(), -2147483647, "Check false: No swarmers attached");
        }
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        pilotingRollData.append(new PilotingRollData(this.getId(), 0, "attempting to dislodge swarmers by dropping prone"));
        this.addPilotingModifierForTerrain(pilotingRollData, moveStep);
        return pilotingRollData;
    }

    public int checkMovementInBuilding(MoveStep moveStep, MoveStep moveStep2, Coords coords, Coords coords2) {
        if (coords2.equals(coords)) {
            return 0;
        }
        IHex iHex = this.game.getBoard().getHex(coords);
        IHex iHex2 = this.game.getBoard().getHex(coords2);
        if (this instanceof Infantry || this instanceof Protomech) {
            return 0;
        }
        int n = 0;
        if (moveStep.getElevation() < iHex.terrainLevel(12)) {
            n += 2;
        } else if ((moveStep.getElevation() == iHex.terrainLevel(12) || moveStep.getElevation() == iHex.terrainLevel(16)) && moveStep.getMovementType() != 3) {
            n += 4;
        }
        if (iHex2 != null) {
            int n2 = this.getElevation();
            if (moveStep2 != null) {
                n2 = moveStep2.getElevation();
            }
            if (n2 < iHex2.terrainLevel(12)) {
                ++n;
            }
        }
        if (n > 1) {
            Building building = null;
            building = this.game.getBoard().getBuildingAt(coords);
            if (building.getType() == 5) {
                return 4;
            }
        }
        return n;
    }

    public PilotingRollData rollMovementInBuilding(Building building, int n, String string) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        int n2 = 0;
        String string2 = string == "" ? "moving through " : string + " ";
        switch (building.getType()) {
            case 1: {
                string2 = "Light";
                break;
            }
            case 2: {
                n2 = 1;
                string2 = "Medium";
                break;
            }
            case 3: {
                n2 = 2;
                string2 = "Heavy";
                break;
            }
            case 4: {
                n2 = 5;
                string2 = "Hardened";
                break;
            }
            case 5: {
                n2 = 12;
                string2 = "Wall";
            }
        }
        pilotingRollData.append(new PilotingRollData(this.getId(), n2, "moving through " + string2 + " " + building.getName()));
        if (n >= 25) {
            pilotingRollData.addModifier(6, "moved 25+ hexes");
        } else if (n >= 18) {
            pilotingRollData.addModifier(5, "moved 18-24 hexes");
        } else if (n >= 10) {
            pilotingRollData.addModifier(4, "moved 10+ hexes");
        } else if (n >= 7) {
            pilotingRollData.addModifier(3, "moved 7-9 hexes");
        } else if (n >= 5) {
            pilotingRollData.addModifier(2, "moved 5-6 hexes");
        } else if (n >= 3) {
            pilotingRollData.addModifier(1, "moved 3-4 hexes");
        }
        return pilotingRollData;
    }

    public int getMovementBeforeSkidPSRModifier(int n) {
        int n2 = -1;
        n2 = n > 24 ? 6 : (n > 17 ? 5 : (n > 10 ? 4 : (n > 7 ? 2 : (n > 4 ? 1 : (n > 2 ? 0 : -1)))));
        if (this.getCrew().getOptions().booleanOption("maneuvering_ace")) {
            --n2;
        }
        return n2;
    }

    public abstract int getMaxElevationChange();

    public static String encodeTransporters(Entity entity) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<Transporter> enumeration = entity.transports.elements();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(',');
            }
            Transporter transporter = enumeration.nextElement();
            stringBuffer.append(transporter.getClass().getName());
            if (!(transporter instanceof TroopSpace)) continue;
            stringBuffer.append("=").append(((TroopSpace)transporter).totalSpace);
        }
        return stringBuffer.toString();
    }

    public static void decodeTransporters(Entity entity, String string) throws IllegalStateException {
        Enumeration<String> enumeration = StringUtil.splitString(string, ",").elements();
        while (enumeration.hasMoreElements()) {
            try {
                String string2 = enumeration.nextElement();
                Class<?> clazz = Class.forName(string2);
                TroopSpace troopSpace = null;
                if (TroopSpace.class.getName().equals(string2)) {
                    int n = Integer.parseInt(string2.substring(string2.lastIndexOf("=")));
                    troopSpace = new TroopSpace(n);
                } else {
                    troopSpace = (TroopSpace)clazz.newInstance();
                }
                entity.addTransporter(troopSpace);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IllegalStateException(exception.getMessage());
            }
        }
    }

    public void addTransporter(Transporter transporter) {
        this.transports.insertElementAt(transporter, 0);
    }

    public void removeAllTransporters() {
        this.transports = new Vector();
    }

    @Override
    public boolean canLoad(Entity entity) {
        if (this instanceof Infantry) {
            return false;
        }
        if (!entity.isEnemyOf(this)) {
            Enumeration<Transporter> enumeration = this.transports.elements();
            while (enumeration.hasMoreElements()) {
                Transporter transporter = enumeration.nextElement();
                if (!transporter.canLoad(entity) || entity.getElevation() != this.getElevation()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void load(Entity entity) {
        Enumeration<Transporter> enumeration = this.transports.elements();
        while (enumeration.hasMoreElements()) {
            Transporter transporter = enumeration.nextElement();
            if (!transporter.canLoad(entity) || entity.getElevation() != this.getElevation()) continue;
            transporter.load(entity);
            return;
        }
        throw new IllegalArgumentException(this.getShortName() + " can not load " + entity.getShortName());
    }

    public void pickUp(MechWarrior mechWarrior) {
        this.pickedUpMechWarriors.addElement(new Integer(mechWarrior.getId()));
    }

    @Override
    public Vector<Entity> getLoadedUnits() {
        Vector<Entity> vector = new Vector<Entity>();
        for (Transporter transporter : this.transports) {
            for (Entity entity : transporter.getLoadedUnits()) {
                vector.addElement(entity);
            }
        }
        return vector;
    }

    @Override
    public boolean unload(Entity entity) {
        Enumeration<Transporter> enumeration = this.transports.elements();
        while (enumeration.hasMoreElements()) {
            Transporter transporter = enumeration.nextElement();
            if (!transporter.unload(entity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getUnusedString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<Transporter> enumeration = this.transports.elements();
        while (enumeration.hasMoreElements()) {
            Transporter transporter = enumeration.nextElement();
            stringBuffer.append(transporter.getUnusedString());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isWeaponBlockedAt(int n, boolean bl) {
        for (Transporter transporter : this.transports) {
            if (!transporter.isWeaponBlockedAt(n, bl)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Entity getExteriorUnitAt(int n, boolean bl) {
        for (Transporter transporter : this.transports) {
            Entity entity = transporter.getExteriorUnitAt(n, bl);
            if (null == entity) continue;
            return entity;
        }
        return null;
    }

    public ArrayList<Entity> getExternalUnits() {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        for (Transporter transporter : this.transports) {
            arrayList.addAll(transporter.getExternalUnits());
        }
        return arrayList;
    }

    @Override
    public int getCargoMpReduction() {
        int n = 0;
        for (Transporter transporter : this.transports) {
            n += transporter.getCargoMpReduction();
        }
        return n;
    }

    public HitData getTrooperAtLocation(HitData hitData, Entity entity) {
        return this.rollHitLocation(0, 0);
    }

    public void setTransportId(int n) {
        this.conveyance = n;
        if (n == -1) {
            this.unloadedThisTurn = true;
            this.done = true;
        }
    }

    public int getTransportId() {
        return this.conveyance;
    }

    public boolean isStealthActive() {
        return false;
    }

    public TargetRoll getStealthModifier(int n, Entity entity) {
        TargetRoll targetRoll = null;
        if (!this.isStealthActive()) {
            targetRoll = new TargetRoll(0, "stealth not active");
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                targetRoll = new TargetRoll(0, "stealth not installed");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown range constant: " + n);
            }
        }
        return targetRoll;
    }

    public void setSwarmTargetId(int n) {
        this.swarmTargetId = n;
        if (n == -1) {
            this.unloadedThisTurn = true;
            this.done = true;
        }
    }

    public int getSwarmTargetId() {
        return this.swarmTargetId;
    }

    public void setSwarmAttackerId(int n) {
        this.swarmAttackerId = n;
    }

    public int getSwarmAttackerId() {
        return this.swarmAttackerId;
    }

    public boolean hasInfernoAmmo() {
        boolean bl = false;
        for (Mounted mounted : this.getAmmo()) {
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (ammoType.getAmmoType() != 9 && ammoType.getAmmoType() != 50 && ammoType.getAmmoType() != 25 || ammoType.getMunitionType() != 0x400000L || mounted.getShotsLeft() <= 0) continue;
            bl = true;
        }
        return bl;
    }

    public void setSalvage(boolean bl) {
        if (!bl) {
            this.setRemovalCondition(1024);
        }
        this.salvageable = bl;
    }

    public boolean isSalvage() {
        return this.salvageable;
    }

    public boolean isRepairable() {
        return this.isSalvage();
    }

    public int getRemovalCondition() {
        return this.removalCondition;
    }

    public void setRemovalCondition(int n) {
        if (this.removalCondition < n) {
            this.removalCondition = n;
        }
    }

    public boolean isClearingMinefield() {
        return this.clearingMinefield;
    }

    public void setClearingMinefield(boolean bl) {
        this.clearingMinefield = bl;
    }

    public boolean isSpotting() {
        return this.spotting;
    }

    public void setSpotting(boolean bl) {
        this.spotting = bl;
    }

    public boolean canSpot() {
        if (this.game.getOptions().booleanOption("pilots_cannot_spot") && this instanceof MechWarrior) {
            return false;
        }
        return this.isActive() && !this.isOffBoard();
    }

    public String toString() {
        return "Entity [" + this.getDisplayName() + ", " + this.getId() + "]";
    }

    public void setDeployRound(int n) {
        this.deployRound = n;
    }

    public int getDeployRound() {
        return this.deployRound;
    }

    public void setDeployed(boolean bl) {
        this.deployed = bl;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public boolean shouldDeploy(int n) {
        return !this.deployed && this.getDeployRound() <= n && !this.isOffBoard();
    }

    public void setUnitNumber(char c) {
        this.unitNumber = c;
    }

    public char getUnitNumber() {
        return this.unitNumber;
    }

    public boolean canFlee() {
        Coords coords = this.getPosition();
        return coords != null && this.getWalkMP() > 0 && !this.isProne() && !this.isStuck() && !this.isShutDown() && !this.getCrew().isUnconscious() && (coords.x == 0 || coords.x == this.game.getBoard().getWidth() - 1 || coords.y == 0 || coords.y == this.game.getBoard().getHeight() - 1);
    }

    public void setSeenByEnemy(boolean bl) {
        this.seenByEnemy = bl;
    }

    public boolean isSeenByEnemy() {
        return this.seenByEnemy;
    }

    public void setVisibleToEnemy(boolean bl) {
        this.visibleToEnemy = bl;
    }

    public boolean isVisibleToEnemy() {
        return this.visibleToEnemy;
    }

    protected int applyGravityEffectsOnMP(int n) {
        int n2 = n;
        if (this.game != null) {
            float f = (float)n / this.game.getOptions().floatOption("gravity");
            f = (double)Math.abs((float)Math.round(f) - f) == 0.5 ? (float)Math.floor(f) : (float)Math.round(f);
            n2 = (int)f;
        }
        return n2;
    }

    public boolean canCharge() {
        return !this.isImmobile() && this.getWalkMP() > 0 && !this.isStuck() && !this.isProne();
    }

    public boolean canDFA() {
        return !this.isImmobile() && this.getJumpMP() > 0 && !this.isStuck() && !this.isProne();
    }

    boolean isUsingManAce() {
        return this.getCrew().getOptions().booleanOption("maneuvering_ace");
    }

    public Enumeration<Entity> getKills() {
        final int n = this.id;
        return this.game.getSelectedOutOfGameEntities(new EntitySelector(){
            private final int killerId;
            {
                this.killerId = n;
            }

            public boolean accept(Entity entity) {
                return this.killerId == entity.killerId;
            }
        });
    }

    public int getKillNumber() {
        final int n = this.id;
        return this.game.getSelectedOutOfGameEntityCount(new EntitySelector(){
            private final int killerId;
            {
                this.killerId = n;
            }

            public boolean accept(Entity entity) {
                return this.killerId == entity.killerId;
            }
        });
    }

    public void addKill(Entity entity) {
        entity.killerId = this.id;
    }

    public boolean getGaveKillCredit() {
        return this.killerId != -1;
    }

    public boolean isEligibleFor(int n) {
        if (n == 4 == this.isDeployed()) {
            return false;
        }
        if (this.isCarcass()) {
            return false;
        }
        switch (n) {
            case 8: {
                return this.isEligibleForMovement();
            }
            case 12: {
                return this.isEligibleForFiring();
            }
            case 14: {
                return this.isEligibleForPhysical();
            }
            case 7: {
                return this.isEligibleForTargetingPhase();
            }
            case 10: {
                return this.isEligibleForOffboard();
            }
        }
        return true;
    }

    public boolean canAssist(int n) {
        if (n != 14 && n != 12 && n != 10) {
            return false;
        }
        if (this.isUnjammingRAC() || this.isCharging() || this.isMakingDfa() || this.isFindingClub() || this.isOffBoard()) {
            return false;
        }
        if (!this.isActive()) {
            return false;
        }
        return this.isUsingSpotlight();
    }

    public boolean isEligibleForFiring() {
        if (this.isUnjammingRAC() || this.isCharging() || this.isMakingDfa()) {
            return false;
        }
        if (this.isOffBoard() || this.isAssaultDropInProgress()) {
            return false;
        }
        if (!this.game.getOptions().booleanOption("skip_ineligable_firing")) {
            return true;
        }
        return this.isActive();
    }

    public boolean isEligibleForMovement() {
        if (this.isOffBoard() || this.isAssaultDropInProgress()) {
            return false;
        }
        if (!this.game.getOptions().booleanOption("skip_ineligable_movement")) {
            return true;
        }
        return this.isActive() && !this.isImmobile();
    }

    public boolean isEligibleForOffboard() {
        if (this.isUnjammingRAC() || this.isCharging() || this.isMakingDfa()) {
            return false;
        }
        if (this.isOffBoard() || this.isAssaultDropInProgress()) {
            return false;
        }
        for (Mounted mounted : this.getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (!weaponType.hasFlag(0x8000000L) || !mounted.isReady()) continue;
            return true;
        }
        return false;
    }

    public boolean isAttackingThisTurn() {
        Vector<EntityAction> vector = this.game.getActionsVector();
        Enumeration<EntityAction> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityAction entityAction = enumeration.nextElement();
            if (entityAction.getEntityId() != this.getId() || !(entityAction instanceof AbstractAttackAction)) continue;
            return true;
        }
        return false;
    }

    public boolean isEligibleForPhysical() {
        Object object;
        boolean bl = false;
        boolean bl2 = this.game.getOptions().booleanOption("friendly_fire");
        if (!(this instanceof Mech || this instanceof Protomech || this instanceof Infantry)) {
            return false;
        }
        if (this.isUnjammingRAC() || this.isCharging() || this.isMakingDfa() || this.isFindingClub() || this.isOffBoard() || this.isAssaultDropInProgress()) {
            return false;
        }
        if (this.game.getOptions().booleanOption("no_clan_physical") && this.isClan() && !this.hasINarcPodsAttached() && this.getSwarmAttackerId() == -1) {
            return false;
        }
        if (this.hasVibroblades()) {
            return true;
        }
        if (!this.game.getOptions().booleanOption("skip_ineligable_physical")) {
            return true;
        }
        if (!this.isActive()) {
            return false;
        }
        if (this.getPosition() == null) {
            return false;
        }
        if (this.hasINarcPodsAttached() && this instanceof Mech) {
            return true;
        }
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (!bl && enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!this.isEnemyOf((Entity)object) && (!bl2 || this.getId() == ((Entity)object).getId()) || ((Entity)object).getPosition() == null || this.getPosition().distance(((Entity)object).getPosition()) > 1) continue;
            bl |= Compute.canPhysicalTarget(this.game, this.getId(), (Targetable)object);
            bl |= this instanceof Mech && !this.isProne() && this.getCrew().getOptions().booleanOption("dodge_maneuver") && Compute.canPhysicalTarget(this.game, ((Entity)object).getId(), this);
        }
        object = this.game.getBoard().getBuildings();
        while (!bl && object.hasMoreElements()) {
            Building building = (Building)object.nextElement();
            Enumeration<Coords> enumeration2 = building.getCoords();
            while (!bl && enumeration2.hasMoreElements()) {
                Coords coords = enumeration2.nextElement();
                if (this.getPosition().distance(coords) > 1) continue;
                BuildingTarget buildingTarget = new BuildingTarget(coords, this.game.getBoard(), false);
                bl |= Compute.canPhysicalTarget(this.game, this.getId(), buildingTarget);
            }
        }
        return bl;
    }

    public boolean isEligibleForTargetingPhase() {
        if (this.isAssaultDropInProgress()) {
            return false;
        }
        for (Mounted mounted : this.getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType == null || !weaponType.hasFlag(65536L)) continue;
            return true;
        }
        return false;
    }

    public int getTroopCarryingSpace() {
        int n = 0;
        Enumeration<Transporter> enumeration = this.transports.elements();
        while (enumeration.hasMoreElements()) {
            Transporter transporter = enumeration.nextElement();
            if (!(transporter instanceof TroopSpace)) continue;
            n = (int)((double)n + ((TroopSpace)transporter).totalSpace);
        }
        return n;
    }

    public boolean hasBattleArmorHandles() {
        Enumeration<Transporter> enumeration = this.transports.elements();
        while (enumeration.hasMoreElements()) {
            Transporter transporter = enumeration.nextElement();
            if (!(transporter instanceof BattleArmorHandles)) continue;
            return true;
        }
        return false;
    }

    public boolean isOffBoard() {
        return this.offBoardDistance > 0;
    }

    public void setOffBoard(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("negative number given for distance offboard");
        }
        if (n2 < -1 || n2 > 3) {
            throw new IllegalArgumentException("bad direction");
        }
        if (0 == n && -1 != n2) {
            throw new IllegalArgumentException("onboard unit was given an offboard direction");
        }
        if (0 != n && -1 == n2) {
            throw new IllegalArgumentException("offboard unit was not given an offboard direction");
        }
        this.offBoardDistance = n;
        this.offBoardDirection = n2;
    }

    public int getOffBoardDistance() {
        return this.offBoardDistance;
    }

    public int getOffBoardDirection() {
        return this.offBoardDirection;
    }

    public void deployOffBoard() {
        if (null == this.game) {
            throw new IllegalStateException("game not set; possible serialization error");
        }
        switch (this.offBoardDirection) {
            case -1: {
                break;
            }
            case 0: {
                this.setPosition(new Coords(this.game.getBoard().getWidth() / 2 + this.game.getBoard().getWidth() % 2, -this.getOffBoardDistance()));
                this.setFacing(3);
                this.setDeployed(true);
                break;
            }
            case 1: {
                this.setPosition(new Coords(this.game.getBoard().getWidth() / 2 + this.game.getBoard().getWidth() % 2, this.game.getBoard().getHeight() + this.getOffBoardDistance()));
                this.setFacing(0);
                this.setDeployed(true);
                break;
            }
            case 2: {
                this.setPosition(new Coords(this.game.getBoard().getWidth() + this.getOffBoardDistance(), this.game.getBoard().getHeight() / 2 + this.game.getBoard().getHeight() % 2));
                this.setFacing(5);
                this.setDeployed(true);
                break;
            }
            case 3: {
                this.setPosition(new Coords(-this.getOffBoardDistance(), this.game.getBoard().getHeight() / 2 + this.game.getBoard().getHeight() % 2));
                this.setFacing(1);
                this.setDeployed(true);
            }
        }
    }

    public Vector getPickedUpMechWarriors() {
        return this.pickedUpMechWarriors;
    }

    public boolean isCaptured() {
        return this.captured && !this.isDestroyed();
    }

    public void setCaptured(boolean bl) {
        this.captured = bl;
    }

    public void setSpotlight(boolean bl) {
        this.hasSpotlight = bl;
    }

    public boolean hasSpotlight() {
        return this.hasSpotlight;
    }

    public void setSpotlightState(boolean bl) {
        if (this.hasSpotlight) {
            this.spotlightIsActive = bl;
            if (bl) {
                this.illuminated = true;
            }
        }
    }

    public boolean isIlluminated() {
        return this.illuminated;
    }

    public void setIlluminated(boolean bl) {
        this.illuminated = bl;
    }

    public boolean isUsingSpotlight() {
        return this.hasSpotlight && this.spotlightIsActive;
    }

    public void setUsedSearchlight(boolean bl) {
        this.usedSearchlight = bl;
    }

    public boolean usedSearchlight() {
        return this.usedSearchlight;
    }

    public void illuminateTarget(HexTarget hexTarget) {
        if (this.hasSpotlight && this.spotlightIsActive && hexTarget != null) {
            this.illuminated = true;
            ArrayList<Coords> arrayList = Coords.intervening(this.getPosition(), hexTarget.getPosition());
            for (Coords coords : arrayList) {
                Enumeration<Entity> enumeration = this.game.getEntities(coords);
                while (enumeration.hasMoreElements()) {
                    Entity entity = enumeration.nextElement();
                    entity.setIlluminated(true);
                }
            }
        }
    }

    public boolean isStuck() {
        return this.stuckInSwamp;
    }

    public void setStuck(boolean bl) {
        this.stuckInSwamp = bl;
    }

    public boolean canUnstickByJumping() {
        return this.canUnstickByJumping;
    }

    public void setCanUnstickByJumping(boolean bl) {
        this.canUnstickByJumping = bl;
    }

    public String destroy(String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 512;
        if (!bl2) {
            this.setSalvage(bl2);
            n = 1024;
        }
        if (this.isDoomed() || this.isDestroyed()) {
            return stringBuffer.toString();
        }
        this.setDoomed(true);
        Enumeration enumeration = this.getPickedUpMechWarriors().elements();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            Entity entity = this.game.getEntity(n2);
            entity.setDestroyed(true);
            this.game.removeEntity(entity.getId(), n);
            stringBuffer.append("\n*** ").append(entity.getDisplayName() + " died in the wreckage. ***\n");
        }
        return stringBuffer.toString();
    }

    public void addTargetedBySwarm(int n, int n2) {
        this.hitBySwarmsEntity.addElement(new Integer(n));
        this.hitBySwarmsWeapon.addElement(new Integer(n2));
    }

    public boolean getTargetedBySwarm(int n, int n2) {
        for (int i = 0; i < this.hitBySwarmsEntity.size(); ++i) {
            Integer n3 = this.hitBySwarmsEntity.elementAt(i);
            Integer n4 = this.hitBySwarmsWeapon.elementAt(i);
            if (n != n3 || n2 != n4) continue;
            return true;
        }
        return false;
    }

    public int getShortRangeModifier() {
        if (this.getTargSysType() == 3) {
            return -1;
        }
        if (this.getTargSysType() == 2) {
            return 1;
        }
        return 0;
    }

    public int getMediumRangeModifier() {
        return 2;
    }

    public int getLongRangeModifier() {
        if (this.getTargSysType() == 3) {
            return 5;
        }
        if (this.getTargSysType() == 2) {
            return 3;
        }
        return 4;
    }

    public int getExtremeRangeModifier() {
        return 8;
    }

    public int getTargSysType() {
        return this.targSys;
    }

    public void setTargSysType(int n) {
        this.targSys = n;
    }

    public void setArmorType(int n) {
        this.armorType = n;
    }

    public void setStructureType(int n) {
        this.structureType = n;
    }

    public void setArmorType(String string) {
        this.setArmorType(EquipmentType.getArmorType(string));
    }

    public void setStructureType(String string) {
        this.setStructureType(EquipmentType.getStructureType(string));
    }

    public int getArmorType() {
        return this.armorType;
    }

    public void setArmorTechLevel(int n) {
        this.armorTechLevel = n;
    }

    public int getArmorTechLevel() {
        return this.armorTechLevel;
    }

    public int getStructureType() {
        return this.structureType;
    }

    public void setWeaponDestroyed(Mounted mounted) {
        if (this.weaponList.contains(mounted)) {
            mounted.setDestroyed(true);
        }
    }

    public void setTaggedBy(int n) {
        this.taggedBy = n;
    }

    public int getTaggedBy() {
        return this.taggedBy;
    }

    public abstract double getCost();

    public int getWeaponsAndEquipmentCost() {
        int n = 0;
        for (Mounted mounted : this.getEquipment()) {
            int n2 = (int)mounted.getType().getCost();
            if (n2 == Integer.MIN_VALUE) {
                n2 = mounted.getType().resolveVariableCost(this);
            }
            n += n2;
        }
        return n;
    }

    public boolean removePartialCoverHits(int n, int n2, int n3) {
        return false;
    }

    public boolean isOnSameSheet(Coords coords) {
        if (this.game.getOptions().booleanOption("a4homing_target_area")) {
            return coords.distance(this.getPosition()) <= 8;
        }
        return coords.x / 16 == this.getPosition().x / 16 && coords.y / 17 == this.getPosition().y / 17;
    }

    public abstract boolean doomedInVacuum();

    public double getArmorWeight() {
        double d = 16.0 * EquipmentType.getArmorPointMultiplier(this.armorType, this.techLevel);
        double d2 = 0.0;
        while ((int)Math.round(d2 * d) < this.getTotalOArmor()) {
            d2 += 0.5;
        }
        return d2;
    }

    public boolean hasTAG() {
        for (Mounted mounted : this.getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType == null || !weaponType.hasFlag(0x8000000L)) continue;
            return true;
        }
        return false;
    }

    public boolean isCanon() {
        return this.canon;
    }

    public void setCanon(boolean bl) {
        this.canon = bl;
    }

    public boolean climbMode() {
        return this.climbMode;
    }

    public void setClimbMode(boolean bl) {
        this.climbMode = bl;
    }

    public boolean usedTag() {
        for (Mounted mounted : this.getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (!mounted.isUsedThisRound() || !weaponType.hasFlag(0x8000000L)) continue;
            return true;
        }
        return false;
    }

    public boolean hasEiCockpit() {
        return this.game != null && this.game.getOptions().booleanOption("all_have_ei_cockpit");
    }

    public boolean hasActiveEiCockpit() {
        return this.hasEiCockpit() && this.getCrew().getOptions().booleanOption("ei_implant");
    }

    public boolean isLayingMines() {
        return this.layingMines;
    }

    public void setLayingMines(boolean bl) {
        this.layingMines = bl;
    }

    public boolean canLayMine() {
        Iterator<Mounted> iterator = this.miscList.iterator();
        while (iterator.hasNext()) {
            Mounted mounted;
            Mounted mounted2 = mounted = iterator.next();
            EquipmentType equipmentType = mounted2.getType();
            if (mounted2.isMissing() || !equipmentType.hasFlag(524288L) || this.isLayingMines()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int sideTable(Coords coords) {
        boolean bl;
        if (coords.equals(this.position)) {
            return 0;
        }
        int n = (this.position.degree(coords) + (6 - this.facing) * 60) % 360;
        boolean bl2 = bl = this instanceof Tank || this.game.getOptions().booleanOption("quad_hit_location") && this instanceof QuadMech;
        if (bl) {
            if (n > 30 && n <= 150) {
                return 3;
            }
            if (n > 150 && n < 210) {
                return 1;
            }
            if (n >= 210 && n < 330) {
                return 2;
            }
            return 0;
        }
        if (n > 90 && n <= 150) {
            return 3;
        }
        if (n > 150 && n < 210) {
            return 1;
        }
        if (n >= 210 && n < 270) {
            return 2;
        }
        return 0;
    }

    public boolean canGoHullDown() {
        return false;
    }

    public boolean canAssaultDrop() {
        return false;
    }

    public void setAssaultDropInProgress(boolean bl) {
        this.assaultDropInProgress = bl ? 1 : 0;
    }

    public void setLandedAssaultDrop() {
        this.assaultDropInProgress = 2;
        this.moved = 3;
    }

    public boolean isAssaultDropInProgress() {
        return this.assaultDropInProgress != 0;
    }

    public void addPilotingModifierForTerrain(PilotingRollData pilotingRollData, Coords coords) {
        if (coords == null || pilotingRollData == null) {
            return;
        }
        if (this.isOffBoard() || !this.isDeployed()) {
            return;
        }
        IHex iHex = this.game.getBoard().getHex(coords);
        int n = iHex.terrainPilotingModifier();
        if (n != 0) {
            pilotingRollData.addModifier(n, "difficult terrain");
        }
    }

    public void addPilotingModifierForTerrain(PilotingRollData pilotingRollData, MoveStep moveStep) {
        if (moveStep.getElevation() > 0) {
            return;
        }
        this.addPilotingModifierForTerrain(pilotingRollData, moveStep.getPosition());
    }

    public void addPilotingModifierForTerrain(PilotingRollData pilotingRollData) {
        if (this.getElevation() > 0) {
            return;
        }
        this.addPilotingModifierForTerrain(pilotingRollData, this.getPosition());
    }

    public boolean fixElevation() {
        if (!this.isDeployed() || this.isOffBoard() || !this.game.getBoard().contains(this.getPosition())) {
            return false;
        }
        if (!this.isElevationValid(this.getElevation(), this.game.getBoard().getHex(this.getPosition()))) {
            System.err.println(this.getDisplayName() + " in hex " + HexTarget.coordsToId(this.getPosition()) + " is at invalid elevation: " + this.getElevation());
            this.setElevation(this.elevationOccupied(this.game.getBoard().getHex(this.getPosition())));
            System.err.println("   moved to elevation " + this.getElevation());
            return true;
        }
        return false;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public boolean itemOppositeTech(String string) {
        if (this.isClan()) {
            return string.toLowerCase().indexOf("(IS)") != -1 || string.toLowerCase().indexOf("Inner Sphere") != -1;
        }
        return string.toLowerCase().indexOf("(C)") != -1 || string.toLowerCase().indexOf("Clan") != -1;
    }

    public int getRetreatedDirection() {
        return this.retreatedDirection;
    }

    public void setRetreatedDirection(int n) {
        this.retreatedDirection = n;
    }

    public void setLastTarget(int n) {
        this.lastTarget = n;
    }

    public int getLastTarget() {
        return this.lastTarget;
    }

    public boolean isSufferingEMI() {
        return this._isEMId;
    }

    public void setEMI(boolean bl) {
        this._isEMId = bl;
    }

    public abstract boolean isNuclearHardened();

    public void setHidden(boolean bl) {
        this.isHidden = bl;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isCarcass() {
        return this.carcass;
    }

    public void setCarcass(boolean bl) {
        this.carcass = bl;
    }

    public void destroyLocation(int n) {
        if (this.getInternal(n) < 0) {
            return;
        }
        this.setArmor(-2, n, false);
        this.setInternal(-2, n);
        if (this.hasRearArmor(n)) {
            this.setArmor(-2, n, true);
        }
        for (Mounted serializable : this.getEquipment()) {
            if (serializable.getLocation() != n || !serializable.getType().isHittable()) continue;
            serializable.setMissing(true);
        }
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null) continue;
            if (criticalSlot.getType() == 0 && criticalSlot.getIndex() == 3 && !criticalSlot.isDamaged()) {
                ++this.engineHitsThisRound;
            }
            criticalSlot.setMissing(true);
        }
        if (this.getDependentLocation(n) != -1) {
            this.destroyLocation(this.getDependentLocation(n));
        }
    }

    public PilotingRollData checkSideSlip(int n, IHex iHex, int n2, MoveStep moveStep, int n3, int n4, Coords coords, Coords coords2, int n5) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        if (!(n == 3 || iHex == null || n5 <= 1 || n2 != 2 && n2 != 5 || n3 == n4 || coords.equals(coords2))) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "flanking and turning"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: VTOL is not apparently sideslipping");
        }
        return pilotingRollData;
    }

    public boolean isFlying() {
        return false;
    }

    public void setSpotTargetId(int n) {
        this.spotTargetId = n;
    }

    public int getSpotTargetId() {
        return this.spotTargetId;
    }
}

