/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.HitData;
import megamek.common.IHex;
import megamek.common.LocationFullException;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.PilotingRollData;
import megamek.common.Report;
import megamek.common.WeaponType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GunEmplacement
extends Entity
implements Serializable {
    private String name = null;
    private int cf = 40;
    private int height = 2;
    private boolean turretNotExists = false;
    private boolean turretLocked = false;
    private boolean burning = false;
    public static final int LOC_BUILDING = 0;
    public static final int LOC_NORTH = 1;
    public static final int LOC_EAST = 2;
    public static final int LOC_WEST = 3;
    public static final int LOC_TURRET = 4;
    public static final String[] HIT_LOCATION_NAMES = new String[]{"Building", "Turret"};
    private static int[] CRITICAL_SLOTS = new int[]{0, 0, 0, 0, 0};
    private static String[] LOCATION_ABBRS = new String[]{"BU", "N", "E", "W", "TU"};
    private static String[] LOCATION_NAMES = new String[]{"Building", "North", "East", "West", "Turret"};

    public GunEmplacement() {
        this.initConstructionFactor(40);
        this.setHeight(2);
        this.setTurret(false);
        this.initTurretArmor(0);
        this.initializeInternal(-1, 1);
        this.initializeInternal(-1, 2);
        this.initializeInternal(-1, 3);
    }

    public boolean hasTurret() {
        return !this.turretNotExists;
    }

    public void setTurret(boolean bl) {
        boolean bl2 = this.turretNotExists = !bl;
        if (!bl) {
            super.setSecondaryFacing(-1);
        }
    }

    public boolean isTurretLocked() {
        return this.turretLocked;
    }

    public void setTurretLocked(boolean bl) {
        this.turretLocked = bl;
    }

    public int getConstructionFactor() {
        return this.cf;
    }

    public void setConstructionFactor(int n) {
        this.cf = n;
        this.setWeight(n);
    }

    public void initConstructionFactor(int n) {
        this.setConstructionFactor(n);
        this.initializeArmor(n, 0);
        this.setArmorType(0);
        this.setArmorTechLevel(0);
        this.initializeInternal(-1, 0);
    }

    public void initTurretArmor(int n) {
        this.initializeArmor(n, 4);
        this.initializeInternal(-1, 4);
    }

    public int getCurrentTurretArmor() {
        return this.getArmor(4);
    }

    public String getName() {
        return this.name;
    }

    public boolean isIn(Coords coords) {
        return this.getPosition().equals(coords);
    }

    public Enumeration<Coords> getCoords() {
        Vector<Coords> vector = new Vector<Coords>(1);
        vector.add(this.getPosition());
        return vector.elements();
    }

    public int getConstructionType() {
        if (this.cf <= 15) {
            return 1;
        }
        if (this.cf <= 40) {
            return 2;
        }
        if (this.cf <= 90) {
            return 3;
        }
        if (this.cf <= 150) {
            return 4;
        }
        return -1;
    }

    public int getCurrentCF() {
        return this.getArmor(0);
    }

    public void setCurrentCF(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid value for Construction Factor: " + n);
        }
    }

    public int getPhaseCF() {
        return this.getArmor(0);
    }

    public void setPhaseCF(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid value for Construction Factor: " + n);
        }
    }

    public boolean isBurning() {
        return this.burning;
    }

    public void setBurning(boolean bl) {
        this.burning = bl;
    }

    @Override
    public int height() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    @Override
    public boolean isImmobile() {
        return true;
    }

    @Override
    public boolean isEligibleForMovement() {
        return false;
    }

    @Override
    public String getMovementString(int n) {
        return "Not possible!";
    }

    @Override
    public String getMovementAbbr(int n) {
        return "!";
    }

    @Override
    public boolean isHexProhibited(IHex iHex) {
        return iHex.containsTerrain(10);
    }

    @Override
    public int getWalkMP(boolean bl) {
        return 0;
    }

    @Override
    public boolean canChangeSecondaryFacing() {
        return this.hasTurret() && !this.turretLocked;
    }

    @Override
    public boolean isValidSecondaryFacing(int n) {
        return this.hasTurret() && !this.turretLocked;
    }

    @Override
    public int clipSecondaryFacing(int n) {
        return n;
    }

    @Override
    public void setSecondaryFacing(int n) {
        if (!this.turretLocked) {
            super.setSecondaryFacing(n);
        }
    }

    @Override
    public void setFacing(int n) {
        super.setFacing(0);
    }

    @Override
    public String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    @Override
    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    @Override
    public int locations() {
        return this.hasTurret() ? LOCATION_ABBRS.length : LOCATION_ABBRS.length - 1;
    }

    @Override
    public boolean hasRearArmor(int n) {
        return false;
    }

    @Override
    public int getWeaponArc(int n) {
        switch (this.getEquipment(n).getLocation()) {
            case 1: {
                return 8;
            }
            case 2: {
                return 9;
            }
            case 3: {
                return 10;
            }
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public boolean isSecondaryArcWeapon(int n) {
        return this.getEquipment(n).getLocation() == 4;
    }

    @Override
    public int sideTable(Coords coords) {
        return 0;
    }

    @Override
    public HitData rollHitLocation(int n, int n2, int n3, int n4) {
        if (n3 != -1 && n4 == 1) {
            switch (Compute.d6(2)) {
                case 6: 
                case 7: 
                case 8: {
                    return new HitData(n3 == 0 ? 0 : 4, false, true);
                }
            }
        }
        return this.rollHitLocation(n, n2);
    }

    @Override
    public HitData rollHitLocation(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        switch (Compute.d6(2)) {
            case 2: {
                n4 = 4;
                break;
            }
            case 3: 
            case 11: {
                if (!this.hasTurret()) break;
                n3 = 4;
                n4 = 8;
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                if (!this.hasTurret()) break;
                n3 = 4;
                break;
            }
            case 12: {
                n4 = 16;
            }
        }
        return new HitData(n3, false, n4);
    }

    @Override
    public HitData getTransferLocation(HitData hitData) {
        return hitData.getLocation() == 4 ? new HitData(0) : new HitData(-2);
    }

    @Override
    public int getDependentLocation(int n) {
        return n == 0 ? 4 : -1;
    }

    @Override
    public int calculateBattleValue() {
        return this.calculateBattleValue(false, false);
    }

    @Override
    public int calculateBattleValue(boolean bl, boolean bl2) {
        double d = 0.0;
        double d2 = 0.0;
        d += (double)this.getTotalArmor();
        double d3 = 0.0;
        for (Mounted mounted : this.getEquipment()) {
            EquipmentType equipmentType = mounted.getType();
            if (mounted.isDestroyed() || !(equipmentType instanceof WeaponType && equipmentType.hasFlag(0x1000000L) || equipmentType instanceof AmmoType && ((AmmoType)equipmentType).getAmmoType() == 14) && !equipmentType.hasFlag(1024L)) continue;
            d3 += equipmentType.getBV(this);
        }
        d += d3;
        d *= 0.5;
        double d4 = 0.0;
        boolean bl3 = this.hasTargComp();
        for (Mounted mounted : this.getWeaponList()) {
            Mounted mounted2;
            WeaponType weaponType = (WeaponType)mounted.getType();
            double d5 = weaponType.getBV(this);
            if (mounted.isDestroyed() || weaponType.hasFlag(0x1000000L)) continue;
            if (mounted.getLinkedBy() != null && (mounted2 = mounted.getLinkedBy()).getType() instanceof MiscType && mounted2.getType().hasFlag(512L)) {
                d5 *= 1.2;
            }
            if (weaponType.hasFlag(1L) && bl3) {
                d5 *= 1.2;
            }
            if (mounted.getLocation() != 4) {
                d5 *= 0.5;
            }
            d4 += d5;
        }
        d2 += d4;
        double d6 = 0.0;
        for (Mounted mounted : this.getAmmo()) {
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (mounted.getShotsLeft() == 0 || ammoType.getAmmoType() == 14) continue;
            d6 += ammoType.getBV(this);
        }
        d2 += d6;
        double d7 = 0.0;
        if (this.hasC3MM() && this.calculateFreeC3MNodes() < 2 || this.hasC3M() && this.calculateFreeC3Nodes() < 3 || this.hasC3S() && this.C3Master > -1 || this.hasC3i() && this.calculateFreeC3Nodes() < 5 || bl) {
            d7 = Math.round(0.35 * d4);
        }
        double d8 = this.crew.getBVSkillMultiplier();
        int n = (int)Math.round(d + (d2 *= 0.44) + d7);
        int n2 = (int)Math.round((double)n * d8);
        return n2;
    }

    @Override
    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        return pilotingRollData;
    }

    @Override
    public Vector<Report> victoryReport() {
        Vector<Report> vector = new Vector<Report>();
        Report report = new Report(7025);
        report.type = 0;
        report.addDesc(this);
        vector.addElement(report);
        report = new Report(7035);
        report.type = 0;
        report.newlines = 0;
        vector.addElement(report);
        vector.addAll(this.crew.getDescVector(false));
        report = new Report(7070, 0);
        report.add(this.getKillNumber());
        vector.addElement(report);
        if (this.isDestroyed()) {
            Entity entity = this.game.getEntity(this.killerId);
            if (entity == null) {
                entity = this.game.getOutOfGameEntity(this.killerId);
            }
            if (entity != null) {
                report = new Report(7072, 0);
                report.addDesc(entity);
            } else {
                report = new Report(7073, 0);
            }
            vector.addElement(report);
        }
        report.newlines = 2;
        return vector;
    }

    @Override
    public int[] getNoOfSlots() {
        return CRITICAL_SLOTS;
    }

    @Override
    public int getRunMPwithoutMASC(boolean bl) {
        return 0;
    }

    @Override
    public int getHeatCapacity() {
        return 999;
    }

    @Override
    public int getHeatCapacityWithWater() {
        return this.getHeatCapacity();
    }

    @Override
    public int getEngineCritHeat() {
        return 0;
    }

    @Override
    public void autoSetInternal() {
        this.initializeInternal(0, 0);
        if (this.hasTurret()) {
            this.initializeInternal(0, 4);
        }
    }

    @Override
    public int getMaxElevationChange() {
        return 0;
    }

    @Override
    public boolean isRepairable() {
        boolean bl = this.isSalvage();
        for (int i = 0; bl && i < 4; ++i) {
            int n = this.getInternal(i);
            bl = n != -2 && n != -3;
        }
        return bl;
    }

    @Override
    public boolean canCharge() {
        return false;
    }

    @Override
    public boolean canDFA() {
        return false;
    }

    @Override
    public boolean canFlee() {
        return false;
    }

    @Override
    public boolean canFlipArms() {
        return false;
    }

    @Override
    public boolean canGoDown() {
        return false;
    }

    @Override
    public boolean canGoDown(int n, Coords coords) {
        return false;
    }

    @Override
    public double getCost() {
        return 0.0;
    }

    @Override
    public boolean doomedInVacuum() {
        for (Mounted mounted : this.getEquipment()) {
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(32768L)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNuclearHardened() {
        return true;
    }

    @Override
    protected void addEquipment(Mounted mounted, int n, boolean bl) throws LocationFullException {
        super.addEquipment(mounted, n, bl);
        this.addCritical(n, new CriticalSlot(1, this.getEquipmentNum(mounted), true));
    }
}

