/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import megamek.common.RoundUpdated;

public class InfernoTracker
implements Serializable,
RoundUpdated {
    private int turnsLeftToBurn = 0;
    private int turnsIVLeftToBurn = 0;
    public static final Inferno STANDARD_ROUND = new Inferno(6, 3);
    public static final Inferno INFERNO_IV_ROUND = new Inferno(10, 3);
    public static final Inferno STANDARD_TURN = new Inferno(6, 1);
    public static final Inferno INFERNO_IV_TURN = new Inferno(10, 1);

    public void add(Inferno inferno, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("InfernoTracker can't track negative hits. ");
        }
        switch (inferno.getHeatPerRound()) {
            case 6: {
                this.turnsLeftToBurn += inferno.getBurnRoundsPerHit() * n;
                break;
            }
            case 10: {
                this.turnsIVLeftToBurn += inferno.getBurnRoundsPerHit() * n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Inferno round added to the InfernoTracker.");
            }
        }
    }

    public void clear() {
        this.turnsLeftToBurn = 0;
        this.turnsIVLeftToBurn = 0;
    }

    public boolean isStillBurning() {
        return this.turnsLeftToBurn > 0 || this.turnsIVLeftToBurn > 0;
    }

    public void newRound(int n) {
        if (this.turnsIVLeftToBurn > 0) {
            --this.turnsIVLeftToBurn;
        } else if (this.turnsLeftToBurn > 0) {
            --this.turnsLeftToBurn;
        }
    }

    public int getTurnsLeftToBurn() {
        int n = 0;
        n = this.turnsLeftToBurn + this.turnsIVLeftToBurn;
        return n;
    }

    public int getArrowIVTurnsLeftToBurn() {
        int n = 0;
        n = this.turnsIVLeftToBurn;
        return n;
    }

    public int getHeat() {
        int n = 0;
        if (this.turnsIVLeftToBurn > 0) {
            n = 10;
        } else if (this.turnsLeftToBurn > 0) {
            n = 6;
        }
        return n;
    }

    public void setTurnsLeftToBurn(int n) {
        this.turnsLeftToBurn = n;
    }

    static class Inferno
    implements Serializable {
        private int heatPerRound;
        private int burnRoundsPerHit;

        public Inferno() {
            this.heatPerRound = 6;
            this.burnRoundsPerHit = 3;
        }

        public Inferno(int n, int n2) {
            this.heatPerRound = n;
            this.burnRoundsPerHit = n2;
        }

        public int getHeatPerRound() {
            return this.heatPerRound;
        }

        public int getBurnRoundsPerHit() {
            return this.burnRoundsPerHit;
        }
    }
}

