/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.Messages;

public class TechConstants {
    public static final int T_ALLOWED_ALL = -2;
    public static final int T_TECH_UNKNOWN = -1;
    public static final int T_IS_LEVEL_1 = 0;
    public static final int T_IS_LEVEL_2 = 1;
    public static final int T_CLAN_LEVEL_2 = 2;
    public static final int T_IS_LEVEL_2_ALL = 3;
    public static final int T_LEVEL_2_ALL = 4;
    public static final int T_IS_LEVEL_3 = 5;
    public static final int T_CLAN_LEVEL_3 = 6;
    public static final int T_ALL = 7;
    public static final int SIZE_LEVEL_2 = 5;
    public static final String[] T_NAMES = new String[]{"IS_level_1", "IS_level_2", "Clan_level_2", "IS_level_1_and_2", "All_level_2", "IS_level_3", "Clan_level_3", "All"};
    public static final int SIZE = T_NAMES.length;
    public static final String[] T_SIMPLE_LEVEL = new String[]{"1", "2", "2", "-1", "-1", "3", "3", "-1"};

    public static String getLevelName(int n) {
        if (n >= 0 && n < SIZE) {
            return T_NAMES[n];
        }
        throw new IllegalArgumentException("Unknown tech level");
    }

    public static String getLevelDisplayableName(int n) {
        if (n >= 0 && n < SIZE) {
            return Messages.getString("TechLevel." + T_NAMES[n]);
        }
        throw new IllegalArgumentException("Unknown tech level");
    }

    public static boolean isLegal(int n, int n2) {
        return TechConstants.isLegal(n, n2, false);
    }

    public static boolean isLegal(int n, int n2, boolean bl) {
        if (n2 == -2) {
            return true;
        }
        if (n2 == -1) {
            return bl;
        }
        if (n == n2) {
            return true;
        }
        if (n == 5 || n == 6) {
            return true;
        }
        if (n2 == 0 && (n == 1 || n == 3 || n == 4 || n == 5 || n == 7)) {
            return true;
        }
        if (n2 == 1 && (n == 3 || n == 4 || n == 5 || n == 7)) {
            return true;
        }
        if (n2 == 2 && (n == 2 || n == 6 || n == 7)) {
            return true;
        }
        if (n2 == 5 && (n == 5 || n == 7)) {
            return true;
        }
        return n2 == 6 && n == 7;
    }

    public static String getTechName(int n) {
        if (n == 0 || n == 1 || n == 5) {
            return "Inner Sphere";
        }
        if (n == 2 || n == 6) {
            return "Clan";
        }
        return "(Unknown Technology Base)";
    }
}

