/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import megamek.common.BipedMech;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.PhysicalAttackAction;

public class TripAttackAction
extends PhysicalAttackAction {
    public TripAttackAction(int n, int n2) {
        super(n, n2);
    }

    public TripAttackAction(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public ToHitData toHit(IGame iGame) {
        return TripAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()));
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable) {
        Entity entity = iGame.getEntity(n);
        if (entity == null) {
            return new ToHitData(Integer.MAX_VALUE, "You can't attack from a null entity!");
        }
        if (!iGame.getOptions().booleanOption("maxtech_new_physicals")) {
            return new ToHitData(Integer.MAX_VALUE, "no MaxTech physicals");
        }
        String string = TripAttackAction.toHitIsImpossible(iGame, entity, targetable);
        if (string != null) {
            return new ToHitData(Integer.MAX_VALUE, "impossible");
        }
        IHex iHex = iGame.getBoard().getHex(entity.getPosition());
        IHex iHex2 = iGame.getBoard().getHex(targetable.getPosition());
        int n2 = entity.getElevation() + iHex.getElevation();
        int n3 = n2 + entity.getHeight();
        int n4 = targetable.getElevation() + iHex2.getElevation();
        if (!(entity instanceof BipedMech) || !(targetable instanceof Mech)) {
            return new ToHitData(Integer.MAX_VALUE, "Only biped mechs can trip other mechs");
        }
        if (entity.isLocationBad(7) || entity.isLocationBad(6)) {
            return new ToHitData(Integer.MAX_VALUE, "Leg missing");
        }
        int n5 = entity.getPosition().distance(targetable.getPosition());
        if (n5 > 1) {
            return new ToHitData(Integer.MAX_VALUE, "Target out of range");
        }
        int n6 = -1;
        int n7 = -1;
        if (n3 < n4 || n2 > n4) {
            return new ToHitData(Integer.MAX_VALUE, "Target elevation not in range");
        }
        if (!Compute.isInArc(entity.getPosition(), entity.getFacing(), targetable.getPosition(), 1)) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in arc");
        }
        if (entity.isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is prone");
        }
        if (((Entity)targetable).isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is prone");
        }
        boolean[] blArray = new boolean[entity.locations()];
        for (int i = 0; i < entity.locations(); ++i) {
            blArray[i] = false;
        }
        for (Mounted serializable2 : entity.getWeaponList()) {
            int n8;
            if (!serializable2.isUsedThisRound() || (n8 = serializable2.getLocation()) == -1) continue;
            blArray[n8] = true;
        }
        if (!entity.hasWorkingSystem(11, 6)) {
            blArray[6] = true;
        }
        if (!entity.hasWorkingSystem(11, 7)) {
            blArray[7] = true;
        }
        if (!entity.hasWorkingSystem(7, 4)) {
            blArray[4] = true;
        }
        if (!entity.hasWorkingSystem(7, 5)) {
            blArray[5] = true;
        }
        if (n2 < n4) {
            if (blArray[4] || blArray[5]) {
                return new ToHitData(Integer.MAX_VALUE, "both arms unusable");
            }
            n6 = 5;
            n7 = 4;
        } else {
            if (blArray[6]) {
                if (blArray[7]) {
                    return new ToHitData(Integer.MAX_VALUE, "both legs unusable");
                }
                n6 = 7;
            }
            if (blArray[4]) {
                if (blArray[5]) {
                    return new ToHitData(Integer.MAX_VALUE, "both arms unusable");
                }
                n7 = 5;
            }
        }
        int n9 = entity.getCrew().getPiloting() - 1;
        ToHitData toHitData = new ToHitData(n9, "base");
        TripAttackAction.setCommonModifiers(toHitData, iGame, entity, targetable);
        if (n6 == -1) {
            ToHitData toHitData2 = TripAttackAction.getLimbModifier(7, entity);
            ToHitData toHitData3 = TripAttackAction.getLimbModifier(6, entity);
            if (toHitData2.getValue() < toHitData3.getValue()) {
                toHitData.append(toHitData2);
            } else {
                toHitData.append(toHitData3);
            }
        } else {
            toHitData.append(TripAttackAction.getLimbModifier(n6, entity));
        }
        if (n7 == -1) {
            ToHitData toHitData4 = TripAttackAction.getLimbModifier(5, entity);
            ToHitData toHitData5 = TripAttackAction.getLimbModifier(4, entity);
            if (toHitData4.getValue() < toHitData5.getValue()) {
                toHitData.append(toHitData4);
            } else {
                toHitData.append(toHitData5);
            }
        } else {
            toHitData.append(TripAttackAction.getLimbModifier(n7, entity));
        }
        return toHitData;
    }

    private static ToHitData getLimbModifier(int n, Entity entity) {
        ToHitData toHitData = new ToHitData();
        if (n == 7 || n == 6) {
            if (!entity.hasWorkingSystem(12, n)) {
                toHitData.addModifier(2, "Upper leg actuator destroyed");
            }
            if (!entity.hasWorkingSystem(13, n)) {
                toHitData.addModifier(2, "Lower leg actuator destroyed");
            }
            if (!entity.hasWorkingSystem(14, n)) {
                toHitData.addModifier(1, "Foot actuator destroyed");
            }
        } else if (n == 4 || n == 5) {
            if (!entity.hasWorkingSystem(8, n)) {
                toHitData.addModifier(2, "Upper arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(9, n)) {
                toHitData.addModifier(2, "Lower arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(10, n)) {
                toHitData.addModifier(1, "Hand actuator destroyed");
            }
        } else {
            toHitData.addModifier(Integer.MAX_VALUE, "not limb");
        }
        return toHitData;
    }
}

