/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.preference;

import gd.xml.ParseException;
import gd.xml.tiny.ParsedXML;
import gd.xml.tiny.TinyParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import megamek.common.preference.ClientPreferences;
import megamek.common.preference.IClientPreferences;
import megamek.common.preference.IPreferenceStore;
import megamek.common.preference.PreferenceStore;

public class PreferenceManager {
    public static final String DEFAULT_CFG_FILE_NAME = "mmconf/clientsettings.xml";
    public static final String CFG_FILE_OPTION_NAME = "cfgfilename";
    public static final String ROOT_NODE_NAME = "MegaMekSettings";
    public static final String CLIENT_SETTINGS_STORE_NAME = "ClientSettings";
    public static final String STORE_NODE_NAME = "store";
    public static final String PREFERENCE_NODE_NAME = "preference";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String VALUE_ATTRIBUTE = "value";
    protected Hashtable<String, IPreferenceStore> stores = new Hashtable();
    protected ClientPreferences clientPreferences;
    protected PreferenceStore clientPreferenceStore = new PreferenceStore();
    protected static PreferenceManager instance = new PreferenceManager();

    protected PreferenceManager() {
        this.load();
        this.clientPreferences = new ClientPreferences(this.clientPreferenceStore);
    }

    public static PreferenceManager getInstance() {
        return instance;
    }

    public static IClientPreferences getClientPreferences() {
        return PreferenceManager.getInstance().clientPreferences;
    }

    public IPreferenceStore getPreferenceStore(String string) {
        IPreferenceStore iPreferenceStore = this.stores.get(string);
        if (iPreferenceStore == null) {
            iPreferenceStore = new PreferenceStore();
            this.stores.put(string, iPreferenceStore);
        }
        return iPreferenceStore;
    }

    protected void load() {
        this.stores = new Hashtable();
        this.clientPreferenceStore = new PreferenceStore();
        String string = System.getProperty(CFG_FILE_OPTION_NAME, DEFAULT_CFG_FILE_NAME);
        this.load(string);
        this.clientPreferences = new ClientPreferences(this.clientPreferenceStore);
    }

    protected void load(String string) {
        ParsedXML parsedXML = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        try {
            parsedXML = TinyParser.parseXML((InputStream)fileInputStream);
        }
        catch (ParseException parseException) {
            System.out.println("Error parsing settings file'" + string + ",.");
            parseException.printStackTrace(System.out);
            return;
        }
        Enumeration enumeration = parsedXML.elements();
        ParsedXML parsedXML2 = (ParsedXML)enumeration.nextElement();
        if (parsedXML2.getName().equals(ROOT_NODE_NAME)) {
            Enumeration enumeration2 = parsedXML2.elements();
            while (enumeration2.hasMoreElements()) {
                ParsedXML parsedXML3 = (ParsedXML)enumeration2.nextElement();
                if (parsedXML3 == null || !parsedXML3.getName().equals(STORE_NODE_NAME)) continue;
                String string2 = parsedXML3.getAttribute(NAME_ATTRIBUTE);
                if (string2.equals(CLIENT_SETTINGS_STORE_NAME)) {
                    this.loadGroup(parsedXML3, this.clientPreferenceStore);
                    continue;
                }
                this.loadGroup(parsedXML3, this.getPreferenceStore(string2));
            }
        } else {
            System.out.println("Root node of settings file is incorrectly named. Name should be 'ROOT_NODE_NAME' but name is '" + parsedXML2.getName() + "'");
        }
    }

    protected void loadGroup(ParsedXML parsedXML, IPreferenceStore iPreferenceStore) {
        Enumeration enumeration = parsedXML.elements();
        while (enumeration.hasMoreElements()) {
            ParsedXML parsedXML2 = (ParsedXML)enumeration.nextElement();
            if (parsedXML2 == null || !parsedXML2.getName().equals(PREFERENCE_NODE_NAME)) continue;
            String string = parsedXML2.getAttribute(NAME_ATTRIBUTE);
            String string2 = parsedXML2.getAttribute(VALUE_ATTRIBUTE);
            if (string == null || string2 == null) continue;
            iPreferenceStore.putValue(string, string2);
        }
    }

    public void save() {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(DEFAULT_CFG_FILE_NAME))));
            bufferedWriter.write("<?xml version=\"1.0\"?>");
            bufferedWriter.write("\r\n");
            bufferedWriter.write("<MegaMekSettings>");
            bufferedWriter.write("\r\n");
            this.saveStore(bufferedWriter, CLIENT_SETTINGS_STORE_NAME, this.clientPreferenceStore);
            Enumeration<String> enumeration = this.stores.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                PreferenceStore preferenceStore = (PreferenceStore)this.stores.get(string);
                this.saveStore(bufferedWriter, string, preferenceStore);
            }
            bufferedWriter.write("</MegaMekSettings>");
            bufferedWriter.write("\r\n");
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void saveStore(Writer writer, String string, PreferenceStore preferenceStore) throws IOException {
        writer.write("\t<store name=\"" + PreferenceManager.quoteXMLChars(string) + "\">");
        writer.write("\r\n");
        Enumeration<Object> enumeration = preferenceStore.properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)preferenceStore.properties.get(string2);
            writer.write("\t\t<preference name=\"" + PreferenceManager.quoteXMLChars(string2) + "\" " + VALUE_ATTRIBUTE + "=\"" + PreferenceManager.quoteXMLChars(string3) + "\"/>");
            writer.write("\r\n");
        }
        writer.write("\t</store>");
        writer.write("\r\n");
    }

    protected static String quoteXMLChars(String string) {
        StringBuffer stringBuffer = null;
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            String string2 = null;
            if (c == '&') {
                string2 = "&amp;";
            } else if (c == '<') {
                string2 = "&lt;";
            } else if (c == '\r') {
                string2 = "&#13;";
            } else if (c == '>') {
                string2 = "&gt;";
            } else if (c == '\"') {
                string2 = "&quot;";
            } else if (c == '\'') {
                string2 = "&apos;";
            }
            if (string2 == null) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string);
            }
            String string3 = stringBuffer.toString();
            String string4 = string3.substring(0, i + n2);
            String string5 = string3.substring(i + n2 + 1, string3.length());
            stringBuffer = new StringBuffer(string4 + string2 + string5);
            n2 += string2.length() - 1;
        }
        if (stringBuffer == null) {
            return string;
        }
        return stringBuffer.toString();
    }
}

