/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.xml;

import gd.xml.tiny.ParsedXML;
import java.io.IOException;
import java.io.Writer;
import megamek.common.Coords;
import megamek.common.IGame;

public class CoordsEncoder {
    public static void encode(Coords coords, Writer writer) throws IOException {
        if (null == coords) {
            throw new IllegalArgumentException("The coords is null.");
        }
        if (null == writer) {
            throw new IllegalArgumentException("The writer is null.");
        }
        writer.write("<coords version=\"1.0\" hash=\"");
        writer.write(Integer.toString(coords.hashCode()));
        writer.write("\" />");
    }

    public static Coords decode(ParsedXML parsedXML, IGame iGame) {
        if (null == parsedXML) {
            throw new IllegalArgumentException("The coords is null.");
        }
        if (!parsedXML.getName().equals("coords")) {
            throw new IllegalStateException("Not passed a coords node.");
        }
        String string = parsedXML.getAttribute("hash");
        if (null == string) {
            throw new IllegalStateException("Couldn't decode the coords node.");
        }
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalStateException("Couldn't find coords for " + string);
        }
        return Coords.getFromHashCode(n);
    }
}

