/*
 * Decompiled with CFR 0.152.
 */
package megamek.server;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Report;
import megamek.common.Terrains;
import megamek.server.DynamicTerrainProcessor;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FireProcessor
extends DynamicTerrainProcessor {
    private IGame game;
    Vector<Report> vPhaseReport;

    public FireProcessor(Server server) {
        super(server);
    }

    @Override
    void DoEndPhaseChanges(Vector<Report> vector) {
        this.game = this.server.getGame();
        if (this.game.getOptions().booleanOption("fire")) {
            this.vPhaseReport = vector;
            this.resolveFire();
            this.vPhaseReport = null;
        }
    }

    private void debugTime(String string, boolean bl) {
    }

    private void resolveFire() {
        IHex iHex;
        Coords coords;
        int n;
        Report report;
        int n2;
        IBoard iBoard = this.game.getBoard();
        int n3 = iBoard.getWidth();
        int n4 = iBoard.getHeight();
        int n5 = this.game.getWindDirection();
        Hashtable<Coords, Vector<Entity>> hashtable = this.game.getPositionMap();
        Vector<Building> vector = new Vector<Building>();
        if (this.game.getOptions().booleanOption("maxtech_fire")) {
            this.resolveSmoke();
        }
        Enumeration<Building> enumeration = this.game.getBoard().getBuildings();
        while (enumeration.hasMoreElements()) {
            Building building = enumeration.nextElement();
            if (!building.isBurning()) continue;
            n2 = Math.max(building.getCurrentCF() - 2, 0);
            building.setCurrentCF(n2);
            if (n2 == 0) {
                report = new Report(5120, 0);
                report.add(building.getName());
                this.vPhaseReport.addElement(report);
                this.server.collapseBuilding(building, hashtable);
                continue;
            }
            if (this.server.checkForCollapse(building, hashtable)) continue;
            building.setPhaseCF(n2);
            vector.addElement(building);
        }
        this.debugTime("resolve fire 1", true);
        for (n = 0; n < n3; ++n) {
            for (n2 = 0; n2 < n4; ++n2) {
                coords = new Coords(n, n2);
                iHex = iBoard.getHex(n, n2);
                boolean bl = iBoard.burnInferno(coords);
                if ((iHex.containsTerrain(1) || iHex.containsTerrain(23)) && iHex.terrainLevel(7) == 2 && this.game.getOptions().booleanOption("woods_burn_down")) {
                    this.burnDownWoods(coords);
                }
                if (!(!iHex.containsTerrain(7) || bl || iHex.containsTerrain(1) || iHex.containsTerrain(23) || iHex.containsTerrain(32) || iHex.containsTerrain(10))) {
                    this.server.removeFire(n, n2, iHex);
                    continue;
                }
                if (iHex.terrainLevel(7) != 2) continue;
                report = new Report(5125, 0);
                if (bl) {
                    report.messageId = 5130;
                }
                report.add(coords.getBoardNum());
                this.vPhaseReport.addElement(report);
                this.spreadFire(n, n2, n5);
            }
        }
        this.debugTime("resolve fire 1 end, begin resolve fire 2", true);
        for (n = 0; n < n3; ++n) {
            for (n2 = 0; n2 < n4; ++n2) {
                coords = new Coords(n, n2);
                iHex = iBoard.getHex(n, n2);
                if (iHex.terrainLevel(7) == 1) {
                    iHex.removeTerrain(7);
                    iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 2));
                    this.server.sendChangedHex(coords);
                    report = new Report(5135, 0);
                    report.add(coords.getBoardNum());
                    this.vPhaseReport.addElement(report);
                    Building building = this.game.getBoard().getBuildingAt(coords);
                    if (building != null) {
                        building.setBurning(true);
                        vector.addElement(building);
                    }
                }
                if (iHex.containsTerrain(7) && !this.game.getOptions().booleanOption("maxtech_fire")) {
                    this.server.addSmoke(n, n2, n5);
                    this.server.addSmoke(n, n2, (n5 + 1) % 6);
                    this.server.addSmoke(n, n2, (n5 + 5) % 6);
                    iBoard.initializeAround(n, n2);
                    continue;
                }
                if (!iHex.containsTerrain(7) || !this.game.getOptions().booleanOption("maxtech_fire")) continue;
                this.server.addL3Smoke(n, n2);
                iBoard.initializeAround(n, n2);
            }
        }
        this.debugTime("resolve fire 2 end", false);
        if (!vector.isEmpty()) {
            this.server.sendChangedCFBuildings(vector);
        }
        if (this.game.getOptions().booleanOption("maxtech_fire")) {
            this.game.determineWind();
        }
    }

    public void burnDownWoods(Coords coords) {
        int n = 5;
        try {
            n = this.game.getOptions().intOption("woods_burn_down_amount");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.server.tryClearHex(coords, n, -1);
    }

    public void spreadFire(int n, int n2, int n3) {
        Coords coords = new Coords(n, n2);
        Coords coords2 = coords.translated(n3);
        this.spreadFire(coords2, 9);
        IHex iHex = this.game.getBoard().getHex(coords2);
        if (iHex != null && !iHex.containsTerrain(7)) {
            this.spreadFire(coords2.translated(n3), 12);
        }
        this.spreadFire(coords.translated((n3 + 1) % 6), 11);
        this.spreadFire(coords.translated((n3 + 5) % 6), 11);
    }

    public void spreadFire(Coords coords, int n) {
        IHex iHex = this.game.getBoard().getHex(coords);
        if (iHex == null) {
            return;
        }
        if (!iHex.containsTerrain(7) && this.server.ignite(iHex, n)) {
            this.server.sendChangedHex(coords);
            Report report = new Report(5150, 0);
            report.add(coords.getBoardNum());
            this.vPhaseReport.addElement(report);
        }
    }

    private void resolveSmoke() {
        IBoard iBoard = this.game.getBoard();
        int n = iBoard.getWidth();
        int n2 = iBoard.getHeight();
        int n3 = this.game.getWindDirection();
        int n4 = this.game.getWindStrength();
        class SmokeDrift {
            public Coords coords;
            public int size;

            public SmokeDrift(Coords coords, int n) {
                this.coords = coords;
                this.size = n;
            }
        }
        Vector<SmokeDrift> vector = new Vector<SmokeDrift>();
        if (n4 > 0) {
            Coords coords;
            int n5;
            this.debugTime("resolve smoke 1", true);
            for (n5 = 0; n5 < n; ++n5) {
                for (int i = 0; i < n2; ++i) {
                    coords = new Coords(n5, i);
                    IHex iHex = iBoard.getHex(n5, i);
                    if (!iHex.containsTerrain(8)) continue;
                    int n6 = iHex.terrainLevel(8);
                    Coords coords2 = this.driftAddSmoke(n5, i, n3, n4);
                    if (iBoard.contains(coords2)) {
                        vector.addElement(new SmokeDrift(new Coords(coords2), n6));
                    } else {
                        Report report = new Report(5230, 0);
                        report.add(coords.getBoardNum());
                        this.vPhaseReport.addElement(report);
                    }
                    iHex.removeTerrain(8);
                    this.server.sendChangedHex(coords);
                }
            }
            this.debugTime("resolve smoke 1 end, resolve smoke 2 begin", true);
            for (n5 = 0; n5 < vector.size(); ++n5) {
                SmokeDrift smokeDrift = (SmokeDrift)vector.elementAt(n5);
                coords = smokeDrift.coords;
                int n7 = smokeDrift.size;
                IHex iHex = this.game.getBoard().getHex(coords);
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(8, n7));
                this.server.sendChangedHex(coords);
            }
            this.debugTime("resolve smoke 2 end, resolve smoke 3 begin", true);
            for (n5 = 0; n5 < vector.size(); ++n5) {
                SmokeDrift smokeDrift = (SmokeDrift)vector.elementAt(n5);
                coords = smokeDrift.coords;
                int n8 = smokeDrift.size;
                IHex iHex = this.game.getBoard().getHex(coords);
                int n9 = Compute.d6(2);
                boolean bl = this.driftSmokeDissipate(iHex, n9, n8, n4);
                this.driftSmokeReport(coords, n8, bl);
                this.server.sendChangedHex(coords);
            }
            this.debugTime("resolve smoke 3 end", false);
        }
    }

    public Coords driftAddSmoke(int n, int n2, int n3, int n4) {
        Coords coords = new Coords(n, n2);
        Coords coords2 = coords.translated(n3);
        if (n4 == 3) {
            coords2 = coords2.translated(n3);
        }
        return coords2;
    }

    public boolean driftSmokeDissipate(IHex iHex, int n, int n2, int n3) {
        if (n > 10 || n > 9 && n3 == 2 || n > 7 && n3 == 3) {
            iHex.removeTerrain(8);
            if (n2 == 2) {
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(8, 1));
                return true;
            }
            return true;
        }
        return false;
    }

    public void driftSmokeReport(Coords coords, int n, boolean bl) {
        if (n == 2 && bl) {
            Report report = new Report(5210, 0);
            report.add(coords.getBoardNum());
            this.vPhaseReport.addElement(report);
        } else if (n == 2 && !bl) {
            Report report = new Report(5215, 0);
            report.add(coords.getBoardNum());
            this.vPhaseReport.addElement(report);
        } else if (n == 1 && bl) {
            Report report = new Report(5220, 0);
            report.add(coords.getBoardNum());
            this.vPhaseReport.addElement(report);
        } else if (n == 1 && !bl) {
            Report report = new Report(5225, 0);
            report.add(coords.getBoardNum());
            this.vPhaseReport.addElement(report);
        }
    }
}

