/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.MWClient;
import common.House;
import common.util.StringUtils;
import java.awt.Color;
import java.util.StringTokenizer;

public class CUser
implements Comparable {
    protected String Name;
    protected String Addon;
    protected int Userlevel = 0;
    protected String PlayerHouse;
    protected String Fluff;
    protected int Exp;
    protected float Rating;
    protected int Status;
    protected String HTMLColor;
    protected Color RGBColor;
    protected String Country;
    protected boolean LoggedIn = false;
    protected boolean isMerc = false;
    protected boolean isInvis = false;

    public CUser() {
        this.Name = "";
        this.Addon = "";
        this.PlayerHouse = "";
        this.Fluff = "";
        this.Exp = 0;
        this.Rating = 0.0f;
        this.Status = 1;
        this.HTMLColor = "black";
        this.RGBColor = Color.black;
        this.Country = "";
        this.isMerc = false;
        this.isInvis = false;
    }

    public CUser(String data) {
        StringTokenizer ST = null;
        this.Addon = "";
        this.PlayerHouse = "";
        this.Fluff = "";
        this.Exp = 0;
        this.Rating = 0.0f;
        this.Status = 1;
        this.RGBColor = Color.black;
        ST = new StringTokenizer(data, "~");
        try {
            this.Name = ST.nextToken();
            this.HTMLColor = ST.nextToken();
            this.Country = ST.nextToken();
            this.Userlevel = Integer.parseInt(ST.nextToken());
            this.isInvis = Boolean.parseBoolean(ST.nextToken());
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog("Error in deserializing user");
        }
    }

    public void setName(String tname) {
        this.Name = tname;
    }

    public String getName() {
        return this.Name;
    }

    public void setAddon(String taddon) {
        this.Addon = taddon;
    }

    public String getAddon() {
        return this.Addon;
    }

    public void setCountry(String tcountry) {
        this.Country = tcountry;
    }

    public String getCountry() {
        return this.Country;
    }

    public void setColor(String tcolor) {
        this.HTMLColor = tcolor;
    }

    public String getColor() {
        return this.HTMLColor;
    }

    public void setUserlevel(int tlevel) {
        this.Userlevel = tlevel;
    }

    public int getUserlevel() {
        return this.Userlevel;
    }

    public void setFluff(String tfluff) {
        this.Fluff = tfluff;
    }

    public String getFluff() {
        return this.Fluff;
    }

    public String getHouse() {
        return this.PlayerHouse;
    }

    public void setExp(int texp) {
        this.Exp = texp;
    }

    public int getExp() {
        return this.Exp;
    }

    public void setRating(float trating) {
        this.Rating = trating;
    }

    public float getRating() {
        return this.Rating;
    }

    public boolean isInvis() {
        return this.isInvis;
    }

    public void setMercStatus(boolean merc) {
        this.isMerc = merc;
    }

    public boolean isMerc() {
        return this.isMerc;
    }

    public Color getRGBColor() {
        return this.RGBColor;
    }

    public void setCampaignData(MWClient mwclient, String data) {
        StringTokenizer ST = new StringTokenizer(data, "#");
        try {
            this.Exp = Integer.parseInt(ST.nextToken());
            this.Rating = Float.parseFloat(ST.nextToken());
            this.setStatus(Integer.parseInt(ST.nextToken()));
            if (ST.hasMoreTokens()) {
                this.Fluff = ST.nextToken();
            }
            if (this.Fluff.equals(" ") || this.Fluff.equals("0")) {
                this.Fluff = "";
            }
            if (ST.hasMoreTokens()) {
                this.PlayerHouse = ST.nextToken();
            }
            if (ST.hasMoreElements()) {
                this.isMerc = Boolean.parseBoolean(ST.nextToken());
            }
            House playerH = mwclient.getData().getHouseByName(this.PlayerHouse);
            this.Addon = playerH.getAbbreviation();
            this.RGBColor = Color.black;
            this.RGBColor = StringUtils.html2Color(playerH.getHousePlayerColor());
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog(ex);
        }
    }

    public void clearCampaignData() {
        this.Addon = "";
        this.PlayerHouse = "";
        this.Fluff = "";
        this.Exp = 0;
        this.Rating = 0.0f;
        this.Status = 1;
        this.RGBColor = Color.black;
    }

    public void setStatus(int status) {
        this.Status = status;
        if (this.Status == 1) {
            this.LoggedIn = false;
            this.clearCampaignData();
        } else if (this.Status == 2 || this.Status == 3 || this.Status == 4) {
            this.LoggedIn = true;
        }
    }

    public int getStatus() {
        return this.Status;
    }

    public boolean isLoggedIn() {
        return this.LoggedIn;
    }

    public String getShortInfo() {
        String info = "<html><body>" + this.getName();
        if (this.Userlevel >= 100 && this.Userlevel < 200) {
            info = info + " (Moderator)";
        }
        if (this.Userlevel >= 200) {
            info = info + " (Admin)";
        }
        if (!this.Country.equals("unknown")) {
            info = info + " (" + this.getCountry() + ")";
        }
        info = info + "</body></html>";
        return info;
    }

    public String getInfo(boolean removeImages) {
        String info = "<html><body>" + this.Name;
        if (!this.Addon.equals("") && this.LoggedIn) {
            info = info + " [" + this.Addon + "]";
        }
        if (this.Userlevel >= 100 && this.Userlevel < 200) {
            info = info + " (Moderator)";
        }
        if (this.Userlevel >= 200) {
            info = info + " (Admin)";
        }
        if (!this.Country.equals("unknown")) {
            info = info + " (" + this.getCountry() + ")";
        }
        if (this.LoggedIn) {
            info = info + "<br>Exp: " + this.Exp;
            if (this.Rating >= 1.0f) {
                info = info + " Rating: " + this.Rating;
            }
            if (!this.PlayerHouse.equals("")) {
                info = info + "<br>Fights for " + this.PlayerHouse;
            }
            if (!this.Fluff.equals("")) {
                String toShow = "";
                if (removeImages) {
                    int start = this.Fluff.indexOf("<img");
                    int finish = -1;
                    if (start != -1) {
                        finish = this.Fluff.indexOf(">", start);
                    }
                    if (start != -1 && finish != -1) {
                        String firstHalf = this.Fluff.substring(0, start);
                        String secondHalf = this.Fluff.substring(finish + 1, this.Fluff.length());
                        toShow = firstHalf + "(img blocked)" + secondHalf;
                    }
                    info = info + "<br>" + toShow;
                } else {
                    info = info + "<br>" + this.Fluff;
                }
            }
        }
        info = info + "</body></html>";
        return info;
    }

    public int compareTo(Object o) {
        if (!(o instanceof CUser)) {
            return 0;
        }
        CUser u = (CUser)o;
        return this.getName().compareTo(u.getName());
    }
}

