/*
 * Decompiled with CFR 0.152.
 */
package client.campaign;

import client.campaign.CCampaign;
import client.campaign.CUnit;
import common.campaign.pilot.Pilot;
import java.util.StringTokenizer;

public class CBMUnit {
    private boolean soldByPlayer = false;
    private String modelName = "";
    private String fileName = "";
    private int auctionID = -1;
    private int unitID = -1;
    private int salesTicksRemaining = -1;
    private int minBid = -1;
    private int playersBid = -1;
    CUnit embeddedUnit;

    public CBMUnit(String listingData, CCampaign campaign) {
        StringTokenizer subTokenizer = new StringTokenizer(listingData, "*");
        this.auctionID = Integer.parseInt(subTokenizer.nextToken());
        this.unitID = Integer.parseInt(subTokenizer.nextToken());
        this.modelName = subTokenizer.nextToken();
        this.fileName = subTokenizer.nextToken();
        this.salesTicksRemaining = Integer.parseInt(subTokenizer.nextToken());
        this.minBid = Integer.parseInt(subTokenizer.nextToken());
        this.soldByPlayer = Boolean.parseBoolean(subTokenizer.nextToken());
        this.playersBid = Integer.parseInt(subTokenizer.nextToken());
        this.embeddedUnit = new CUnit();
        this.embeddedUnit.setUnitFilename(this.fileName);
        this.embeddedUnit.createEntity();
        int factionGunnery = campaign.getPlayer().getMyHouse().getBaseGunner();
        int factionPiloting = campaign.getPlayer().getMyHouse().getBasePilot();
        if (this.embeddedUnit.getType() == 0 || this.embeddedUnit.getType() == 1) {
            this.embeddedUnit.setPilot(new Pilot("BM Unit", factionGunnery, factionPiloting));
        } else {
            this.embeddedUnit.setPilot(new Pilot("BM Unit", factionGunnery, 5));
        }
        this.embeddedUnit.getEntity().setCrew(new megamek.common.Pilot("Generic Pilot", factionGunnery, factionPiloting));
    }

    public int getAuctionID() {
        return this.auctionID;
    }

    public int getUnitID() {
        return this.unitID;
    }

    public String getModelName() {
        return this.modelName;
    }

    public int getTicks() {
        return this.salesTicksRemaining;
    }

    public void decrementSalesTicks() {
        --this.salesTicksRemaining;
    }

    public int getMinBid() {
        return this.minBid;
    }

    public boolean playerIsSeller() {
        return this.soldByPlayer;
    }

    public int getBid() {
        return this.playersBid;
    }

    public CUnit getEmbeddedUnit() {
        return this.embeddedUnit;
    }
}

