/*
 * Decompiled with CFR 0.152.
 */
package client.campaign;

import client.MWClient;
import common.campaign.pilot.Pilot;
import common.campaign.pilot.skills.PilotSkill;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPersonalPilotQueues {
    private ArrayList<LinkedList<Pilot>> mekPilots = new ArrayList();
    private ArrayList<LinkedList<Pilot>> protoPilots = new ArrayList();

    public CPersonalPilotQueues() {
        for (int i = 0; i <= 3; ++i) {
            this.mekPilots.add(i, new LinkedList());
            this.protoPilots.add(i, new LinkedList());
        }
    }

    private ArrayList<LinkedList<Pilot>> getUnitTypeQueue(int typeToGet) {
        if (typeToGet == 3) {
            return this.protoPilots;
        }
        return this.mekPilots;
    }

    private Pilot getPilotFromString(String pilotData) {
        StringTokenizer subTokenizer = new StringTokenizer(pilotData, "#");
        String pilotname = subTokenizer.nextToken();
        int exp = Integer.parseInt(subTokenizer.nextToken());
        int gunnery = Integer.parseInt(subTokenizer.nextToken());
        int piloting = Integer.parseInt(subTokenizer.nextToken());
        Pilot pilot = new Pilot(pilotname, gunnery, piloting);
        pilot.setExperience(exp);
        int skillAmount = Integer.parseInt(subTokenizer.nextToken());
        for (int i = 0; i < skillAmount; ++i) {
            PilotSkill skill = new PilotSkill(Integer.parseInt(subTokenizer.nextToken()), subTokenizer.nextToken(), Integer.parseInt(subTokenizer.nextToken()), subTokenizer.nextToken());
            if (skill.getName().equals("Weapon Specialist")) {
                pilot.setWeapon(subTokenizer.nextToken());
            }
            if (skill.getName().equals("Trait")) {
                pilot.setCurrentFaction(subTokenizer.nextToken());
            }
            if (skill.getName().equals("Edge")) {
                pilot.setTac(Boolean.parseBoolean(subTokenizer.nextToken()));
                pilot.setKO(Boolean.parseBoolean(subTokenizer.nextToken()));
                pilot.setHeadHit(Boolean.parseBoolean(subTokenizer.nextToken()));
                pilot.setExplosion(Boolean.parseBoolean(subTokenizer.nextToken()));
            }
            pilot.getSkills().add(skill);
        }
        if (subTokenizer.hasMoreElements()) {
            pilot.setKills(Integer.parseInt(subTokenizer.nextToken()));
        }
        return pilot;
    }

    public void addPilot(StringTokenizer ST) {
        try {
            int pilotType = Integer.parseInt(ST.nextToken());
            int pilotClass = Integer.parseInt(ST.nextToken());
            Pilot pilot = this.getPilotFromString(ST.nextToken());
            this.getUnitTypeQueue(pilotType).get(pilotClass).addLast(pilot);
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog("Error while adding pilot to PPQ");
            MWClient.mwClientLog.clientErrLog(ex);
        }
    }

    public void removePilot(StringTokenizer ST) {
        try {
            int pilotType = Integer.parseInt(ST.nextToken());
            int pilotClass = Integer.parseInt(ST.nextToken());
            int pilotPosition = Integer.parseInt(ST.nextToken());
            this.getUnitTypeQueue(pilotType).get(pilotClass).remove(pilotPosition);
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog("Unable to remove pilot form queue");
            MWClient.mwClientLog.clientErrLog(ex);
        }
    }

    public LinkedList getPilotQueue(int unitType, int weightClass) {
        return this.getUnitTypeQueue(unitType).get(weightClass);
    }

    public void fromString(String stringFromServer) {
        Pilot toAdd;
        int count;
        int weightClass;
        StringTokenizer mainTokenizer = new StringTokenizer(stringFromServer, "$");
        for (LinkedList<Pilot> currList : this.mekPilots) {
            currList.clear();
        }
        for (LinkedList<Pilot> currList : this.protoPilots) {
            currList.clear();
        }
        for (weightClass = 0; weightClass <= 3; ++weightClass) {
            int listSize = Integer.parseInt(mainTokenizer.nextToken());
            for (count = 0; count < listSize; ++count) {
                toAdd = this.getPilotFromString(mainTokenizer.nextToken());
                this.getUnitTypeQueue(0).get(weightClass).addLast(toAdd);
            }
        }
        for (weightClass = 0; weightClass <= 3; ++weightClass) {
            int listSize = Integer.parseInt(mainTokenizer.nextToken());
            for (count = 0; count < listSize; ++count) {
                toAdd = this.getPilotFromString(mainTokenizer.nextToken());
                this.getUnitTypeQueue(3).get(weightClass).addLast(toAdd);
            }
        }
    }
}

