/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.campaign.CUnit;
import client.gui.SpringLayoutHelper;
import common.House;
import common.campaign.pilot.Pilot;
import common.util.UnitUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import megamek.client.Client;
import megamek.common.AmmoType;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.TechConstants;

public class AdvanceRepairDialog
extends JFrame
implements ActionListener,
MouseListener,
KeyListener,
ChangeListener {
    private MWClient mwclient = null;
    private Entity unit = null;
    private CUnit playerUnit = null;
    private static final String okayCommand = "Add";
    private static final String cancelCommand = "Close";
    private static final String techComboCommand = "TechCombo";
    private String windowName = "Repair Dialog";
    private int critLocation = -1;
    private int critSlot = -1;
    private int selectedSlot = -1;
    private boolean armor = false;
    private int tablocation = 0;
    private Vector<Integer> techs = new Vector();
    private int techType = 0;
    private int baseLineCost = 0;
    private int techWorkMod = 0;
    private int retries = 0;
    private boolean salvage = false;
    private final JButton okayButton = new JButton("Repair");
    private final JButton cancelButton = new JButton("Close");
    private JOptionPane pane;
    private JPanel MasterPanel = new JPanel(new SpringLayout());
    private JPanel contentPane;
    private JPanel techPanel = new JPanel(new SpringLayout());
    private JTextField costField = new JTextField(3);
    private SpinnerListModel workHoursModel = new SpinnerListModel();
    private JSpinner workHoursField = new JSpinner();
    private JTextField baseRollField = new JTextField(3);
    private SpinnerNumberModel numberOfRetriesEditor = new SpinnerNumberModel();
    private JSpinner numberOfRetriesField = new JSpinner(this.numberOfRetriesEditor);
    private JComboBox techComboBox = new JComboBox();
    JTabbedPane ConfigPane = new JTabbedPane(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdvanceRepairDialog(MWClient c, int unitID, boolean salvage) {
        CUnit pUnit = c.getPlayer().getUnit(unitID);
        Entity unit = null;
        Entity entity = pUnit.getEntity();
        synchronized (entity) {
            unit = pUnit.getEntity();
        }
        new AdvanceRepairDialog(c, pUnit, unit, salvage);
    }

    public AdvanceRepairDialog(MWClient c, CUnit playerUnit, Entity unit, boolean salvage) {
        this.playerUnit = playerUnit;
        this.unit = unit;
        this.mwclient = c;
        this.tablocation = c.getPlayer().getRepairLocation();
        this.techs.addAll(c.getPlayer().getAvailableTechs());
        this.techType = c.getPlayer().getRepairTechType();
        this.retries = c.getPlayer().getRepairRetries();
        this.salvage = salvage;
        if (!Boolean.parseBoolean(this.mwclient.getserverConfigs("UsePartsRepair"))) {
            this.salvage = false;
        }
        if (this.salvage) {
            this.windowName = unit.getShortNameRaw() + " Salvage Dialog";
            this.okayButton.setText("Salvage");
        } else {
            this.windowName = unit.getShortNameRaw() + " Repair Dialog";
        }
        this.addKeyListener(this);
        this.okayButton.setActionCommand(okayCommand);
        this.cancelButton.setActionCommand(cancelCommand);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okayButton.setToolTipText("Set a tech to repair the selected location.");
        this.okayButton.setMnemonic('R');
        this.cancelButton.setMnemonic(27);
        this.cancelButton.setToolTipText("Close the repair dialog");
        this.ConfigPane = new JTabbedPane();
        this.ConfigPane.addMouseListener(this);
        this.loadPanel();
        this.loadTechPanel();
        Object[] options = new Object[]{this.okayButton, this.cancelButton};
        this.pane = new JOptionPane(this.MasterPanel, -1, -1, null, options, null);
        this.setIconImage(this.mwclient.getConfig().getImage("REPAIR").getImage());
        this.setExtendedState(0);
        this.setTitle(this.windowName);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.pane, "Center");
        this.setResizable(true);
        this.setSize(new Dimension(268, 628));
        this.setExtendedState(0);
        this.repaint();
        this.setLocation(Math.max(this.mwclient.getMainFrame().getLocation().x, this.mwclient.getMainFrame().getLocation().x + (this.mwclient.getMainFrame().getWidth() / 2 - this.getWidth() / 2)), Math.max(this.mwclient.getMainFrame().getLocation().y + this.mwclient.getMainFrame().getHeight() / 2 - this.getHeight() / 2, this.mwclient.getMainFrame().getLocation().y));
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(okayCommand)) {
            if (this.critLocation < 0 || this.critSlot < 0) {
                JOptionPane.showMessageDialog(null, "Invaild location/Slot please try again");
                return;
            }
            if (this.critLocation > 10) {
                this.critSlot = 15;
            }
            this.techType = this.techComboBox.getSelectedIndex();
            if (this.techType == 4) {
                this.techType = UnitUtils.techType((String)this.techComboBox.getSelectedItem());
            }
            int retries = 0;
            if (!this.salvage) {
                retries = Integer.parseInt(this.numberOfRetriesField.getValue().toString());
            }
            if (this.critSlot >= 13) {
                this.mwclient.getPlayer().setRepairLocation(1);
            } else {
                this.mwclient.getPlayer().setRepairLocation(0);
            }
            this.mwclient.getPlayer().setRepairRetries(retries);
            this.mwclient.getPlayer().setRepairTechType(this.techType);
            if (retries < 0) {
                retries = 999;
            }
            int numberOfTechs = 1;
            if (this.techType < 4) {
                numberOfTechs = this.mwclient.getPlayer().getAvailableTechs().get(this.techType);
            } else if (this.techType == 4 && this.playerUnit.getPilotIsReparing()) {
                numberOfTechs = 0;
            } else if (this.techType == 5) {
                numberOfTechs = 1;
            }
            if (this.salvage) {
                this.mwclient.sendChat("/c salvageunit#" + this.unit.getExternalId() + "#" + this.critLocation + "#" + this.critSlot + "#" + this.armor + "#" + this.techType + "#true");
                super.dispose();
                return;
            }
            if (!(UnitUtils.checkRepairViability(this.unit, this.critLocation, this.critSlot, this.armor) && numberOfTechs > 0 || this.techType == 5)) {
                if (!this.mwclient.getRMT().isQueued(this.critLocation, this.critSlot, this.unit.getExternalId())) {
                    String workOrder = this.unit.getExternalId() + "#" + this.critLocation + "#" + this.critSlot + "#" + this.baseRollField.getText() + "#" + retries;
                    this.mwclient.getRMT().addWorkOrder(this.techType, workOrder);
                    this.mwclient.systemMessage("Work placed in queue.");
                } else {
                    this.mwclient.systemMessage("A work order has already been placed for that job!");
                }
                this.tablocation = this.armor ? 1 : 0;
                this.retries = retries;
                this.loadPanel();
                this.loadTechPanel();
            } else {
                this.mwclient.sendChat("/c repairunit#" + this.unit.getExternalId() + "#" + this.critLocation + "#" + this.critSlot + "#" + this.armor + "#" + this.techType + "#" + retries + "#" + this.techWorkMod + "#true");
                super.dispose();
            }
            return;
        }
        if (command.equals(cancelCommand)) {
            this.mwclient.getPlayer().resetRepairs();
            super.dispose();
        } else if (command.equals(techComboCommand)) {
            this.techType = this.techComboBox.getSelectedIndex();
            String techString = (String)this.techComboBox.getSelectedItem();
            if (UnitUtils.techType(techString) == 4) {
                Pilot pilot = this.playerUnit.getPilot();
                this.techType = pilot.getSkills().getPilotSkill(2).getLevel();
            } else if (UnitUtils.techType(techString) == 5) {
                this.techType = 5;
            }
            this.setCost();
            this.setBaseRoll();
            this.setWorkHours();
        }
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent arg0) {
        if (arg0.getComponent() instanceof JList) {
            String component;
            JList templist = (JList)arg0.getComponent();
            if (arg0.getButton() == 3 && (component = (String)templist.getSelectedValue()) != null) {
                if (component.startsWith("Sensors") && !UnitUtils.hasTargettingComputer(this.unit)) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.setAutoscrolls(true);
                    for (int pos = 0; pos < MiscType.targSysNames.length; ++pos) {
                        if (pos == 1 || this.mwclient.getData().getBannedTargetingSystems().containsKey(pos)) continue;
                        JMenuItem info = new JMenuItem(MiscType.getTargetSysName(pos));
                        info.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                AdvanceRepairDialog.this.mwclient.sendChat("/c settargetsystemtype#" + AdvanceRepairDialog.this.unit.getExternalId() + "#" + e.getActionCommand());
                            }
                        });
                        info.setActionCommand(Integer.toString(pos));
                        popup.add(info);
                    }
                    popup.show(this, arg0.getX() + 50, arg0.getY() + 120);
                } else if (this.unit instanceof Mech && component.indexOf("Cockpit") > -1) {
                    JPopupMenu popup = new JPopupMenu();
                    if (!((Mech)this.unit).isAutoEject()) {
                        JMenuItem info = new JMenuItem("Enable AutoEject");
                        info.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                AdvanceRepairDialog.this.mwclient.sendChat("/c setautoeject#" + AdvanceRepairDialog.this.unit.getExternalId() + "#true");
                                ((Mech)AdvanceRepairDialog.this.unit).setAutoEject(true);
                            }
                        });
                        popup.add(info);
                    } else {
                        JMenuItem info = new JMenuItem("Disable AutoEject");
                        info.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                AdvanceRepairDialog.this.mwclient.sendChat("/c setautoeject#" + AdvanceRepairDialog.this.unit.getExternalId() + "#false");
                                ((Mech)AdvanceRepairDialog.this.unit).setAutoEject(false);
                            }
                        });
                        popup.add(info);
                    }
                    popup.show(this, arg0.getX() + 50, arg0.getY() + 120);
                } else if (component.indexOf("Ammo") > -1 || component.indexOf("Pods") > -1) {
                    JPopupMenu popup = new JPopupMenu();
                    Client mmClient = new Client("temp", "None", 0);
                    mmClient.game.getOptions().loadOptions();
                    CriticalSlot cs = this.unit.getCritical(this.critLocation, this.critSlot);
                    AmmoType at = (AmmoType)this.unit.getEquipmentType(cs);
                    Vector<AmmoType> vAllTypes = AmmoType.getMunitionsFor(at.getAmmoType());
                    boolean canDump = mmClient.game.getOptions().booleanOption("lobby_ammo_dump");
                    if (vAllTypes == null) {
                        return;
                    }
                    if (vAllTypes.size() < 2 && !canDump) {
                        return;
                    }
                    int n = vAllTypes.size();
                    for (int x = 0; x < n; ++x) {
                        AmmoType atCheck = vAllTypes.elementAt(x);
                        boolean bTechMatch = TechConstants.isLegal(this.unit.getTechLevel(), atCheck.getTechLevel());
                        String munition = Long.toString(atCheck.getMunitionType());
                        House faction = this.mwclient.getData().getHouseByName(this.mwclient.getPlayer().getHouse());
                        if (this.mwclient.getData().getServerBannedAmmo().containsKey(munition) || faction.getBannedAmmo().containsKey(munition)) continue;
                        if (!bTechMatch && this.unit.getTechLevel() == 1 && atCheck.getTechLevel() == 0) {
                            bTechMatch = true;
                        }
                        if (!mmClient.game.getOptions().booleanOption("is_eq_limits") && this.unit.getTechLevel() == 0 && atCheck.getTechLevel() == 1) {
                            bTechMatch = true;
                        }
                        if (mmClient.game.getOptions().booleanOption("allow_level_3_ammo")) {
                            if (!mmClient.game.getOptions().booleanOption("is_eq_limits")) {
                                if (this.unit.getTechLevel() == 2 && atCheck.getTechLevel() == 6) {
                                    bTechMatch = true;
                                }
                                if ((this.unit.getTechLevel() == 0 || this.unit.getTechLevel() == 1) && atCheck.getTechLevel() == 5) {
                                    bTechMatch = true;
                                }
                            }
                        } else if (atCheck.getTechLevel() == 5 || atCheck.getTechLevel() == 6) {
                            bTechMatch = false;
                        }
                        if (this.unit.isMixedTech()) {
                            bTechMatch = true;
                        }
                        long muniType = atCheck.getMunitionType();
                        if (!mmClient.game.getOptions().booleanOption("clan_ignore_eq_limits") && this.unit.isClan() && ((muniType &= 0xFFFFFFFFFFFFEFFFL) == 16384L || muniType == 262144L || muniType == 524288L || muniType == 0x100000L || muniType == 0x200000L || muniType == 0x80000000L || muniType == 0x100000000L)) {
                            bTechMatch = false;
                        }
                        if (!mmClient.game.getOptions().booleanOption("minefields") && AmmoType.canDeliverMinefield(atCheck) || atCheck.hasFlag(4L) && !(this.unit instanceof Protomech) || this.unit instanceof Protomech && atCheck.hasFlag(1L) && !atCheck.hasFlag(4L) || !bTechMatch || atCheck.getRackSize() != at.getRackSize() || atCheck.hasFlag(2L) || atCheck.getTonnage(this.unit) != at.getTonnage(this.unit)) continue;
                        int cost = this.mwclient.getData().getAmmoCost().get(atCheck.getMunitionType());
                        JMenuItem info = new JMenuItem();
                        Mounted m = this.unit.getEquipment(cs.getIndex());
                        if (m.getLocation() == -1) {
                            cost /= atCheck.getShots();
                            cost = Math.max(cost, 1);
                            if (atCheck.getAmmoType() == 30) {
                                cost = (int)((double)cost / 2.5);
                                cost = Math.max(cost, 1);
                            }
                            info.setText(atCheck.getName() + " (" + m.getShotsLeft() + "/1) " + this.mwclient.moneyOrFluMessage(true, true, cost));
                        } else {
                            info.setText(atCheck.getName() + " (" + m.getShotsLeft() + "/" + atCheck.getShots() + ") " + this.mwclient.moneyOrFluMessage(true, true, cost));
                        }
                        info.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                AdvanceRepairDialog.this.mwclient.sendChat("/c setunitammobycrit#" + AdvanceRepairDialog.this.unit.getExternalId() + "#" + AdvanceRepairDialog.this.critLocation + "#" + AdvanceRepairDialog.this.critSlot + "#" + e.getActionCommand());
                            }
                        });
                        info.setActionCommand(atCheck.getAmmoType() + "#" + atCheck.getInternalName() + "#" + atCheck.getRackSize());
                        popup.add(info);
                    }
                    popup.show(this, arg0.getX() + 50, arg0.getY() + 120);
                }
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent arg0) {
        if (arg0.getComponent() instanceof JList) {
            JList templist = (JList)arg0.getComponent();
            if (templist.getName().startsWith("armor")) {
                this.critLocation = Integer.parseInt(templist.getName().substring(5));
                this.selectedSlot = templist.getSelectedIndex();
                this.selectedSlot = this.selectedSlot == 0 ? 13 : (this.selectedSlot == 2 ? 15 : (this.unit.hasRearArmor(this.critLocation) ? 14 : 15));
            } else {
                this.selectedSlot = templist.getSelectedIndex();
                this.critLocation = Integer.parseInt(templist.getName());
            }
            this.setCost();
            this.setBaseRoll();
            this.setWorkHours();
        }
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPanel() {
        this.ConfigPane.removeAll();
        JPanel mainPanel = new JPanel();
        JPanel armorPanel = new JPanel();
        mainPanel.addMouseListener(this);
        armorPanel.addMouseListener(this);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        armorPanel.setLayout(new BoxLayout(armorPanel, 1));
        JPanel headPanel = new JPanel();
        JPanel torsoPanel = new JPanel();
        JPanel legPanel = new JPanel();
        JPanel laPanel = new JPanel();
        JPanel raPanel = new JPanel();
        JPanel llPanel = new JPanel();
        JPanel rlPanel = new JPanel();
        JPanel ltPanel = new JPanel();
        JPanel rtPanel = new JPanel();
        JPanel ctPanel = new JPanel();
        JPanel headArmorPanel = new JPanel();
        JPanel laArmorPanel = new JPanel();
        JPanel raArmorPanel = new JPanel();
        JPanel llArmorPanel = new JPanel();
        JPanel rlArmorPanel = new JPanel();
        JPanel ltArmorPanel = new JPanel();
        JPanel rtArmorPanel = new JPanel();
        JPanel ctArmorPanel = new JPanel();
        headPanel.setLayout(new BoxLayout(headPanel, 0));
        headArmorPanel.setLayout(new BoxLayout(headArmorPanel, 0));
        torsoPanel.setLayout(new BoxLayout(torsoPanel, 0));
        legPanel.setLayout(new BoxLayout(legPanel, 0));
        Entity entity = this.unit;
        synchronized (entity) {
            String armorName = EquipmentType.getArmorTypeName(this.unit.getArmorType());
            String isName = EquipmentType.getStructureTypeName(this.unit.getStructureType());
            if (armorName.equalsIgnoreCase("Standard")) {
                armorName = "Armor";
            }
            if (isName.equalsIgnoreCase("Standard")) {
                isName = "Internal";
            }
            block23: for (int location = 0; location < this.unit.locations(); ++location) {
                JPanel locationPanel = new JPanel();
                locationPanel.addMouseListener(this);
                Vector<String> critNames = new Vector<String>();
                Vector<String> armorNames = new Vector<String>(3);
                boolean armorDamage = false;
                boolean critDamage = false;
                if (this.unit.getArmor(location) > this.unit.getOArmor(location)) {
                    UnitUtils.removeArmorRepair(this.unit, 13, location);
                    armorNames.add("!!" + armorName + ": " + this.unit.getArmor(location) + "/" + this.unit.getOArmor(location));
                    UnitUtils.setArmorRepair(this.unit, 13, location);
                } else if (this.mwclient.getRMT().isQueued(location, 13, this.unit.getExternalId())) {
                    armorNames.add("@@" + armorName + ": " + Math.max(0, this.unit.getArmor(location)) + "/" + this.unit.getOArmor(location));
                } else {
                    armorNames.add(armorName + ": " + Math.max(0, this.unit.getArmor(location)) + "/" + this.unit.getOArmor(location));
                }
                if (this.unit.getArmor(location) != this.unit.getOArmor(location)) {
                    armorDamage = true;
                }
                if (this.unit.hasRearArmor(location)) {
                    if (this.unit.getArmor(location, true) > this.unit.getOArmor(location, true)) {
                        UnitUtils.removeArmorRepair(this.unit, 14, location);
                        armorNames.add("!!" + armorName + "(r): " + this.unit.getArmor(location, true) + "/" + this.unit.getOArmor(location, true));
                        UnitUtils.setArmorRepair(this.unit, 14, location);
                    } else if (this.mwclient.getRMT().isQueued(location, 14, this.unit.getExternalId())) {
                        armorNames.add("@@" + armorName + "(r): " + Math.max(0, this.unit.getArmor(location, true)) + "/" + this.unit.getOArmor(location, true));
                    } else {
                        armorNames.add("" + armorName + "(r): " + Math.max(0, this.unit.getArmor(location, true)) + "/" + this.unit.getOArmor(location, true));
                    }
                    if (this.unit.getArmor(location, true) != this.unit.getOArmor(location, true)) {
                        armorDamage = true;
                    }
                }
                if (this.unit.getInternal(location) > this.unit.getOInternal(location)) {
                    UnitUtils.removeArmorRepair(this.unit, 15, location);
                    armorNames.add("!!" + isName + ": " + this.unit.getInternal(location) + "/" + this.unit.getOInternal(location));
                    UnitUtils.setArmorRepair(this.unit, 15, location);
                } else if (this.mwclient.getRMT().isQueued(location, 15, this.unit.getExternalId())) {
                    armorNames.add("@@" + isName + ": " + Math.max(0, this.unit.getInternal(location)) + "/" + this.unit.getOInternal(location));
                } else {
                    armorNames.add(isName + ": " + Math.max(0, this.unit.getInternal(location)) + "/" + this.unit.getOInternal(location));
                }
                if (this.unit.getInternal(location) != this.unit.getOInternal(location)) {
                    armorDamage = true;
                }
                JList ArmorSlotList = new JList(armorNames);
                ArmorSlotList.addMouseListener(this);
                ArmorSlotList.addKeyListener(this);
                ArmorSlotList.setVisibleRowCount(armorNames.size());
                ArmorSlotList.setSelectionMode(0);
                ArmorSlotList.setFont(new Font("Arial", 0, 10));
                ArmorSlotList.setName("armor" + location);
                switch (location) {
                    case 0: {
                        headArmorPanel.add(ArmorSlotList);
                        headArmorPanel.addMouseListener(this);
                        if (critDamage) {
                            ArmorSlotList.setBackground(Color.red);
                            break;
                        }
                        if (armorDamage) {
                            ArmorSlotList.setBackground(Color.yellow);
                            break;
                        }
                        ArmorSlotList.setBackground(Color.green);
                        break;
                    }
                    case 5: {
                        laArmorPanel.add(ArmorSlotList);
                        laArmorPanel.addMouseListener(this);
                        if (critDamage) {
                            ArmorSlotList.setBackground(Color.red);
                            break;
                        }
                        if (armorDamage) {
                            ArmorSlotList.setBackground(Color.yellow);
                            break;
                        }
                        ArmorSlotList.setBackground(Color.green);
                        break;
                    }
                    case 4: {
                        raArmorPanel.add(ArmorSlotList);
                        raArmorPanel.addMouseListener(this);
                        if (critDamage) {
                            ArmorSlotList.setBackground(Color.red);
                            break;
                        }
                        if (armorDamage) {
                            ArmorSlotList.setBackground(Color.yellow);
                            break;
                        }
                        ArmorSlotList.setBackground(Color.green);
                        break;
                    }
                    case 1: {
                        ctArmorPanel.add(ArmorSlotList);
                        ctArmorPanel.addMouseListener(this);
                        if (critDamage) {
                            ArmorSlotList.setBackground(Color.red);
                            break;
                        }
                        if (armorDamage) {
                            ArmorSlotList.setBackground(Color.yellow);
                            break;
                        }
                        ArmorSlotList.setBackground(Color.green);
                        break;
                    }
                    case 3: {
                        ltArmorPanel.add(ArmorSlotList);
                        ltArmorPanel.addMouseListener(this);
                        if (critDamage) {
                            ArmorSlotList.setBackground(Color.red);
                            break;
                        }
                        if (armorDamage) {
                            ArmorSlotList.setBackground(Color.yellow);
                            break;
                        }
                        ArmorSlotList.setBackground(Color.green);
                        break;
                    }
                    case 2: {
                        rtArmorPanel.add(ArmorSlotList);
                        rtArmorPanel.addMouseListener(this);
                        if (critDamage) {
                            ArmorSlotList.setBackground(Color.red);
                            break;
                        }
                        if (armorDamage) {
                            ArmorSlotList.setBackground(Color.yellow);
                            break;
                        }
                        ArmorSlotList.setBackground(Color.green);
                        break;
                    }
                    case 7: {
                        llArmorPanel.add(ArmorSlotList);
                        llArmorPanel.addMouseListener(this);
                        if (critDamage) {
                            ArmorSlotList.setBackground(Color.red);
                            break;
                        }
                        if (armorDamage) {
                            ArmorSlotList.setBackground(Color.yellow);
                            break;
                        }
                        ArmorSlotList.setBackground(Color.green);
                        break;
                    }
                    case 6: {
                        rlArmorPanel.add(ArmorSlotList);
                        rlArmorPanel.addMouseListener(this);
                        if (critDamage) {
                            ArmorSlotList.setBackground(Color.red);
                            break;
                        }
                        if (armorDamage) {
                            ArmorSlotList.setBackground(Color.yellow);
                            break;
                        }
                        ArmorSlotList.setBackground(Color.green);
                    }
                }
                for (int slot = 0; slot < this.unit.getNumberOfCriticals(location); ++slot) {
                    CriticalSlot cs = this.unit.getCritical(location, slot);
                    if (cs == null) {
                        if (this.unit instanceof Tank || location != 0) continue;
                        critNames.add("-- Empty --");
                        continue;
                    }
                    if (cs.getType() == 0) {
                        String result = "";
                        if (cs.isRepairing()) {
                            result = result + "!!";
                        } else if (this.mwclient.getRMT().isQueued(location, slot, this.unit.getExternalId())) {
                            result = result + "@@";
                            critDamage = true;
                        } else if (cs.isMissing()) {
                            result = result + "# ";
                            critDamage = true;
                        } else if (cs.isDamaged()) {
                            result = result + "* ";
                            critDamage = true;
                        } else if (cs.isBreached()) {
                            result = result + "location ";
                            critDamage = true;
                        }
                        if (!(this.unit instanceof Mech)) continue;
                        critNames.add(result + ((Mech)this.unit).getSystemName(cs.getIndex()));
                        continue;
                    }
                    if (cs.getType() != 1) continue;
                    Mounted m = this.unit.getEquipment(cs.getIndex());
                    if (cs.isRepairing()) {
                        critNames.add("!!" + m.getDesc());
                        continue;
                    }
                    if (this.mwclient.getRMT().isQueued(location, slot, this.unit.getExternalId())) {
                        critNames.add("@@" + m.getDesc());
                        critDamage = true;
                        continue;
                    }
                    if (cs.isMissing()) {
                        critNames.add("# " + m.getDesc());
                        critDamage = true;
                        continue;
                    }
                    if (cs.isDamaged()) {
                        critDamage = true;
                        critNames.add("* " + m.getDesc());
                        continue;
                    }
                    if (cs.isBreached()) {
                        critNames.add("location " + m.getDesc());
                        critDamage = true;
                        continue;
                    }
                    critNames.add(m.getDesc());
                }
                JList CriticalSlotList = new JList(critNames);
                CriticalSlotList.addMouseListener(this);
                CriticalSlotList.addKeyListener(this);
                CriticalSlotList.setVisibleRowCount(critNames.size());
                CriticalSlotList.setSelectionMode(0);
                CriticalSlotList.setFont(new Font("Arial", 0, 10));
                CriticalSlotList.setName(Integer.toString(location));
                switch (location) {
                    case 0: {
                        headPanel.add(CriticalSlotList);
                        headPanel.addMouseListener(this);
                        if (critDamage) {
                            CriticalSlotList.setBackground(Color.red);
                            continue block23;
                        }
                        if (armorDamage) {
                            CriticalSlotList.setBackground(Color.yellow);
                            continue block23;
                        }
                        CriticalSlotList.setBackground(Color.green);
                        continue block23;
                    }
                    case 5: {
                        laPanel.add(CriticalSlotList);
                        laPanel.addMouseListener(this);
                        if (critDamage) {
                            CriticalSlotList.setBackground(Color.red);
                            continue block23;
                        }
                        if (armorDamage) {
                            CriticalSlotList.setBackground(Color.yellow);
                            continue block23;
                        }
                        CriticalSlotList.setBackground(Color.green);
                        continue block23;
                    }
                    case 4: {
                        raPanel.add(CriticalSlotList);
                        raPanel.addMouseListener(this);
                        if (critDamage) {
                            CriticalSlotList.setBackground(Color.red);
                            continue block23;
                        }
                        if (armorDamage) {
                            CriticalSlotList.setBackground(Color.yellow);
                            continue block23;
                        }
                        CriticalSlotList.setBackground(Color.green);
                        continue block23;
                    }
                    case 1: {
                        ctPanel.add(CriticalSlotList);
                        ctPanel.addMouseListener(this);
                        if (critDamage) {
                            CriticalSlotList.setBackground(Color.red);
                            continue block23;
                        }
                        if (armorDamage) {
                            CriticalSlotList.setBackground(Color.yellow);
                            continue block23;
                        }
                        CriticalSlotList.setBackground(Color.green);
                        continue block23;
                    }
                    case 3: {
                        ltPanel.add(CriticalSlotList);
                        ltPanel.addMouseListener(this);
                        if (critDamage) {
                            CriticalSlotList.setBackground(Color.red);
                            continue block23;
                        }
                        if (armorDamage) {
                            CriticalSlotList.setBackground(Color.yellow);
                            continue block23;
                        }
                        CriticalSlotList.setBackground(Color.green);
                        continue block23;
                    }
                    case 2: {
                        rtPanel.add(CriticalSlotList);
                        rtPanel.addMouseListener(this);
                        if (critDamage) {
                            CriticalSlotList.setBackground(Color.red);
                            continue block23;
                        }
                        if (armorDamage) {
                            CriticalSlotList.setBackground(Color.yellow);
                            continue block23;
                        }
                        CriticalSlotList.setBackground(Color.green);
                        continue block23;
                    }
                    case 7: {
                        llPanel.add(CriticalSlotList);
                        llPanel.addMouseListener(this);
                        if (critDamage) {
                            CriticalSlotList.setBackground(Color.red);
                            continue block23;
                        }
                        if (armorDamage) {
                            CriticalSlotList.setBackground(Color.yellow);
                            continue block23;
                        }
                        CriticalSlotList.setBackground(Color.green);
                        continue block23;
                    }
                    case 6: {
                        rlPanel.add(CriticalSlotList);
                        rlPanel.addMouseListener(this);
                        if (critDamage) {
                            CriticalSlotList.setBackground(Color.red);
                            continue block23;
                        }
                        if (armorDamage) {
                            CriticalSlotList.setBackground(Color.yellow);
                            continue block23;
                        }
                        CriticalSlotList.setBackground(Color.green);
                    }
                }
            }
        }
        mainPanel.add(headPanel);
        torsoPanel.add(laPanel);
        torsoPanel.add(ltPanel);
        torsoPanel.add(ctPanel);
        torsoPanel.add(rtPanel);
        torsoPanel.add(raPanel);
        mainPanel.add(torsoPanel);
        legPanel.add(llPanel);
        legPanel.add(rlPanel);
        mainPanel.add(legPanel);
        this.ConfigPane.addTab("Crits", mainPanel);
        torsoPanel = new JPanel();
        legPanel = new JPanel();
        torsoPanel.setLayout(new BoxLayout(torsoPanel, 0));
        legPanel.setLayout(new BoxLayout(legPanel, 0));
        armorPanel.add(headArmorPanel);
        torsoPanel.add(laArmorPanel);
        torsoPanel.add(ltArmorPanel);
        torsoPanel.add(ctArmorPanel);
        torsoPanel.add(rtArmorPanel);
        torsoPanel.add(raArmorPanel);
        armorPanel.add(torsoPanel);
        legPanel.add(llArmorPanel);
        legPanel.add(rlArmorPanel);
        armorPanel.add(legPanel);
        this.ConfigPane.addTab("Armor", armorPanel);
        this.ConfigPane.setSelectedIndex(this.tablocation);
    }

    private void loadTechPanel() {
        this.techPanel.removeAll();
        Vector<String> techString = new Vector<String>(4, 1);
        techString.add("Green - " + this.techs.elementAt(0));
        techString.add("Reg   - " + this.techs.elementAt(1));
        techString.add("Vet   - " + this.techs.elementAt(2));
        techString.add("Elite - " + this.techs.elementAt(3));
        Pilot pilot = this.playerUnit.getPilot();
        if (pilot.getSkills().has(2)) {
            techString.add(UnitUtils.techDescription(4));
        }
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("AllowCritRepairsForRewards")) && !this.salvage) {
            techString.add(UnitUtils.techDescription(5));
        }
        this.techComboBox = new JComboBox(techString);
        this.techComboBox.addActionListener(this);
        this.techComboBox.setActionCommand(techComboCommand);
        try {
            if (this.techType >= this.techComboBox.getMaximumRowCount()) {
                this.techComboBox.setSelectedIndex(0);
            } else {
                this.techComboBox.setSelectedIndex(this.techType);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.techPanel.add(new JLabel("Techs: ", 11));
        this.techPanel.add(this.techComboBox);
        this.techPanel.add(new JLabel("Hours: ", 11));
        this.workHoursField.setToolTipText("One work hour equals 1 RL second");
        this.workHoursField.addChangeListener(this);
        this.workHoursField.addKeyListener(this);
        this.techPanel.add(this.workHoursField);
        this.techPanel.add(new JLabel("Cost/Roll ", 11));
        this.costField.setText("0");
        this.costField.setEditable(false);
        this.techPanel.add(this.costField);
        this.baseRollField.setText("12");
        this.baseRollField.setEditable(false);
        this.techPanel.add(this.baseRollField);
        if (!this.salvage) {
            this.techPanel.add(new JLabel("Attempts: ", 11));
            this.numberOfRetriesEditor.setMaximum(Integer.valueOf(100));
            this.numberOfRetriesEditor.setMinimum(Integer.valueOf(-1));
            this.numberOfRetriesEditor.setStepSize(1);
            try {
                this.numberOfRetriesEditor.setValue(this.retries);
                this.numberOfRetriesField.setValue(this.retries);
            }
            catch (Exception ex) {
                this.numberOfRetriesEditor.setValue(0);
                this.numberOfRetriesField.setValue(0);
            }
            this.numberOfRetriesField.setToolTipText("<html>Number of times the assigned tech will try to finish the repair<br>will stop when repair is sucessful or you run out of money or tries<br>Set to -1 or infinite retries</html>");
            this.numberOfRetriesField.addKeyListener(this);
            this.techPanel.add(this.numberOfRetriesField);
            SpringLayoutHelper.setupSpringGrid(this.techPanel, 9);
        } else {
            SpringLayoutHelper.setupSpringGrid(this.techPanel, 8);
        }
        this.workHoursField.setEnabled(!this.salvage);
        this.numberOfRetriesField.setEnabled(!this.salvage);
        this.MasterPanel.add(this.ConfigPane);
        this.MasterPanel.add(this.techPanel);
        SpringLayoutHelper.setupSpringGrid(this.MasterPanel, 2, 1);
    }

    public void setCost() {
        if (this.critLocation < 0 || this.selectedSlot < 0) {
            return;
        }
        int totalCost = 1;
        int techCost = 0;
        int techCostWorkMod = 0;
        double totalCrits = 1.0;
        this.critSlot = this.selectedSlot;
        if (this.techComboBox.getSelectedIndex() < 4) {
            techCost = Integer.parseInt(this.mwclient.getserverConfigs(UnitUtils.techDescription(this.techType) + "TechRepairCost"));
            techCostWorkMod = this.techWorkMod;
        }
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("UseRealRepairCosts"))) {
            double costMod;
            this.armor = false;
            if (this.critSlot >= 13) {
                this.armor = true;
            }
            double cost = UnitUtils.getPartCost(this.unit, this.critLocation, this.critSlot, this.armor);
            if (Boolean.parseBoolean(this.mwclient.getserverConfigs("UsePartsRepair"))) {
                cost = 0.0;
            }
            if ((costMod = Double.parseDouble(this.mwclient.getserverConfigs("RealRepairCostMod"))) > 0.0) {
                cost *= costMod;
            }
            this.costField.setText(Integer.toString((int)(cost += (double)(techCost * Math.abs(techCostWorkMod) + techCost))));
        } else if (this.critSlot == 13) {
            this.armor = true;
            double cost = CUnit.getArmorCost(this.unit, this.mwclient);
            if (this.unit.getArmor(this.critLocation) > this.unit.getOArmor(this.critLocation)) {
                UnitUtils.removeArmorRepair(this.unit, 13, this.critLocation);
                cost *= (double)(this.unit.getOArmor(this.critLocation) - this.unit.getArmor(this.critLocation));
                UnitUtils.setArmorRepair(this.unit, 13, this.critLocation);
            } else {
                cost *= (double)(this.unit.getOArmor(this.critLocation) - this.unit.getArmor(this.critLocation));
            }
            cost += (double)(techCost * Math.abs(techCostWorkMod));
            cost += (double)techCost;
            cost = Math.max(1.0, cost);
            this.costField.setText(Integer.toString((int)cost));
            this.critSlot = 13;
        } else if (this.critSlot == 14) {
            this.armor = true;
            double cost = CUnit.getArmorCost(this.unit, this.mwclient);
            if (this.unit.getArmor(this.critLocation, true) > this.unit.getOArmor(this.critLocation, true)) {
                UnitUtils.removeArmorRepair(this.unit, 14, this.critLocation);
                cost *= (double)(this.unit.getOArmor(this.critLocation, true) - this.unit.getArmor(this.critLocation, true));
                UnitUtils.setArmorRepair(this.unit, 14, this.critLocation);
            } else {
                cost *= (double)(this.unit.getOArmor(this.critLocation, true) - this.unit.getArmor(this.critLocation, true));
            }
            cost += (double)(techCost * Math.abs(techCostWorkMod));
            cost += (double)techCost;
            cost = Math.max(1.0, cost);
            this.costField.setText(Integer.toString((int)cost));
            this.critSlot = 14;
        } else if (this.critSlot == 15) {
            this.armor = true;
            double cost = CUnit.getStructureCost(this.unit, this.mwclient);
            if (this.unit.getInternal(this.critLocation) > this.unit.getOInternal(this.critLocation)) {
                UnitUtils.removeArmorRepair(this.unit, 15, this.critLocation);
                cost *= (double)(this.unit.getOInternal(this.critLocation) - this.unit.getInternal(this.critLocation));
                UnitUtils.setArmorRepair(this.unit, 15, this.critLocation);
            } else {
                cost *= (double)(this.unit.getOInternal(this.critLocation) - this.unit.getInternal(this.critLocation));
            }
            cost += (double)(techCost * Math.abs(techCostWorkMod));
            cost += (double)techCost;
            cost = Math.max(1.0, cost);
            this.costField.setText(Integer.toString((int)cost));
            this.critSlot = 15;
        } else {
            this.armor = false;
            CriticalSlot cs = this.unit.getCritical(this.critLocation, this.critSlot);
            double cost = 1.0;
            totalCrits = this.salvage ? (double)(UnitUtils.getNumberOfCrits(this.unit, cs) - UnitUtils.getNumberOfDamagedCrits(this.unit, this.critSlot, this.critLocation, this.armor)) : (double)UnitUtils.getNumberOfDamagedCrits(this.unit, this.critSlot, this.critLocation, this.armor);
            cost = CUnit.getCritCost(this.unit, this.mwclient, cs);
            totalCost = (int)(totalCrits * cost);
            totalCost += (int)(totalCrits * (double)techCost);
            totalCost += techCost;
            cost = Math.max(1, totalCost += techCost * Math.abs(this.techWorkMod));
            this.costField.setText(Integer.toString((int)cost));
        }
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("AllowCritRepairsForRewards")) && UnitUtils.techType((String)this.techComboBox.getSelectedItem()) == 5) {
            double cost = totalCrits * Double.parseDouble(this.mwclient.getserverConfigs("RewardPointsForCritRepair"));
            cost = Math.ceil(cost);
            cost = Math.max(cost, 1.0);
            this.costField.setText(Integer.toString((int)cost));
        }
    }

    public void setBaseRoll() {
        if (this.critLocation < 0 || this.critSlot < 0) {
            return;
        }
        int roll = UnitUtils.getTechRoll(this.unit, this.critLocation, this.critSlot, this.techType, this.armor, this.mwclient.getData().getHouseByName(this.mwclient.getPlayer().getHouse()).getTechLevel(), this.salvage);
        this.baseRollField.setText(Integer.toString(roll));
    }

    public void keyTyped(KeyEvent arg0) {
    }

    public void keyPressed(KeyEvent arg0) {
    }

    public void keyReleased(KeyEvent arg0) {
        if (arg0.getKeyCode() == 27) {
            this.mwclient.getPlayer().resetRepairs();
            super.dispose();
        }
        if (arg0.getComponent().equals(this.numberOfRetriesField) && this.numberOfRetriesField.getValue().toString().length() != 0) {
            try {
                Integer.parseInt(this.numberOfRetriesField.getValue().toString());
            }
            catch (Exception ex) {
                this.numberOfRetriesEditor.setValue(0);
                this.numberOfRetriesField.setValue(0);
            }
        }
        if (arg0.getComponent().equals(this.workHoursField)) {
            this.workHoursField.setValue(this.workHoursField.getPreviousValue());
        }
        if (arg0.getComponent() instanceof JList) {
            this.critLocation = this.ConfigPane.getSelectedIndex();
            JList templist = (JList)arg0.getComponent();
            this.selectedSlot = templist.getSelectedIndex();
            this.setCost();
            this.setBaseRoll();
            this.setWorkHours();
        }
    }

    private void setWorkHours() {
        if (this.critLocation < 0 || this.critSlot < 0) {
            return;
        }
        int baseLine = Integer.parseInt(this.mwclient.getserverConfigs("TimeForEachRepairPoint"));
        if (!this.armor) {
            CriticalSlot cs = this.unit.getCritical(this.critLocation, this.critSlot);
            int totalCrits = UnitUtils.getNumberOfCrits(this.unit, cs);
            baseLine *= totalCrits;
        }
        if (this.techType == 4) {
            this.techType = UnitUtils.techType((String)this.techComboBox.getSelectedItem());
        }
        if (this.techType == 5) {
            baseLine = 1;
        }
        int rolls = UnitUtils.getTechRoll(this.unit, this.critLocation, this.critSlot, this.techType, this.armor, this.mwclient.getData().getHouseByName(this.mwclient.getPlayer().getHouse()).getTechLevel(), this.salvage) - 3;
        int maxCost = baseLine;
        this.baseLineCost = baseLine;
        this.techWorkMod = 0;
        Vector<Integer> tempVector = new Vector<Integer>();
        tempVector.add(baseLine / 2);
        tempVector.add(baseLine);
        for (int x = 0; x < rolls; ++x) {
            tempVector.add(maxCost *= 2);
        }
        this.workHoursModel.setList(tempVector);
        this.workHoursModel.setValue(baseLine);
        this.workHoursField.setModel(this.workHoursModel);
    }

    public void stateChanged(ChangeEvent arg0) {
        int value;
        int roll = 0;
        if (value < this.baseLineCost) {
            if (this.techType == 5) {
                this.techWorkMod = 0;
                roll = 1;
                this.baseRollField.setText(Integer.toString(roll));
            } else if (this.techType != 0) {
                this.techWorkMod = 1;
                roll = UnitUtils.getTechRoll(this.unit, this.critLocation, this.critSlot, this.techType - 1, this.armor, this.mwclient.getData().getHouseByName(this.mwclient.getPlayer().getHouse()).getTechLevel(), this.salvage);
                this.baseRollField.setText(Integer.toString(roll));
            }
            return;
        }
        if (value == this.baseLineCost) {
            this.techWorkMod = 0;
        } else {
            this.techWorkMod = 0;
            for (value = Integer.parseInt(this.workHoursModel.getValue().toString()); value > this.baseLineCost; value /= 2) {
                --this.techWorkMod;
            }
        }
        roll = UnitUtils.getTechRoll(this.unit, this.critLocation, this.critSlot, this.techType, this.armor, this.mwclient.getData().getHouseByName(this.mwclient.getPlayer().getHouse()).getTechLevel());
        this.baseRollField.setText(Integer.toString(roll + this.techWorkMod));
        this.setCost();
    }
}

