/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import common.util.UnitUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import megamek.common.Entity;
import megamek.common.Mech;

class ArmorPanel
extends JPanel {
    public JLabel armorTotal;
    public JLabel internalTotal;
    public JLabel locHL = new JLabel("Location", 0);
    public JLabel internalHL = new JLabel("Internal", 0);
    public JLabel armorHL = new JLabel("Armor", 0);
    public JLabel[] locL;
    public JLabel[] internalL;
    public JLabel[] armorL;

    public ArmorPanel() {
        super(new GridBagLayout());
        this.armorTotal = new JLabel("Armor: 999/999", 0);
        this.internalTotal = new JLabel("Internal total: ", 0);
    }

    public void displayMech(Entity en) {
        int i;
        this.removeAll();
        this.locL = new JLabel[en.locations()];
        this.internalL = new JLabel[en.locations()];
        this.armorL = new JLabel[en.locations()];
        for (int i2 = 0; i2 < en.locations(); ++i2) {
            this.locL[i2] = new JLabel("Center Torso Rear", 2);
            this.internalL[i2] = new JLabel("99", 0);
            this.armorL[i2] = new JLabel("999", 0);
        }
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        if (en instanceof Mech) {
            this.armorTotal.setText("Armor: " + en.getTotalArmor() + "/" + ((en.getTotalInternal() - 3) * 2 + 9));
        } else {
            this.armorTotal.setText("Armor: " + en.getTotalArmor());
        }
        this.add((Component)this.armorTotal, c);
        this.internalTotal.setText("Internal: " + en.getTotalInternal());
        this.add((Component)this.internalTotal, c);
        c.gridwidth = 1;
        this.add((Component)this.locHL, c);
        this.add((Component)this.armorHL, c);
        c.gridwidth = 0;
        this.add((Component)this.internalHL, c);
        for (i = 0; i < en.locations(); ++i) {
            c.gridwidth = 1;
            this.add((Component)this.locL[i], c);
            this.add((Component)this.armorL[i], c);
            c.gridwidth = 0;
            this.add((Component)this.internalL[i], c);
        }
        for (i = 0; i < en.locations(); ++i) {
            this.locL[i].setText(en.getLocationName(i));
            if (en.getInternal(i) >= 99) {
                UnitUtils.removeArmorRepair(en, 15, i);
                this.internalL[i].setText(en.getInternalString(i));
                UnitUtils.setArmorRepair(en, 15, i);
            } else {
                this.internalL[i].setText(en.getInternalString(i));
            }
            if (en.getArmor(i) >= 99) {
                UnitUtils.removeArmorRepair(en, 13, i);
                if (en.hasRearArmor(i) && en.getArmor(i, true) >= 99) {
                    UnitUtils.removeArmorRepair(en, 14, i);
                }
                this.armorL[i].setText(en.getArmorString(i) + (en.hasRearArmor(i) ? " (" + en.getArmorString(i, true) + ")" : ""));
                UnitUtils.setArmorRepair(en, 13, i);
                if (!en.hasRearArmor(i) || en.getArmor(i, true) == en.getOArmor(i, true)) continue;
                UnitUtils.setArmorRepair(en, 14, i);
                continue;
            }
            this.armorL[i].setText(en.getArmorString(i) + (en.hasRearArmor(i) ? " (" + en.getArmorString(i, true) + ")" : ""));
        }
        this.validate();
    }
}

