/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.campaign.CArmy;
import client.campaign.CPlayer;
import client.campaign.CUnit;
import client.gui.SpringLayoutHelper;
import common.Unit;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ArmyViewerDialog
extends JDialog
implements ActionListener,
KeyListener,
ListSelectionListener,
WindowListener,
ItemListener {
    private static final long serialVersionUID = -3851019509649287454L;
    private static final int KEY_TIMEOUT = 1000;
    private StringBuilder m_sbSearch = new StringBuilder();
    private long m_nLastSearch = 0L;
    private DefaultListModel defaultModel = null;
    private ListSelectionModel listSelectionModel = null;
    private JList armyList = null;
    private JScrollPane listScrollPane = null;
    private JScrollPane leftScrollPane = null;
    private JButton bCancel = new JButton("Close");
    private JButton bSelect = new JButton("Select");
    private JTextArea armyView = null;
    private JComboBox teamBox = new JComboBox();
    private CPlayer player = null;
    private String opName = null;
    private int selectedArmyId = -1;
    private TreeSet<Integer> validArmyList = new TreeSet();
    private MWClient mwclient = null;
    private String planetName = null;
    private String defenderName = null;
    private int opID = -1;
    private int teamNumbers = -1;
    private int viewerMode = 0;
    public static final int AVD_DEFEND = 0;
    public static final int AVD_ATTACK = 1;
    public static final int AVD_ATTACKFROMRESERVE = 2;
    private static final String SPACES = "                        ";

    public ArmyViewerDialog(MWClient mwclient, String opName, StringTokenizer validArmyList, int mode, String planet, String defender, int opid, int teamNumbers) {
        super(mwclient.getMainFrame(), "Army Viewer", true);
        this.player = mwclient.getPlayer();
        this.opName = opName;
        this.mwclient = mwclient;
        this.viewerMode = mode;
        this.planetName = planet;
        this.defenderName = defender;
        this.opID = opid;
        this.teamNumbers = teamNumbers;
        if (validArmyList != null) {
            while (validArmyList.hasMoreElements()) {
                this.validArmyList.add(Integer.parseInt(validArmyList.nextToken()));
            }
        }
        this.teamBox.setPreferredSize(new Dimension(100, 22));
        this.teamBox.setMaximumSize(new Dimension(100, 22));
        this.teamBox.setMinimumSize(new Dimension(100, 22));
        if (teamNumbers > 1) {
            for (int team = 1; team <= teamNumbers; ++team) {
                this.teamBox.addItem("Team #" + team);
            }
        }
        this.armyView = new JTextArea(15, 38);
        this.armyView.setAutoscrolls(true);
        this.defaultModel = new DefaultListModel();
        this.armyList = new JList(this.defaultModel);
        this.listSelectionModel = this.armyList.getSelectionModel();
        this.armyList.setVisibleRowCount(Integer.parseInt(mwclient.getserverConfigs("MaxLancesPerPlayer")));
        this.listSelectionModel.addListSelectionListener(this);
        this.listScrollPane = new JScrollPane(this.armyList);
        this.leftScrollPane = new JScrollPane(this.armyView);
        this.listScrollPane.setAlignmentX(0.0f);
        this.listScrollPane.setHorizontalScrollBarPolicy(31);
        this.leftScrollPane.setAlignmentX(0.0f);
        this.leftScrollPane.setHorizontalScrollBarPolicy(31);
        this.armyList.setSelectionMode(0);
        this.armyView.setFont(new Font("Monospaced", 0, 11));
        this.armyList.setFont(new Font("Monospaced", 0, 11));
        JPanel textBoxSpring = new JPanel(new SpringLayout());
        textBoxSpring.add(this.listScrollPane);
        textBoxSpring.add(this.leftScrollPane);
        SpringLayoutHelper.setupSpringGrid(textBoxSpring, 3);
        JPanel buttonHolder = new JPanel();
        buttonHolder.add(this.bSelect);
        buttonHolder.add(this.bCancel);
        JPanel springHolder = new JPanel(new SpringLayout());
        if (this.teamNumbers > 1) {
            springHolder.add(this.teamBox);
        }
        springHolder.add(textBoxSpring);
        springHolder.add(buttonHolder);
        SpringLayoutHelper.setupSpringGrid(springHolder, 1);
        this.getContentPane().add(springHolder);
        this.getRootPane().setDefaultButton(this.bSelect);
        this.clearArmyPreview();
        this.setSize(785, 560);
        this.setResizable(false);
        this.armyList.addListSelectionListener(this);
        this.armyList.addKeyListener(this);
        this.bCancel.addActionListener(this);
        this.bSelect.addActionListener(this);
        this.addWindowListener(this);
        this.armyList.setSelectedIndex(-1);
        this.setModal(false);
        this.sortArmies();
        this.pack();
        this.setVisible(true);
        this.armyList.requestFocus();
    }

    private void sortArmies() {
        this.defaultModel.clear();
        int x = 0;
        if (this.opName != null) {
            for (CArmy currArmy : this.player.getArmies()) {
                if (!currArmy.getLegalOperations().contains(this.opName)) continue;
                this.defaultModel.add(x++, this.formatArmy(currArmy));
            }
        } else {
            for (CArmy army : this.player.getArmies()) {
                if (!this.validArmyList.contains(army.getID())) continue;
                this.defaultModel.add(x++, this.formatArmy(army));
            }
        }
        this.repaint();
    }

    private void searchFor(String search) {
        int i = 0;
        for (CArmy army : this.player.getArmies()) {
            if (army.getName().toLowerCase().startsWith(search)) {
                this.armyList.setSelectedIndex(i);
                this.armyList.ensureIndexIsVisible(i);
                break;
            }
            ++i;
        }
    }

    public void setVisible(boolean show) {
        this.setLocationRelativeTo(null);
        super.setVisible(show);
        this.pack();
    }

    private String formatArmy(CArmy army) {
        StringBuilder result = new StringBuilder();
        result.append(this.makeLength("#" + Integer.toString(army.getID()), 3) + " ");
        result.append(this.makeLength(army.getName(), 15) + " ");
        result.append(this.makeLength("BV: " + Integer.toString(army.getBV()), 10));
        return result.toString();
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.bCancel) {
            this.setVisible(false);
            this.selectedArmyId = -1;
        }
        if (ae.getSource() == this.bSelect) {
            try {
                String armyID = (String)this.armyList.getSelectedValue();
                armyID = armyID.substring(1, armyID.indexOf(" "));
                this.selectedArmyId = Integer.parseInt(armyID);
                if (this.viewerMode == 0) {
                    int team = -1;
                    if (this.teamNumbers > 1) {
                        team = this.teamBox.getSelectedIndex() + 1;
                    }
                    this.mwclient.sendChat("/c defend#" + this.opID + "#" + armyID + "#" + team);
                } else if (this.viewerMode == 1) {
                    this.mwclient.sendChat("/c attack#" + this.opName + "#" + armyID + "#" + this.planetName);
                } else {
                    this.mwclient.sendChat("/c attackfromreserve#" + this.opName + "#" + armyID + "#" + this.planetName + "#" + this.defenderName);
                }
                this.setVisible(false);
            }
            catch (Exception ex) {
                MWClient.mwClientLog.clientErrLog(ex);
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        int selected = this.armyList.getSelectedIndex();
        if (selected == -1) {
            this.clearArmyPreview();
            return;
        }
        String armyID = (String)this.armyList.getSelectedValue();
        armyID = armyID.substring(1, armyID.indexOf(" "));
        this.previewArmy(Integer.parseInt(armyID));
    }

    public void itemStateChanged(ItemEvent ie) {
        Object currSelection = this.armyList.getSelectedValue();
        this.armyList.setSelectedValue(currSelection, true);
    }

    void clearArmyPreview() {
        this.armyView.setEditable(false);
        this.armyView.setText("");
        this.previewArmy(-1);
    }

    void previewArmy(int armyID) {
        this.armyView.setEditable(false);
        if (armyID > -1) {
            StringBuilder armyText = new StringBuilder();
            CArmy army = this.player.getArmy(armyID);
            for (Unit unit : army.getUnits()) {
                armyText.append(this.makeLength("#" + unit.getId(), 7) + " " + this.makeLength(((CUnit)unit).getModelName(), 12) + " ");
                if (unit.getType() == 1 || unit.getType() == 0) {
                    armyText.append(" (" + unit.getPilot().getGunnery() + "/" + unit.getPilot().getPiloting() + ")");
                } else {
                    armyText.append(" (" + unit.getPilot().getGunnery() + ")");
                }
                armyText.append(" BV: " + ((CUnit)unit).getBV() + "\n");
            }
            this.armyView.setText(armyText.toString());
        } else {
            this.armyView.setText("No army selected");
        }
        this.armyView.setCaretPosition(0);
    }

    public int getSelectedArmyID() {
        return this.selectedArmyId;
    }

    private String makeLength(String s, int nLength) {
        if (s.length() == nLength) {
            return s;
        }
        if (s.length() > nLength) {
            return s.substring(0, nLength - 2) + "..";
        }
        return s + SPACES.substring(0, nLength - s.length());
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyPressed(KeyEvent ke) {
        long curTime;
        if (ke.getKeyCode() == 10) {
            ActionEvent event = new ActionEvent(this.bCancel, 1001, "");
            this.actionPerformed(event);
        }
        if ((curTime = System.currentTimeMillis()) - this.m_nLastSearch > 1000L) {
            this.m_sbSearch = new StringBuilder();
        }
        this.m_nLastSearch = curTime;
        this.m_sbSearch.append(ke.getKeyChar());
        this.searchFor(this.m_sbSearch.toString().toLowerCase());
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

