/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.gui.SpringLayoutHelper;
import common.House;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public final class TraitDialog
implements ActionListener,
KeyListener {
    private MWClient mwclient = null;
    private static final String okayCommand = "Add";
    private static final String cancelCommand = "Close";
    private static final String removeCommand = "Remove";
    private static final String traitCommand = "Trait";
    private static final String factionCommand = "Faction";
    private String windowName = "Trait Editor";
    private static final String delimiter = "*";
    private final JButton okayButton = new JButton("Add");
    private final JButton cancelButton = new JButton("Close");
    private final JButton removeButton = new JButton("Remove");
    private final JLabel factionLabel = new JLabel("faction:", 11);
    private final JLabel traitLabel = new JLabel("Trait:", 11);
    private final JLabel gunneryLaserLabel = new JLabel("G/L:", 11);
    private final JLabel gunneryBalisticLabel = new JLabel("G/B:", 11);
    private final JLabel gunneryMissileLabel = new JLabel("G/M:", 11);
    private final JLabel astechLabel = new JLabel("AT:", 11);
    private final JLabel tacticalGeniusLabel = new JLabel("TG:", 11);
    private final JLabel weaponSpecialistLabel = new JLabel("WS:", 11);
    private final JLabel meleeSpecialistLabel = new JLabel("MS:", 11);
    private final JLabel dodgeManeuverLabel = new JLabel("DM:", 11);
    private final JLabel ironManLabel = new JLabel("IM:", 11);
    private final JLabel maneuveringAceLabel = new JLabel("MA:", 11);
    private final JLabel NAGLabel = new JLabel("NAG:", 11);
    private final JLabel NAPLabel = new JLabel("NAP:", 11);
    private final JLabel painResistanceLabel = new JLabel("PR:", 11);
    private final JLabel survivalistSkillLabel = new JLabel("SV:", 11);
    private final JLabel enhancedInterfaceLabel = new JLabel("EI:", 11);
    private final JLabel quickStudyLabel = new JLabel("QS:", 11);
    private final JLabel giftedLabel = new JLabel("GT:", 11);
    private final JLabel medtechLabel = new JLabel("MT:", 11);
    private final JTextField gunneryLaserText = new JTextField(3);
    private final JTextField gunneryBalisticText = new JTextField(3);
    private final JTextField gunneryMissileText = new JTextField(3);
    private final JTextField astechText = new JTextField(3);
    private final JTextField tacticalGeniusText = new JTextField(3);
    private final JTextField weaponSpecialistText = new JTextField(3);
    private final JTextField meleeSpecialistText = new JTextField(3);
    private final JTextField dodgeManeuverText = new JTextField(3);
    private final JTextField ironManText = new JTextField(3);
    private final JTextField maneuveringAceText = new JTextField(3);
    private final JTextField NAGText = new JTextField(3);
    private final JTextField NAPText = new JTextField(3);
    private final JTextField painResistanceText = new JTextField(3);
    private final JTextField survivalistSkillText = new JTextField(3);
    private final JTextField enhancedInterfaceText = new JTextField(3);
    private final JTextField quickStudyText = new JTextField(3);
    private final JTextField giftedText = new JTextField(3);
    private final JTextField medtechText = new JTextField(3);
    private JComboBox factionComboBox = new JComboBox();
    private JComboBox traitComboBox = new JComboBox();
    private JDialog dialog;
    private JOptionPane pane;
    JTabbedPane ConfigPane = new JTabbedPane(1);

    public TraitDialog(MWClient c, boolean player) {
        this.mwclient = c;
        TreeSet<String> names = new TreeSet<String>();
        names.add("Common");
        Iterator<House> factions = this.mwclient.getData().getAllHouses().iterator();
        while (factions.hasNext()) {
            names.add(factions.next().getName());
        }
        this.factionComboBox = new JComboBox<Object>(names.toArray());
        this.traitComboBox.setEditable(!player);
        this.okayButton.setActionCommand(okayCommand);
        this.cancelButton.setActionCommand(cancelCommand);
        this.factionComboBox.setActionCommand(factionCommand);
        this.traitComboBox.setActionCommand(traitCommand);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.okayButton.setToolTipText("Save Trait");
        if (player) {
            this.cancelButton.setToolTipText("Exit");
            this.windowName = "Trait Viewer";
        } else {
            this.cancelButton.setToolTipText("Exit without saving changes");
        }
        this.removeButton.setToolTipText("Delete Trait");
        this.traitComboBox.addActionListener(this);
        this.factionComboBox.addActionListener(this);
        this.okayButton.setVisible(!player);
        this.removeButton.setVisible(!player);
        JPanel traitsPanel = new JPanel();
        traitsPanel.setLayout(new BoxLayout(traitsPanel, 1));
        JPanel skillPanel = new JPanel(new SpringLayout());
        JPanel comboPanel = new JPanel(new SpringLayout());
        comboPanel.add(this.factionLabel);
        this.factionComboBox.setToolTipText("Select a faction");
        comboPanel.add(this.factionComboBox);
        comboPanel.add(this.traitLabel);
        if (player) {
            this.traitComboBox.setToolTipText("Select a trait.");
        } else {
            this.traitComboBox.setToolTipText("Select a trait or enter a new one.");
        }
        comboPanel.add(this.traitComboBox);
        skillPanel.add(this.astechLabel);
        this.astechText.setToolTipText("<html>Astech<br>Modifies the chance for a pilot to receive this skill</html>");
        this.astechText.setEditable(!player);
        skillPanel.add(this.astechText);
        skillPanel.add(this.dodgeManeuverLabel);
        this.dodgeManeuverText.setToolTipText("<html>Dodge Maneuver<br>Modifies the chance for a pilot to receive this skill</html>");
        this.dodgeManeuverText.setEditable(!player);
        skillPanel.add(this.dodgeManeuverText);
        skillPanel.add(this.enhancedInterfaceLabel);
        this.enhancedInterfaceText.setToolTipText("<html>Enhanced Interface<br>Modifies the chance for a pilot to receive this skill</html>");
        this.enhancedInterfaceText.setEditable(!player);
        skillPanel.add(this.enhancedInterfaceText);
        skillPanel.add(this.giftedLabel);
        this.giftedText.setToolTipText("<html>Gifted<br>Modifies the chance for a pilot to receive this skill</html>");
        this.giftedText.setEditable(!player);
        skillPanel.add(this.giftedText);
        skillPanel.add(this.gunneryLaserLabel);
        this.gunneryLaserText.setToolTipText("<html>Gunnery Laser<br>Modifies the chance for a pilot to receive this skill</html>");
        this.gunneryLaserText.setEditable(!player);
        skillPanel.add(this.gunneryLaserText);
        skillPanel.add(this.gunneryBalisticLabel);
        this.gunneryBalisticText.setToolTipText("<html>Gunnery Ballistic<br>Modifies the chance for a pilot to receive this skill</html>");
        this.gunneryBalisticText.setEditable(!player);
        skillPanel.add(this.gunneryBalisticText);
        skillPanel.add(this.gunneryMissileLabel);
        this.gunneryMissileText.setToolTipText("<html>Gunnery Missile<br>Modifies the chance for a pilot to receive this skill</html>");
        this.gunneryMissileText.setEditable(!player);
        skillPanel.add(this.gunneryMissileText);
        skillPanel.add(this.ironManLabel);
        this.ironManText.setToolTipText("<html>Iron Man<br>Modifies the chance for a pilot to receive this skill</html>");
        this.ironManText.setEditable(!player);
        skillPanel.add(this.ironManText);
        skillPanel.add(this.maneuveringAceLabel);
        this.maneuveringAceText.setToolTipText("<html>Maneuvering Ace<br>Modifies the chance for a pilot to receive this skill</html>");
        this.maneuveringAceText.setEditable(!player);
        skillPanel.add(this.maneuveringAceText);
        skillPanel.add(this.medtechLabel);
        this.medtechText.setToolTipText("<html>Medtech<br>Modifies the chance for a pilot to receive this skill</html>");
        this.medtechText.setEditable(!player);
        skillPanel.add(this.medtechText);
        skillPanel.add(this.meleeSpecialistLabel);
        this.meleeSpecialistText.setToolTipText("<html>Melee Specialist<br>Modifies the chance for a pilot to receive this skill</html>");
        this.meleeSpecialistText.setEditable(!player);
        skillPanel.add(this.meleeSpecialistText);
        skillPanel.add(this.NAGLabel);
        this.NAGText.setToolTipText("<html>Natural Aptitiude: Gunnery<br>Modifies the chance for a pilot to receive this skill</html>");
        this.NAGText.setEditable(!player);
        skillPanel.add(this.NAGText);
        skillPanel.add(this.NAPLabel);
        this.NAPText.setToolTipText("<html>Natural Aptitude: Piloting<br>Modifies the chance for a pilot to receive this skill</html>");
        this.NAPText.setEditable(!player);
        skillPanel.add(this.NAPText);
        skillPanel.add(this.painResistanceLabel);
        this.painResistanceText.setToolTipText("<html>Pain Resistance<br>Modifies the chance for a pilot to receive this skill</html>");
        this.painResistanceText.setEditable(!player);
        skillPanel.add(this.painResistanceText);
        skillPanel.add(this.quickStudyLabel);
        this.quickStudyText.setToolTipText("<html>Quick Study</html>");
        this.quickStudyText.setEditable(!player);
        skillPanel.add(this.quickStudyText);
        skillPanel.add(this.survivalistSkillLabel);
        this.survivalistSkillText.setToolTipText("<html>Survivalist</html>");
        this.survivalistSkillText.setEditable(!player);
        skillPanel.add(this.survivalistSkillText);
        skillPanel.add(this.tacticalGeniusLabel);
        this.tacticalGeniusText.setToolTipText("<html>Tactical Genius</html>");
        this.tacticalGeniusText.setEditable(!player);
        skillPanel.add(this.tacticalGeniusText);
        skillPanel.add(this.weaponSpecialistLabel);
        this.weaponSpecialistText.setToolTipText("<html>Weapon Specialist</html>");
        this.weaponSpecialistText.setEditable(!player);
        skillPanel.add(this.weaponSpecialistText);
        SpringLayoutHelper.setupSpringGrid(comboPanel, 2);
        SpringLayoutHelper.setupSpringGrid(skillPanel, 8);
        traitsPanel.add(comboPanel);
        traitsPanel.add(skillPanel);
        JPanel mainPanel = new JPanel();
        Object[] options = new Object[]{this.okayButton, this.removeButton, this.cancelButton};
        this.pane = new JOptionPane(traitsPanel, -1, -1, null, options, null);
        this.dialog = this.pane.createDialog(mainPanel, this.windowName);
        this.dialog.getRootPane().setDefaultButton(this.cancelButton);
        this.loadAllFiles();
        this.factionComboBox.setSelectedIndex(0);
        this.dialog.setModal(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
        if (this.pane.getValue() != this.okayButton) {
            this.dialog.dispose();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        String faction = (String)this.factionComboBox.getSelectedItem();
        String trait = ((String)this.traitComboBox.getSelectedItem()).trim();
        if (e.getComponent().equals(this.factionComboBox)) {
            this.loadFactionTraits(faction);
        } else {
            this.populateTraits(faction, trait);
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(okayCommand)) {
            String faction = (String)this.factionComboBox.getSelectedItem();
            String trait = ((String)this.traitComboBox.getSelectedItem()).trim();
            if (trait.trim().length() < 1) {
                JOptionPane.showMessageDialog(null, "You did not enter a trait name!");
                return;
            }
            String result = this.getResults(faction, trait);
            this.mwclient.sendChat("/c addtrait#" + result);
            this.loadAllFiles();
            this.loadFactionTraits(faction);
        } else if (command.equals(cancelCommand)) {
            this.pane.setValue(this.cancelButton);
            this.dialog.dispose();
        } else if (command.equals(removeCommand)) {
            String faction = (String)this.factionComboBox.getSelectedItem();
            String trait = ((String)this.traitComboBox.getSelectedItem()).trim();
            if (trait.length() < 1) {
                JOptionPane.showMessageDialog(null, "You have to select a trait before you can remove it!");
                return;
            }
            int choice = JOptionPane.showConfirmDialog(null, "Are you sure you want to remove this trait?", "Remove it?", 0);
            if (choice == 0) {
                this.mwclient.sendChat("/c removetrait#" + faction + "#" + trait + "#CONFIRM");
                this.loadAllFiles();
                this.loadFactionTraits(faction);
            }
        } else if (command.equals(factionCommand)) {
            String selection = (String)this.factionComboBox.getSelectedItem();
            this.loadFactionTraits(selection);
        } else if (command.equals(traitCommand)) {
            String faction = (String)this.factionComboBox.getSelectedItem();
            if (this.traitComboBox.getSelectedItem() == null) {
                return;
            }
            String trait = ((String)this.traitComboBox.getSelectedItem()).trim();
            this.populateTraits(faction, trait);
        }
    }

    private void loadFactionTraits(String faction) {
        File traitFile = new File(this.mwclient.getCacheDir() + "/" + faction.toLowerCase() + "traitnames.txt");
        TreeSet<String> names = new TreeSet<String>();
        if (this.traitComboBox.getItemCount() > 0) {
            this.traitComboBox.removeAllItems();
        }
        try {
            FileInputStream fis = new FileInputStream(traitFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            while (dis.ready()) {
                StringTokenizer traitName = new StringTokenizer(dis.readLine(), delimiter);
                names.add(traitName.nextToken());
            }
            Object[] tempArray = names.toArray();
            for (int i = 0; i < tempArray.length; ++i) {
                this.traitComboBox.addItem(tempArray[i]);
            }
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog("Unable to load faction " + faction);
            MWClient.mwClientLog.clientErrLog(ex);
        }
        if (this.traitComboBox.getItemCount() > 0) {
            this.traitComboBox.setSelectedIndex(0);
        }
        this.traitComboBox.revalidate();
    }

    private void loadAllFiles() {
        this.mwclient.loadServerTraitFiles();
    }

    private void populateTraits(String faction, String trait) {
        File traitFile = new File(this.mwclient.getCacheDir() + "/" + faction.toLowerCase() + "traitnames.txt");
        this.gunneryLaserText.setText("0");
        this.gunneryBalisticText.setText("0");
        this.gunneryMissileText.setText("0");
        this.astechText.setText("0");
        this.tacticalGeniusText.setText("0");
        this.weaponSpecialistText.setText("0");
        this.meleeSpecialistText.setText("0");
        this.dodgeManeuverText.setText("0");
        this.ironManText.setText("0");
        this.maneuveringAceText.setText("0");
        this.NAGText.setText("0");
        this.NAPText.setText("0");
        this.painResistanceText.setText("0");
        this.survivalistSkillText.setText("0");
        this.enhancedInterfaceText.setText("0");
        this.giftedText.setText("0");
        this.quickStudyText.setText("0");
        this.medtechText.setText("0");
        try {
            FileInputStream fis = new FileInputStream(traitFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            while (dis.ready()) {
                StringTokenizer traitNames = new StringTokenizer(dis.readLine(), delimiter);
                String traitName = traitNames.nextToken();
                if (!traitName.equalsIgnoreCase(trait)) continue;
                while (traitNames.hasMoreTokens()) {
                    int traitID = Integer.parseInt(traitNames.nextToken());
                    String traitMod = traitNames.nextToken();
                    if (traitID == 9) {
                        this.gunneryBalisticText.setText(traitMod);
                        continue;
                    }
                    if (traitID == 10) {
                        this.gunneryLaserText.setText(traitMod);
                        continue;
                    }
                    if (traitID == 11) {
                        this.gunneryMissileText.setText(traitMod);
                        continue;
                    }
                    if (traitID == 2) {
                        this.astechText.setText(traitMod);
                        continue;
                    }
                    if (traitID == 1) {
                        this.dodgeManeuverText.setText(traitMod);
                        continue;
                    }
                    if (traitID == 13) {
                        this.ironManText.setText(traitMod);
                        continue;
                    }
                    if (traitID == 7) {
                        this.maneuveringAceText.setText(traitMod);
                        continue;
                    }
                    if (traitID == 3) {
                        this.meleeSpecialistText.setText(traitMod);
                        continue;
                    }
                    if (traitID == 5) {
                        this.NAGText.setText(traitMod);
                        continue;
                    }
                    if (traitID == 6) {
                        this.NAPText.setText(traitMod);
                        continue;
                    }
                    if (traitID == 4) {
                        this.painResistanceText.setText(traitMod);
                        continue;
                    }
                    if (traitID == 14) {
                        this.survivalistSkillText.setText(traitMod);
                        continue;
                    }
                    if (traitID == 8) {
                        this.tacticalGeniusText.setText(traitMod);
                        continue;
                    }
                    if (traitID == 12) {
                        this.weaponSpecialistText.setText(traitMod);
                        continue;
                    }
                    if (traitID == 16) {
                        this.enhancedInterfaceText.setText(traitMod);
                        continue;
                    }
                    if (traitID == 18) {
                        this.giftedText.setText(traitMod);
                        continue;
                    }
                    if (traitID == 17) {
                        this.quickStudyText.setText(traitMod);
                        continue;
                    }
                    if (traitID != 19) continue;
                    this.medtechText.setText(traitMod);
                }
            }
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog("populate Traits error");
            MWClient.mwClientLog.clientErrLog(ex);
        }
    }

    public String getResults(String faction, String trait) {
        String result = faction + "#" + trait + "#";
        if (Integer.parseInt(this.gunneryBalisticText.getText()) != 0) {
            result = result + 9;
            result = result + delimiter;
            result = result + this.gunneryBalisticText.getText();
            result = result + delimiter;
        }
        if (Integer.parseInt(this.gunneryLaserText.getText()) != 0) {
            result = result + 10;
            result = result + delimiter;
            result = result + this.gunneryLaserText.getText();
            result = result + delimiter;
        }
        if (Integer.parseInt(this.gunneryMissileText.getText()) != 0) {
            result = result + 11;
            result = result + delimiter;
            result = result + this.gunneryMissileText.getText();
            result = result + delimiter;
        }
        if (Integer.parseInt(this.astechText.getText()) != 0) {
            result = result + 2;
            result = result + delimiter;
            result = result + this.astechText.getText();
            result = result + delimiter;
        }
        if (Integer.parseInt(this.dodgeManeuverText.getText()) != 0) {
            result = result + 1;
            result = result + delimiter;
            result = result + this.dodgeManeuverText.getText();
            result = result + delimiter;
        }
        if (Integer.parseInt(this.ironManText.getText()) != 0) {
            result = result + 13;
            result = result + delimiter;
            result = result + this.ironManText.getText();
            result = result + delimiter;
        }
        if (Integer.parseInt(this.maneuveringAceText.getText()) != 0) {
            result = result + 7;
            result = result + delimiter;
            result = result + this.maneuveringAceText.getText();
            result = result + delimiter;
        }
        if (Integer.parseInt(this.meleeSpecialistText.getText()) != 0) {
            result = result + 3;
            result = result + delimiter;
            result = result + this.meleeSpecialistText.getText();
            result = result + delimiter;
        }
        if (Integer.parseInt(this.NAGText.getText()) != 0) {
            result = result + 5;
            result = result + delimiter;
            result = result + this.NAGText.getText();
            result = result + delimiter;
        }
        if (Integer.parseInt(this.NAPText.getText()) != 0) {
            result = result + 6;
            result = result + delimiter;
            result = result + this.NAPText.getText();
            result = result + delimiter;
        }
        if (Integer.parseInt(this.painResistanceText.getText()) != 0) {
            result = result + 4;
            result = result + delimiter;
            result = result + this.painResistanceText.getText();
            result = result + delimiter;
        }
        if (Integer.parseInt(this.survivalistSkillText.getText()) != 0) {
            result = result + 14;
            result = result + delimiter;
            result = result + this.survivalistSkillText.getText();
            result = result + delimiter;
        }
        if (Integer.parseInt(this.tacticalGeniusText.getText()) != 0) {
            result = result + 8;
            result = result + delimiter;
            result = result + this.tacticalGeniusText.getText();
            result = result + delimiter;
        }
        if (Integer.parseInt(this.weaponSpecialistText.getText()) != 0) {
            result = result + 12;
            result = result + delimiter;
            result = result + this.weaponSpecialistText.getText();
            result = result + delimiter;
        }
        if (Integer.parseInt(this.enhancedInterfaceText.getText()) != 0) {
            result = result + 16;
            result = result + delimiter;
            result = result + this.enhancedInterfaceText.getText();
            result = result + delimiter;
        }
        if (Integer.parseInt(this.giftedText.getText()) != 0) {
            result = result + 18;
            result = result + delimiter;
            result = result + this.giftedText.getText();
            result = result + delimiter;
        }
        if (Integer.parseInt(this.quickStudyText.getText()) != 0) {
            result = result + 17;
            result = result + delimiter;
            result = result + this.quickStudyText.getText();
            result = result + delimiter;
        }
        if (Integer.parseInt(this.medtechText.getText()) != 0) {
            result = result + 19;
            result = result + delimiter;
            result = result + this.medtechText.getText();
            result = result + delimiter;
        }
        result = result + "#CONFIRM";
        return result;
    }
}

