/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.gui.CMainFrame;
import client.gui.MechInfo;
import client.gui.SpringLayoutHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import megamek.client.ui.AWT.MechView;
import megamek.client.ui.AWT.UnitFailureDialog;
import megamek.client.ui.AWT.UnitLoadingDialog;
import megamek.common.Entity;
import megamek.common.EntityWeightClass;
import megamek.common.EquipmentType;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.common.MechSummaryComparator;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.TechConstants;
import megamek.common.UnitType;
import megamek.common.WeaponType;
import megamek.common.loaders.EntityLoadingException;

public class UnitViewerDialog
extends JFrame
implements ActionListener,
KeyListener,
ListSelectionListener,
Runnable,
WindowListener,
ItemListener {
    private static final int KEY_TIMEOUT = 1000;
    public static final int UNIT_VIEWER = 0;
    public static final int OMNI_VARIANT_SELECTOR = 1;
    public static final int UNIT_SELECTOR = 2;
    private String[] saSorts = new String[]{"Name", "Ref", "Weight", "BV"};
    private CMainFrame clientgui;
    private MechSummary[] mechsCurrent;
    private UnitLoadingDialog unitLoadingDialog;
    private StringBuilder m_sbSearch = new StringBuilder();
    private long m_nLastSearch = 0L;
    private JLabel labelType = new JLabel("Tech: ", 4);
    private JComboBox chType = new JComboBox();
    private JLabel labelUnitType = new JLabel("Type: ", 4);
    private JComboBox chUnitType = new JComboBox();
    private JLabel labelWeightClass = new JLabel("Class: ", 4);
    private JComboBox chWeightClass = new JComboBox();
    private JLabel labelSort = new JLabel("Sort: ", 4);
    private JComboBox chSort = new JComboBox();
    private JPanel pParams = new JPanel();
    private JPanel textBoxSpring = new JPanel(new SpringLayout());
    private JPanel springHolder = new JPanel(new SpringLayout());
    private JPanel fluffBoxSpring = new JPanel(new SpringLayout());
    DefaultListModel defaultModel = null;
    ListSelectionModel listSelectionModel = null;
    JList mechList = null;
    JScrollPane listScrollPane = null;
    JScrollPane leftScrollPane = null;
    JScrollPane rightScrollPane = null;
    JScrollPane fluffScrollPane = null;
    private JButton bCancel = new JButton("Close");
    private JButton bSelect = new JButton("Select");
    private JTextArea mechViewLeft = null;
    private JTextArea mechViewRight = null;
    private JTextArea unitFluff = null;
    private JPanel pUpper = new JPanel();
    private JPanel pPreview = new JPanel();
    private MWClient mwclient = null;
    private int viewerType = 0;
    private boolean viewFluff = false;
    private JPanel m_pOpenAdvanced = new JPanel();
    private JButton m_bToggleAdvanced = new JButton("< Show Advanced Search >");
    private JPanel m_pSouthParams = new JPanel();
    private JComboBox m_cWalk = new JComboBox();
    private JTextField m_tWalk = new JTextField(2);
    private JComboBox m_cJump = new JComboBox();
    private JTextField m_tJump = new JTextField(2);
    private JComboBox m_cArmor = new JComboBox();
    private JTextField m_tWeapons1 = new JTextField(2);
    private JComboBox m_cWeapons1 = new JComboBox();
    private JComboBox m_cOrAnd = new JComboBox();
    private JTextField m_tWeapons2 = new JTextField(2);
    private JComboBox m_cWeapons2 = new JComboBox();
    private JCheckBox m_chkEquipment = new JCheckBox();
    private JComboBox m_cEquipment = new JComboBox();
    private JButton m_bSearch = new JButton("Search");
    private JButton m_bReset = new JButton("Reset");
    private JLabel m_lCount = new JLabel();
    private int m_count;
    private int m_old_nType;
    private int m_old_nUnitType;
    private static final String SPACES = "                        ";

    public UnitViewerDialog(CMainFrame cl, UnitLoadingDialog uld, MWClient mwclient, int viewer) {
        super("Unit Viewer");
        this.viewerType = viewer;
        if (this.viewerType == 1) {
            this.setTitle("Omni Variant Selector");
        } else if (this.viewerType == 2) {
            this.setTitle("Unit Selector");
        }
        this.clientgui = cl;
        this.unitLoadingDialog = uld;
        this.mwclient = mwclient;
        this.viewFluff = Boolean.parseBoolean(mwclient.getConfigParam("VIEWFLUFF"));
        this.mechViewLeft = new JTextArea(17, 29);
        this.mechViewRight = new JTextArea(17, 34);
        this.unitFluff = new JTextArea(10, 40);
        this.defaultModel = new DefaultListModel();
        this.mechList = new JList(this.defaultModel);
        this.listSelectionModel = this.mechList.getSelectionModel();
        this.mechList.setVisibleRowCount(17);
        this.listSelectionModel.addListSelectionListener(this);
        this.listScrollPane = new JScrollPane(this.mechList);
        this.leftScrollPane = new JScrollPane(this.mechViewLeft);
        this.rightScrollPane = new JScrollPane(this.mechViewRight);
        this.fluffScrollPane = new JScrollPane(this.unitFluff);
        this.listScrollPane.setAlignmentX(0.0f);
        this.listScrollPane.setHorizontalScrollBarPolicy(31);
        this.leftScrollPane.setAlignmentX(0.0f);
        this.leftScrollPane.setHorizontalScrollBarPolicy(31);
        this.rightScrollPane.setAlignmentX(0.0f);
        this.rightScrollPane.setHorizontalScrollBarPolicy(31);
        this.fluffScrollPane.setAlignmentX(0.0f);
        this.fluffScrollPane.setHorizontalScrollBarPolicy(31);
        this.fluffScrollPane.setVerticalScrollBarPolicy(22);
        this.mechList.setSelectionMode(0);
        this.mechViewLeft.setFont(new Font("Monospaced", 0, 11));
        this.mechViewRight.setFont(new Font("Monospaced", 0, 11));
        this.mechList.setFont(new Font("Monospaced", 0, 11));
        for (int x = 0; x < this.saSorts.length; ++x) {
            this.chSort.addItem(this.saSorts[x]);
        }
        String sort = mwclient.getConfigParam("UNITVIEWERSORT");
        this.chSort.setSelectedItem(sort);
        this.pPreview = new MechInfo(mwclient);
        this.pPreview.setVisible(false);
        this.pPreview.setMinimumSize(new Dimension(86, 74));
        this.pPreview.setMaximumSize(new Dimension(86, 74));
        this.pUpper.setLayout(new BorderLayout());
        this.pUpper.add((Component)this.pParams, "West");
        this.pUpper.add((Component)this.pPreview, "Center");
        this.pUpper.add((Component)this.m_pSouthParams, "South");
        this.pParams.setLayout(new GridLayout(4, 2));
        this.pParams.add(this.labelWeightClass);
        this.pParams.add(this.chWeightClass);
        this.pParams.add(this.labelType);
        this.pParams.add(this.chType);
        this.pParams.add(this.labelUnitType);
        this.pParams.add(this.chUnitType);
        this.pParams.add(this.labelSort);
        this.pParams.add(this.chSort);
        this.pParams.doLayout();
        this.populateChoices();
        this.populateJComboBoxs();
        this.buildSouthParams(false);
        this.getContentPane().add(this.springHolder);
        this.clearMechPreview();
        this.setSize(785, 560);
        this.setResizable(false);
        this.chWeightClass.addItemListener(this);
        this.chType.addItemListener(this);
        this.chUnitType.addItemListener(this);
        this.chSort.addItemListener(this);
        this.mechList.addListSelectionListener(this);
        this.mechList.addKeyListener(this);
        this.bCancel.addActionListener(this);
        this.bSelect.addActionListener(this);
        this.m_bSearch.addActionListener(this);
        this.m_bReset.addActionListener(this);
        this.m_bToggleAdvanced.addActionListener(this);
        this.addWindowListener(this);
    }

    public void run() {
        this.filterMechs();
        this.unitLoadingDialog.setVisible(false);
        Hashtable hFailedFiles = MechSummaryCache.getInstance().getFailedFiles();
        if (hFailedFiles != null && hFailedFiles.size() > 0) {
            new UnitFailureDialog((Frame)this.clientgui, hFailedFiles);
        }
        try {
            String previousIndex = this.mwclient.getConfigParam("UNITVIEWERUNIT");
            this.mechList.setSelectedValue(previousIndex, true);
        }
        catch (Exception e) {
            this.mechList.setSelectedIndex(-1);
        }
        this.pPreview.setVisible(true);
        this.setVisible(true);
        this.mechList.requestFocus();
    }

    private void buildSouthParams(boolean showAdvanced) {
        if (showAdvanced) {
            this.m_bToggleAdvanced.setText("> Hide Advanced Search <");
            this.m_pOpenAdvanced.add(this.m_bToggleAdvanced);
            this.m_pSouthParams.setLayout(new GridLayout(5, 1));
            this.m_pSouthParams.add(this.m_pOpenAdvanced);
            JPanel row1 = new JPanel();
            row1.setLayout(new FlowLayout(1));
            row1.add(new JLabel("Walk"));
            row1.add(this.m_cWalk);
            row1.add(this.m_tWalk);
            row1.add(new JLabel("Jump"));
            row1.add(this.m_cJump);
            row1.add(this.m_tJump);
            row1.add(new JLabel("Armor"));
            row1.add(this.m_cArmor);
            this.m_pSouthParams.add(row1);
            JPanel row2 = new JPanel();
            row2.setLayout(new FlowLayout(0));
            row2.add(new JLabel("Weapons:"));
            row2.add(new JLabel("At least"));
            row2.add(this.m_tWeapons1);
            row2.add(this.m_cWeapons1);
            row2.add(this.m_cOrAnd);
            row2.add(new JLabel("At least"));
            row2.add(this.m_tWeapons2);
            row2.add(this.m_cWeapons2);
            this.m_pSouthParams.add(row2);
            JPanel row3 = new JPanel();
            row3.setLayout(new FlowLayout(1));
            row3.add(new JLabel("Equipment"));
            row3.add(this.m_chkEquipment);
            row3.add(this.m_cEquipment);
            this.m_pSouthParams.add(row3);
            JPanel row4 = new JPanel();
            row4.add(this.m_bSearch);
            row4.add(this.m_bReset);
            row4.add(this.m_lCount);
            this.m_pSouthParams.add(row4);
        } else {
            this.m_bToggleAdvanced.setText("< Show Advanced Search >");
            this.m_pOpenAdvanced.add(this.m_bToggleAdvanced);
            this.m_pSouthParams.setLayout(new GridLayout(2, 1));
            this.m_pSouthParams.add(this.m_pOpenAdvanced);
        }
        this.paintScreen(false);
    }

    private void toggleAdvanced() {
        this.pUpper.remove(this.m_pSouthParams);
        this.m_pSouthParams = new JPanel();
        this.buildSouthParams(this.m_bToggleAdvanced.getText().equals("< Show Advanced Search >"));
        this.pUpper.add((Component)this.m_pSouthParams, "South");
        this.pack();
        this.repaint();
    }

    private void populateJComboBoxs() {
        String weight = this.mwclient.getConfigParam("UNITVIEWERWEIGHT");
        this.chWeightClass.setSelectedItem(weight);
        String tech = this.mwclient.getConfigParam("UNITVIEWERTECH");
        this.chType.setSelectedItem(tech);
        String type = this.mwclient.getConfigParam("UNITVIEWERTYPE");
        this.chUnitType.setSelectedItem(type);
    }

    private void saveComboBoxSettings() {
        this.mwclient.getConfig().setParam("UNITVIEWERWEIGHT", (String)this.chWeightClass.getSelectedItem());
        this.mwclient.getConfig().setParam("UNITVIEWERTECH", (String)this.chType.getSelectedItem());
        this.mwclient.getConfig().setParam("UNITVIEWERTYPE", (String)this.chUnitType.getSelectedItem());
        this.mwclient.getConfig().setParam("UNITVIEWERSORT", (String)this.chSort.getSelectedItem());
        if (this.mechList.getSelectedValue() != null) {
            this.mwclient.getConfig().setParam("UNITVIEWERUNIT", this.mechList.getSelectedValue().toString());
        }
        this.mwclient.getConfig().saveConfig();
        this.mwclient.setConfig();
    }

    private void filterMechs() {
        this.filterMechs(false);
    }

    private void filterMechs(boolean calledByAdvancedSearch) {
        Vector<MechSummary> vMechs = new Vector<MechSummary>();
        int nType = this.chType.getSelectedIndex();
        int nUnitType = this.chUnitType.getSelectedIndex();
        int nClass = this.chWeightClass.getSelectedIndex();
        MechSummary[] mechs = MechSummaryCache.getInstance().getAllMechs();
        if (mechs == null) {
            System.err.println("No units to filter!");
            return;
        }
        try {
            for (int x = 0; x < mechs.length; ++x) {
                if (mechs[x].getName().startsWith("Error") || nClass != EntityWeightClass.SIZE && mechs[x].getWeightClass() != nClass || nType != 7 && nType != mechs[x].getType() && (nType != 4 || mechs[x].getType() != 0 && mechs[x].getType() != 1 && mechs[x].getType() != 2) && (nType != 3 || mechs[x].getType() != 0 && mechs[x].getType() != 1) || nUnitType != UnitType.SIZE && !mechs[x].getUnitType().equals(UnitType.getTypeName(nUnitType))) continue;
                vMechs.add(mechs[x]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("mechs size: " + mechs.length);
        }
        this.mechsCurrent = new MechSummary[vMechs.size()];
        this.m_count = vMechs.size();
        if (!(calledByAdvancedSearch || this.m_old_nType == nType && this.m_old_nUnitType == nUnitType)) {
            this.populateWeaponsAndEquipmentChoices();
        }
        this.m_old_nType = nType;
        this.m_old_nUnitType = nUnitType;
        vMechs.copyInto(this.mechsCurrent);
        this.sortMechs();
    }

    private void populateChoices() {
        int i;
        for (i = 0; i < EntityWeightClass.SIZE; ++i) {
            this.chWeightClass.addItem(EntityWeightClass.getClassName(i));
        }
        this.chWeightClass.addItem("All");
        this.chWeightClass.setSelectedIndex(0);
        for (i = 0; i < TechConstants.SIZE; ++i) {
            this.chType.addItem(TechConstants.getLevelDisplayableName(i));
        }
        this.chType.setSelectedIndex(0);
        for (i = 0; i < UnitType.SIZE; ++i) {
            this.chUnitType.addItem(UnitType.getTypeDisplayableName(i));
        }
        this.chUnitType.addItem("All");
        this.chUnitType.setSelectedIndex(0);
        this.m_cWalk.addItem("At Least");
        this.m_cWalk.addItem("Equal To");
        this.m_cWalk.addItem("No More Than");
        this.m_cJump.addItem("At Least");
        this.m_cJump.addItem("Equal To");
        this.m_cJump.addItem("No More Than");
        this.m_cArmor.addItem("Any");
        this.m_cArmor.addItem("%25 maximum");
        this.m_cArmor.addItem("%50 maximum");
        this.m_cArmor.addItem("%75 maximum");
        this.m_cArmor.addItem("%90 maximum");
        this.m_cOrAnd.addItem("or");
        this.m_cOrAnd.addItem("and");
        this.populateWeaponsAndEquipmentChoices();
    }

    private void populateWeaponsAndEquipmentChoices() {
        this.m_cWeapons1.removeAllItems();
        this.m_cWeapons2.removeAllItems();
        this.m_cEquipment.removeAllItems();
        this.m_tWeapons1.setText("");
        this.m_tWeapons2.setText("");
        this.m_chkEquipment.setSelected(false);
        int nType = this.chType.getSelectedIndex();
        int nUnitType = this.chUnitType.getSelectedIndex();
        Enumeration e = EquipmentType.getAllTypes();
        while (e.hasMoreElements()) {
            EquipmentType et = (EquipmentType)e.nextElement();
            if (!(!(et instanceof WeaponType) || et.getTechLevel() != nType && nType != 7 && (nType != 4 || et.getTechLevel() != 0 && et.getTechLevel() != 1 && et.getTechLevel() != 2) && (nType != 3 && nType != 1 || et.getTechLevel() != 0 && et.getTechLevel() != 1))) {
                if (!(nUnitType == UnitType.SIZE || !UnitType.getTypeName(nUnitType).equals("Mek") && !UnitType.getTypeName(nUnitType).equals("Tank") || !et.hasFlag(64L) && !et.hasFlag(2048L) && !et.hasFlag(4096L))) continue;
                this.m_cWeapons1.addItem(et.getName());
                this.m_cWeapons2.addItem(et.getName());
            }
            if (!(et instanceof MiscType) || et.getTechLevel() != nType && nType != 7 && (nType != 4 || et.getTechLevel() != 0 && et.getTechLevel() != 1 && et.getTechLevel() != 2) && (nType != 3 && nType != 1 || et.getTechLevel() != 0 && et.getTechLevel() != 1)) continue;
            this.m_cEquipment.addItem(et.getName());
        }
        try {
            this.m_cWeapons1.setSelectedIndex(0);
            this.m_cWeapons2.setSelectedIndex(0);
            this.m_cEquipment.setSelectedIndex(0);
        }
        catch (IllegalArgumentException ex) {
            MWClient.mwClientLog.clientErrLog("Error in Unit Viewer. Could not set slider indices to 0");
            MWClient.mwClientLog.clientErrLog(ex);
        }
        this.m_cWeapons1.invalidate();
        this.m_cWeapons2.invalidate();
        this.m_cEquipment.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortMechs() {
        Arrays.sort(this.mechsCurrent, new MechSummaryComparator(this.chSort.getSelectedIndex()));
        this.defaultModel.clear();
        try {
            this.mechList.setEnabled(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (int x = 0; x < this.mechsCurrent.length; ++x) {
                this.defaultModel.addElement(this.formatMech(this.mechsCurrent[x]));
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            this.mechList.setEnabled(true);
        }
        this.m_lCount.setText(this.mechsCurrent.length + "/" + this.m_count);
        this.repaint();
    }

    private void searchFor(String search) {
        for (int i = 0; i < this.mechsCurrent.length; ++i) {
            if (!this.mechsCurrent[i].getName().toLowerCase().startsWith(search)) continue;
            this.mechList.setSelectedIndex(i);
            this.mechList.ensureIndexIsVisible(i);
            break;
        }
    }

    public void setVisible(boolean show) {
        this.setLocationRelativeTo(null);
        super.setVisible(show);
        this.pack();
    }

    private String formatMech(MechSummary ms) {
        String result = "";
        result = this.makeLength(ms.getModel(), 12) + " " + this.makeLength(ms.getChassis(), 10) + " " + this.makeLength(Integer.toString(ms.getTons()), 3) + " " + this.makeLength(Integer.toString(ms.getBV()), 5);
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("UseCalculatedCosts"))) {
            result = result + this.makeLength(NumberFormat.getInstance().format(ms.getCost()), 10);
        }
        return result;
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.bCancel) {
            this.saveComboBoxSettings();
            this.dispose();
        }
        if (ae.getSource() == this.bSelect) {
            this.saveComboBoxSettings();
            if (this.viewerType == 1) {
                try {
                    MechSummary ms = this.mechsCurrent[this.mechList.getSelectedIndex()];
                    String unit = ms.getName();
                    this.setVisible(false);
                    String moneyMod = JOptionPane.showInputDialog(this.clientgui, (Object)("Money Mod for " + unit));
                    if (moneyMod == null || moneyMod.length() == 0) {
                        this.dispose();
                        return;
                    }
                    String compMod = JOptionPane.showInputDialog(this.clientgui, (Object)("Comp Mod for " + unit));
                    if (compMod == null || compMod.length() == 0) {
                        this.dispose();
                        return;
                    }
                    String fluMod = JOptionPane.showInputDialog(this.clientgui, (Object)("Flu Mod for " + unit));
                    if (fluMod == null || fluMod.length() == 0) {
                        this.dispose();
                        return;
                    }
                    this.mwclient.sendChat("/c AddOmniVariantMod#" + unit + "#" + moneyMod + "$" + compMod + "$" + fluMod);
                    this.dispose();
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog(ex);
                }
            } else if (this.viewerType == 2) {
                try {
                    String fluff;
                    MechSummary ms = this.mechsCurrent[this.mechList.getSelectedIndex()];
                    String unitFile = ms.getEntryName();
                    String unit = ms.getName();
                    this.setVisible(false);
                    if (unitFile == null || unitFile.equals("null")) {
                        unitFile = ms.getSourceFile().getName();
                    }
                    if ((fluff = JOptionPane.showInputDialog(this.clientgui, (Object)("Fluff text for " + unit))) == null || fluff.length() == 0) {
                        this.dispose();
                        return;
                    }
                    String gunnery = JOptionPane.showInputDialog(this.clientgui, "Gunnery skill for " + unit, 99);
                    if (gunnery == null || gunnery.length() == 0) {
                        this.dispose();
                        return;
                    }
                    String piloting = JOptionPane.showInputDialog(this.clientgui, "Piloting Mod for " + unit, 99);
                    if (piloting == null || piloting.length() == 0) {
                        this.dispose();
                        return;
                    }
                    String skills = null;
                    skills = JOptionPane.showInputDialog(this.clientgui, (Object)("Skills Mod for " + unit + " (comma delimited)"));
                    if (skills == null) {
                        this.dispose();
                        return;
                    }
                    this.mwclient.sendChat("/c createunit#" + unitFile + "#" + fluff + "#" + gunnery + "#" + piloting + "#" + skills);
                    this.dispose();
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog(ex);
                }
            } else {
                this.dispose();
            }
        } else if (ae.getSource().equals(this.m_bSearch)) {
            this.advancedSearch();
        } else if (ae.getSource().equals(this.m_bReset)) {
            this.resetSearch();
        } else if (ae.getSource().equals(this.m_bToggleAdvanced)) {
            this.toggleAdvanced();
        }
    }

    private void advancedSearch() {
        int second;
        String s = this.m_lCount.getText();
        int first = Integer.parseInt(s.substring(0, s.indexOf(47)));
        if (first != (second = Integer.parseInt(s.substring(s.indexOf(47) + 1)))) {
            this.filterMechs(true);
        }
        ArrayList<MechSummary> vMatches = new ArrayList<MechSummary>();
        for (int i = 0; i < this.mechsCurrent.length; ++i) {
            MechSummary ms = this.mechsCurrent[i];
            try {
                Entity entity = new MechFileParser(ms.getSourceFile(), ms.getEntryName()).getEntity();
                if (!this.isMatch(entity)) continue;
                vMatches.add(ms);
                continue;
            }
            catch (EntityLoadingException ex) {
                // empty catch block
            }
        }
        this.mechsCurrent = vMatches.toArray(new MechSummary[0]);
        this.clearMechPreview();
        this.sortMechs();
        this.paintScreen(false);
    }

    private boolean isMatch(Entity entity) {
        int walk = -1;
        try {
            walk = Integer.parseInt(this.m_tWalk.getText());
        }
        catch (NumberFormatException ne) {
            // empty catch block
        }
        if (walk > -1 && (this.m_cWalk.getSelectedIndex() == 0 ? entity.getWalkMP() < walk : (this.m_cWalk.getSelectedIndex() == 1 ? walk != entity.getWalkMP() : this.m_cWalk.getSelectedIndex() == 2 && entity.getWalkMP() > walk))) {
            return false;
        }
        int jump = -1;
        try {
            jump = Integer.parseInt(this.m_tJump.getText());
        }
        catch (NumberFormatException ne) {
            // empty catch block
        }
        if (jump > -1 && (this.m_cJump.getSelectedIndex() == 0 ? entity.getJumpMP() < jump : (this.m_cJump.getSelectedIndex() == 1 ? jump != entity.getJumpMP() : this.m_cJump.getSelectedIndex() == 2 && entity.getJumpMP() > jump))) {
            return false;
        }
        int sel = this.m_cArmor.getSelectedIndex();
        if (sel > 0) {
            int armor = entity.getTotalArmor();
            int maxArmor = entity.getTotalInternal() * 2 + 3;
            if (sel == 1 ? (double)armor < (double)maxArmor * 0.25 : (sel == 2 ? (double)armor < (double)maxArmor * 0.5 : (sel == 3 ? (double)armor < (double)maxArmor * 0.75 : sel == 4 && (double)armor < (double)maxArmor * 0.9))) {
                return false;
            }
        }
        boolean weaponLine1Active = false;
        boolean weaponLine2Active = false;
        boolean foundWeapon1 = false;
        boolean foundWeapon2 = false;
        int count = 0;
        int weapon1 = -1;
        try {
            weapon1 = Integer.parseInt(this.m_tWeapons1.getText());
        }
        catch (NumberFormatException ne) {
            // empty catch block
        }
        if (weapon1 > -1) {
            weaponLine1Active = true;
            for (int i = 0; i < entity.getWeaponList().size(); ++i) {
                WeaponType wt = (WeaponType)entity.getWeaponList().get(i).getType();
                if (!wt.getName().equals(this.m_cWeapons1.getSelectedItem())) continue;
                ++count;
            }
            if (count >= weapon1) {
                foundWeapon1 = true;
            }
        }
        count = 0;
        int weapon2 = -1;
        try {
            weapon2 = Integer.parseInt(this.m_tWeapons2.getText());
        }
        catch (NumberFormatException ne) {
            // empty catch block
        }
        if (weapon2 > -1) {
            weaponLine2Active = true;
            for (int i = 0; i < entity.getWeaponList().size(); ++i) {
                WeaponType wt = (WeaponType)entity.getWeaponList().get(i).getType();
                if (!wt.getName().equals(this.m_cWeapons2.getSelectedItem())) continue;
                ++count;
            }
            if (count >= weapon2) {
                foundWeapon2 = true;
            }
        }
        if (weaponLine1Active && !weaponLine2Active && !foundWeapon1) {
            return false;
        }
        if (weaponLine2Active && !weaponLine1Active && !foundWeapon2) {
            return false;
        }
        if (weaponLine1Active && weaponLine2Active && (this.m_cOrAnd.getSelectedIndex() == 0 ? !foundWeapon1 && !foundWeapon2 : !foundWeapon1 || !foundWeapon2)) {
            return false;
        }
        count = 0;
        if (this.m_chkEquipment.isSelected()) {
            for (Mounted m : entity.getMisc()) {
                MiscType mt = (MiscType)m.getType();
                if (!mt.getName().equals(this.m_cEquipment.getSelectedItem())) continue;
                ++count;
            }
            if (count < 1) {
                return false;
            }
        }
        return true;
    }

    private void resetSearch() {
        this.m_cWalk.setSelectedIndex(0);
        this.m_tWalk.setText("");
        this.m_cJump.setSelectedIndex(0);
        this.m_tJump.setText("");
        this.m_cArmor.setSelectedIndex(0);
        this.m_cOrAnd.setSelectedIndex(0);
        this.populateWeaponsAndEquipmentChoices();
        this.filterMechs(false);
        this.paintScreen(false);
    }

    public void valueChanged(ListSelectionEvent event) {
        int selected = this.mechList.getSelectedIndex();
        if (selected == -1) {
            this.clearMechPreview();
            return;
        }
        MechSummary ms = this.mechsCurrent[selected];
        try {
            Entity entity = new MechFileParser(ms.getSourceFile(), ms.getEntryName()).getEntity();
            this.previewMech(entity);
        }
        catch (EntityLoadingException ex) {
            System.out.println("Unable to load mech: " + ms.getSourceFile() + ": " + ms.getEntryName() + ": " + ex.getMessage());
            ex.printStackTrace();
            this.clearMechPreview();
            return;
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        Object currSelection = this.mechList.getSelectedValue();
        if (ie.getSource() == this.chSort) {
            this.sortMechs();
        } else if (ie.getSource() == this.chWeightClass || ie.getSource() == this.chType || ie.getSource() == this.chUnitType) {
            this.filterMechs();
        }
        this.mechList.setSelectedValue(currSelection, true);
    }

    void clearMechPreview() {
        this.mechViewLeft.setEditable(false);
        this.mechViewRight.setEditable(false);
        this.unitFluff.setEditable(false);
        this.mechViewLeft.setText("");
        this.mechViewRight.setText("");
        this.unitFluff.setText("");
        this.previewMech(null);
    }

    void previewMech(Entity entity) {
        Entity currEntity = entity;
        boolean populateTextFields = true;
        this.paintScreen(entity != null && currEntity.getFluff() != null && this.viewFluff);
        if (entity == null) {
            try {
                MechSummary ms = MechSummaryCache.getInstance().getMech("Error OMG-UR-FD");
                currEntity = new MechFileParser(ms.getSourceFile(), ms.getEntryName()).getEntity();
                populateTextFields = false;
            }
            catch (EntityLoadingException e) {
                // empty catch block
            }
        }
        MechView mechView = null;
        try {
            mechView = new MechView(currEntity);
        }
        catch (Exception e) {
            populateTextFields = false;
        }
        this.mechViewLeft.setEditable(false);
        this.mechViewRight.setEditable(false);
        if (populateTextFields && mechView != null) {
            this.mechViewLeft.setText(mechView.getMechReadoutBasic());
            this.mechViewRight.setText(mechView.getMechReadoutLoadout());
            if (currEntity.getFluff() != null && this.viewFluff) {
                this.unitFluff.setEditable(false);
                this.unitFluff.setLineWrap(true);
                this.unitFluff.setText(currEntity.getFluff());
                this.unitFluff.setCaretPosition(0);
            } else {
                this.unitFluff.setText("");
            }
        } else {
            this.mechViewLeft.setText("No unit selected");
            this.mechViewRight.setText("No unit selected");
        }
        this.mechViewLeft.setCaretPosition(0);
        this.mechViewRight.setCaretPosition(0);
        try {
            ((MechInfo)this.pPreview).setUnit(currEntity);
            ((MechInfo)this.pPreview).setImageVisible(true);
            this.pPreview.paint(this.pPreview.getGraphics());
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private String makeLength(String s, int nLength) {
        if (s.length() == nLength) {
            return s;
        }
        if (s.length() > nLength) {
            return s.substring(0, nLength - 2) + "..";
        }
        return s + SPACES.substring(0, nLength - s.length());
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyPressed(KeyEvent ke) {
        long curTime;
        if (ke.getKeyCode() == 10) {
            ActionEvent event = new ActionEvent(this.bCancel, 1001, "");
            this.actionPerformed(event);
        }
        if ((curTime = System.currentTimeMillis()) - this.m_nLastSearch > 1000L) {
            this.m_sbSearch = new StringBuilder();
        }
        this.m_nLastSearch = curTime;
        this.m_sbSearch.append(ke.getKeyChar());
        this.searchFor(this.m_sbSearch.toString().toLowerCase());
    }

    private void paintScreen(boolean fluff) {
        this.springHolder.removeAll();
        this.textBoxSpring.removeAll();
        this.fluffBoxSpring.removeAll();
        if (fluff) {
            this.textBoxSpring.add(this.listScrollPane);
            this.textBoxSpring.add(this.leftScrollPane);
            this.textBoxSpring.add(this.rightScrollPane);
            SpringLayoutHelper.setupSpringGrid(this.textBoxSpring, 3);
            this.fluffBoxSpring.add(this.fluffScrollPane);
            SpringLayoutHelper.setupSpringGrid(this.fluffBoxSpring, 1);
        } else {
            this.textBoxSpring.add(this.listScrollPane);
            this.textBoxSpring.add(this.leftScrollPane);
            this.textBoxSpring.add(this.rightScrollPane);
            SpringLayoutHelper.setupSpringGrid(this.textBoxSpring, 3);
        }
        JPanel buttonHolder = new JPanel();
        if (this.viewerType != 0) {
            buttonHolder.add(this.bSelect);
        }
        buttonHolder.add(this.bCancel);
        this.springHolder.add(this.pUpper);
        this.springHolder.add(this.textBoxSpring);
        if (fluff) {
            this.springHolder.add(this.fluffBoxSpring);
        }
        this.springHolder.add(buttonHolder);
        SpringLayoutHelper.setupSpringGrid(this.springHolder, 1);
        this.pack();
        this.repaint();
        this.mechList.grabFocus();
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.saveComboBoxSettings();
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

