/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Mounted;
import megamek.common.WeaponType;

class WeaponPanel
extends JPanel
implements ListSelectionListener {
    public JList weaponList = new JList();
    public JComboBox ammoList;
    public JPanel displayP;
    public JPanel rangeP;
    public JPanel targetP;
    public JLabel wAmmo;
    public JLabel wNameL;
    public JLabel wHeatL;
    public JLabel wDamL;
    public JLabel wMinL;
    public JLabel wShortL;
    public JLabel wMedL;
    public JLabel wLongL;
    public JLabel wNameR;
    public JLabel wHeatR;
    public JLabel wDamR;
    public JLabel wMinR;
    public JLabel wShortR;
    public JLabel wMedR;
    public JLabel wLongR;
    public JLabel wTargetL;
    public JLabel wRangeL;
    public JLabel wToHitL;
    public JLabel wTargetR;
    public JLabel wRangeR;
    public JLabel wToHitR;
    private Vector ammo;
    private Entity entity;

    public WeaponPanel() {
        super(new GridBagLayout());
        this.weaponList.setVisibleRowCount(4);
        this.weaponList.addListSelectionListener(this);
        this.wAmmo = new JLabel("Ammo", 2);
        this.ammoList = new JComboBox();
        this.ammoList.setEditable(false);
        JPanel ammoP = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        ammoP.add((Component)this.wAmmo, c);
        c.gridwidth = 3;
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        ammoP.add((Component)this.ammoList, c);
        this.wNameL = new JLabel("Name", 2);
        this.wHeatL = new JLabel("Heat", 0);
        this.wDamL = new JLabel("Damage", 0);
        this.wNameR = new JLabel("", 2);
        this.wHeatR = new JLabel("--", 0);
        this.wDamR = new JLabel("--", 0);
        this.displayP = new JPanel(new GridBagLayout());
        c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.displayP.add((Component)this.wNameL, c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.displayP.add((Component)this.wHeatL, c);
        c.gridwidth = 0;
        this.displayP.add((Component)this.wDamL, c);
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.displayP.add((Component)this.wNameR, c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.displayP.add((Component)this.wHeatR, c);
        c.gridwidth = 0;
        this.displayP.add((Component)this.wDamR, c);
        this.wMinL = new JLabel("Min", 0);
        this.wShortL = new JLabel("Short", 0);
        this.wMedL = new JLabel("Med", 0);
        this.wLongL = new JLabel("Long", 0);
        this.wMinR = new JLabel("---", 0);
        this.wShortR = new JLabel("---", 0);
        this.wMedR = new JLabel("---", 0);
        this.wLongR = new JLabel("---", 0);
        this.rangeP = new JPanel(new GridLayout(2, 4));
        this.rangeP.add(this.wMinL);
        this.rangeP.add(this.wShortL);
        this.rangeP.add(this.wMedL);
        this.rangeP.add(this.wLongL);
        this.rangeP.add(this.wMinR);
        this.rangeP.add(this.wShortR);
        this.rangeP.add(this.wMedR);
        this.rangeP.add(this.wLongR);
        this.wTargetL = new JLabel("Target:");
        this.wRangeL = new JLabel("Range:");
        this.wToHitL = new JLabel("To Hit:");
        this.wTargetR = new JLabel("---");
        this.wRangeR = new JLabel("---");
        this.wToHitR = new JLabel("---");
        this.targetP = new JPanel(new GridLayout(3, 2));
        this.targetP.add(this.wTargetL);
        this.targetP.add(this.wTargetR);
        this.targetP.add(this.wRangeL);
        this.targetP.add(this.wRangeR);
        this.targetP.add(this.wToHitL);
        this.targetP.add(this.wToHitR);
        c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        this.add((Component)new JScrollPane(this.weaponList), c);
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.add((Component)ammoP, c);
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.add((Component)this.displayP, c);
        this.add((Component)this.rangeP, c);
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.add((Component)this.targetP, c);
    }

    public void displayMech(Entity en) {
        this.entity = en;
        this.weaponList.removeAll();
        this.ammoList.removeAllItems();
        this.ammoList.setEnabled(false);
        ArrayList<String> data = new ArrayList<String>();
        for (Mounted mounted : this.entity.getWeaponList()) {
            WeaponType wtype = (WeaponType)mounted.getType();
            String wn = mounted.getDesc() + " [" + this.entity.getLocationAbbr(mounted.getLocation()) + "]";
            if (wtype.getAmmoType() != -1) {
                int shotsLeft = 0;
                if (mounted.getLinked() != null && !mounted.getLinked().isDumping()) {
                    shotsLeft = mounted.getLinked().getShotsLeft();
                }
                EquipmentType typeUsed = mounted.getLinked() == null ? null : mounted.getLinked().getType();
                int totalShotsLeft = this.entity.getTotalAmmoOfType(typeUsed);
                wn = wn + " (" + shotsLeft + "/" + totalShotsLeft + ")";
                if (wtype.hasModes()) {
                    wn = wn + " " + mounted.curMode().getDisplayableName();
                }
            }
            data.add(wn);
        }
        this.weaponList.setListData(data.toArray());
    }

    public void displaySelected() {
        if (this.weaponList.getSelectedIndex() == -1) {
            this.ammoList.removeAllItems();
            this.ammoList.setEnabled(false);
            this.wNameR.setText("");
            this.wHeatR.setText("--");
            this.wDamR.setText("--");
            this.wMinR.setText("---");
            this.wShortR.setText("---");
            this.wMedR.setText("---");
            this.wLongR.setText("---");
            return;
        }
        Mounted mounted = this.entity.getWeaponList().get(this.weaponList.getSelectedIndex());
        WeaponType wtype = (WeaponType)mounted.getType();
        this.wNameR.setText(mounted.getDesc());
        this.wHeatR.setText(wtype.getHeat() + "");
        if (wtype.getDamage() == -2) {
            this.wDamR.setText("Missile");
        } else if (wtype.getDamage() == -3) {
            this.wDamR.setText("Variable");
        } else {
            this.wDamR.setText(new Integer(wtype.getDamage()).toString());
        }
        if (wtype.getMinimumRange() > 0) {
            this.wMinR.setText(Integer.toString(wtype.getMinimumRange()));
        } else {
            this.wMinR.setText("---");
        }
        if (wtype.getShortRange() > 1) {
            this.wShortR.setText("1 - " + wtype.getShortRange());
        } else {
            this.wShortR.setText("" + wtype.getShortRange());
        }
        if (wtype.getMediumRange() - wtype.getShortRange() > 1) {
            this.wMedR.setText(wtype.getShortRange() + 1 + " - " + wtype.getMediumRange());
        } else {
            this.wMedR.setText("" + wtype.getMediumRange());
        }
        if (wtype.getLongRange() - wtype.getMediumRange() > 1) {
            this.wLongR.setText(wtype.getMediumRange() + 1 + " - " + wtype.getLongRange());
        } else {
            this.wLongR.setText("" + wtype.getLongRange());
        }
        this.ammoList.removeAllItems();
        if (wtype.getAmmoType() == -1) {
            this.ammoList.setEnabled(false);
        } else {
            this.ammoList.setEnabled(true);
            this.ammo = new Vector();
            int nCur = -1;
            int i = 0;
            for (Mounted mountedAmmo : this.entity.getAmmo()) {
                AmmoType atype = (AmmoType)mountedAmmo.getType();
                if (mountedAmmo.isDestroyed() || mountedAmmo.getShotsLeft() <= 0 || mountedAmmo.isDumping() || atype.getAmmoType() != wtype.getAmmoType() || atype.getRackSize() != wtype.getRackSize()) continue;
                this.ammo.addElement(mountedAmmo);
                if (mounted.getLinked() == mountedAmmo) {
                    nCur = i;
                }
                ++i;
            }
            int n = this.ammo.size();
            for (int x = 0; x < n; ++x) {
                String s = this.formatAmmo((Mounted)this.ammo.elementAt(x));
                if (s.length() <= 0) continue;
                this.ammoList.addItem(s);
            }
            if (nCur == -1) {
                this.ammoList.setEnabled(false);
            } else {
                this.ammoList.setSelectedIndex(nCur);
            }
        }
    }

    private String formatAmmo(Mounted m) {
        StringBuilder sb = new StringBuilder(64);
        int ammoIndex = m.getDesc().indexOf("Ammo");
        sb.append("[").append(this.entity.getLocationAbbr(m.getLocation())).append("] ");
        if (ammoIndex == -1) {
            sb.append(m.getDesc());
        } else {
            sb.append(m.getDesc().substring(0, ammoIndex));
            sb.append(m.getDesc().substring(ammoIndex + 4));
        }
        return sb.toString();
    }

    public void valueChanged(ListSelectionEvent ev) {
        this.displaySelected();
    }
}

