/*
 * Decompiled with CFR 0.152.
 */
package client.protocol;

import client.MWClient;
import client.gui.SplashWindow;
import client.protocol.ConnectionHandlerLocal;
import client.protocol.IClient;
import client.protocol.IConnectionHandler;
import client.protocol.IConnectionListener;
import java.io.IOException;
import java.net.Socket;

public class CConnector
implements IConnectionListener {
    protected IClient Client;
    protected String _host = "";
    protected int _port = -1;
    protected boolean _connected = false;
    protected IConnectionHandler _connectionHandler;
    private SplashWindow splash;

    public CConnector(IClient client) {
        this.Client = client;
    }

    public CConnector(IClient client, String host, int port) {
        this.Client = client;
        this._host = host;
        this._port = port;
    }

    public boolean isConnected() {
        return this._connected;
    }

    public void incomingMessage(String message) {
        this.Client.processIncoming(message);
    }

    public void socketClosed() {
        this._connected = false;
        this.Client.connectionLost();
    }

    public void send(String message) {
        MWClient.mwClientLog.clientOutputLog("SENT: " + message);
        this._connectionHandler.queueMessage(message);
    }

    public void connect(String host, int port) {
        this._host = host;
        this._port = port;
        this.connect();
    }

    public void connect() {
        try {
            if (this._connected) {
                MWClient.mwClientLog.clientErrLog("already connected...");
                return;
            }
            if (this._host.equals("") || this._port == -1) {
                MWClient.mwClientLog.clientErrLog("no host or port set...");
                return;
            }
            IOException ioexception = null;
            MWClient.mwClientLog.clientErrLog("Opening socket connection to " + this._host + ":" + this._port);
            Socket s = null;
            try {
                s = new Socket(this._host, this._port);
                MWClient.mwClientLog.clientErrLog("CConnector: connected to " + this._host + ":" + this._port);
                s.setTcpNoDelay(true);
                this._connectionHandler = new ConnectionHandlerLocal(s);
                this._connectionHandler.setListener(this);
                this._connected = true;
                this.Client.connectionEstablished();
                return;
            }
            catch (IOException e) {
                ioexception = e;
                MWClient.mwClientLog.clientErrLog("giving up");
                if (ioexception != null) {
                    throw ioexception;
                }
            }
        }
        catch (IOException e) {
            if (this.splash != null) {
                this.splash.setStatus(this.splash.STATUS_CONNECTFAILED);
            }
            MWClient.mwClientLog.clientErrLog(e);
            return;
        }
    }

    public void closeConnection() {
        this._connectionHandler.shutdown(true);
    }

    public void setSplashWindow(SplashWindow s) {
        this.splash = s;
    }
}

