/*
 * Decompiled with CFR 0.152.
 */
package common;

import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import common.House;
import common.Influences;
import common.Planet;
import common.PlanetEnvironment;
import common.PlanetEnvironments;
import common.TerrainProvider;
import common.UnitFactory;
import common.persistence.DatWriter;
import common.persistence.MMNetSerializable;
import common.persistence.TreeReader;
import common.persistence.TreeWriter;
import common.util.BinReader;
import common.util.BinWriter;
import common.util.MMNetXStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CampaignData
implements TerrainProvider,
MMNetSerializable {
    public static CampaignData cd;
    private TreeMap<Integer, House> factions = new TreeMap();
    private TreeMap<String, Integer> factionid = new TreeMap();
    private TreeMap<Integer, Planet> planets = new TreeMap();
    private TreeMap<String, Integer> planetid = new TreeMap();
    private ArrayList<PlanetEnvironment> terrains = new ArrayList();
    private Hashtable<String, String> ServerBannedAmmo = new Hashtable();
    private HashMap<Integer, String> bannedTargetingSystems = new HashMap();
    private Hashtable<String, Integer> commands = new Hashtable();
    private TreeMap<String, String> planetOpFlags = new TreeMap();
    private Hashtable<Long, Integer> AmmoCost = new Hashtable();

    public Planet getPlanet(int id) {
        return this.planets.get(new Integer(id));
    }

    public Planet getPlanetByName(String name) {
        try {
            Integer planetID = this.planetid.get(name.toLowerCase());
            return this.getPlanet(planetID);
        }
        catch (Exception ex) {
            System.err.println("Looking for planet: " + name);
            return null;
        }
    }

    public UnitFactory getFactoryByName(Planet p, String name) {
        for (UnitFactory e : p.getUnitFactories()) {
            if (!e.getName().equalsIgnoreCase(name)) continue;
            return e;
        }
        return null;
    }

    public void updateFactoryTick(String planet, String factory, int tick) {
        Planet p = this.getPlanetByName(planet);
        UnitFactory unitFactory = this.getFactoryByName(p, factory);
        unitFactory.setTicksUntilRefresh(tick);
    }

    public Planet getPlanetByPartialName(String name) {
        Iterator<Planet> e = this.getAllPlanets().iterator();
        Planet theone = null;
        boolean found = false;
        while (e.hasNext() && !found) {
            Planet p = e.next();
            if (p.getName().equals(name)) {
                theone = p;
                found = true;
                continue;
            }
            if (p.getName().indexOf(name) == -1) continue;
            if (theone == null) {
                theone = p;
                continue;
            }
            return null;
        }
        if (theone == null) {
            return null;
        }
        return theone;
    }

    public Collection<Planet> getAllPlanets() {
        return this.planets.values();
    }

    public void addPlanet(Planet planet) {
        if (planet.getId() == -1) {
            planet.setId(this.getUnusedPlanetID());
        }
        this.planets.put(new Integer(planet.getId()), planet);
        this.planetid.put(planet.getName().toLowerCase(), new Integer(planet.getId()));
    }

    public void removePlanet(int id) {
        this.planetid.remove(this.getPlanet(id).getName().toLowerCase());
        this.planets.remove(new Integer(id));
    }

    public void clearPlanets() {
        this.planets.clear();
    }

    public int getUnusedPlanetID() {
        int id = 0;
        while (this.planets.keySet().contains(new Integer(id))) {
            ++id;
        }
        return id;
    }

    public House getHouse(int ID) {
        return this.factions.get(ID);
    }

    public Collection<House> getAllHouses() {
        return this.factions.values();
    }

    public void addHouse(House faction) {
        if (faction.getId() == -1) {
            faction.setId(this.getUnusedHouseID());
        }
        this.factions.put(new Integer(faction.getId()), faction);
        this.factionid.put(faction.getName().toLowerCase(), new Integer(faction.getId()));
    }

    public House getHouseByName(String name) {
        try {
            House h = this.getHouse(this.factionid.get(name.toLowerCase()));
            return h;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void clearHouses() {
        this.factions.clear();
    }

    public int getUnusedHouseID() {
        int id = 0;
        int hid = 0;
        for (House e : this.factions.values()) {
            hid = e.getId();
            if (hid <= id) continue;
            id = hid;
        }
        return ++id;
    }

    public int getUnusedTerrainID() {
        int id = 0;
        int hid = 0;
        for (PlanetEnvironment e : this.terrains) {
            hid = e.getId();
            if (hid <= id) continue;
            id = hid;
        }
        return ++id;
    }

    public void binOut(BinWriter out) throws IOException {
        this.binTerrainsOut(out);
        this.binHousesOut(out);
        this.binPlanetsOut(out);
    }

    public void binHousesOut(BinWriter out) throws IOException {
        out.println(this.factions.size(), "factions.size");
        Iterator<House> it = this.factions.values().iterator();
        while (it.hasNext()) {
            it.next().binOut(out);
        }
    }

    public void binHousesOut(ArrayList<House> houses, BinWriter out) throws IOException {
        out.println(houses.size(), "houses.size");
        for (House house : houses) {
            house.binOut(out);
        }
    }

    public void binTerrainsOut(BinWriter out) throws IOException {
        out.println(this.terrains.size(), "terrains.size");
        Iterator<PlanetEnvironment> it = this.terrains.iterator();
        while (it.hasNext()) {
            it.next().binOut(out);
        }
    }

    public void binPlanetsOut(BinWriter out) throws IOException {
        out.println(this.planets.size(), "planets.size");
        Iterator<Planet> it = this.planets.values().iterator();
        while (it.hasNext()) {
            it.next().binOut(out);
        }
    }

    public void binPlanetsOut(ArrayList<Planet> planets, BinWriter out) throws IOException {
        out.println(planets.size(), "planets.size");
        for (Planet planet : planets) {
            planet.binOut(out);
        }
    }

    public CampaignData() {
        cd = this;
        PlanetEnvironments.data = this;
    }

    public CampaignData(BinReader in) throws IOException {
        int i;
        cd = this;
        PlanetEnvironments.data = this;
        int size = in.readInt("terrains.size");
        for (i = 0; i < size; ++i) {
            PlanetEnvironment pe = new PlanetEnvironment();
            pe.binIn(in, this);
            this.terrains.add(pe);
        }
        size = in.readInt("factions.size");
        for (i = 0; i < size; ++i) {
            this.addHouse(new House(in));
        }
        size = in.readInt("planets.size");
        for (i = 0; i < size; ++i) {
            this.addPlanet(new Planet(in, this.factions, this));
        }
    }

    public void decodeMutablePlanets(BinReader in, Map<Integer, Influences> changesSinceLastRefresh) throws IOException {
        int count = in.readInt("mutableplanetsize");
        System.out.println("retrieving " + count + " planets due differential update.");
        changesSinceLastRefresh.clear();
        for (int i = 0; i < count; ++i) {
            int id = in.readInt("planetid");
            Influences infOld = new Influences(this.getPlanet(id).getInfluence());
            this.getPlanet(id).decodeMutableFields(in, this);
            Influences infNew = this.getPlanet(id).getInfluence();
            changesSinceLastRefresh.put(new Integer(id), infNew.difference(infOld));
        }
    }

    public void encodeMutablePlanets(BinWriter out, Collection ids) throws IOException {
        out.println(ids.size(), "mutableplanetsize");
        for (Integer id : ids) {
            out.println(id, "planetid");
            this.getPlanet(id).encodeMutableFields(out, this);
        }
    }

    public void saveData(File directory) throws IOException {
        if (directory == null) {
            throw new IllegalArgumentException("Please specify a directory.");
        }
        if (directory.exists() && !directory.isDirectory()) {
            throw new IllegalArgumentException(directory.getName() + " is not a directory.");
        }
        if (!directory.exists()) {
            directory.mkdir();
        }
        MMNetXStream xml = new MMNetXStream((HierarchicalStreamDriver)new DomDriver());
        xml.toXML(this, new FileWriter(directory.getPath() + "/data.xml"));
        DatWriter datWriter = new DatWriter(directory.getPath() + "/CampaignData.dat");
        datWriter.write(this, "CampaignData");
        datWriter.close();
    }

    public static CampaignData loadData(File directory) throws IOException {
        if (directory == null || !directory.isDirectory()) {
            throw new IllegalArgumentException("Please specify a directory.");
        }
        MMNetXStream xml = new MMNetXStream((HierarchicalStreamDriver)new DomDriver());
        CampaignData data = (CampaignData)xml.fromXML(new FileReader(directory.getPath() + "/data.xml"));
        return data;
    }

    @Override
    public PlanetEnvironment getTerrain(int id) {
        for (PlanetEnvironment env : this.terrains) {
            if (env.getId() != id) continue;
            return env;
        }
        return null;
    }

    @Override
    public Collection<PlanetEnvironment> getAllTerrains() {
        return this.terrains;
    }

    @Override
    public void addTerrain(PlanetEnvironment pe) {
        pe.setId(this.getUnusedTerrainID());
        this.terrains.add(pe);
    }

    public PlanetEnvironment getTerrainByName(String TerrainName) {
        for (PlanetEnvironment env : this.terrains) {
            if (!env.getName().equals(TerrainName)) continue;
            return env;
        }
        return null;
    }

    @Override
    public void binOut(TreeWriter out) {
        out.write(this.terrains, "terrains");
        out.startDataBlock("factions");
        out.write(this.factions.size(), "factionsCount");
        for (House h : this.factions.values()) {
            out.write(h.getClass().getName(), "factionType");
            out.write(h, "faction");
        }
        out.endDataBlock("factions");
        out.startDataBlock("planets");
        out.write(this.factions.size(), "planetsCount");
        for (Planet p : this.planets.values()) {
            out.write(p.getClass().getName(), "planetType");
            out.write(p, "planet");
        }
        out.endDataBlock("planets");
    }

    @Override
    public void binIn(TreeReader in, CampaignData dataProvider) throws IOException {
        String type;
        int i;
        this.terrains.clear();
        in.startDataBlock("factions");
        this.factions.clear();
        int size = in.readInt("factionsCount");
        for (i = 0; i < size; ++i) {
            type = in.readString("factionType");
            try {
                House h = (House)Class.forName(type).newInstance();
                in.readObject(h, this, "faction");
                this.factions.put(new Integer(h.getId()), h);
                continue;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        in.endDataBlock("factions");
        in.startDataBlock("planets");
        this.planets.clear();
        size = in.readInt("planetsCount");
        for (i = 0; i < size; ++i) {
            type = in.readString("planetsType");
            try {
                Planet p = (Planet)Class.forName(type).newInstance();
                in.readObject(p, this, "planet");
                this.planets.put(new Integer(p.getId()), p);
                continue;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        in.endDataBlock("planets");
    }

    public Hashtable<String, Long> getMunitionsByName() {
        Hashtable<String, Long> munitions = new Hashtable<String, Long>();
        munitions.put("Standard", 0L);
        munitions.put("LBX Clutser", 1L);
        munitions.put("AC Armor Piercing", 2L);
        munitions.put("AC Flechette", 4L);
        munitions.put("AC Incendiary", 8L);
        munitions.put("AC Precision", 16L);
        munitions.put("AC Tracer", 0x400000000L);
        munitions.put("ATM Extended Range", 32L);
        munitions.put("ATM High Explosive", 64L);
        munitions.put("LRM/SRM Fragmentation", 128L);
        munitions.put("LRM/SRM Listen Kill", 256L);
        munitions.put("LRM/SRM Anti-TSM", 512L);
        munitions.put("LRM/SRM Narc", 1024L);
        munitions.put("LRM/SRM Artemis", 2048L);
        munitions.put("LRM/SRM Heat-Seeking", 0x2000000000L);
        munitions.put("LRM/SRM Dead-Fire", 0x1000000000L);
        munitions.put("LRM/SRM Tandem-Charge", 0x4000000000L);
        munitions.put("LRM Incendiary", 4096L);
        munitions.put("LRM Flare", 8192L);
        munitions.put("LRM SemiGuided", 16384L);
        munitions.put("LRM Swarm", 32768L);
        munitions.put("LRM Swarm I", 65536L);
        munitions.put("LRM Thunder", 131072L);
        munitions.put("LRM Thunder Augmented", 262144L);
        munitions.put("LRM Thunder Inferno", 524288L);
        munitions.put("LRM Thunder VibraBomb", 0x100000L);
        munitions.put("LRM Thunder Active", 0x200000L);
        munitions.put("LRM Follow The Leader", 0x8000000000L);
        munitions.put("SRM Inferno", 0x400000L);
        munitions.put("SRM Acid", 0x800000L);
        munitions.put("LRT/SRT", 0x20000000000L);
        munitions.put("iNarc Explosive", 0x1000000L);
        munitions.put("iNarc ECM", 0x2000000L);
        munitions.put("iNarc HayWire", 0x4000000L);
        munitions.put("iNarc Nemesis", 0x8000000L);
        munitions.put("Narc Explosive", 0x10000000L);
        munitions.put("Arrow IV Homing", 0x20000000L);
        munitions.put("Arrow IV FASCAM", 0x40000000L);
        munitions.put("Arrow IV Inferno", 0x80000000L);
        munitions.put("Arrow IV VibraBomb", 0x100000000L);
        munitions.put("Arrow IV Smoke", 0x200000000L);
        munitions.put("Arrow IV Davy Crockett", 0x800000000L);
        return munitions;
    }

    public Hashtable<Long, String> getMunitionsByNumber() {
        Hashtable<Long, String> munitions = new Hashtable<Long, String>();
        munitions.put(0L, "Standard");
        munitions.put(1L, "LBX Cluster");
        munitions.put(2L, "AC Armor Piercing");
        munitions.put(4L, "AC Flechette");
        munitions.put(8L, "AC Incendiary");
        munitions.put(16L, "AC Precision");
        munitions.put(0x400000000L, "AC Tracer");
        munitions.put(32L, "ATM Extended Range");
        munitions.put(64L, "ATM High Explosive");
        munitions.put(128L, "LRM/SRM Fragmentation");
        munitions.put(256L, "LRM/SRM Listen Kill");
        munitions.put(512L, "LRM/SRM Anti-TSM");
        munitions.put(1024L, "LRM/SRM Narc");
        munitions.put(2048L, "LRM/SRM Artemis");
        munitions.put(0x2000000000L, "LRM/SRM Heat-Seeking");
        munitions.put(0x4000000000L, "LRM/SRM Tandem-Charge");
        munitions.put(0x1000000000L, "LRM/SRM Dead-Fire");
        munitions.put(4096L, "LRM Incendiary");
        munitions.put(8192L, "LRM Flare");
        munitions.put(16384L, "LRM SemiGuided");
        munitions.put(32768L, "LRM Swarm");
        munitions.put(65536L, "LRM Swarm I");
        munitions.put(131072L, "LRM Thunder");
        munitions.put(262144L, "LRM Thunder Augmented");
        munitions.put(524288L, "LRM Thunder Inferno");
        munitions.put(0x100000L, "LRM Thunder VibraBomb");
        munitions.put(0x200000L, "LRM Thunder Active");
        munitions.put(0x8000000000L, "LRM Follow The Leader");
        munitions.put(0x400000L, "SRM Inferno");
        munitions.put(0x800000L, "SRM Acid");
        munitions.put(0x20000000000L, "LRT/SRT");
        munitions.put(0x1000000L, "iNarc Explosive");
        munitions.put(0x2000000L, "iNarc ECM");
        munitions.put(0x4000000L, "iNarc HayWire");
        munitions.put(0x8000000L, "iNarc Nemesis");
        munitions.put(0x10000000L, "Narc Explosive");
        munitions.put(0x20000000L, "Arrow IV Homing");
        munitions.put(0x40000000L, "Arrow IV FASCAM");
        munitions.put(0x80000000L, "Arrow IV Inferno");
        munitions.put(0x100000000L, "Arrow IV VibraBomb");
        munitions.put(0x200000000L, "Arrow IV Smoke");
        munitions.put(0x800000000L, "Arrow IV Davy Crockett");
        return munitions;
    }

    public void setServerBannedAmmo(Hashtable<String, String> ban) {
        this.ServerBannedAmmo = ban;
    }

    public Hashtable<String, String> getServerBannedAmmo() {
        return this.ServerBannedAmmo;
    }

    public void setBannedTargetingSystems(HashMap<Integer, String> ban) {
        this.bannedTargetingSystems = ban;
    }

    public HashMap<Integer, String> getBannedTargetingSystems() {
        return this.bannedTargetingSystems;
    }

    public void setAmmoCost(Hashtable<Long, Integer> cost) {
        this.AmmoCost = cost;
    }

    public Hashtable<Long, Integer> getAmmoCost() {
        return this.AmmoCost;
    }

    public void importAccessLevels(BinReader in) {
        Hashtable<String, Integer> commandTemp = this.getCommandTable();
        try {
            int size = in.readInt("CommandSize");
            for (int pos = 0; pos < size; ++pos) {
                String commandName = in.readLine("CommandName");
                int accessLevel = in.readInt("AccessLevel");
                commandTemp.put(commandName, new Integer(accessLevel));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setCommandTable(commandTemp);
    }

    public void setCommandTable(Hashtable<String, Integer> commands) {
        this.commands = commands;
    }

    public Hashtable<String, Integer> getCommandTable() {
        return this.commands;
    }

    public int getAccessLevel(String command) {
        int level = 200;
        if (this.getCommandTable().get(command.toUpperCase()) != null) {
            level = this.getCommandTable().get(command.toUpperCase());
        }
        return level;
    }

    public TreeMap<String, String> getPlanetOpFlags() {
        return this.planetOpFlags;
    }
}

