/*
 * Decompiled with CFR 0.152.
 */
package admin.dialog;

import client.MWClient;
import client.gui.SpringLayoutHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public final class AmmoCostDialog
implements ActionListener {
    private MWClient mwclient = null;
    private static final String okayCommand = "Add";
    private static final String cancelCommand = "Close";
    private String windowName = "Ammo Cost Editor";
    private final JButton okayButton = new JButton("Save");
    private final JButton cancelButton = new JButton("Close");
    private JDialog dialog;
    private JOptionPane pane;
    private JPanel ammoPanel = new JPanel(new SpringLayout());
    JTabbedPane ConfigPane = new JTabbedPane(1);

    public AmmoCostDialog(MWClient c) {
        this.mwclient = c;
        this.okayButton.setActionCommand(okayCommand);
        this.cancelButton.setActionCommand(cancelCommand);
        this.cancelButton.setSelected(true);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okayButton.setToolTipText("Save");
        this.cancelButton.setToolTipText("Exit without saving changes");
        JPanel banPanel = new JPanel();
        banPanel.setLayout(new BoxLayout(banPanel, 1));
        this.loadAmmo();
        TreeSet<String> munitions = new TreeSet<String>(this.mwclient.getData().getMunitionsByName().keySet());
        for (String munitionName : munitions) {
            this.ammoPanel.add(new JLabel(munitionName, 11));
            JTextField ammoCost = new JTextField(5);
            ammoCost.setName(munitionName);
            if (this.mwclient.getData().getAmmoCost().get(this.mwclient.getData().getMunitionsByName().get(munitionName)) != null) {
                ammoCost.setText(Integer.toString(this.mwclient.getData().getAmmoCost().get(this.mwclient.getData().getMunitionsByName().get(munitionName))));
            }
            this.ammoPanel.add(ammoCost);
        }
        SpringLayoutHelper.setupSpringGrid(this.ammoPanel, 4);
        banPanel.add(this.ammoPanel);
        Object[] options = new Object[]{this.okayButton, this.cancelButton};
        this.pane = new JOptionPane(banPanel, -1, -1, null, options, null);
        this.dialog = this.pane.createDialog(this.ammoPanel, this.windowName);
        this.dialog.getRootPane().setDefaultButton(this.cancelButton);
        this.dialog.setModal(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(okayCommand)) {
            int cost = 0;
            for (int x = 0; x < this.ammoPanel.getComponentCount(); ++x) {
                Component field = this.ammoPanel.getComponent(x);
                if (!(field instanceof JTextField)) continue;
                JTextField textBox = (JTextField)field;
                Long ammo = this.mwclient.getData().getMunitionsByName().get(textBox.getName());
                try {
                    cost = Integer.parseInt(textBox.getText());
                }
                catch (Exception ex) {
                    cost = 0;
                    MWClient.mwClientLog.clientErrLog(ex);
                }
                if (this.mwclient.getData().getAmmoCost().get(ammo) != null && cost == this.mwclient.getData().getAmmoCost().get(ammo)) continue;
                this.mwclient.sendChat("/c adminsetammocost#" + ammo + "#" + cost);
            }
            this.dialog.dispose();
            return;
        }
        if (command.equals(cancelCommand)) {
            this.dialog.dispose();
        }
    }

    public void loadAmmo() {
        this.mwclient.loadAmmoCosts();
    }
}

