/*
 * Decompiled with CFR 0.152.
 */
package admin.dialog;

import client.MWClient;
import client.gui.SpringLayoutHelper;
import common.AdvanceTerrain;
import common.Continent;
import common.House;
import common.Planet;
import common.PlanetEnvironment;
import common.UnitFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlanetEditorDialog
implements ActionListener,
KeyListener {
    private MWClient mwclient = null;
    private String planetName = "";
    private AdvanceTerrain aTerrain = new AdvanceTerrain();
    private int advanceTerrainId = -1;
    private Planet selectedPlanet;
    private boolean useAdvanceTerrain = false;
    private TreeSet<String> removedOwners = new TreeSet();
    private HashMap<String, Integer> ownersMap = new HashMap();
    private TreeSet<String> removedTerrain = new TreeSet();
    private HashMap<String, Integer> terrainMap = new HashMap();
    private TreeSet<String> removedFactory = new TreeSet();
    private HashMap<String, String> factoryMap = new HashMap();
    private HashMap<String, AdvanceTerrain> advanceTerrainMap = new HashMap();
    private static final String okayCommand = "Save";
    private static final String cancelCommand = "Cancel";
    private static final String refreshCommand = "Refresh";
    private static final String addOwnerCommand = "AddOwner";
    private static final String removeOwnerCommand = "RemoveOwner";
    private static final String resetOwnersCommand = "ResetOwners";
    private static final String addFactoryCommand = "AddFactory";
    private static final String removeFactoryCommand = "RemoveFactory";
    private static final String removeAllFactoriesCommand = "RemoveAllFactories";
    private static final String addTerrainCommand = "AddTerrain";
    private static final String RemoveTerrainCommand = "RemoveTerrain";
    private static final String removeAllTerrainsCommand = "RemoveAllTerrains";
    private static final String planetTerrainsCombo = "PlanetTerrainsCombo";
    private static final String planetOwnersListCommand = "PlanetOwnersList";
    private static final String staticMapCBCommmand = "StaticMapCB";
    private static final String vacuumCBCommand = "VacuumCB";
    private static final String windowName = "Vertigo's Planet Editor";
    private final JButton okayButton = new JButton("Save");
    private final JButton cancelButton = new JButton("Close");
    private final JButton refreshButton = new JButton("Refresh");
    private final JButton addOwnerButton = new JButton("Add Owner");
    private final JButton removeOwnerButton = new JButton("Remove Owner");
    private final JButton resetOwnersButton = new JButton("Reset All Owners");
    private final JButton addFactory = new JButton("Add Factory");
    private final JButton removeFactory = new JButton("Remove Factory");
    private final JButton removeAllFactories = new JButton("Remove All");
    private final JButton addTerrain = new JButton("Add Terrain");
    private final JButton removeTerrain = new JButton("Remove Terrain");
    private final JButton removeAllTerrains = new JButton("Remove All");
    private final JTextField DisplayNameText = new JTextField(5);
    private final JTextField StaticMapNameText = new JTextField(5);
    private final JTextField XSizeText = new JTextField(5);
    private final JTextField YSizeText = new JTextField(5);
    private final JTextField XBoardSizeText = new JTextField(5);
    private final JTextField YBoardSizeText = new JTextField(5);
    private final JTextField LowTempText = new JTextField(5);
    private final JTextField HighTempText = new JTextField(5);
    private final JTextField GravityText = new JTextField(5);
    private final JTextField NightChanceText = new JTextField(5);
    private final JTextField NightTempModText = new JTextField(5);
    private final JTextField MinVisibilityText = new JTextField(5);
    private final JTextField MaxVisibilityText = new JTextField(5);
    private final JTextField planetBays = new JTextField(5);
    private final JTextField planetComps = new JTextField(5);
    private final JTextField planetXPosition = new JTextField(5);
    private final JTextField planetYPosition = new JTextField(5);
    private final JTextField newTerrainPercent = new JTextField(5);
    private final JTextField newFactoryName = new JTextField(10);
    private final JTextField currentFactionOwnerShip = new JTextField(5);
    private final JTextField newFacitonOwnerShip = new JTextField(5);
    private final JTextField currentTerrainPercent = new JTextField(5);
    private final JTextField minPlanetOwnerShip = new JTextField(5);
    private final JTextField planetConquerPoints = new JTextField(5);
    private final JCheckBox isStaticMapCB = new JCheckBox();
    private final JCheckBox isVacuumCB = new JCheckBox();
    private final JCheckBox isHomeWorldCB = new JCheckBox();
    private JDialog dialog;
    private JOptionPane pane;
    private JPanel masterPanel;
    private JPanel planets;
    private JPanel planetInfo;
    private JPanel planetProduction;
    private JPanel planetTerrain;
    private JPanel planetAdvanceTerrain;
    private String[] factoryTypes = new String[]{"All", "Mek", "Vee", "Mek & Vee", "Inf", "Mek & Inf", "Vee & Inf", "Mek & Inf & Vee", "Proto", "Mek & Proto", "Vee & Proto", "Mek & Vee & Proto", "Inf & Proto", "Mek & Inf & Proto", "Vee & Inf & Proto", "Mek & Vee & Inf & Proto", "BA", "Mek & BA", "Vee & BA", "Mek & Vee & BA", "Inf & BA", "Mek & Inf & BA", "Vee & Inf & BA", "Mek & Vee & Inf & BA", "Proto & BA", "Mek & Proto & BA", "Vee & Proto & BA", "Mek & Vee & Proto & BA", "Inf & Proto & BA", "Mek & Inf & Proto & BA", "Vee & Inf & Proto & BA"};
    private String[] factorySizes = new String[]{"Light", "Medium", "Heavy", "Assault"};
    private JComboBox planetNames;
    private JComboBox houseNames;
    private JComboBox planetOwnersList;
    private JComboBox planetFactories;
    private JComboBox planetTerrains;
    private JComboBox allTerrains;
    private JComboBox factorySize = new JComboBox<String>(this.factorySizes);
    private JComboBox factoryType = new JComboBox<String>(this.factoryTypes);
    private JComboBox factoryOwners;
    private JComboBox ownerNames;
    JTabbedPane ConfigPane = new JTabbedPane(1);

    public PlanetEditorDialog(MWClient c, String planetName) {
        this.mwclient = c;
        this.planetName = planetName;
        this.useAdvanceTerrain = Boolean.parseBoolean(this.mwclient.getserverConfigs("UseStaticMaps"));
        this.okayButton.setActionCommand(okayCommand);
        this.cancelButton.setActionCommand(cancelCommand);
        this.refreshButton.setActionCommand(refreshCommand);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.refreshButton.addActionListener(this);
        this.okayButton.setToolTipText("Save Options");
        this.cancelButton.setToolTipText("Exit without saving changes");
        this.refreshButton.setToolTipText("Reload data");
        this.masterPanel = new JPanel();
        this.masterPanel.setLayout(new BoxLayout(this.masterPanel, 1));
        this.loadAllPanels();
        this.masterPanel.add(this.planets);
        this.masterPanel.add(this.planetInfo);
        this.masterPanel.add(this.planetProduction);
        this.masterPanel.add(this.planetTerrain);
        this.masterPanel.add(this.planetAdvanceTerrain);
        Object[] options = new Object[]{this.refreshButton, this.okayButton, this.cancelButton};
        this.pane = new JOptionPane(this.masterPanel, -1, -1, null, options, null);
        this.dialog = this.pane.createDialog(this.masterPanel, windowName);
        this.dialog.getRootPane().setDefaultButton(this.okayButton);
        this.dialog.setLocation(this.mwclient.getMainFrame().getLocation().x + this.dialog.getWidth() / 2, this.mwclient.getMainFrame().getLocation().y);
        this.dialog.setModal(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(okayCommand)) {
            if (!this.saveAllData()) {
                JOptionPane.showMessageDialog(this.mwclient.getMainFrame(), "Unable to Save Data, Check Error Logs");
            }
            try {
                this.mwclient.refreshData();
                this.removedFactory.clear();
                this.removedTerrain.clear();
                this.removedOwners.clear();
            }
            catch (Exception ex) {
                MWClient.mwClientLog.clientErrLog("PlanetEditorDialog Save Error!");
                MWClient.mwClientLog.clientErrLog(ex);
            }
            this.refreshAllPanels();
        } else if (command.equals(cancelCommand)) {
            this.dialog.dispose();
        } else if (command.equals(refreshCommand)) {
            this.planetName = this.planetNames.getSelectedItem().toString();
            this.selectedPlanet = this.mwclient.getData().getPlanetByName(this.planetName);
            this.removedOwners.clear();
            this.removedTerrain.clear();
            this.removedFactory.clear();
            this.refreshAllPanels();
        } else if (command.equals(planetTerrainsCombo)) {
            if (this.planetTerrains.getItemCount() > 0) {
                this.currentTerrainPercent.setText(Integer.toString(this.terrainMap.get(this.planetTerrains.getSelectedItem().toString())));
                this.advanceTerrainId = this.getTerrainId();
                this.loadAdvanceTerrainsData();
            }
        } else if (command.equals(planetOwnersListCommand)) {
            try {
                this.currentFactionOwnerShip.setText(Integer.toString(this.ownersMap.get(this.planetOwnersList.getSelectedItem().toString())));
            }
            catch (Exception ex) {
                this.currentFactionOwnerShip.setText("");
            }
        } else if (command.equals(resetOwnersCommand)) {
            for (int pos = 0; pos < this.planetOwnersList.getItemCount(); ++pos) {
                String name = this.planetOwnersList.getItemAt(pos).toString();
                if (name.equals(this.houseNames.getSelectedItem().toString())) continue;
                this.removedOwners.add(name);
            }
            this.planetOwnersList.removeActionListener(this);
            this.planetOwnersList.removeAllItems();
            this.planetOwnersList.addItem(this.houseNames.getSelectedItem().toString());
            this.planetOwnersList.addActionListener(this);
            this.ownersMap.put(this.houseNames.getSelectedItem().toString(), 100);
            this.planetOwnersList.setActionCommand(planetOwnersListCommand);
            if (this.planetOwnersList.getItemCount() > 0) {
                this.planetOwnersList.setSelectedIndex(0);
            }
        } else if (command.equals(addOwnerCommand)) {
            try {
                int percent = Integer.parseInt(this.newFacitonOwnerShip.getText().trim().replaceAll("%", ""));
                String newOwner = this.ownerNames.getSelectedItem().toString();
                this.removedOwners.remove(newOwner);
                this.ownersMap.put(newOwner, percent);
                this.planetOwnersList.addItem(newOwner);
                this.ownerNames.removeItem(newOwner);
                if (this.ownerNames.getItemCount() > 0) {
                    this.ownerNames.setSelectedIndex(0);
                }
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this.dialog, "Invalid Number Format Please try again");
            }
        } else if (command.equals(removeOwnerCommand)) {
            try {
                String removedOwner = this.planetOwnersList.getSelectedItem().toString();
                this.removedOwners.add(removedOwner);
                this.ownersMap.remove(removedOwner);
                this.planetOwnersList.removeItem(removedOwner);
                this.ownerNames.addItem(removedOwner);
                this.currentFactionOwnerShip.setText("");
                if (this.planetOwnersList.getItemCount() > 0) {
                    this.planetOwnersList.setSelectedIndex(0);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (command.equals(addFactoryCommand)) {
            String factoryName = this.newFactoryName.getText().trim();
            String factoryDesc = factoryName + "#" + this.factorySize.getSelectedItem().toString() + "#" + this.factoryOwners.getSelectedItem().toString() + "#" + this.factoryType.getSelectedIndex();
            String fullFactoryName = this.factorySize.getSelectedItem().toString() + " " + this.factoryType.getSelectedItem().toString() + " " + this.newFactoryName.getText().trim() + " " + this.factoryOwners.getSelectedItem().toString();
            this.factoryMap.put(factoryName, factoryDesc);
            this.planetFactories.addItem(fullFactoryName);
            this.newFactoryName.setText("");
            this.factorySize.setSelectedIndex(0);
            this.factoryOwners.setSelectedIndex(0);
            this.factoryType.setSelectedIndex(0);
        } else if (command.equals(removeFactoryCommand)) {
            if (this.planetFactories.getItemCount() < 1) {
                return;
            }
            String factoryName = "";
            for (UnitFactory factory : this.selectedPlanet.getUnitFactories()) {
                factoryName = factory.getSize() + " " + factory.getFullTypeString().trim() + " " + factory.getName() + " " + factory.getFounder();
                if (!this.planetFactories.getSelectedItem().toString().trim().equals(factoryName)) continue;
                this.removedFactory.add(factory.getName());
                this.factoryMap.remove(factory.getName());
                this.planetFactories.removeItemAt(this.planetFactories.getSelectedIndex());
                break;
            }
        } else if (command.equals(removeAllFactoriesCommand)) {
            this.removedFactory.addAll(this.factoryMap.keySet());
            this.factoryMap.clear();
            this.planetFactories.removeAllItems();
        } else if (command.equals(addTerrainCommand)) {
            try {
                int percent = Integer.parseInt(this.newTerrainPercent.getText().trim().replaceAll("%", ""));
                this.terrainMap.put(this.allTerrains.getSelectedItem().toString(), percent);
                this.planetTerrains.addItem(this.allTerrains.getSelectedItem().toString().trim());
                this.planetTerrains.setSelectedIndex(0);
                if (this.useAdvanceTerrain) {
                    AdvanceTerrain at = new AdvanceTerrain();
                    at.setDisplayName(this.allTerrains.getSelectedItem().toString());
                    this.advanceTerrainMap.put(this.allTerrains.getSelectedItem().toString(), at);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (command.equals(RemoveTerrainCommand)) {
            this.currentTerrainPercent.setText("");
            if (this.planetTerrains.getItemCount() > 0) {
                String terrainName = this.planetTerrains.getSelectedItem().toString().trim();
                this.terrainMap.remove(terrainName);
                this.removedTerrain.add(terrainName);
                this.planetTerrains.removeItemAt(this.planetTerrains.getSelectedIndex());
                if (this.planetTerrains.getItemCount() > 0) {
                    this.planetTerrains.setSelectedIndex(0);
                }
                if (this.useAdvanceTerrain) {
                    this.advanceTerrainMap.remove(terrainName);
                }
            }
        } else if (command.equals(removeAllTerrainsCommand)) {
            this.removedTerrain.addAll(this.terrainMap.keySet());
            if (this.useAdvanceTerrain) {
                this.advanceTerrainMap.clear();
            }
            this.terrainMap.clear();
            this.planetTerrains.removeAllItems();
            this.currentTerrainPercent.setText("");
        } else if (command.equals(staticMapCBCommmand) || command.equals(staticMapCBCommmand)) {
            this.updateAdvanceTerrain();
        }
    }

    private void loadAllPanels() {
        this.selectedPlanet = this.mwclient.getData().getPlanetByName(this.planetName);
        this.loadPlanetNames();
        this.loadPlanetInfo();
        this.loadPlanetProduction();
        this.loadPlanetTerrain();
        this.advanceTerrainId = this.getTerrainId();
        this.loadAdvanceTerrains();
        this.masterPanel.repaint();
    }

    private void refreshAllPanels() {
        this.loadPlanetNamesData();
        this.loadPlanetInfoData();
        this.loadPlanetProductionData();
        this.loadPlanetTerrainData();
        this.advanceTerrainId = this.getTerrainId();
        this.loadAdvanceTerrainsData();
    }

    private void loadPlanetInfo() {
        this.planetInfo = new JPanel();
        this.planetInfo.setLayout(null);
        Dimension textFieldSize = new Dimension(35, 22);
        Dimension comboBoxSize = new Dimension(150, 22);
        this.planetInfo.setLayout(new BoxLayout(this.planetInfo, 1));
        JPanel panel1 = new JPanel();
        panel1.add(new JLabel("Coords:", 11));
        this.planetXPosition.setPreferredSize(textFieldSize);
        this.planetXPosition.setMaximumSize(textFieldSize);
        this.planetXPosition.setMinimumSize(textFieldSize);
        this.planetXPosition.setText(Double.toString(this.selectedPlanet.getPosition().getX()));
        this.planetXPosition.setToolTipText("Planets X Coord");
        panel1.add(this.planetXPosition);
        panel1.add(new JLabel(",", 11));
        this.planetYPosition.setPreferredSize(textFieldSize);
        this.planetYPosition.setMaximumSize(textFieldSize);
        this.planetYPosition.setMinimumSize(textFieldSize);
        this.planetYPosition.setText(Double.toString(this.selectedPlanet.getPosition().getY()));
        this.planetYPosition.setToolTipText("Planets Y Coord");
        panel1.add(this.planetYPosition);
        this.isHomeWorldCB.setText("HomeWorld");
        this.isHomeWorldCB.setSelected(this.selectedPlanet.isHomeWorld());
        panel1.add(this.isHomeWorldCB);
        JPanel panel2 = new JPanel();
        panel2.add(new JLabel("MinOwnerShip:", 11));
        this.minPlanetOwnerShip.setText(Integer.toString(this.selectedPlanet.getMinPlanetOwnerShip()));
        panel2.add(this.minPlanetOwnerShip);
        this.minPlanetOwnerShip.setPreferredSize(textFieldSize);
        this.minPlanetOwnerShip.setMaximumSize(textFieldSize);
        this.minPlanetOwnerShip.setMinimumSize(textFieldSize);
        panel2.add(new JLabel("Conquer Points:", 11));
        this.planetConquerPoints.setPreferredSize(textFieldSize);
        this.planetConquerPoints.setMaximumSize(textFieldSize);
        this.planetConquerPoints.setMinimumSize(textFieldSize);
        this.planetConquerPoints.setText(Integer.toString(this.selectedPlanet.getConquestPoints()));
        panel2.add(this.planetConquerPoints);
        JPanel panel3 = new JPanel(new SpringLayout());
        panel3.add(new JLabel("Original Owner:", 11));
        this.houseNames = new JComboBox();
        this.populateHouseNames(this.houseNames);
        this.houseNames.setPreferredSize(comboBoxSize);
        this.houseNames.setMaximumSize(comboBoxSize);
        this.houseNames.setMinimumSize(comboBoxSize);
        this.houseNames.setSelectedItem(this.selectedPlanet.getOriginalOwner());
        panel3.add(this.houseNames);
        SpringLayoutHelper.setupSpringGrid(panel3, 2);
        JPanel panel4 = new JPanel();
        panel4.setLayout(new BoxLayout(panel4, 2));
        panel4.add(new JLabel("Owners:", 2));
        TreeSet<String> houseList = new TreeSet<String>();
        for (House house : this.selectedPlanet.getInfluence().getHouses()) {
            houseList.add(house.getName());
            this.ownersMap.put(house.getName(), this.selectedPlanet.getInfluence().getInfluence(house.getId()));
        }
        this.planetOwnersList = new JComboBox<Object>(houseList.toArray());
        this.planetOwnersList.addActionListener(this);
        this.planetOwnersList.setActionCommand(planetOwnersListCommand);
        this.planetOwnersList.setSelectedIndex(0);
        this.planetOwnersList.setPreferredSize(comboBoxSize);
        this.planetOwnersList.setMaximumSize(comboBoxSize);
        this.planetOwnersList.setMinimumSize(comboBoxSize);
        panel4.add(this.planetOwnersList);
        this.currentFactionOwnerShip.setPreferredSize(textFieldSize);
        this.currentFactionOwnerShip.setMaximumSize(textFieldSize);
        this.currentFactionOwnerShip.setMinimumSize(textFieldSize);
        this.currentFactionOwnerShip.addKeyListener(this);
        panel4.add(this.currentFactionOwnerShip);
        JPanel panel5 = new JPanel();
        this.ownerNames = new JComboBox();
        this.populateHouseNames(this.ownerNames);
        this.ownerNames.setPreferredSize(comboBoxSize);
        this.ownerNames.setMaximumSize(comboBoxSize);
        this.ownerNames.setMinimumSize(comboBoxSize);
        panel5.add(this.ownerNames);
        panel5.add(this.newFacitonOwnerShip);
        JPanel buttonPanel = new JPanel();
        this.addOwnerButton.addActionListener(this);
        this.addOwnerButton.setActionCommand(addOwnerCommand);
        this.removeOwnerButton.addActionListener(this);
        this.removeOwnerButton.setActionCommand(removeOwnerCommand);
        this.resetOwnersButton.addActionListener(this);
        this.resetOwnersButton.setActionCommand(resetOwnersCommand);
        buttonPanel.add(this.addOwnerButton);
        buttonPanel.add(this.removeOwnerButton);
        buttonPanel.add(this.resetOwnersButton);
        this.planetInfo.add(panel1);
        this.planetInfo.add(panel2);
        this.planetInfo.add(panel3);
        this.planetInfo.add(panel4);
        this.planetInfo.add(panel5);
        this.planetInfo.add(buttonPanel);
        this.planetInfo.setBorder(BorderFactory.createLineBorder(Color.black));
        this.planetInfo.repaint();
    }

    private void loadPlanetProduction() {
        this.planetProduction = new JPanel();
        Dimension textFieldSize = new Dimension(35, 22);
        Dimension comboBoxSize = new Dimension(150, 22);
        this.planetProduction.setBorder(BorderFactory.createLineBorder(Color.black));
        this.planetProduction.setLayout(new BoxLayout(this.planetProduction, 1));
        JPanel panel1 = new JPanel(new SpringLayout());
        panel1.add(new JLabel("Warehouses:", 11));
        this.planetBays.setText(Integer.toString(this.selectedPlanet.getBaysProvided()));
        this.planetBays.setName("BaysProvided");
        this.planetBays.addActionListener(this);
        this.planetBays.setPreferredSize(textFieldSize);
        this.planetBays.setMaximumSize(textFieldSize);
        this.planetBays.setMinimumSize(textFieldSize);
        panel1.add(this.planetBays);
        panel1.add(new JLabel("Production:", 11));
        this.planetComps.setText(Integer.toString(this.selectedPlanet.getCompProduction()));
        this.planetComps.setName("CompProduction");
        this.planetComps.addActionListener(this);
        this.planetComps.setPreferredSize(textFieldSize);
        this.planetComps.setMaximumSize(textFieldSize);
        this.planetComps.setMinimumSize(textFieldSize);
        panel1.add(this.planetComps);
        SpringLayoutHelper.setupSpringGrid(panel1, 4);
        JPanel panel2 = new JPanel();
        panel2.add(new JLabel("Factories", 11));
        TreeSet<String> factoryList = new TreeSet<String>();
        for (UnitFactory factory : this.selectedPlanet.getUnitFactories()) {
            factoryList.add(factory.getSize() + " " + factory.getFullTypeString().trim() + " " + factory.getName() + " " + factory.getFounder());
            this.factoryMap.put(factory.getName(), factory.getName() + "#" + factory.getSize() + "#" + factory.getFounder() + "#" + factory.getType());
        }
        this.planetFactories = new JComboBox<Object>(factoryList.toArray());
        this.planetFactories.setOpaque(false);
        panel2.add(this.planetFactories);
        JPanel panel3 = new JPanel();
        this.newFactoryName.setToolTipText("Name of your new factory");
        this.factoryOwners = new JComboBox();
        this.populateHouseNames(this.factoryOwners);
        this.factoryOwners.setPreferredSize(comboBoxSize);
        this.factoryOwners.setMaximumSize(comboBoxSize);
        this.factoryOwners.setMinimumSize(comboBoxSize);
        panel3.add(this.factorySize);
        panel3.add(this.factoryType);
        panel3.add(this.factoryOwners);
        panel3.add(this.newFactoryName);
        JPanel buttonPanel = new JPanel();
        this.addFactory.addActionListener(this);
        this.addFactory.setActionCommand(addFactoryCommand);
        buttonPanel.add(this.addFactory);
        this.removeFactory.addActionListener(this);
        this.removeFactory.setActionCommand(removeFactoryCommand);
        buttonPanel.add(this.removeFactory);
        this.removeAllFactories.addActionListener(this);
        this.removeAllFactories.setActionCommand(removeAllFactoriesCommand);
        buttonPanel.add(this.removeAllFactories);
        this.planetProduction.add(panel1);
        this.planetProduction.add(panel2);
        this.planetProduction.add(panel3);
        this.planetProduction.add(buttonPanel);
        this.planetProduction.repaint();
    }

    private void loadPlanetTerrain() {
        this.planetTerrain = new JPanel();
        this.planetTerrain.setBorder(BorderFactory.createLineBorder(Color.black));
        this.planetTerrain.setLayout(new BoxLayout(this.planetTerrain, 1));
        JPanel panel1 = new JPanel();
        panel1.add(new JLabel("Terrains:", 0));
        TreeSet<String> terrainList = new TreeSet<String>();
        Iterator<Continent> terrains = this.selectedPlanet.getEnvironments().iterator();
        while (terrains.hasNext()) {
            Continent terrain = terrains.next();
            terrainList.add(terrain.getEnvironment().getName());
            this.terrainMap.put(terrain.getEnvironment().getName(), terrain.getSize());
        }
        this.planetTerrains = new JComboBox<Object>(terrainList.toArray());
        this.planetTerrains.addActionListener(this);
        this.planetTerrains.setActionCommand(planetTerrainsCombo);
        if (this.planetTerrains.getItemCount() > 0) {
            this.planetTerrains.setSelectedIndex(0);
        }
        this.currentTerrainPercent.addKeyListener(this);
        panel1.add(this.planetTerrains);
        panel1.add(this.currentTerrainPercent);
        JPanel panel2 = new JPanel();
        this.allTerrains = new JComboBox();
        terrainList = new TreeSet();
        for (PlanetEnvironment terrain : this.mwclient.getData().getAllTerrains()) {
            if (this.terrainMap.containsKey(terrain.getName())) continue;
            terrainList.add(terrain.getName());
        }
        this.addAllItems(this.allTerrains, terrainList);
        panel2.add(this.allTerrains);
        this.newTerrainPercent.setToolTipText("Enter the % Chance for this new Terrain");
        panel2.add(this.newTerrainPercent);
        JPanel buttonPanel = new JPanel();
        this.addTerrain.addActionListener(this);
        this.addTerrain.setActionCommand(addTerrainCommand);
        buttonPanel.add(this.addTerrain);
        this.removeTerrain.addActionListener(this);
        this.removeTerrain.setActionCommand(RemoveTerrainCommand);
        buttonPanel.add(this.removeTerrain);
        this.removeAllTerrains.addActionListener(this);
        this.removeAllTerrains.setActionCommand(removeAllTerrainsCommand);
        buttonPanel.add(this.removeAllTerrains);
        this.planetTerrain.add(panel1);
        this.planetTerrain.add(panel2);
        this.planetTerrain.add(buttonPanel);
        this.planetTerrain.repaint();
    }

    private void loadAdvanceTerrains() {
        this.planetAdvanceTerrain = new JPanel();
        this.planetAdvanceTerrain.setBorder(BorderFactory.createLineBorder(Color.black));
        this.aTerrain = this.mwclient.getData().getPlanetByName(this.planetName).getAdvanceTerrain().get(this.advanceTerrainId);
        this.planetAdvanceTerrain.setLayout(new BoxLayout(this.planetAdvanceTerrain, 1));
        JPanel textPanel = new JPanel(new SpringLayout());
        JPanel checkboxPanel = new JPanel();
        if (this.useAdvanceTerrain) {
            for (int aTerrainId : this.selectedPlanet.getAdvanceTerrain().keySet()) {
                this.advanceTerrainMap.put(this.mwclient.getData().getTerrain(aTerrainId).getName(), this.selectedPlanet.getAdvanceTerrain().get(aTerrainId));
            }
            textPanel.add(new JLabel("Display Name:", 11));
            this.DisplayNameText.setToolTipText("Name of the Continent to appear in planet info");
            this.DisplayNameText.addKeyListener(this);
            textPanel.add(this.DisplayNameText);
            textPanel.add(new JLabel("Static Map Name:", 11));
            this.StaticMapNameText.setToolTipText("<HTML>Name of a static map you wish to use instead of the RMG<BR>Static Map must be checked to work<br>leave on surprise to grab a random map");
            this.StaticMapNameText.addKeyListener(this);
            textPanel.add(this.StaticMapNameText);
            textPanel.add(new JLabel("Map X Size:", 11));
            this.XSizeText.setToolTipText("For static maps X size of the Map");
            this.XSizeText.addKeyListener(this);
            textPanel.add(this.XSizeText);
            textPanel.add(new JLabel("Map Y Size:", 11));
            this.YSizeText.setToolTipText("For static maps Y size of the Map");
            this.YSizeText.addKeyListener(this);
            textPanel.add(this.YSizeText);
            textPanel.add(new JLabel("Board X Size:", 11));
            this.XBoardSizeText.setToolTipText("For static maps X size of the Board");
            this.XBoardSizeText.addKeyListener(this);
            textPanel.add(this.XBoardSizeText);
            textPanel.add(new JLabel("Board Y Size:", 11));
            this.YBoardSizeText.setToolTipText("For static maps Y size of the Board");
            this.YBoardSizeText.addKeyListener(this);
            textPanel.add(this.YBoardSizeText);
            textPanel.add(new JLabel("Low Temp:", 11));
            this.LowTempText.setToolTipText("The Lowest temp for this terrain");
            this.LowTempText.addKeyListener(this);
            textPanel.add(this.LowTempText);
            textPanel.add(new JLabel("High Temp:", 11));
            this.HighTempText.setToolTipText("The Highest temp for this terrain");
            this.HighTempText.addKeyListener(this);
            textPanel.add(this.HighTempText);
            textPanel.add(new JLabel("Gravity:", 11));
            this.GravityText.setToolTipText("Gravity for this terrain");
            this.GravityText.addKeyListener(this);
            textPanel.add(this.GravityText);
            textPanel.add(new JLabel("Night Chance:", 11));
            this.NightChanceText.setToolTipText("Chance for night to occur on this terrain");
            this.NightChanceText.addKeyListener(this);
            textPanel.add(this.NightChanceText);
            textPanel.add(new JLabel("Temp Reduction:", 11));
            this.NightTempModText.setToolTipText("<html>Calculated temp is reduced by <br> this much at night and 1/2 as much at dusk/down<br>i.e. if set to 10 and the temp is 50 the new temp with be 40</html>");
            this.NightTempModText.addKeyListener(this);
            textPanel.add(this.NightTempModText);
            textPanel.add(new JLabel("Min Visibility:", 11));
            this.MinVisibilityText.setToolTipText("The Minium Visibility this map can see");
            this.MinVisibilityText.addKeyListener(this);
            textPanel.add(this.MinVisibilityText);
            textPanel.add(new JLabel("Max Visibility:", 11));
            this.MaxVisibilityText.setToolTipText("<html>The Max Visibility this map can see</html>");
            this.MaxVisibilityText.addKeyListener(this);
            textPanel.add(this.MaxVisibilityText);
            SpringLayoutHelper.setupSpringGrid(textPanel, 4);
            this.isStaticMapCB.setText("Use Static Maps");
            this.isStaticMapCB.setToolTipText("Check if you want to use static maps.");
            this.isStaticMapCB.addActionListener(this);
            this.isStaticMapCB.setActionCommand(staticMapCBCommmand);
            checkboxPanel.add(this.isStaticMapCB);
            this.isVacuumCB.setText("Has a Vaccum");
            this.isVacuumCB.setToolTipText("Check if you want a vacuum for this terrain.");
            this.isVacuumCB.addActionListener(this);
            this.isVacuumCB.setActionCommand(vacuumCBCommand);
            checkboxPanel.add(this.isVacuumCB);
        } else {
            textPanel.add(new JLabel("Low Temp:", 11));
            this.LowTempText.setToolTipText("The Lowest temp for this terrain");
            textPanel.add(this.LowTempText);
            textPanel.add(new JLabel("High Temp:", 11));
            this.HighTempText.setToolTipText("The Highest temp for this terrain");
            textPanel.add(this.HighTempText);
            textPanel.add(new JLabel("Gravity:", 11));
            this.GravityText.setToolTipText("Gravity for this terrain");
            textPanel.add(this.GravityText);
            textPanel.add(new JLabel("Night Chance:", 11));
            this.NightChanceText.setToolTipText("Chance for night to occur on this terrain");
            textPanel.add(this.NightChanceText);
            textPanel.add(new JLabel("Temp Reduction:", 11));
            this.NightTempModText.setToolTipText("<html>Calculated temp is reduced by <br> this much at night and 1/2 as much at dusk/down<br>i.e. if set to 10 and the temp is 50 the new temp with be 40</html>");
            textPanel.add(this.NightTempModText);
            SpringLayoutHelper.setupSpringGrid(textPanel, 4);
        }
        this.planetAdvanceTerrain.add(checkboxPanel);
        this.planetAdvanceTerrain.add(textPanel);
        if (this.aTerrain != null && this.useAdvanceTerrain) {
            this.DisplayNameText.setText(this.aTerrain.getDisplayName());
            this.StaticMapNameText.setText(this.aTerrain.getStaticMapName());
            this.XSizeText.setText(Integer.toString(this.aTerrain.getXSize()));
            this.YSizeText.setText(Integer.toString(this.aTerrain.getYSize()));
            this.XBoardSizeText.setText(Integer.toString(this.aTerrain.getXBoardSize()));
            this.YBoardSizeText.setText(Integer.toString(this.aTerrain.getYBoardSize()));
            this.LowTempText.setText(Integer.toString(this.aTerrain.getLowTemp()));
            this.HighTempText.setText(Integer.toString(this.aTerrain.getHighTemp()));
            this.GravityText.setText(Double.toString(this.aTerrain.getGravity()));
            this.NightChanceText.setText(Integer.toString(this.aTerrain.getNightChance()));
            this.NightTempModText.setText(Integer.toString(this.aTerrain.getNightTempMod()));
            this.MinVisibilityText.setText(Integer.toString(this.aTerrain.getMinVisibility()));
            this.MaxVisibilityText.setText(Integer.toString(this.aTerrain.getMaxVisibility()));
            this.isStaticMapCB.setSelected(this.aTerrain.isStaticMap());
            this.isVacuumCB.setSelected(this.aTerrain.isVacuum());
        } else {
            this.LowTempText.setText(Integer.toString(this.selectedPlanet.getTemp().width));
            this.HighTempText.setText(Double.toString(this.selectedPlanet.getTemp().height));
            this.GravityText.setText(Double.toString(this.selectedPlanet.getGravity()));
            this.NightChanceText.setText(Integer.toString(this.selectedPlanet.getNightChance()));
            this.NightTempModText.setText(Integer.toString(this.selectedPlanet.getNightTempMod()));
        }
        this.planetAdvanceTerrain.repaint();
    }

    private void loadPlanetNames() {
        this.planets = new JPanel();
        Collection<Planet> planets = this.mwclient.getData().getAllPlanets();
        Dimension comboBoxSize = new Dimension(150, 22);
        TreeSet<String> pNames = new TreeSet<String>();
        Iterator<Planet> it = planets.iterator();
        while (it.hasNext()) {
            pNames.add(it.next().getName());
        }
        this.planetNames = new JComboBox<Object>(pNames.toArray());
        this.planetNames.setSelectedItem(this.planetName);
        this.planetNames.addActionListener(this);
        this.planetNames.setActionCommand(refreshCommand);
        this.planetNames.setPreferredSize(comboBoxSize);
        this.planetNames.setMaximumSize(comboBoxSize);
        this.planetNames.setMinimumSize(comboBoxSize);
        this.planets.add(new JLabel("Planet:", 11));
        this.planets.add(this.planetNames);
        this.planets.setBorder(BorderFactory.createLineBorder(Color.black));
    }

    private void loadPlanetInfoData() {
        this.planetXPosition.setText(Double.toString(this.selectedPlanet.getPosition().getX()));
        this.planetXPosition.setToolTipText("Planets X Coord");
        this.planetYPosition.setText(Double.toString(this.selectedPlanet.getPosition().getY()));
        this.planetYPosition.setToolTipText("Planets Y Coord");
        this.isHomeWorldCB.setText("HomeWorld");
        this.isHomeWorldCB.setSelected(this.selectedPlanet.isHomeWorld());
        this.ownersMap.clear();
        this.houseNames.removeAllItems();
        this.populateHouseNames(this.houseNames);
        this.houseNames.setSelectedItem(this.selectedPlanet.getOriginalOwner());
        TreeSet<String> houseList = new TreeSet<String>();
        for (House house : this.selectedPlanet.getInfluence().getHouses()) {
            if (this.removedOwners.contains(house.getName())) continue;
            houseList.add(house.getName());
            this.ownersMap.put(house.getName(), this.selectedPlanet.getInfluence().getInfluence(house.getId()));
        }
        this.planetOwnersList.removeActionListener(this);
        this.planetOwnersList.removeAllItems();
        this.addAllItems(this.planetOwnersList, houseList);
        this.planetOwnersList.addActionListener(this);
        this.planetOwnersList.setActionCommand(planetOwnersListCommand);
        this.planetOwnersList.setSelectedIndex(0);
        this.minPlanetOwnerShip.setText(Integer.toString(this.selectedPlanet.getMinPlanetOwnerShip()));
        this.planetConquerPoints.setText(Integer.toString(this.selectedPlanet.getConquestPoints()));
        this.ownerNames.removeAllItems();
        this.populateHouseNames(this.ownerNames);
    }

    private void loadPlanetProductionData() {
        this.planetBays.setText(Integer.toString(this.selectedPlanet.getBaysProvided()));
        this.planetBays.setName("BaysProvided");
        this.planetBays.addActionListener(this);
        this.planetComps.setText(Integer.toString(this.selectedPlanet.getCompProduction()));
        this.planetComps.setName("CompProduction");
        this.planetComps.addActionListener(this);
        this.factoryMap.clear();
        TreeSet<String> factoryList = new TreeSet<String>();
        for (UnitFactory factory : this.selectedPlanet.getUnitFactories()) {
            if (this.removedFactory.contains(factory.getName())) continue;
            factoryList.add(factory.getSize() + " " + factory.getFullTypeString().trim() + " " + factory.getName() + " " + factory.getFounder());
            this.factoryMap.put(factory.getName(), factory.getName() + "#" + factory.getSize() + "#" + factory.getFounder() + "#" + factory.getType());
        }
        this.planetFactories.removeAllItems();
        this.addAllItems(this.planetFactories, factoryList);
    }

    private void loadPlanetTerrainData() {
        TreeSet<String> terrainList = new TreeSet<String>();
        Iterator<Continent> terrains = this.selectedPlanet.getEnvironments().iterator();
        this.terrainMap.clear();
        while (terrains.hasNext()) {
            Continent terrain = terrains.next();
            if (this.removedTerrain.contains(terrain.getEnvironment().getName())) continue;
            terrainList.add(terrain.getEnvironment().getName());
            this.terrainMap.put(terrain.getEnvironment().getName(), terrain.getSize());
        }
        this.planetTerrains.removeActionListener(this);
        this.planetTerrains.removeAllItems();
        this.addAllItems(this.planetTerrains, terrainList);
        this.planetTerrains.addActionListener(this);
        this.planetTerrains.setActionCommand(planetTerrainsCombo);
        if (this.planetTerrains.getItemCount() > 0) {
            this.planetTerrains.setSelectedIndex(0);
        }
        this.allTerrains.removeAllItems();
        terrainList = new TreeSet();
        for (PlanetEnvironment terrain : this.mwclient.getData().getAllTerrains()) {
            if (this.terrainMap.containsKey(terrain.getName())) continue;
            terrainList.add(terrain.getName());
        }
        this.addAllItems(this.allTerrains, terrainList);
    }

    private void loadAdvanceTerrainsData() {
        this.aTerrain = this.planetTerrains.getItemCount() < 1 ? null : this.advanceTerrainMap.get(this.planetTerrains.getSelectedItem().toString());
        if (this.aTerrain != null) {
            this.DisplayNameText.setText(this.aTerrain.getDisplayName());
            this.StaticMapNameText.setText(this.aTerrain.getStaticMapName());
            this.XSizeText.setText(Integer.toString(this.aTerrain.getXSize()));
            this.YSizeText.setText(Integer.toString(this.aTerrain.getYSize()));
            this.XBoardSizeText.setText(Integer.toString(this.aTerrain.getXBoardSize()));
            this.YBoardSizeText.setText(Integer.toString(this.aTerrain.getYBoardSize()));
            this.LowTempText.setText(Integer.toString(this.aTerrain.getLowTemp()));
            this.HighTempText.setText(Integer.toString(this.aTerrain.getHighTemp()));
            this.GravityText.setText(Double.toString(this.aTerrain.getGravity()));
            this.NightChanceText.setText(Integer.toString(this.aTerrain.getNightChance()));
            this.NightTempModText.setText(Integer.toString(this.aTerrain.getNightTempMod()));
            this.MinVisibilityText.setText(Integer.toString(this.aTerrain.getMinVisibility()));
            this.MaxVisibilityText.setText(Integer.toString(this.aTerrain.getMaxVisibility()));
            this.isStaticMapCB.setSelected(this.aTerrain.isStaticMap());
            this.isVacuumCB.setSelected(this.aTerrain.isVacuum());
        } else {
            this.DisplayNameText.setText("");
            this.StaticMapNameText.setText("");
            this.XSizeText.setText("");
            this.YSizeText.setText("");
            this.XBoardSizeText.setText("");
            this.YBoardSizeText.setText("");
            this.LowTempText.setText(Integer.toString(this.selectedPlanet.getTemp().width));
            this.HighTempText.setText(Double.toString(this.selectedPlanet.getTemp().height));
            this.GravityText.setText(Double.toString(this.selectedPlanet.getGravity()));
            this.NightChanceText.setText(Integer.toString(this.selectedPlanet.getNightChance()));
            this.NightTempModText.setText(Integer.toString(this.selectedPlanet.getNightTempMod()));
            this.MinVisibilityText.setText("");
            this.MaxVisibilityText.setText("");
            this.isStaticMapCB.setSelected(false);
            this.isVacuumCB.setSelected(false);
        }
    }

    private void loadPlanetNamesData() {
        this.planetNames.removeActionListener(this);
        this.planetNames.removeAllItems();
        TreeSet<String> pNames = new TreeSet<String>();
        for (Planet planet : this.mwclient.getData().getAllPlanets()) {
            pNames.add(planet.getName());
        }
        this.planetNames.removeAllItems();
        this.addAllItems(this.planetNames, pNames);
        this.planetNames.setSelectedItem(this.planetName);
        this.planetNames.addActionListener(this);
        this.planetNames.setActionCommand(refreshCommand);
    }

    private void populateHouseNames(JComboBox combo) {
        TreeSet<String> factionNames = new TreeSet<String>();
        for (House house : this.mwclient.getData().getAllHouses()) {
            if (this.ownersMap.containsKey(house.getName())) continue;
            factionNames.add(house.getName());
        }
        this.addAllItems(combo, factionNames);
    }

    private void addAllItems(JComboBox combo, TreeSet<String> list) {
        for (String name : list) {
            combo.addItem(name);
        }
    }

    private int getTerrainId() {
        try {
            return this.mwclient.getData().getTerrainByName(this.planetTerrains.getSelectedItem().toString().trim()).getId();
        }
        catch (Exception ex) {
            return -1;
        }
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getComponent() == null) {
            return;
        }
        if (e.getComponent().equals(this.currentFactionOwnerShip)) {
            try {
                int percent = Integer.parseInt(this.currentFactionOwnerShip.getText().trim().replaceAll("%", ""));
                this.ownersMap.put(this.planetOwnersList.getSelectedItem().toString(), percent);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (e.getComponent().equals(this.currentTerrainPercent)) {
            try {
                int percent = Integer.parseInt(this.currentTerrainPercent.getText().trim().replaceAll("%", ""));
                this.terrainMap.put(this.planetTerrains.getSelectedItem().toString(), percent);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (e.getComponent().equals(this.StaticMapNameText) || e.getComponent().equals(this.DisplayNameText) || e.getComponent().equals(this.XBoardSizeText) || e.getComponent().equals(this.YBoardSizeText) || e.getComponent().equals(this.XSizeText) || e.getComponent().equals(this.YSizeText) || e.getComponent().equals(this.MinVisibilityText) || e.getComponent().equals(this.MaxVisibilityText) || e.getComponent().equals(this.LowTempText) || e.getComponent().equals(this.HighTempText) || e.getComponent().equals(this.NightChanceText) || e.getComponent().equals(this.NightTempModText) || e.getComponent().equals(this.GravityText)) {
            this.updateAdvanceTerrain();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private void updateAdvanceTerrain() {
        AdvanceTerrain aTerrain = this.advanceTerrainMap.get(this.planetTerrains.getSelectedItem().toString());
        if (aTerrain == null) {
            return;
        }
        aTerrain.setDisplayName(this.DisplayNameText.getText());
        aTerrain.setStaticMapName(this.StaticMapNameText.getText());
        aTerrain.setXSize(Integer.parseInt(this.XSizeText.getText()));
        aTerrain.setYSize(Integer.parseInt(this.YSizeText.getText()));
        aTerrain.setXBoardSize(Integer.parseInt(this.XBoardSizeText.getText()));
        aTerrain.setYBoardSize(Integer.parseInt(this.YBoardSizeText.getText()));
        aTerrain.setLowTemp(Integer.parseInt(this.LowTempText.getText()));
        aTerrain.setHighTemp(Integer.parseInt(this.HighTempText.getText()));
        aTerrain.setGravity(Double.parseDouble(this.GravityText.getText()));
        aTerrain.setNightChance(Integer.parseInt(this.NightChanceText.getText()));
        aTerrain.setNightTempMod(Integer.parseInt(this.NightTempModText.getText()));
        aTerrain.setMinVisibility(Integer.parseInt(this.MinVisibilityText.getText()));
        aTerrain.setMaxVisibility(Integer.parseInt(this.MaxVisibilityText.getText()));
        aTerrain.setStaticMap(this.isStaticMapCB.isSelected());
        aTerrain.setVacuum(this.isVacuumCB.isSelected());
    }

    private boolean saveAllData() {
        try {
            this.removeOwners();
            this.removeFactories();
            this.removeTerrain();
            this.saveOwners();
            this.saveFactories();
            this.saveTerrain();
            this.saveAdvanceTerrain();
            this.saveMisc();
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog(ex);
            return false;
        }
        return true;
    }

    private void removeOwners() {
        if (this.removedOwners.size() < 1) {
            return;
        }
        for (String owner : this.removedOwners) {
            this.mwclient.sendChat("/c AdminRemovePlanetOwnership#" + this.planetName + "#" + owner);
        }
    }

    private void removeFactories() {
        this.mwclient.sendChat("/c AdminRemoveAllFactories#" + this.planetName);
    }

    private void removeTerrain() {
        this.mwclient.sendChat("/c AdminRemoveAllTerrain#" + this.planetName);
    }

    private void saveOwners() {
        for (String owner : this.ownersMap.keySet()) {
            this.mwclient.sendChat("/c AdminUpdatePlanetOwnership#" + this.planetName + "#" + owner + "#" + this.ownersMap.get(owner));
        }
    }

    private void saveFactories() {
        for (String factory : this.factoryMap.keySet()) {
            this.mwclient.sendChat("/c AdminCreateFactory#" + this.planetName + "#" + this.factoryMap.get(factory));
        }
    }

    private void saveTerrain() {
        for (String terrain : this.terrainMap.keySet()) {
            this.mwclient.sendChat("/c AdminCreateTerrain#" + this.planetName + "#" + terrain + "#" + this.terrainMap.get(terrain));
        }
    }

    private void saveAdvanceTerrain() {
        if (this.useAdvanceTerrain) {
            for (String terrain : this.terrainMap.keySet()) {
                AdvanceTerrain aTerrain = this.advanceTerrainMap.get(terrain);
                this.mwclient.sendChat("/c SetAdvancePlanetTerrain#" + this.planetName + "#" + this.mwclient.getData().getTerrainByName(terrain).getId() + "#" + (aTerrain.getDisplayName().trim().length() < 1 ? "Display Name" : aTerrain.getDisplayName()) + "#" + aTerrain.getXSize() + "#" + aTerrain.getYSize() + "#" + aTerrain.isStaticMap() + "#" + aTerrain.getXBoardSize() + "#" + aTerrain.getYBoardSize() + "#" + aTerrain.getLowTemp() + "#" + aTerrain.getHighTemp() + "#" + aTerrain.getGravity() + "#" + aTerrain.isVacuum() + "#" + aTerrain.getNightChance() + "#" + aTerrain.getNightTempMod() + "#" + aTerrain.getStaticMapName() + "#" + aTerrain.getMinVisibility() + "#" + aTerrain.getMaxVisibility());
            }
        } else {
            this.mwclient.sendChat("/c AdminSetPlanetBoardSize#" + this.planetName + "#" + this.XBoardSizeText.getText() + "#" + this.YBoardSizeText.getText());
            this.mwclient.sendChat("/c AdminSetPlanetGravity#" + this.planetName + "#" + this.GravityText.getText());
            this.mwclient.sendChat("/c AdminSetPlanetMapSize#" + this.planetName + "#" + this.XSizeText.getText() + "#" + this.YSizeText.getText());
            this.mwclient.sendChat("/c AdminSetPlanetTemperature#" + this.planetName + "#" + this.LowTempText.getText() + "#" + this.HighTempText.getText());
            this.mwclient.sendChat("/c AdminSetPlanetVacuum#" + this.planetName + "#" + this.isVacuumCB.isSelected());
        }
    }

    private void saveMisc() {
        if (!this.planetXPosition.getText().equals(Double.toString(this.selectedPlanet.getPosition().getX())) || !this.planetYPosition.getText().equals(Double.toString(this.selectedPlanet.getPosition().getY()))) {
            this.mwclient.sendChat("/c AdminMovePlanet#" + this.planetName + "#" + this.planetXPosition.getText() + "#" + this.planetYPosition.getText());
        }
        if (!this.planetOwnersList.getSelectedItem().toString().equals(this.selectedPlanet.getOriginalOwner())) {
            this.mwclient.sendChat("/c AdminSetPlanetOriginalOwner#" + this.planetName + "#" + this.planetOwnersList.getSelectedItem().toString());
        }
        if (!this.minPlanetOwnerShip.getText().equals(Integer.toString(this.selectedPlanet.getMinPlanetOwnerShip()))) {
            this.mwclient.sendChat("/c SetPlanetMinOwnerShip#" + this.planetName + "#" + this.selectedPlanet.getMinPlanetOwnerShip());
        }
        if (!this.planetConquerPoints.getText().equals(Integer.toString(this.selectedPlanet.getConquestPoints()))) {
            this.mwclient.sendChat("/c SetPlanetConquerPoints#" + this.planetName + "#" + this.selectedPlanet.getConquestPoints());
        }
    }
}

