/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.AdvanceTerrain;
import common.CampaignData;
import common.Continent;
import common.House;
import common.Influences;
import common.MutableSerializable;
import common.PlanetEnvironments;
import common.UnitFactory;
import common.persistence.MMNetSerializable;
import common.persistence.TreeReader;
import common.persistence.TreeWriter;
import common.util.BinReader;
import common.util.BinWriter;
import common.util.Position;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Planet
implements Comparable,
MutableSerializable,
MMNetSerializable {
    private int id;
    private String name;
    private Position position;
    private Vector<UnitFactory> unitFactories = new Vector();
    private PlanetEnvironments environments = new PlanetEnvironments();
    private String description = "";
    private int baysProvided = 0;
    private boolean conquerable = true;
    private int compProduction = 0;
    private Influences influence;
    private Dimension MapSize = new Dimension(1, 1);
    private Dimension BoardSize = new Dimension(16, 17);
    private Dimension temperature = new Dimension(25, 25);
    private double gravity = 1.0;
    private boolean vacuum = false;
    private int nightChance = 0;
    private int nightTempMod = 0;
    private Hashtable<Integer, AdvanceTerrain> advanceTerrain = new Hashtable();
    private int minPlanetOwnerShip = -1;
    private boolean homeWorld = false;
    private String originalOwner = "";
    private TreeMap<String, String> planetFlags = new TreeMap();
    private int maxConquestPoints = 100;
    private int DBID = 0;

    public Planet(int id, String name, Position position, Influences influence) {
        this.setId(id);
        this.setName(name);
        this.setPosition(position);
        this.setInfluence(influence);
    }

    public Planet() {
    }

    public Planet(BinReader in, Map factions, CampaignData data) throws IOException {
        int i;
        this.setId(new Integer(in.readInt("id")));
        this.setName(in.readLine("name"));
        this.setPosition(new Position(in.readDouble("x"), in.readDouble("y")));
        this.setUnitFactories(new Vector<UnitFactory>());
        int size = in.readInt("unitFactories.size");
        for (i = 0; i < size; ++i) {
            UnitFactory uf = new UnitFactory();
            uf.binIn(in);
            this.getUnitFactories().add(uf);
        }
        this.setEnvironments(new PlanetEnvironments());
        this.getEnvironments().binIn(in, data);
        this.setDescription(in.readLine("description"));
        this.setBaysProvided(in.readInt("baysProvided"));
        this.setConquerable(in.readBoolean("conquerable"));
        this.setCompProduction(in.readInt("compProduction"));
        this.setInfluence(new Influences());
        this.getInfluence().binIn(in, factions);
        this.setMapSize(new Dimension(in.readInt("x"), in.readInt("y")));
        this.setBoardSize(new Dimension(in.readInt("x"), in.readInt("y")));
        this.setTemp(new Dimension(in.readInt("lowtemp"), in.readInt("hitemp")));
        this.setGravity(in.readDouble("gravity"));
        this.setVacuum(in.readBoolean("vacuum"));
        this.setMinPlanetOwnerShip(in.readInt("minplanetownership"));
        this.setHomeWorld(in.readBoolean("homeworld"));
        this.setOriginalOwner(in.readLine("originalowner"));
        size = in.readInt("AdvanceTerrain.size");
        for (i = 0; i < size; ++i) {
            AdvanceTerrain aTerrain = new AdvanceTerrain();
            int id = in.readInt("AdvanceTerrainId");
            aTerrain.binIn(in);
            this.getAdvanceTerrain().put(new Integer(id), aTerrain);
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        size = in.readInt("PlanetFlags.size");
        for (int i2 = 0; i2 < size; ++i2) {
            String key = in.readLine("PlanetFlags.key");
            String value = in.readLine("PlanetFlags.value");
            map.put(key, value);
        }
        this.setPlanetFlags(map);
        this.setConquestPoints(in.readInt("MaxInfluence"));
    }

    public int getBaysProvided() {
        return this.baysProvided;
    }

    public void setBaysProvided(int baysProvided) {
        this.baysProvided = baysProvided;
    }

    public int getDBID() {
        return this.DBID;
    }

    public void setDBID(int ID) {
        this.DBID = ID;
    }

    public int getCompProduction() {
        return this.compProduction;
    }

    public void setCompProduction(int compProduction) {
        this.compProduction = compProduction;
    }

    public Integer getPlanetOwner() {
        Integer ownerid = this.getInfluence().getOwner();
        return ownerid;
    }

    public boolean isOwner(int factionid) {
        Integer ownerID = this.getPlanetOwner();
        if (ownerID == null) {
            return false;
        }
        return ownerID == factionid;
    }

    public boolean isConquerable() {
        return this.conquerable;
    }

    public void setConquerable(boolean conquerable) {
        this.conquerable = conquerable;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getNameAsLink() {
        return "<a href=\"JUMPTOPLANET" + this.name + "#\">" + this.name + "</a>";
    }

    public void setName(String name) {
        this.name = name;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public Vector<UnitFactory> getUnitFactories() {
        return this.unitFactories;
    }

    public void setUnitFactories(Vector<UnitFactory> unitFactories) {
        this.unitFactories = unitFactories;
    }

    public PlanetEnvironments getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(PlanetEnvironments environments) {
        this.environments = environments;
    }

    public Influences getInfluence() {
        return this.influence;
    }

    public void setInfluence(Influences influence) {
        this.influence = influence;
    }

    public int compareTo(Object o) {
        Planet p = (Planet)o;
        return this.getId() < p.getId() ? -1 : (this.getId() == p.getId() ? 0 : 1);
    }

    @Override
    public void encodeMutableFields(BinWriter out, CampaignData dataProvider) throws IOException {
        out.println(this.getId(), "id");
        this.getInfluence().encodeMutableFields(out, dataProvider);
        this.binOut(out);
    }

    @Override
    public void decodeMutableFields(BinReader in, CampaignData dataProvider) throws IOException {
        this.setId(new Integer(in.readInt("id")));
        this.getInfluence().decodeMutableFields(in, dataProvider);
        this.binIn(in, dataProvider);
    }

    public void binOut(BinWriter out) throws IOException {
        out.println(this.getId(), "id");
        out.println(this.getName(), "name");
        out.println(this.getPosition().x, "x");
        out.println(this.getPosition().y, "y");
        out.println(this.getUnitFactories().size(), "unitFactories.size");
        Iterator<UnitFactory> i = this.getUnitFactories().iterator();
        while (i.hasNext()) {
            i.next().binOut(out);
        }
        this.getEnvironments().binOut(out);
        out.println(this.getDescription(), "description");
        out.println(this.getBaysProvided(), "baysProvided");
        out.println(this.isConquerable(), "conquerable");
        out.println(this.getCompProduction(), "compProduction");
        this.getInfluence().binOut(out);
        out.println(this.getMapSize().width, "x");
        out.println(this.getMapSize().height, "y");
        out.println(this.getBoardSize().width, "x");
        out.println(this.getBoardSize().height, "y");
        out.println(this.getTemp().width, "lowtemp");
        out.println(this.getTemp().height, "hitemp");
        out.println(this.getGravity(), "gravity");
        out.println(this.isVacuum(), "vacuum");
        out.println(this.getMinPlanetOwnerShip(), "minplanetownership");
        out.println(this.isHomeWorld(), "homeworld");
        out.println(this.getOriginalOwner(), "originalowner");
        out.println(this.getAdvanceTerrain().size(), "AdvanceTerrain.size");
        for (Integer currI : this.getAdvanceTerrain().keySet()) {
            out.println(currI, "AdvanceTerrainId");
            AdvanceTerrain aTerrain = this.getAdvanceTerrain().get(currI);
            aTerrain.binOut(out);
        }
        out.println(this.getPlanetFlags().size(), "PlanetFlags.size");
        for (String key : this.getPlanetFlags().keySet()) {
            out.println(key, "PlanetFlags.key");
            out.println(this.getPlanetFlags().get(key), "PlayerFlags.value");
        }
        out.println(this.getConquestPoints(), "MaxInfluence");
    }

    public void binIn(BinReader in, CampaignData data) throws IOException {
        int i;
        this.setId(new Integer(in.readInt("id")));
        this.setName(in.readLine("name"));
        this.setPosition(new Position(in.readDouble("x"), in.readDouble("y")));
        this.setUnitFactories(new Vector<UnitFactory>());
        int size = in.readInt("unitFactories.size");
        for (i = 0; i < size; ++i) {
            UnitFactory uf = new UnitFactory();
            uf.binIn(in);
            this.getUnitFactories().add(uf);
        }
        this.setEnvironments(new PlanetEnvironments());
        this.getEnvironments().binIn(in, data);
        this.setDescription(in.readLine("description"));
        this.setBaysProvided(in.readInt("baysProvided"));
        this.setConquerable(in.readBoolean("conquerable"));
        this.setCompProduction(in.readInt("compProduction"));
        this.setInfluence(new Influences());
        this.getInfluence().binIn(in);
        this.setMapSize(new Dimension(in.readInt("x"), in.readInt("y")));
        this.setBoardSize(new Dimension(in.readInt("x"), in.readInt("y")));
        this.setTemp(new Dimension(in.readInt("lowtemp"), in.readInt("hitemp")));
        this.setGravity(in.readDouble("gravity"));
        this.setVacuum(in.readBoolean("vacuum"));
        this.setMinPlanetOwnerShip(in.readInt("minplanetownership"));
        this.setHomeWorld(in.readBoolean("homeworld"));
        this.setOriginalOwner(in.readLine("originalowner"));
        size = in.readInt("AdvanceTerrain.size");
        for (i = 0; i < size; ++i) {
            AdvanceTerrain aTerrain = new AdvanceTerrain();
            int id = in.readInt("AdvanceTerrainId");
            aTerrain.binIn(in);
            this.getAdvanceTerrain().put(new Integer(id), aTerrain);
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        size = in.readInt("PlanetFlags.size");
        for (int i2 = 0; i2 < size; ++i2) {
            String key = in.readLine("PlanetFlags.key");
            String value = in.readLine("PlanetFlags.value");
            map.put(key, value);
        }
        this.setPlanetFlags(map);
        this.setConquestPoints(in.readInt("MaxInfluence"));
    }

    public StringBuilder getLongDescription(boolean client) {
        Iterator<MMNetSerializable> it;
        StringBuilder result = new StringBuilder("Information for Planet: <b>");
        result.append(this.getName() + "</b><br><br>");
        result.append("<b>Location:</b> " + (int)this.getPosition().x + " x " + (int)this.getPosition().y + " y<br>" + Math.round(this.getPosition().distanceSq(0.0, 0.0)) + " Lightyears from the galaxy center <br><br>");
        result.append("<b>Industry:</b><br>");
        if (this.getCompProduction() > 0) {
            result.append("Heavy industry allows an export of " + this.getCompProduction() + " parts.<br>");
        }
        if (this.getBaysProvided() > 0) {
            result.append("A warehouse on this world provides all players with " + this.getBaysProvided() + " extra .<br><br>");
        }
        if (this.getUnitFactories().size() > 0) {
            it = this.getUnitFactories().iterator();
            String founder = "";
            if (this.getUnitFactories().size() == 1) {
                result.append("<br><b>Factory:</b><br>");
            } else {
                result.append("<br><b>Factories:</b><br>");
            }
            while (it.hasNext()) {
                UnitFactory u = it.next();
                founder = u.getFounder();
                if (client) {
                    result.append("<img src=\"file:///" + new File(".").getAbsolutePath() + "/data/images/open" + founder + ".gif\">" + u.getSize() + " " + u.getFullTypeString() + u.getName() + " built by " + founder + "<br>");
                    continue;
                }
                result.append("<img src=\"./data/images/open" + founder + ".gif\">" + u.getSize() + " " + u.getFullTypeString() + u.getName() + " built by " + founder + "<br>");
            }
        }
        result.append("<br><b>Planetary Conditions</b><br>");
        result.append("Atmosphere: ");
        if (this.isVacuum()) {
            result.append("None<br>");
        } else {
            result.append("Present<br>");
        }
        result.append("Gravity: " + this.getGravity() + "<br>");
        result.append("Average Low: " + this.getTemp().width + "<br>");
        result.append("Average High: " + this.getTemp().height + "<br>");
        result.append("<br><b>Terrain:</b><br>");
        it = this.getEnvironments().iterator();
        int maxProbab = this.getEnvironments().getTotalEnivronmentPropabilities();
        if (!it.hasNext()) {
            result.append("nothing special");
        } else {
            while (it.hasNext()) {
                Continent pe = (Continent)it.next();
                int curProb = pe.getSize() * 100 / maxProbab;
                if (curProb < 10) {
                    result.append("0");
                }
                result.append(curProb + "% ");
                if (client) {
                    result.append(pe.getEnvironment().toImageAbsolutePathDescription());
                } else {
                    result.append(pe.getEnvironment().toImageDescription());
                }
                String terrainName = pe.getEnvironment().getName();
                result.append(" " + terrainName);
                if (!it.hasNext()) continue;
                result.append("<br>");
            }
        }
        result.append("<br><br><b>Influence:</b><br>");
        it = this.getInfluence().getHouses().iterator();
        while (it.hasNext()) {
            House h = (House)it.next();
            result.append("<font color=" + h.getHouseColor() + ">" + h.getName() + "</font> (" + this.getInfluence().getInfluence(h.getId()) + ")");
            if (it.hasNext()) {
                result.append(", ");
                continue;
            }
            result.append("<br>");
        }
        if (this.getPlanetFlags().size() > 0) {
            result.append("<br><b>Points of Intereset:</b><br>");
            for (String value : this.getPlanetFlags().values()) {
                result.append(value + ", ");
            }
            result.delete(result.length() - 2, result.length());
            result.append("<br> <br>");
        }
        return result;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void binOut(TreeWriter out) {
        out.write(this.getId(), "id");
        out.write(this.getName(), "name");
        out.write(this.getPosition().x, "x");
        out.write(this.getPosition().y, "y");
        out.write(this.getUnitFactories(), "unitFactories");
        out.write(this.getEnvironments(), "environments");
        out.write(this.getDescription(), "description");
        out.write(this.getBaysProvided(), "baysProvided");
        out.write(this.isConquerable(), "conquerable");
        out.write(this.getCompProduction(), "compProduction");
        out.write(this.getInfluence(), "influence");
        out.write(this.getMapSize().width, "x");
        out.write(this.getMapSize().height, "y");
        out.write(this.getBoardSize().width, "x");
        out.write(this.getBoardSize().height, "y");
        out.write(this.getTemp().width, "lowtemp");
        out.write(this.getTemp().height, "hitemp");
        out.write(this.getGravity(), "gravity");
        out.write(this.isVacuum(), "vacuum");
        out.write(this.getMinPlanetOwnerShip(), "minplanetownership");
        out.write(this.isHomeWorld(), "homeworld");
        out.write(this.getOriginalOwner(), "originalowner");
    }

    @Override
    public void binIn(TreeReader in, CampaignData dataProvider) throws IOException {
        this.setId(new Integer(in.readInt("id")));
        this.setName(in.readString("name"));
        this.setPosition(new Position(in.readDouble("x"), in.readDouble("y")));
        this.setUnitFactories(new Vector<UnitFactory>());
        in.readCollection(this.getUnitFactories(), UnitFactory.class, dataProvider, "unitFactories");
        this.setEnvironments(new PlanetEnvironments());
        in.readObject(this.getEnvironments(), dataProvider, "environments");
        this.setDescription(in.readString("description"));
        this.setBaysProvided(in.readInt("baysProvided"));
        this.setConquerable(in.readBoolean("conquerable"));
        this.setCompProduction(in.readInt("compProduction"));
        this.setInfluence(new Influences());
        in.readObject(this.getInfluence(), dataProvider, "influence");
        this.setMapSize(new Dimension(in.readInt("x"), in.readInt("y")));
        this.setBoardSize(new Dimension(in.readInt("x"), in.readInt("y")));
        this.setTemp(new Dimension(in.readInt("lowtemp"), in.readInt("hitemp")));
        this.setGravity(in.readDouble("gravity"));
        this.setVacuum(in.readBoolean("vacuum"));
        this.setMinPlanetOwnerShip(in.readInt("minplanetownership"));
        this.setHomeWorld(in.readBoolean("homeworld"));
        this.setOriginalOwner(in.readString("originalowner"));
        TreeMap<String, String> map = new TreeMap<String, String>();
        int size = in.readInt("PlanetFlags.size");
        for (int i = 0; i < size; ++i) {
            String key = in.readString("PlanetFlags.key");
            String value = in.readString("PlanetFlags.value");
            map.put(key, value);
        }
        this.setPlanetFlags(map);
    }

    public StringBuilder getAdvanceDescription(int level) {
        Iterator<MMNetSerializable> it;
        StringBuilder result = new StringBuilder("Information for Planet: <b>");
        result.append(this.getName() + "</b><br><br>");
        result.append("<b>Location:</b> " + (int)this.getPosition().x + " x " + (int)this.getPosition().y + " y<br>" + Math.round(this.getPosition().distanceSq(0.0, 0.0)) + " Lightyears from the galaxy center <br><br>");
        result.append("<b>Industry:</b><br>");
        if (this.getCompProduction() > 0) {
            result.append("Heavy industry allows an export of " + this.getCompProduction() + " parts.<br>");
        }
        if (this.getBaysProvided() > 0) {
            result.append("A warehouse on this world provides all players with " + this.getBaysProvided() + " extra .<br><br>");
        }
        if (this.getUnitFactories().size() > 0) {
            it = this.getUnitFactories().iterator();
            String founder = "";
            if (this.getUnitFactories().size() == 1) {
                result.append("<br><b>Factory:</b><br>");
            } else {
                result.append("<br><b>Factories:</b><br>");
            }
            while (it.hasNext()) {
                UnitFactory u = (UnitFactory)it.next();
                founder = u.getFounder();
                result.append("<img src=\"file:///" + new File(".").getAbsolutePath() + "/data/images/open" + founder + ".gif\">" + u.getSize() + " " + u.getFullTypeString() + u.getName() + " built by " + founder + "<br>");
            }
        }
        result.append("<br><b>Terrain:</b><br>");
        it = this.getEnvironments().iterator();
        int maxProbab = this.getEnvironments().getTotalEnivronmentPropabilities();
        if (!it.hasNext()) {
            result.append("nothing special");
        } else {
            while (it.hasNext()) {
                Continent pe = (Continent)it.next();
                int curProb = pe.getSize() * 100 / maxProbab;
                if (curProb < 10) {
                    result.append("0");
                }
                result.append(curProb + "% ");
                result.append(pe.getEnvironment().toImageAbsolutePathDescription());
                AdvanceTerrain aTerrain = this.getAdvanceTerrain().get(new Integer(pe.getEnvironment().getId()));
                if (aTerrain == null) {
                    result.append("Nothing special");
                } else {
                    result.append(" " + aTerrain.getDisplayName());
                    result.append("<br>Atmosphere: ");
                    if (aTerrain.isVacuum()) {
                        result.append("None<br>");
                    } else {
                        result.append("Present<br>");
                    }
                    result.append("Gravity: " + aTerrain.getGravity());
                    result.append("<br>Average Low: " + aTerrain.getLowTemp());
                    result.append("<br>Average High: " + aTerrain.getHighTemp());
                    if (level >= 100) {
                        result.append("<br>Night Chance: " + aTerrain.getNightChance());
                        result.append("<br>Night Temp Mod: " + aTerrain.getNightTempMod());
                        if (aTerrain.isStaticMap()) {
                            result.append("<br>Map Name: " + aTerrain.getStaticMapName());
                            result.append("<br>Map Size(XxY): " + aTerrain.getXSize() + " x " + aTerrain.getYSize());
                            result.append("<br>Board Size(XxY): " + aTerrain.getXBoardSize() + " x " + aTerrain.getYBoardSize());
                        }
                        result.append("<br>Min Visibility: " + aTerrain.getMinVisibility());
                        result.append("<br>Max Visibility: " + aTerrain.getMaxVisibility());
                    }
                }
                if (!it.hasNext()) continue;
                result.append("<br>");
            }
        }
        result.append("<br><br><b>Influence:</b><br>");
        it = this.getInfluence().getHouses().iterator();
        while (it.hasNext()) {
            House h = (House)it.next();
            result.append("<font color=" + h.getHouseColor() + ">" + h.getName() + "</font> (" + this.getInfluence().getInfluence(h.getId()) + ")");
            if (it.hasNext()) {
                result.append(", ");
                continue;
            }
            result.append("<br>");
        }
        if (this.getPlanetFlags().size() > 0) {
            result.append("<br><b>Points of Intereset:</b><br>");
            for (String value : this.getPlanetFlags().values()) {
                result.append(value + ", ");
            }
            result.delete(result.length() - 2, result.length());
            result.append("<br><br>");
        }
        return result;
    }

    public int getFactoryCount() {
        return this.getUnitFactories().size();
    }

    public Dimension getMapSize() {
        return this.MapSize;
    }

    public void setMapSize(Dimension map) {
        this.MapSize = map;
    }

    public Dimension getBoardSize() {
        return this.BoardSize;
    }

    public void setBoardSize(Dimension board) {
        this.BoardSize = board;
    }

    public Dimension getTemp() {
        return this.temperature;
    }

    public void setTemp(Dimension temp) {
        this.temperature = temp;
    }

    public double getGravity() {
        return this.gravity;
    }

    public void setGravity(double grav) {
        this.gravity = grav;
    }

    public boolean isVacuum() {
        return this.vacuum;
    }

    public void setVacuum(boolean vac) {
        this.vacuum = vac;
    }

    public int getNightChance() {
        return this.nightChance;
    }

    public void setNightChance(int chance) {
        this.nightChance = chance;
    }

    public int getNightTempMod() {
        return this.nightTempMod;
    }

    public void setNightTempMod(int mod) {
        this.nightTempMod = mod;
    }

    public Hashtable<Integer, AdvanceTerrain> getAdvanceTerrain() {
        return this.advanceTerrain;
    }

    public void setAdvanceTerrain(Hashtable<Integer, AdvanceTerrain> terrain) {
        this.advanceTerrain = terrain;
    }

    public int getMinPlanetOwnerShip() {
        return this.minPlanetOwnerShip;
    }

    public void setMinPlanetOwnerShip(int ownership) {
        this.minPlanetOwnerShip = ownership;
    }

    public void setHomeWorld(boolean homeworld) {
        this.homeWorld = homeworld;
    }

    public boolean isHomeWorld() {
        return this.homeWorld;
    }

    public void setOriginalOwner(String owner) {
        this.originalOwner = owner;
    }

    public String getOriginalOwner() {
        return this.originalOwner;
    }

    public TreeMap<String, String> getPlanetFlags() {
        return this.planetFlags;
    }

    public void setPlanetFlags(TreeMap<String, String> flags) {
        this.planetFlags = flags;
    }

    public int getConquestPoints() {
        return this.maxConquestPoints;
    }

    public void setConquestPoints(int points) {
        this.maxConquestPoints = Math.max(1, points);
    }
}

