/*
 * Decompiled with CFR 0.152.
 */
package common.persistence;

import common.CampaignData;
import common.persistence.MMNetSerializable;
import common.persistence.TreeReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collection;

public class BinReader
implements TreeReader {
    private BufferedReader in;

    public BinReader(BufferedReader in) {
        this.in = in;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int readInt(String name) throws IOException {
        return Integer.parseInt(this.read());
    }

    public double readDouble(String name) throws IOException {
        return Double.parseDouble(this.read());
    }

    public boolean readBoolean(String name) throws IOException {
        return Boolean.getBoolean(this.read());
    }

    public String readString(String name) throws IOException {
        return this.read();
    }

    private String read() throws IOException {
        return this.in.readLine();
    }

    public void startDataBlock(String name) {
    }

    public void endDataBlock(String name) {
    }

    public void readObject(MMNetSerializable obj, CampaignData dataProvider, String name) throws IOException {
        obj.binIn(this, dataProvider);
    }

    public void readCollection(Collection col, Class cl, CampaignData dataProvider, String name) throws IOException {
        int size = this.readInt(null);
        for (int i = 0; i < size; ++i) {
            try {
                MMNetSerializable obj = (MMNetSerializable)cl.newInstance();
                obj.binIn(this, dataProvider);
                col.add(obj);
                continue;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

