/*
 * Decompiled with CFR 0.152.
 */
package updaters;

import updaters.SplashWindow;

class AnimationThread
extends Thread {
    private SplashWindow splash;
    private int cycle;
    private int progress;
    private String progressText = "";

    public AnimationThread(SplashWindow s) {
        this.splash = s;
        this.progress = 0;
        this.cycle = 0;
    }

    protected void setLabelText(String s) {
        this.progressText = "<HTML><CENTER><b>" + s + "</b></CENTER></HTML>";
    }

    private void updateProgress() {
        this.splash.getImageLabel().setText(this.progressText);
    }

    public synchronized void run() {
        while (this.splash.shouldAnimate()) {
            try {
                int currStatus;
                this.wait(150L);
                ++this.cycle;
                if (this.cycle == 4) {
                    this.cycle = 0;
                }
                if ((currStatus = this.splash.getStatus()) == this.splash.STATUS_DATAERROR || currStatus == this.splash.STATUS_INPUTWAIT || currStatus == this.splash.STATUS_CONNECTFAILED) {
                    --this.cycle;
                } else if (this.cycle == 0) {
                    ++this.progress;
                    if (this.progress == 10) {
                        this.progress = 0;
                    }
                }
                this.updateProgress();
                if (this.splash.shouldAnimate()) continue;
                return;
            }
            catch (Exception e) {
                this.splash.getImageLabel().setText("Error in animation thread!");
                return;
            }
        }
    }
}

