/*
 * Decompiled with CFR 0.152.
 */
package client;

import common.CampaignData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class CConfig {
    public static final String IMAGE_PATH = "data/images/";
    public static final String CAMO_PATH = "data/images/camo/";
    public static final String CONFIG_FILE = "./data/mwconfig.txt";
    public static final String CONFIG_BACKUP_FILE = "./data/mwconfig.txt.bak";
    private Properties config = this.setDefaults();
    private TreeMap<String, ImageIcon> images = new TreeMap();

    public CConfig(boolean dedicated) {
        FileInputStream fis;
        File configfile;
        if (!new File(CONFIG_FILE).exists() && !new File(CONFIG_BACKUP_FILE).exists()) {
            this.createConfig();
        }
        try {
            configfile = new File(CONFIG_FILE);
            fis = new FileInputStream(configfile);
            File backupfile = new File(CONFIG_BACKUP_FILE);
            if (backupfile.exists()) {
                FileInputStream backupStream = new FileInputStream(backupfile);
                if (fis.available() < backupStream.available()) {
                    try {
                        this.config.load(backupStream);
                        backupStream.close();
                    }
                    catch (Exception ex) {
                        CampaignData.mwlog.errLog(ex);
                        JOptionPane.showMessageDialog(null, "Unable to load Backup config file");
                    }
                } else {
                    this.config.load(fis);
                }
            } else {
                this.config.load(fis);
            }
            fis.close();
        }
        catch (IOException ie) {
            try {
                File configfile2 = new File(CONFIG_BACKUP_FILE);
                FileInputStream fis2 = new FileInputStream(configfile2);
                this.config.load(fis2);
                fis2.close();
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
                JOptionPane.showMessageDialog(null, "Unable to load Backup config file");
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            JOptionPane.showMessageDialog(null, "Unable to load main config file");
        }
        try {
            configfile = new File("serverdata.dat");
            fis = new FileInputStream(configfile);
            this.config.load(fis);
            fis.close();
            configfile.delete();
            this.saveConfig();
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
        if (dedicated) {
            this.setParam("DEDICATED", "TRUE");
        }
        if (this.isParam("DEDICATED")) {
            return;
        }
        this.images = new TreeMap();
        this.loadImage("data/images/logout_colored.gif", "LOGOUT", 20, 20);
        this.loadImage("data/images/reserve_colored.gif", "RESERVE", 20, 20);
        this.loadImage("data/images/active_colored.gif", "ACTIVE", 20, 20);
        this.loadImage("data/images/fighting_colored.gif", "FIGHT", 20, 20);
        this.loadImage(IMAGE_PATH + this.getParam("LOGOIMAGE"), "LOGO", 100, 100);
        this.loadImage(IMAGE_PATH + this.getParam("TRAYIMAGE"), "TRAY", 20, 20);
        this.loadImage(IMAGE_PATH + this.getParam("REPAIRIMAGE"), "REPAIR", 100, 100);
        if (this.getParam("UNITCAMO").trim().length() != 0) {
            this.loadImage(CAMO_PATH + this.getParam("UNITCAMO"), "CAMO", 84, 72);
        }
    }

    private Properties setDefaults() {
        Properties defaults = new Properties();
        defaults.setProperty("NAME", "");
        defaults.setProperty("NAMEPASSWORD", "");
        defaults.setProperty("PORT", "2346");
        defaults.setProperty("SERVERIP", "");
        defaults.setProperty("SERVERPORT", "2347");
        defaults.setProperty("DATAPORT", "4867");
        defaults.setProperty("AUTOCONNECT", "NO");
        defaults.setProperty("TIMEOUT", "180");
        defaults.setProperty("LOOKANDFEEL", "system");
        defaults.setProperty("TIMESTAMP", "YES");
        defaults.setProperty("DEDICATED", "NO");
        defaults.setProperty("DEDICATEDOWNERNAME", "");
        defaults.setProperty("SPLITTERSIZE", "7");
        defaults.setProperty("PLAYERPANEL", "YES");
        defaults.setProperty("PLAYERPANELHEIGHT", "130");
        defaults.setProperty("LOGO", "NO");
        defaults.setProperty("POPUPONATTACK", "YES");
        defaults.setProperty("POPUPONMESSAGE", "NO");
        defaults.setProperty("UNITCAMO", "Flame.jpg");
        defaults.setProperty("UNITHEX", "NO");
        defaults.setProperty("HQCOLORSCHEME", "grey");
        defaults.setProperty("UNITAMOUNT", "10");
        defaults.setProperty("USERLISTBOLD", "YES");
        defaults.setProperty("USERLISTCOLOR", "YES");
        defaults.setProperty("USERLISTIMAGE", "YES");
        defaults.setProperty("USERLISTCOUNT", "YES");
        defaults.setProperty("USERLISTDEDICATEDS", "NO");
        defaults.setProperty("USERLISTACTIVITYBTN", "YES");
        defaults.setProperty("MAINCHANNELHM", "NO");
        defaults.setProperty("MAINCHANNELPM", "NO");
        defaults.setProperty("MAINCHANNELSM", "NO");
        defaults.setProperty("MAINCHANNELMISC", "NO");
        defaults.setProperty("MAINCHANNELRPG", "NO");
        defaults.setProperty("AUTOSCROLL", "NO");
        defaults.setProperty("REPLYTOSENDER", "YES");
        defaults.setProperty("REPLYTORECEIVER", "NO");
        defaults.setProperty("CHATFONTSIZE", "+0");
        defaults.setProperty("CHATFONTCOLOR", "black");
        defaults.setProperty("SOUNDONCALL", "./data/sounds/call.wav");
        defaults.setProperty("SOUNDONKEYWORD", "./data/sounds/call.wav");
        defaults.setProperty("SOUNDONMESSAGE", "./data/sounds/mail.wav");
        defaults.setProperty("SOUNDONATTACK", "./data/sounds/attack.wav");
        defaults.setProperty("SOUNDONBMWIN", "./data/sounds/radarping.wav");
        defaults.setProperty("SOUNDONACTIVATE", "./data/sounds/activate.wav");
        defaults.setProperty("SOUNDONDEACTIVATE", "./data/sounds/deactivate.wav");
        defaults.setProperty("SOUNDONENEMYDETECTED", "./data/sounds/enemy detected.wav");
        defaults.setProperty("SOUNDONEXITCLIENT", "./data/sounds/exit client.wav");
        defaults.setProperty("SOUNDONMENU", "./data/sounds/menu.wav");
        defaults.setProperty("SOUNDONMENUPOPUP", "./data/sounds/menu popup.wav");
        defaults.setProperty("ENABLECALLSOUND", "YES");
        defaults.setProperty("ENABLEKEYWORDSOUND", "YES");
        defaults.setProperty("ENABLEMESSAGESOUND", "YES");
        defaults.setProperty("ENABLEATTACKSOUND", "YES");
        defaults.setProperty("ENABLEBMSOUND", "YES");
        defaults.setProperty("ENABLEACTIVATESOUND", "YES");
        defaults.setProperty("ENABLEDEACTIVATESOUND", "YES");
        defaults.setProperty("ENABLEENEMYDETECTEDSOUND", "YES");
        defaults.setProperty("ENABLEEXITCLIENTSOUND", "YES");
        defaults.setProperty("ENABLEMENUSOUND", "YES");
        defaults.setProperty("ENABLEMENUPOPUPSOUND", "YES");
        defaults.setProperty("SOUNDSFROMSYSMESSAGES", "NO");
        defaults.setProperty("HQTABVISIBLE", "YES");
        defaults.setProperty("HQTABNAME", "Headquarters");
        defaults.setProperty("HQINTOPROW", "YES");
        defaults.setProperty("HQMNEMONIC", "Q");
        defaults.setProperty("BMTABVISIBLE", "YES");
        defaults.setProperty("BMTABNAME", "Black Market");
        defaults.setProperty("BMINTOPROW", "YES");
        defaults.setProperty("BMMNEMONIC", "L");
        defaults.setProperty("BMETABVISIBLE", "YES");
        defaults.setProperty("BMETABNAME", "Parts Black Market");
        defaults.setProperty("BMEINTOPROW", "YES");
        defaults.setProperty("BMEMNEMONIC", "P");
        defaults.setProperty("HSTATUSTABVISIBLE", "YES");
        defaults.setProperty("HSTATUSTABNAME", "Faction Status");
        defaults.setProperty("HSTATUSINTOPROW", "Yes");
        defaults.setProperty("HSTATUSMNEMONIC", "U");
        defaults.setProperty("BATTLETABVISIBLE", "YES");
        defaults.setProperty("BATTLETABNAME", "Battles");
        defaults.setProperty("BATTLEINTOPROW", "YES");
        defaults.setProperty("BATTLEMNEMONIC", "B");
        defaults.setProperty("MAPTABVISIBLE", "YES");
        defaults.setProperty("MAPTABONCLICK", "YES");
        defaults.setProperty("MAPTABNAME", "Map");
        defaults.setProperty("MAPINTOPROW", "NO");
        defaults.setProperty("MAPMNEMONIC", "A");
        defaults.setProperty("PANELDIVIDER", "200");
        defaults.setProperty("PLAYERPANELDIVIDER", "-1");
        defaults.setProperty("VERTICALDIVIDER", "800");
        defaults.setProperty("MAINCHANNELTABNAME", "Main Channel");
        defaults.setProperty("MAINCHANNELMNEMONIC", "M");
        defaults.setProperty("HOUSEMAILVISIBLE", "YES");
        defaults.setProperty("HOUSEMAILTABNAME", "Faction Channel");
        defaults.setProperty("HOUSEMAILMNEMONIC", "H");
        defaults.setProperty("PRIVATEMAILVISIBLE", "YES");
        defaults.setProperty("PRIVATEMAILTABNAME", "Private Channel");
        defaults.setProperty("PRIVATEMAILMNEMONIC", "P");
        defaults.setProperty("PERSONALLOGVISIBLE", "YES");
        defaults.setProperty("PERSONALLOGTABNAME", "Personal Log");
        defaults.setProperty("PERSONALLOGMNEMONIC", "L");
        defaults.setProperty("SYSTEMLOGVISIBLE", "NO");
        defaults.setProperty("SYSTEMLOGTABNAME", "System Log");
        defaults.setProperty("SYSTEMLOGMNEMONIC", "Y");
        defaults.setProperty("MISCELLANEOUSVISIBLE", "YES");
        defaults.setProperty("MISCELLANEOUSTABNAME", "Miscellaneous");
        defaults.setProperty("MISCELLANEOUSMNEMONIC", "A");
        defaults.setProperty("RPGVISIBLE", "NO");
        defaults.setProperty("RPGTABNAME", "RP Channel");
        defaults.setProperty("RPGMNEMONIC", "R");
        defaults.setProperty("F1BIND", "mystatus");
        defaults.setProperty("F2BIND", "");
        defaults.setProperty("F3BIND", "");
        defaults.setProperty("F4BIND", "");
        defaults.setProperty("F5BIND", "");
        defaults.setProperty("DEFAULTARMYNAME", "");
        defaults.setProperty("DEDAUTORESTART", "10");
        defaults.setProperty("CAMPAIGNSERVERNAME", "MekWars Server");
        defaults.setProperty("STATUSINTRAYICON", "NO");
        defaults.setProperty("TRAYIMAGE", "reserve_colored.gif");
        defaults.setProperty("REPAIRIMAGE", "repair.gif");
        defaults.setProperty("DISABLEALLSOUND", "false");
        defaults.setProperty("SORTMODE", "NAME");
        defaults.setProperty("SORTORDER", "ASCENDING");
        defaults.setProperty("BMSORTCOLUMN", "-2");
        defaults.setProperty("BMSORTORDER", "true");
        defaults.setProperty("BATTLESSORTCOLUMN", "0");
        defaults.setProperty("BATTLESSORTORDER", "true");
        defaults.setProperty("TABLEBROWSERSORTCOLUMN", "3");
        defaults.setProperty("TABLEBROWSERSORTORDER", "false");
        defaults.setProperty("BMESORTCOLUMN", "-2");
        defaults.setProperty("BMESORTORDER", "true");
        defaults.setProperty("UNITVIEWERWEIGHT", "All");
        defaults.setProperty("UNITVIEWERTECH", "All");
        defaults.setProperty("UNITVIEWERTYPE", "Mek");
        defaults.setProperty("UNITVIEWERSORT", "Name");
        defaults.setProperty("UNITVIEWERUNIT", "-1");
        defaults.setProperty("TABLEVIEWERFACTION", "");
        defaults.setProperty("TABLEVIEWERTYPE", "Mek");
        defaults.setProperty("TALEVIEWERWEIGHT", "Light");
        defaults.setProperty("PRIMARYHQSORTORDER", "name");
        defaults.setProperty("SECONDARYHQSORTORDER", "none");
        defaults.setProperty("TERTIARYHQSORTORDER", "none");
        defaults.setProperty("PRIMARYARMYSORTORDER", "id number");
        defaults.setProperty("DARKERMAP", "false");
        defaults.setProperty("BMPREVIEWIMAGE", "false");
        defaults.setProperty("PLAYERCHATCOLORMODE", "playercolors");
        defaults.setProperty("COLOREDEMOTES", "false");
        defaults.setProperty("SELECTEDPLANET", "");
        defaults.setProperty("MAPZOOMLEVEL", "1");
        defaults.setProperty("MAPYOFFSET", "0");
        defaults.setProperty("MAPXOFFSET", "0");
        defaults.setProperty("SHOWENTERANDEXIT", "true");
        defaults.setProperty("CHALLENGESTRING", "Looking for a game at");
        defaults.setProperty("SYSMESSAGECOLOR", "red");
        defaults.setProperty("NOIMGINCHAT", "false");
        defaults.setProperty("SERVERPORT", "2347");
        defaults.setProperty("DATAPORT", "4867");
        defaults.setProperty("PORT", "2346");
        defaults.setProperty("MAXPLAYERS", "12");
        defaults.setProperty("MAXSAVEDGAMEDAYS", "30");
        defaults.setProperty("VIEWFLUFF", "false");
        defaults.setProperty("USEMULTIPLEPM", "false");
        defaults.setProperty("MAXPMTABS", "5");
        defaults.setProperty("MAXPMMESSAGE", "Sorry I Am Busy Try Again Later.");
        defaults.setProperty("MAPFILTER1", "true$false$true$true$true$true$true");
        defaults.setProperty("MAPFILTER2", "true$false$true$true$true$true$true");
        defaults.setProperty("TRAYIMAGE", "reserve_colored.gif");
        defaults.setProperty("IGNOREPUBLIC", "");
        defaults.setProperty("IGNOREHOUSE", "");
        defaults.setProperty("IGNOREPRIVATE", "");
        defaults.setProperty("KEYWORDS", "");
        defaults.setProperty("DEDUPDATECOMMANDFILE", "");
        defaults.setProperty("AUTOUPDATECOMMANDFILE", "");
        defaults.setProperty("MAPOVERLAYCOLOR", "#D3D3D3");
        defaults.setProperty("SOCKETTIMEOUTDELAY", "2000");
        defaults.setProperty("MAPIMAGEX", "0");
        defaults.setProperty("MAPIMAGEY", "0");
        defaults.setProperty("MAPIMAGEHEIGHT", "100");
        defaults.setProperty("MAPIMAGEWIDTH", "100");
        defaults.setProperty("UPDATEKEY", "-1");
        defaults.setProperty("DEDMEMORY", "64");
        defaults.setProperty("RIGHTCOLUMNDYNAMIC", "false");
        defaults.setProperty("RIGHTPILOTEJECT", "false");
        defaults.setProperty("RIGHTREPAIR", "false");
        defaults.setProperty("RIGHTENGINE", "false");
        defaults.setProperty("RIGHTEQUIPMENT", "false");
        defaults.setProperty("RIGHTARMOR", "false");
        defaults.setProperty("RIGHTAMMO", "false");
        defaults.setProperty("RIGHTCOMMANDER", "false");
        defaults.setProperty("LEFTCOLUMNDYNAMIC", "false");
        defaults.setProperty("LEFTPILOTEJECT", "false");
        defaults.setProperty("LEFTREPAIR", "false");
        defaults.setProperty("LEFTENGINE", "false");
        defaults.setProperty("LEFTEQUIPMENT", "false");
        defaults.setProperty("LEFTARMOR", "false");
        defaults.setProperty("LEFTAMMO", "false");
        defaults.setProperty("LEFTCOMMANDER", "false");
        defaults.setProperty("ENABLESPLASHSCREEN", "true");
        defaults.setProperty("WINDOWSTATE", "0");
        defaults.setProperty("WINDOWHEIGHT", "100");
        defaults.setProperty("WINDOWWIDTH", "100");
        defaults.setProperty("WINDOWLEFT", "0");
        defaults.setProperty("WINDOWTOP", "0");
        defaults.setProperty("REPAIRARMORTECH", "0");
        defaults.setProperty("REPAIRARMORROLL", "9");
        defaults.setProperty("REPAIRINTERNALTECH", "0");
        defaults.setProperty("REPAIRINTERNALROLL", "9");
        defaults.setProperty("REPAIRWEAPONSTECH", "0");
        defaults.setProperty("REPAIRWEAPONSROLL", "9");
        defaults.setProperty("REPAIREQUIPMENTTECH", "0");
        defaults.setProperty("REPAIREQUIPMENTROLL", "9");
        defaults.setProperty("REPAIRSYSTEMSTECH", "0");
        defaults.setProperty("REPAIRSYSTEMSROLL", "9");
        defaults.setProperty("REPAIRENGINESTECH", "0");
        defaults.setProperty("REPAIRENGINESROLL", "9");
        defaults.setProperty("SALVAGEARMORTECH", "0");
        defaults.setProperty("SALVAGEINTERNALTECH", "0");
        defaults.setProperty("SALVAGEWEAPONSTECH", "0");
        defaults.setProperty("SALVAGEEQUIPMENTTECH", "0");
        defaults.setProperty("SALVAGESYSTEMSTECH", "0");
        defaults.setProperty("SALVAGEENGINESTECH", "0");
        defaults.setProperty("BACKGROUNDCOLOR", "#FFFFFF");
        defaults.setProperty("USEAWTINTERFACE", "YES");
        defaults.setProperty("USERDEFINDMESSAGETAB", "0");
        defaults.setProperty("INVERTCHATCOLOR", "NO");
        return defaults;
    }

    public void createConfig() {
        try {
            FileOutputStream fos = new FileOutputStream(CONFIG_FILE);
            PrintStream ps = new PrintStream(fos);
            ps.close();
            fos.close();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Failed to create config file. Check folder write access privledges?");
            System.exit(0);
        }
    }

    public void loadImage(String imagename, String image, int width, int height) {
        if (imagename.equals("")) {
            return;
        }
        try {
            this.images.put(image, new ImageIcon(new ImageIcon(imagename).getImage().getScaledInstance(width, height, 1)));
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public ImageIcon getImage(String image) {
        return this.images.get(image);
    }

    public String getParam(String param) {
        String tparam = null;
        if (param.endsWith(":")) {
            param = param.substring(0, param.lastIndexOf(":"));
        }
        if ((tparam = this.config.getProperty(param)) == null) {
            tparam = "";
        }
        return tparam;
    }

    public void setParam(String param, String value) {
        this.config.setProperty(param, value);
    }

    public boolean isParam(String param) {
        String tparam = this.getParam(param);
        return tparam.equalsIgnoreCase("YES") || tparam.equalsIgnoreCase("TRUE") || tparam.equalsIgnoreCase("ON");
    }

    public boolean isUsingStatusIcons() {
        if (Boolean.parseBoolean(this.getParam("RIGHTPILOTEJECT"))) {
            return true;
        }
        if (Boolean.parseBoolean(this.getParam("RIGHTREPAIR"))) {
            return true;
        }
        if (Boolean.parseBoolean(this.getParam("RIGHTENGINE"))) {
            return true;
        }
        if (Boolean.parseBoolean(this.getParam("RIGHTEQUIPMENT"))) {
            return true;
        }
        if (Boolean.parseBoolean(this.getParam("RIGHTARMOR"))) {
            return true;
        }
        if (Boolean.parseBoolean(this.getParam("RIGHTAMMO"))) {
            return true;
        }
        if (Boolean.parseBoolean(this.getParam("LEFTPILOTEJECT"))) {
            return true;
        }
        if (Boolean.parseBoolean(this.getParam("LEFTREPAIR"))) {
            return true;
        }
        if (Boolean.parseBoolean(this.getParam("LEFTENGINE"))) {
            return true;
        }
        if (Boolean.parseBoolean(this.getParam("LEFTEQUIPMENT"))) {
            return true;
        }
        if (Boolean.parseBoolean(this.getParam("LEFTARMOR"))) {
            return true;
        }
        return Boolean.parseBoolean(this.getParam("LEFTAMMO"));
    }

    public int getIntParam(String param) {
        int toReturn;
        try {
            toReturn = Integer.parseInt(this.getParam(param));
        }
        catch (Exception ex) {
            return 0;
        }
        return toReturn;
    }

    public void saveConfig() {
        PrintStream ps;
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(CONFIG_BACKUP_FILE);
            ps = new PrintStream(fos);
            this.config.store(ps, "Client Config Backup");
            fos.close();
            ps.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            CampaignData.mwlog.errLog("Failed backingup config file");
            return;
        }
        try {
            fos = new FileOutputStream(CONFIG_FILE);
            ps = new PrintStream(fos);
            this.config.store(ps, "Client Config");
            fos.close();
            ps.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            CampaignData.mwlog.errLog("Failed saving config file");
        }
    }
}

