/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.MWClient;
import common.CampaignData;
import common.House;
import common.util.StringUtils;
import java.awt.Color;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CUser
implements Comparable<Object> {
    protected String Name;
    protected String Addon;
    protected int Userlevel = 0;
    protected String PlayerHouse;
    protected String Fluff;
    protected int Exp;
    protected float Rating;
    protected int Status;
    protected String HTMLColor;
    protected Color RGBColor;
    protected String Country;
    protected boolean LoggedIn = false;
    protected boolean isMerc = false;
    protected boolean isInvis = false;
    protected String subFaction = "";

    public CUser() {
        this.Name = "";
        this.Addon = "";
        this.PlayerHouse = "";
        this.Fluff = "";
        this.Exp = 0;
        this.Rating = 0.0f;
        this.Status = 1;
        this.HTMLColor = "black";
        this.RGBColor = Color.black;
        this.Country = "";
        this.isMerc = false;
        this.isInvis = false;
    }

    public CUser(String data) {
        StringTokenizer ST = null;
        this.Addon = "";
        this.PlayerHouse = "";
        this.Fluff = "";
        this.Exp = 0;
        this.Rating = 0.0f;
        this.Status = 1;
        this.RGBColor = Color.black;
        ST = new StringTokenizer(data, "~");
        try {
            this.Name = ST.nextToken();
            this.HTMLColor = ST.nextToken();
            this.Country = ST.nextToken();
            this.Userlevel = Integer.parseInt(ST.nextToken());
            this.isInvis = Boolean.parseBoolean(ST.nextToken());
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error in deserializing user");
        }
    }

    public void setName(String tname) {
        this.Name = tname;
    }

    public String getName() {
        return this.Name;
    }

    public void setAddon(String taddon) {
        this.Addon = taddon;
    }

    public String getAddon() {
        return this.Addon;
    }

    public void setCountry(String tcountry) {
        this.Country = tcountry;
    }

    public String getCountry() {
        return this.Country;
    }

    public void setColor(String tcolor) {
        this.HTMLColor = tcolor;
    }

    public String getColor() {
        return this.HTMLColor;
    }

    public void setUserlevel(int tlevel) {
        this.Userlevel = tlevel;
    }

    public int getUserlevel() {
        return this.Userlevel;
    }

    public void setFluff(String tfluff) {
        this.Fluff = tfluff;
    }

    public String getFluff() {
        return this.Fluff;
    }

    public String getHouse() {
        return this.PlayerHouse;
    }

    public void setExp(int texp) {
        this.Exp = texp;
    }

    public int getExp() {
        return this.Exp;
    }

    public void setRating(float trating) {
        this.Rating = trating;
    }

    public float getRating() {
        return this.Rating;
    }

    public boolean isInvis() {
        return this.isInvis;
    }

    public void setMercStatus(boolean merc) {
        this.isMerc = merc;
    }

    public boolean isMerc() {
        return this.isMerc;
    }

    public Color getRGBColor() {
        return this.RGBColor;
    }

    public void setSubFactionName(String subFaction) {
        this.subFaction = subFaction;
    }

    public void setCampaignData(MWClient mwclient, String data) {
        StringTokenizer ST = new StringTokenizer(data, "#");
        try {
            this.Exp = Integer.parseInt(ST.nextToken());
            this.Rating = Float.parseFloat(ST.nextToken());
            this.setStatus(Integer.parseInt(ST.nextToken()));
            if (ST.hasMoreTokens()) {
                this.Fluff = ST.nextToken();
            }
            if (this.Fluff.equals(" ") || this.Fluff.equals("0")) {
                this.Fluff = "";
            }
            if (ST.hasMoreTokens()) {
                this.PlayerHouse = ST.nextToken();
            }
            if (ST.hasMoreElements()) {
                this.isMerc = Boolean.parseBoolean(ST.nextToken());
            }
            if (ST.hasMoreElements()) {
                this.subFaction = ST.nextToken();
            }
            House playerH = mwclient.getData().getHouseByName(this.PlayerHouse);
            this.Addon = playerH.getAbbreviation();
            this.RGBColor = Color.black;
            this.RGBColor = StringUtils.html2Color(playerH.getHousePlayerColor());
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void clearCampaignData() {
        this.Addon = "";
        this.PlayerHouse = "";
        this.Fluff = "";
        this.Exp = 0;
        this.Rating = 0.0f;
        this.Status = 1;
        this.RGBColor = Color.black;
    }

    public void setStatus(int status) {
        this.Status = status;
        if (this.Status == 1) {
            this.LoggedIn = false;
            this.clearCampaignData();
        } else if (this.Status == 2 || this.Status == 3 || this.Status == 4) {
            this.LoggedIn = true;
        }
    }

    public int getStatus() {
        return this.Status;
    }

    public boolean isLoggedIn() {
        return this.LoggedIn;
    }

    public String getShortInfo() {
        StringBuffer info = new StringBuffer("<html><body>");
        info.append(this.getName());
        if (this.Userlevel >= 100 && this.Userlevel < 200) {
            info.append(" (Moderator)");
        }
        if (this.Userlevel >= 200) {
            info.append(" (Admin)");
        }
        if (!this.Country.equals("unknown")) {
            info.append(" (");
            info.append(this.getCountry());
            info.append(")");
        }
        info.append("</body></html>");
        return info.toString();
    }

    public String getInfo(boolean removeImages) {
        StringBuffer info = new StringBuffer("<html><body>");
        info.append(this.Name);
        if (!this.Addon.equals("") && this.LoggedIn) {
            info.append(" [");
            info.append(this.Addon);
            info.append("]");
        }
        if (this.Userlevel >= 100 && this.Userlevel < 200) {
            info.append(" (Moderator)");
        }
        if (this.Userlevel >= 200) {
            info.append(" (Admin)");
        }
        if (!this.Country.equals("unknown")) {
            info.append(" (");
            info.append(this.getCountry());
            info.append(")");
        }
        if (this.LoggedIn) {
            info.append("<br>Exp: ");
            info.append(this.Exp);
            if (this.Rating >= 1.0f) {
                info.append(" Rating: ");
                info.append(this.Rating);
            }
            if (this.PlayerHouse.trim().length() > 0) {
                info.append("<br>Fights for ");
                info.append(this.PlayerHouse);
                if (this.subFaction.trim().length() > 0 && !this.subFaction.equalsIgnoreCase("none")) {
                    info.append("<br><center>");
                    info.append(this.subFaction);
                    info.append("</center>");
                }
            }
            if (!this.Fluff.equals("")) {
                if (removeImages) {
                    info.append("<br>");
                    int start = this.Fluff.toLowerCase().indexOf("<img");
                    int finish = -1;
                    if (start != -1) {
                        finish = this.Fluff.indexOf(">", start);
                    }
                    if (start != -1 && finish != -1) {
                        String firstHalf = this.Fluff.substring(0, start);
                        String secondHalf = this.Fluff.substring(finish + 1, this.Fluff.length());
                        info.append(firstHalf);
                        info.append("(img blocked)");
                        info.append(secondHalf);
                    } else {
                        info.append(this.Fluff);
                    }
                } else {
                    info.append("<br>");
                    info.append(this.Fluff);
                }
            }
        }
        info.append("</body></html>");
        return info.toString();
    }

    @Override
    public int compareTo(Object o) {
        if (!(o instanceof CUser)) {
            return 0;
        }
        CUser u = (CUser)o;
        return this.getName().compareTo(u.getName());
    }
}

