/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.MWClient;
import client.campaign.CArmy;
import client.campaign.CUnit;
import client.util.SerializeEntity;
import common.AdvancedTerrain;
import common.CampaignData;
import common.MMGame;
import common.PlanetEnvironment;
import common.Unit;
import common.campaign.Buildings;
import common.util.UnitUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.CloseClientListener;
import megamek.client.bot.BotClient;
import megamek.client.bot.TestBot;
import megamek.client.bot.ui.AWT.BotGUI;
import megamek.client.ui.AWT.ClientGUI;
import megamek.common.Board;
import megamek.common.Building;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.MapSettings;
import megamek.common.Mech;
import megamek.common.MechWarrior;
import megamek.common.Pilot;
import megamek.common.PlanetaryConditions;
import megamek.common.event.GameBoardChangeEvent;
import megamek.common.event.GameBoardNewEvent;
import megamek.common.event.GameEndEvent;
import megamek.common.event.GameEntityChangeEvent;
import megamek.common.event.GameEntityNewEvent;
import megamek.common.event.GameEntityNewOffboardEvent;
import megamek.common.event.GameEntityRemoveEvent;
import megamek.common.event.GameEvent;
import megamek.common.event.GameListener;
import megamek.common.event.GameMapQueryEvent;
import megamek.common.event.GameNewActionEvent;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GamePlayerChangeEvent;
import megamek.common.event.GamePlayerChatEvent;
import megamek.common.event.GamePlayerConnectedEvent;
import megamek.common.event.GamePlayerDisconnectedEvent;
import megamek.common.event.GameReportEvent;
import megamek.common.event.GameSettingsChangeEvent;
import megamek.common.event.GameTurnChangeEvent;
import megamek.common.options.IBasicOption;
import megamek.common.preference.IClientPreferences;
import megamek.common.preference.PreferenceManager;
import megamek.common.util.BuildingTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClientThread
extends Thread
implements GameListener,
CloseClientListener {
    private String myname;
    private String serverip;
    private String serverName;
    private int serverport;
    private MWClient mwclient;
    private Client client;
    private ClientGUI awtGui;
    private megamek.client.ui.swing.ClientGUI swingGui;
    private boolean awtGUI = false;
    private int turn = 0;
    private ArrayList<Unit> mechs = new ArrayList();
    private ArrayList<CUnit> autoarmy = new ArrayList();
    CArmy army = null;
    BotClient bot = null;
    private IGame.Phase currentPhase = IGame.Phase.PHASE_DEPLOYMENT;
    final int N = 0;
    final int NE = 1;
    final int SE = 2;
    final int S = 3;
    final int SW = 4;
    final int NW = 5;

    public ClientThread(String name, String servername, String ip, int port, MWClient mwclient, ArrayList<Unit> mechs, ArrayList<CUnit> autoarmy) {
        this.myname = name.trim();
        this.serverName = servername;
        this.serverip = ip;
        this.serverport = port;
        this.mwclient = mwclient;
        this.mechs = mechs;
        this.autoarmy = autoarmy;
        if (this.serverip.indexOf("127.0.0.1") != -1) {
            this.serverip = "127.0.0.1";
        }
    }

    public int getTurn() {
        return this.turn;
    }

    public Client getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block78: {
            boolean playerUpdate = false;
            boolean nightGame = false;
            this.awtGUI = this.mwclient.getConfig().isParam("USEAWTINTERFACE");
            CArmy currA = this.mwclient.getPlayer().getLockedArmy();
            this.client = new Client(this.myname, this.serverip, this.serverport);
            this.client.game.addGameListener(this);
            this.client.addCloseClientListener(this);
            this.mwclient.getserverConfigs("MMTimeStampLogFile");
            this.mwclient.getserverConfigs("MMShowUnitId");
            this.mwclient.getserverConfigs("MMKeepGameLog");
            this.mwclient.getserverConfigs("MMGameLogName");
            if (this.awtGUI) {
                this.awtGui = new ClientGUI(this.client);
                this.awtGui.initialize();
                this.swingGui = null;
            } else {
                this.awtGui = null;
                this.swingGui = new megamek.client.ui.swing.ClientGUI(this.client);
                this.swingGui.initialize();
            }
            if (this.mwclient.getGameOptions().size() < 1) {
                this.mwclient.setWaiting(true);
                this.mwclient.sendChat("/c RequestOperationSettings");
                while (this.mwclient.isWaiting()) {
                    try {
                        this.mwclient.addToChat("Retrieving Operation Data Please Wait..");
                        Thread.sleep(1000L);
                    }
                    catch (Exception ex) {}
                }
            }
            Vector<IBasicOption> xmlGameOptions = this.mwclient.getGameOptions();
            try {
                this.client.connect();
            }
            catch (Exception ex) {
                this.client = null;
                this.mwclient.showInfoWindow("Couldn't join this game!");
                CampaignData.mwlog.infoLog(this.serverip + " " + this.serverport);
                return;
            }
            try {
                Entity entity;
                while (this.client.getLocalPlayer() == null) {
                    ClientThread.sleep(50L);
                }
                for (int i = 0; i < 1000 && this.client.game.getPhase() == IGame.Phase.PHASE_UNKNOWN; ++i) {
                    ClientThread.sleep(50L);
                }
                if (this.mwclient.getCurrentEnvironment() != null && this.client.game.getPhase() == IGame.Phase.PHASE_LOUNGE) {
                    MapSettings mySettings = new MapSettings(this.mwclient.getMapSize().width, this.mwclient.getMapSize().height, 1, 1);
                    AdvancedTerrain aTerrain = this.mwclient.getCurrentAdvancedTerrain();
                    if (aTerrain != null && aTerrain.isStaticMap()) {
                        mySettings = new MapSettings(aTerrain.getXSize(), aTerrain.getYSize(), aTerrain.getXBoardSize(), aTerrain.getYBoardSize());
                        ArrayList<String> cArmy = new ArrayList<String>();
                        if (aTerrain.getStaticMapName().toLowerCase().endsWith("surprise")) {
                            int maxBoards = aTerrain.getXBoardSize() * aTerrain.getYBoardSize();
                            for (int i = 0; i < maxBoards; ++i) {
                                cArmy.add("[SURPRISE]");
                            }
                            mySettings.setBoardsSelectedVector(cArmy);
                            if (aTerrain.getStaticMapName().indexOf("/") > -1) {
                                String folder = aTerrain.getStaticMapName().substring(0, aTerrain.getStaticMapName().lastIndexOf("/"));
                                mySettings.setBoardsAvailableVector(this.scanForBoards(aTerrain.getXSize(), aTerrain.getYSize(), folder));
                            } else if (aTerrain.getStaticMapName().indexOf("\\") > -1) {
                                String folder = aTerrain.getStaticMapName().substring(0, aTerrain.getStaticMapName().lastIndexOf("\\"));
                                mySettings.setBoardsAvailableVector(this.scanForBoards(aTerrain.getXSize(), aTerrain.getYSize(), folder));
                            } else {
                                mySettings.setBoardsAvailableVector(this.scanForBoards(aTerrain.getXSize(), aTerrain.getYSize(), ""));
                            }
                        } else if (aTerrain.getStaticMapName().toLowerCase().endsWith("generated")) {
                            PlanetEnvironment env = this.mwclient.getCurrentEnvironment();
                            mySettings.setElevationParams(env.getHillyness(), env.getHillElevationRange(), env.getHillInvertProb());
                            mySettings.setWaterParams(env.getWaterMinSpots(), env.getWaterMaxSpots(), env.getWaterMinHexes(), env.getWaterMaxHexes(), env.getWaterDeepProb());
                            mySettings.setForestParams(env.getForestMinSpots(), env.getForestMaxSpots(), env.getForestMinHexes(), env.getForestMaxHexes(), env.getForestHeavyProb());
                            mySettings.setRoughParams(env.getRoughMinSpots(), env.getRoughMaxSpots(), env.getRoughMinHexes(), env.getRoughMaxHexes());
                            mySettings.setSwampParams(env.getSwampMinSpots(), env.getSwampMaxSpots(), env.getSwampMinHexes(), env.getSwampMaxHexes());
                            mySettings.setPavementParams(env.getPavementMinSpots(), env.getPavementMaxSpots(), env.getPavementMinHexes(), env.getPavementMaxHexes());
                            mySettings.setIceParams(env.getIceMinSpots(), env.getIceMaxSpots(), env.getIceMinHexes(), env.getIceMaxHexes());
                            mySettings.setRubbleParams(env.getRubbleMinSpots(), env.getRubbleMaxSpots(), env.getRubbleMinHexes(), env.getRubbleMaxHexes());
                            mySettings.setFortifiedParams(env.getFortifiedMinSpots(), env.getFortifiedMaxSpots(), env.getFortifiedMinHexes(), env.getFortifiedMaxHexes());
                            mySettings.setSpecialFX(env.getFxMod(), env.getProbForestFire(), env.getProbFreeze(), env.getProbFlood(), env.getProbDrought());
                            mySettings.setRiverParam(env.getRiverProb());
                            mySettings.setCliffParam(env.getCliffProb());
                            mySettings.setRoadParam(env.getRoadProb());
                            mySettings.setCraterParam(env.getCraterProb(), env.getCraterMinNum(), env.getCraterMaxNum(), env.getCraterMinRadius(), env.getCraterMaxRadius());
                            mySettings.setAlgorithmToUse(env.getAlgorithm());
                            mySettings.setInvertNegativeTerrain(env.getInvertNegativeTerrain());
                            mySettings.setMountainParams(env.getMountPeaks(), env.getMountWidthMin(), env.getMountWidthMax(), env.getMountHeightMin(), env.getMountHeightMax(), env.getMountStyle());
                            if (env.getTheme().length() > 1) {
                                mySettings.setTheme(env.getTheme());
                            } else {
                                mySettings.setTheme("");
                            }
                            int maxBoards = aTerrain.getXBoardSize() * aTerrain.getYBoardSize();
                            for (int i = 0; i < maxBoards; ++i) {
                                cArmy.add("[GENERATED]");
                            }
                            mySettings.setBoardsSelectedVector(cArmy);
                            if (aTerrain.getStaticMapName().indexOf("/") > -1) {
                                String folder = aTerrain.getStaticMapName().substring(0, aTerrain.getStaticMapName().lastIndexOf("/"));
                                mySettings.setBoardsAvailableVector(this.scanForBoards(aTerrain.getXSize(), aTerrain.getYSize(), folder));
                            } else if (aTerrain.getStaticMapName().indexOf("\\") > -1) {
                                String folder = aTerrain.getStaticMapName().substring(0, aTerrain.getStaticMapName().lastIndexOf("\\"));
                                mySettings.setBoardsAvailableVector(this.scanForBoards(aTerrain.getXSize(), aTerrain.getYSize(), folder));
                            } else {
                                mySettings.setBoardsAvailableVector(this.scanForBoards(aTerrain.getXSize(), aTerrain.getYSize(), ""));
                            }
                            if (this.mwclient.getBuildingTemplate() != null && this.mwclient.getBuildingTemplate().getTotalBuildings() > 0) {
                                ArrayList<BuildingTemplate> buildingList = this.generateRandomBuildings(mySettings, this.mwclient.getBuildingTemplate());
                                mySettings.setBoardBuildings(buildingList);
                            } else if (!env.getCityType().equalsIgnoreCase("NONE")) {
                                mySettings.setRoadParam(0);
                                mySettings.setCityParams(env.getRoads(), env.getCityType(), env.getMinCF(), env.getMaxCF(), env.getMinFloors(), env.getMaxFloors(), env.getCityDensity(), env.getTownSize());
                            }
                        } else {
                            cArmy.add(aTerrain.getStaticMapName());
                            mySettings.setBoardsSelectedVector(cArmy);
                        }
                        PlanetaryConditions planetCondition = new PlanetaryConditions();
                        planetCondition.setGravity((float)aTerrain.getGravity());
                        planetCondition.setTemperature(aTerrain.getTemperature());
                        planetCondition.setAtmosphere(aTerrain.getAtmosphere());
                        planetCondition.setEMI(aTerrain.hasEMI());
                        planetCondition.setFog(aTerrain.getFog());
                        planetCondition.setLight(aTerrain.getLightConditions());
                        planetCondition.setShiftingWindDirection(aTerrain.hasShifitingWindDirection());
                        planetCondition.setShiftingWindStrength(aTerrain.hasShifitingWindStrength());
                        planetCondition.setTerrainAffected(aTerrain.isTerrainAffected());
                        planetCondition.setWeather(aTerrain.getWeatherConditions());
                        planetCondition.setWindDirection(aTerrain.getWindDirection());
                        planetCondition.setWindStrength(aTerrain.getWindStrength());
                        planetCondition.setMaxWindStrength(aTerrain.getMaxWindStrength());
                        nightGame = aTerrain.getLightConditions() > 1;
                        this.client.sendPlanetaryConditions(planetCondition);
                        mySettings.setMedium(this.mwclient.getMapMedium());
                        this.client.sendMapSettings(mySettings);
                    } else {
                        PlanetEnvironment planetEnvironment = this.mwclient.getCurrentEnvironment();
                        mySettings.setElevationParams(planetEnvironment.getHillyness(), planetEnvironment.getHillElevationRange(), planetEnvironment.getHillInvertProb());
                        mySettings.setWaterParams(planetEnvironment.getWaterMinSpots(), planetEnvironment.getWaterMaxSpots(), planetEnvironment.getWaterMinHexes(), planetEnvironment.getWaterMaxHexes(), planetEnvironment.getWaterDeepProb());
                        mySettings.setForestParams(planetEnvironment.getForestMinSpots(), planetEnvironment.getForestMaxSpots(), planetEnvironment.getForestMinHexes(), planetEnvironment.getForestMaxHexes(), planetEnvironment.getForestHeavyProb());
                        mySettings.setRoughParams(planetEnvironment.getRoughMinSpots(), planetEnvironment.getRoughMaxSpots(), planetEnvironment.getRoughMinHexes(), planetEnvironment.getRoughMaxHexes());
                        mySettings.setSwampParams(planetEnvironment.getSwampMinSpots(), planetEnvironment.getSwampMaxSpots(), planetEnvironment.getSwampMinHexes(), planetEnvironment.getSwampMaxHexes());
                        mySettings.setPavementParams(planetEnvironment.getPavementMinSpots(), planetEnvironment.getPavementMaxSpots(), planetEnvironment.getPavementMinHexes(), planetEnvironment.getPavementMaxHexes());
                        mySettings.setIceParams(planetEnvironment.getIceMinSpots(), planetEnvironment.getIceMaxSpots(), planetEnvironment.getIceMinHexes(), planetEnvironment.getIceMaxHexes());
                        mySettings.setRubbleParams(planetEnvironment.getRubbleMinSpots(), planetEnvironment.getRubbleMaxSpots(), planetEnvironment.getRubbleMinHexes(), planetEnvironment.getRubbleMaxHexes());
                        mySettings.setFortifiedParams(planetEnvironment.getFortifiedMinSpots(), planetEnvironment.getFortifiedMaxSpots(), planetEnvironment.getFortifiedMinHexes(), planetEnvironment.getFortifiedMaxHexes());
                        mySettings.setSpecialFX(planetEnvironment.getFxMod(), planetEnvironment.getProbForestFire(), planetEnvironment.getProbFreeze(), planetEnvironment.getProbFlood(), planetEnvironment.getProbDrought());
                        mySettings.setRiverParam(planetEnvironment.getRiverProb());
                        mySettings.setCliffParam(planetEnvironment.getCliffProb());
                        mySettings.setRoadParam(planetEnvironment.getRoadProb());
                        mySettings.setCraterParam(planetEnvironment.getCraterProb(), planetEnvironment.getCraterMinNum(), planetEnvironment.getCraterMaxNum(), planetEnvironment.getCraterMinRadius(), planetEnvironment.getCraterMaxRadius());
                        mySettings.setAlgorithmToUse(planetEnvironment.getAlgorithm());
                        mySettings.setInvertNegativeTerrain(planetEnvironment.getInvertNegativeTerrain());
                        mySettings.setMountainParams(planetEnvironment.getMountPeaks(), planetEnvironment.getMountWidthMin(), planetEnvironment.getMountWidthMax(), planetEnvironment.getMountHeightMin(), planetEnvironment.getMountHeightMax(), planetEnvironment.getMountStyle());
                        if (planetEnvironment.getTheme().length() > 1) {
                            mySettings.setTheme(planetEnvironment.getTheme());
                        } else {
                            mySettings.setTheme("");
                        }
                        ArrayList<String> boardvec = new ArrayList<String>();
                        boardvec.add("[GENERATED]");
                        mySettings.setBoardsSelectedVector(boardvec);
                        if (this.mwclient.getBuildingTemplate() != null && this.mwclient.getBuildingTemplate().getTotalBuildings() > 0) {
                            ArrayList<BuildingTemplate> buildingList = this.generateRandomBuildings(mySettings, this.mwclient.getBuildingTemplate());
                            mySettings.setBoardBuildings(buildingList);
                        } else if (!planetEnvironment.getCityType().equalsIgnoreCase("NONE")) {
                            mySettings.setRoadParam(0);
                            mySettings.setCityParams(planetEnvironment.getRoads(), planetEnvironment.getCityType(), planetEnvironment.getMinCF(), planetEnvironment.getMaxCF(), planetEnvironment.getMinFloors(), planetEnvironment.getMaxFloors(), planetEnvironment.getCityDensity(), planetEnvironment.getTownSize());
                        }
                        mySettings.setMedium(this.mwclient.getMapMedium());
                        this.client.sendMapSettings(mySettings);
                        if (aTerrain != null) {
                            PlanetaryConditions planetCondition = new PlanetaryConditions();
                            planetCondition.setGravity((float)aTerrain.getGravity());
                            planetCondition.setTemperature(aTerrain.getTemperature());
                            planetCondition.setAtmosphere(aTerrain.getAtmosphere());
                            planetCondition.setEMI(aTerrain.hasEMI());
                            planetCondition.setFog(aTerrain.getFog());
                            planetCondition.setLight(aTerrain.getLightConditions());
                            planetCondition.setShiftingWindDirection(aTerrain.hasShifitingWindDirection());
                            planetCondition.setShiftingWindStrength(aTerrain.hasShifitingWindStrength());
                            planetCondition.setTerrainAffected(aTerrain.isTerrainAffected());
                            planetCondition.setWeather(aTerrain.getWeatherConditions());
                            planetCondition.setWindDirection(aTerrain.getWindDirection());
                            planetCondition.setWindStrength(aTerrain.getWindStrength());
                            planetCondition.setMaxWindStrength(aTerrain.getMaxWindStrength());
                            nightGame = aTerrain.getLightConditions() > 1;
                            this.client.sendPlanetaryConditions(planetCondition);
                        }
                    }
                }
                if (this.mwclient.isUsingBots()) {
                    String name = "War Bot" + this.client.getLocalPlayer().getId();
                    this.bot = new TestBot(name, this.client.getHost(), this.client.getPort());
                    this.bot.game.addGameListener(new BotGUI(this.bot));
                    try {
                        this.bot.connect();
                        ClientThread.sleep(125L);
                        while (this.bot.getLocalPlayer() == null) {
                            ClientThread.sleep(50L);
                        }
                        for (int i = 0; i < 1000 && this.bot.game.getPhase() == IGame.Phase.PHASE_UNKNOWN; ++i) {
                            ClientThread.sleep(50L);
                        }
                    }
                    catch (Exception ex) {
                        CampaignData.mwlog.errLog("Bot Error!");
                        CampaignData.mwlog.errLog(ex);
                    }
                    this.bot.retrieveServerInfo();
                    ClientThread.sleep(125L);
                    if (this.awtGUI) {
                        this.awtGui.getBots().put(name, this.bot);
                    } else {
                        this.swingGui.getBots().put(name, this.bot);
                    }
                    if (this.mwclient.isBotsOnSameTeam()) {
                        this.bot.getLocalPlayer().setTeam(5);
                    }
                    Random r = new Random();
                    this.bot.getLocalPlayer().setStartingPos(r.nextInt(11));
                    this.bot.sendPlayerInfo();
                    ClientThread.sleep(125L);
                }
                if (this.client.game == null || this.client.game.getPhase() != IGame.Phase.PHASE_LOUNGE) break block78;
                this.client.game.getOptions().loadOptions();
                if (this.mechs.size() > 0 && xmlGameOptions.size() > 0) {
                    this.client.sendGameOptions("", xmlGameOptions);
                }
                IClientPreferences cs = PreferenceManager.getClientPreferences();
                cs.setStampFilenames(Boolean.parseBoolean(this.mwclient.getserverConfigs("MMTimeStampLogFile")));
                cs.setShowUnitId(Boolean.parseBoolean(this.mwclient.getserverConfigs("MMShowUnitId")));
                cs.setKeepGameLog(Boolean.parseBoolean(this.mwclient.getserverConfigs("MMKeepGameLog")));
                cs.setGameLogFilename(this.mwclient.getserverConfigs("MMGameLogName"));
                if (this.mwclient.getConfig().getParam("UNITCAMO").length() > 0) {
                    this.client.getLocalPlayer().setCamoCategory("-- General --");
                    this.client.getLocalPlayer().setCamoFileName(this.mwclient.getConfig().getParam("UNITCAMO"));
                    playerUpdate = true;
                }
                if (this.bot != null) {
                    this.bot.getLocalPlayer().setNbrMFConventional(this.mwclient.getPlayer().getConventionalMinesAllowed());
                    this.bot.getLocalPlayer().setNbrMFVibra(this.mwclient.getPlayer().getVibraMinesAllowed());
                } else {
                    this.client.getLocalPlayer().setNbrMFConventional(this.mwclient.getPlayer().getConventionalMinesAllowed());
                    this.client.getLocalPlayer().setNbrMFVibra(this.mwclient.getPlayer().getVibraMinesAllowed());
                }
                for (CUnit cUnit : this.mechs) {
                    entity = cUnit.getEntity();
                    entity.setExternalId(cUnit.getId());
                    entity.setOwner(this.client.getLocalPlayer());
                    entity.setCommander(currA.isCommander(cUnit.getId()));
                    entity.setSpotlight(nightGame);
                    entity.setSpotlightState(nightGame);
                    if (entity.isOffBoard()) {
                        int direction = 0;
                        switch (this.mwclient.getPlayerStartingEdge()) {
                            case 4: 
                            case 14: {
                                direction = 2;
                                break;
                            }
                            case 5: 
                            case 6: 
                            case 7: 
                            case 15: 
                            case 16: 
                            case 17: {
                                direction = 1;
                                break;
                            }
                            case 8: 
                            case 18: {
                                direction = 3;
                                break;
                            }
                            default: {
                                direction = 0;
                            }
                        }
                        entity.setOffBoard(entity.getOffBoardDistance(), direction);
                    }
                    entity.setCrew(UnitUtils.createEntityPilot(cUnit));
                    this.client.sendAddEntity(entity);
                    ClientThread.sleep(125L);
                }
                for (CUnit cUnit : this.autoarmy) {
                    entity = cUnit.getEntity();
                    entity.setSpotlight(nightGame);
                    entity.setSpotlightState(nightGame);
                    entity.setExternalId(cUnit.getId());
                    if (this.bot != null) {
                        entity.setOwner(this.bot.getLocalPlayer());
                    } else {
                        entity.setOwner(this.client.getLocalPlayer());
                    }
                    if (entity.getCrew().getName().equalsIgnoreCase("Unnamed") || entity.getCrew().getName().equalsIgnoreCase("vacant")) {
                        Pilot pilot = new Pilot("AutoArtillery", 4, 5);
                        entity.setCrew(pilot);
                    } else {
                        entity.setCrew(UnitUtils.createEntityPilot(cUnit));
                    }
                    if (this.bot != null) {
                        this.bot.sendAddEntity(entity);
                    } else {
                        this.client.sendAddEntity(entity);
                    }
                    ClientThread.sleep(125L);
                }
                if (this.mwclient.getPlayerStartingEdge() != -1) {
                    this.client.getLocalPlayer().setStartingPos(this.mwclient.getPlayerStartingEdge());
                    playerUpdate = true;
                }
                if (this.mechs.size() > 0) {
                    CArmy cArmy = currA;
                    synchronized (cArmy) {
                        if (currA.getC3Network().size() > 0) {
                            playerUpdate = true;
                            for (int slave : currA.getC3Network().keySet()) {
                                this.linkMegaMekC3Units(currA, slave, currA.getC3Network().get(slave));
                            }
                            if (this.awtGUI) {
                                this.awtGui.chatlounge.refreshEntities();
                            } else {
                                this.swingGui.chatlounge.refreshEntities();
                            }
                        }
                    }
                }
                if (this.mwclient.getPlayer().getTeamNumber() > 0) {
                    this.client.getLocalPlayer().setTeam(this.mwclient.getPlayer().getTeamNumber());
                    playerUpdate = true;
                }
                if (playerUpdate) {
                    this.client.sendPlayerInfo();
                    if (this.bot != null) {
                        this.bot.sendPlayerInfo();
                    }
                }
            }
            catch (Exception e) {
                CampaignData.mwlog.errLog(e);
            }
        }
    }

    public void gamePlayerStatusChange(GameEvent e) {
    }

    @Override
    public void gameTurnChange(GameTurnChangeEvent e) {
        if (this.client != null) {
            if (this.getTurn() == 0 && (this.myname.equals(this.serverName) || this.serverName.startsWith("[Dedicated]"))) {
                this.mwclient.serverSend("SHS|" + this.serverName + "|Running");
            } else if (this.client.game.getPhase() != this.currentPhase && this.client.game.getOptions().booleanOption("paranoid_autosave") && !this.client.getLocalPlayer().isObserver()) {
                this.sendServerGameUpdate();
                this.currentPhase = this.client.game.getPhase();
            }
            ++this.turn;
        }
    }

    @Override
    public void gamePhaseChange(GamePhaseChangeEvent e) {
        try {
            if (this.client.game.getPhase() == IGame.Phase.PHASE_VICTORY) {
                Iterator<Client> i;
                while (this.client.getLocalPlayer() == null) {
                    ClientThread.sleep(50L);
                }
                this.mwclient.getPlayer().setConventionalMinesAllowed(0);
                this.mwclient.getPlayer().setVibraMinesAllowed(0);
                this.mwclient.setUsingBots(false);
                this.mwclient.setEnvironment(null, null, 0);
                this.mwclient.setAdvancedTerrain(null);
                this.mwclient.setPlayerStartingEdge(-1);
                this.mwclient.getGameOptions().clear();
                if (this.awtGUI) {
                    i = this.awtGui.getBots().values().iterator();
                    while (i.hasNext()) {
                        i.next().die();
                    }
                    this.awtGui.getBots().clear();
                } else {
                    i = this.swingGui.getBots().values().iterator();
                    while (i.hasNext()) {
                        i.next().die();
                    }
                    this.swingGui.getBots().clear();
                }
                if (this.client.game.getAllEntitiesOwnedBy(this.client.getLocalPlayer()) < 1) {
                    return;
                }
                MMGame toUse = this.mwclient.getServers().get(this.serverName);
                this.mwclient.serverSend("SGR|" + toUse.getHostName());
                CampaignData.mwlog.infoLog("GAME END");
            } else if (this.client.game.getPhase() == IGame.Phase.PHASE_END_REPORT) {
                if (this.client.getLocalPlayer().isObserver()) {
                    return;
                }
                this.sendServerGameUpdate();
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error reporting game!");
            CampaignData.mwlog.errLog(ex);
        }
    }

    @Override
    public void gameEntityRemove(GameEntityRemoveEvent e) {
        if (this.client.getLocalPlayer().isObserver()) {
            return;
        }
        Entity removedE = e.getEntity();
        if (removedE.getOwner().getName().startsWith("War Bot")) {
            return;
        }
        String toSend = SerializeEntity.serializeEntity(removedE, true, false, this.mwclient.isUsingAdvanceRepairs());
        this.mwclient.serverSend("IPU|" + toSend);
    }

    @Override
    public void gamePlayerConnected(GamePlayerConnectedEvent e) {
    }

    @Override
    public void gamePlayerDisconnected(GamePlayerDisconnectedEvent e) {
    }

    @Override
    public void gamePlayerChange(GamePlayerChangeEvent e) {
    }

    @Override
    public void gamePlayerChat(GamePlayerChatEvent e) {
    }

    @Override
    public void gameReport(GameReportEvent e) {
    }

    @Override
    public void gameEnd(GameEndEvent e) {
    }

    @Override
    public void gameBoardNew(GameBoardNewEvent e) {
    }

    @Override
    public void gameBoardChanged(GameBoardChangeEvent e) {
    }

    @Override
    public void gameSettingsChange(GameSettingsChangeEvent e) {
    }

    @Override
    public void gameMapQuery(GameMapQueryEvent e) {
    }

    @Override
    public void gameEntityNew(GameEntityNewEvent e) {
    }

    @Override
    public void gameEntityNewOffboard(GameEntityNewOffboardEvent e) {
    }

    @Override
    public void gameEntityChange(GameEntityChangeEvent e) {
    }

    @Override
    public void gameNewAction(GameNewActionEvent e) {
    }

    @Override
    public void clientClosed() {
        PreferenceManager.getInstance().save();
        if (this.bot != null) {
            this.bot.die();
            this.bot = null;
        }
        this.client = null;
        this.mwclient.closingGame(this.serverName);
        System.gc();
    }

    public void linkMegaMekC3Units(CArmy army, Integer slaveid, Integer masterid) {
        Entity c3Unit = null;
        Entity c3Master = null;
        while (c3Unit == null || c3Master == null) {
            try {
                for (Entity en : this.client.game.getEntitiesVector()) {
                    if (c3Unit == null && en.getExternalId() == slaveid.intValue()) {
                        c3Unit = en;
                    }
                    if (c3Master != null || en.getExternalId() != masterid.intValue()) continue;
                    c3Master = en;
                }
                ClientThread.sleep(10L);
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Error in linkMegaMekC3Units");
                CampaignData.mwlog.errLog(ex);
            }
        }
        if (c3Unit == null || c3Master == null) {
            CampaignData.mwlog.errLog("Null Units c3Unit: " + c3Unit + " C3Master: " + c3Master);
            return;
        }
        try {
            CUnit masterUnit = (CUnit)army.getUnit(masterid);
            if (!masterUnit.hasC3SlavesLinkedTo(army) && masterUnit.hasBeenC3LinkedTo(army) && (masterUnit.getC3Level() == 2 || masterUnit.getC3Level() == 4)) {
                if (c3Master.getC3MasterId() == -1) {
                    c3Master.setShutDown(false);
                    c3Master.setC3Master(c3Master);
                    this.client.sendUpdateEntity(c3Master);
                }
            } else if (c3Master.getC3MasterId() != -1) {
                c3Master.setShutDown(false);
                c3Master.setC3Master(-1);
                this.client.sendUpdateEntity(c3Master);
            }
            c3Unit.setShutDown(false);
            c3Unit.setC3Master(c3Master);
            this.client.sendUpdateEntity(c3Unit);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            CampaignData.mwlog.errLog("Error in setting up C3Network");
        }
    }

    public static Comparator<? super Object> stringComparator() {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String s1 = ((String)o1).toLowerCase();
                String s2 = ((String)o2).toLowerCase();
                return s1.compareTo(s2);
            }
        };
    }

    private ArrayList<String> scanForBoards(int boardWidth, int boardHeight, String folder) {
        ArrayList<String> boards = new ArrayList<String>();
        File boardDir = new File("data/boards/" + folder);
        if (!boardDir.isDirectory()) {
            return boards;
        }
        String[] fileList = boardDir.list();
        Vector<String> tempList = new Vector<String>(1, 1);
        Comparator<? super Object> sortComp = ClientThread.stringComparator();
        for (int i = 0; i < fileList.length; ++i) {
            if (fileList[i].indexOf(".board") == -1) continue;
            String path = fileList[i];
            if (folder.trim().length() > 0) {
                path = folder + "/" + fileList[i];
            }
            if (!Board.boardIsSize(path, boardWidth, boardHeight)) continue;
            tempList.addElement(path.substring(0, path.lastIndexOf(".board")));
        }
        if (tempList.size() > 0) {
            boards.add("[RANDOM]");
            boards.add("[SURPRISE]");
            boards.add("[GENERATED]");
            Collections.sort(tempList, sortComp);
            for (int loop = 0; loop < tempList.size(); ++loop) {
                boards.add((String)tempList.elementAt(loop));
            }
        } else {
            boards.add("[GENERATED]");
        }
        return boards;
    }

    private ArrayList<BuildingTemplate> generateRandomBuildings(MapSettings mapSettings, Buildings buildingTemplate) {
        ArrayList<BuildingTemplate> buildingList = new ArrayList<BuildingTemplate>();
        ArrayList<String> buildingTypes = new ArrayList<String>();
        int width = mapSettings.getBoardWidth();
        int height = mapSettings.getBoardHeight();
        int minHeight = 0;
        int minWidth = 0;
        switch (buildingTemplate.getStartingEdge()) {
            case 2: {
                height = 5;
                minHeight = 1;
                break;
            }
            case 6: {
                if (height > 5) {
                    minHeight = height - 5;
                }
                height = 5;
                break;
            }
            case 4: {
                if (width > 5) {
                    minWidth = width - 5;
                }
                width = 5;
                break;
            }
            case 8: {
                width = 5;
                minWidth = 1;
                break;
            }
        }
        StringTokenizer types = new StringTokenizer(buildingTemplate.getBuildingType(), ",");
        while (types.hasMoreTokens()) {
            buildingTypes.add(types.nextToken());
        }
        int typeSize = buildingTypes.size();
        Random r = new Random();
        TreeSet<String> tempMap = new TreeSet<String>();
        Coords coord = new Coords();
        String stringCoord = "";
        for (int count = 0; count < buildingTemplate.getTotalBuildings(); ++count) {
            int y;
            int x;
            int loops = 0;
            boolean CFx2 = false;
            ArrayList<Coords> coordList = new ArrayList<Coords>();
            do {
                if (loops++ > 100) {
                    CFx2 = true;
                    break;
                }
                x = r.nextInt(width) + minWidth;
                y = r.nextInt(height) + minHeight;
                if (x >= mapSettings.getBoardWidth()) {
                    x = mapSettings.getBoardWidth() - 2;
                } else if (x <= 1) {
                    x = 2;
                }
                if (y >= mapSettings.getBoardHeight()) {
                    y = mapSettings.getBoardHeight() - 2;
                } else if (y <= 1) {
                    y = 2;
                }
                coord = new Coords(x, y);
            } while (tempMap.contains(stringCoord = x + "," + y));
            tempMap.add(stringCoord);
            coordList.add(coord);
            int floors = buildingTemplate.getMaxFloors() - buildingTemplate.getMinFloors();
            floors = floors <= 0 ? buildingTemplate.getMinFloors() : r.nextInt(floors) + buildingTemplate.getMinFloors();
            int totalCF = buildingTemplate.getMaxCF() - buildingTemplate.getMinCF();
            totalCF = totalCF <= 0 ? buildingTemplate.getMinCF() : r.nextInt(totalCF) + buildingTemplate.getMinCF();
            if (CFx2) {
                totalCF *= 2;
            }
            int type = 1;
            try {
                type = typeSize == 1 ? Integer.parseInt((String)buildingTypes.get(0)) : Integer.parseInt((String)buildingTypes.get(r.nextInt(typeSize)));
            }
            catch (Exception ex) {
                // empty catch block
            }
            buildingList.add(new BuildingTemplate(type, coordList, totalCF, floors, -1));
        }
        return buildingList;
    }

    public int getBuildingsLeft() {
        Enumeration<Building> buildings = this.client.game.getBoard().getBuildings();
        int buildingCount = 0;
        while (buildings.hasMoreElements()) {
            buildings.nextElement();
            ++buildingCount;
        }
        return buildingCount;
    }

    private void sendServerGameUpdate() {
        Enumeration<Entity> en = this.client.game.getEntities();
        while (en.hasMoreElements()) {
            Entity ent = en.nextElement();
            if (ent.getOwner().getName().startsWith("War Bot") || !(ent instanceof MechWarrior) && !UnitUtils.hasArmorDamage(ent) && !UnitUtils.hasISDamage(ent) && !UnitUtils.hasCriticalDamage(ent) && !UnitUtils.hasLowAmmo(ent) && !UnitUtils.hasEmptyAmmo(ent)) continue;
            if (ent instanceof Mech && ent.getInternal(1) <= 0) {
                this.mwclient.serverSend("IPU|" + SerializeEntity.serializeEntity(ent, true, true, this.mwclient.isUsingAdvanceRepairs()));
                continue;
            }
            this.mwclient.serverSend("IPU|" + SerializeEntity.serializeEntity(ent, true, false, this.mwclient.isUsingAdvanceRepairs()));
        }
    }
}

