/*
 * Decompiled with CFR 0.152.
 */
package client.campaign;

import client.MWClient;
import client.campaign.CBMUnit;
import client.campaign.CPlayer;
import client.gui.dialog.ArmyViewerDialog;
import common.BMEquipment;
import common.CampaignData;
import common.util.ComponentToCritsConverter;
import common.util.TokenReader;
import java.io.File;
import java.util.StringTokenizer;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCampaign {
    MWClient mwclient;
    CPlayer Player;
    TreeMap<Integer, CBMUnit> BlackMarket = new TreeMap();
    TreeMap<String, BMEquipment> BlackMarketParts = new TreeMap();
    TreeMap<String, ComponentToCritsConverter> ComponentConverter = new TreeMap();

    public CCampaign(MWClient client) {
        this.mwclient = client;
        this.Player = new CPlayer(this.mwclient);
        File f = new File("data/campaign/");
        if (f.exists() && !f.isDirectory()) {
            f.delete();
        }
        if (!f.exists()) {
            try {
                f.mkdirs();
            }
            catch (Exception e) {
                CampaignData.mwlog.errLog(e);
            }
        }
    }

    public boolean decodeCommand(String command) {
        StringTokenizer ST = new StringTokenizer(command, "|");
        String element = TokenReader.readString(ST);
        command = command.substring(3);
        if (element.equals("PS")) {
            if (!this.Player.setData(command)) {
                this.mwclient.addToChat("Player data load failed!<br>");
                return false;
            }
            return true;
        }
        if (element.equals("CC")) {
            String commandid = TokenReader.readString(ST);
            if (commandid.equals("AT")) {
                if (this.mwclient.getConfig().isParam("ENABLEATTACKSOUND")) {
                    this.mwclient.doPlaySound(this.mwclient.getConfigParam("SOUNDONATTACK"));
                }
                this.mwclient.addToChat("<font color=\"red\"><b>Your forces are under attack!</b></font>", 1);
                this.mwclient.addToChat("<font color=\"red\"><b>Your forces are under attack!</b></font>", 2, "Server");
                if (this.mwclient.getConfig().isParam("POPUPONATTACK")) {
                    int opID = TokenReader.readInt(ST);
                    int teams = TokenReader.readInt(ST);
                    new ArmyViewerDialog(this.mwclient, null, ST, 0, null, null, opID, teams);
                }
            }
            if (commandid.equals("NT")) {
                int time = TokenReader.readInt(ST);
                boolean decrement = TokenReader.readBoolean(ST);
                this.mwclient.processTick(time);
                if (decrement) {
                    for (CBMUnit currUnit : this.BlackMarket.values()) {
                        currUnit.decrementSalesTicks();
                    }
                    this.mwclient.refreshGUI(6);
                }
            }
            return true;
        }
        if (element.equals("CA")) {
            if (!this.setData(command)) {
                this.mwclient.addToChat("<b>Error: Campaign data load failed.</b><br>");
                return false;
            }
            return true;
        }
        if (element.equals("PL")) {
            if (!this.Player.decodeCommand(command)) {
                this.mwclient.addToChat("<b>Error: Player data load failed.</b><br>");
                return false;
            }
            return true;
        }
        if (element.equals("MS")) {
            if (!this.showMsg(command)) {
                this.mwclient.addToChat("<b>Error: Message show failed.</b><br>");
                return false;
            }
            return true;
        }
        if (element.equals("ST")) {
            if (!this.showStatus(command)) {
                this.mwclient.addToChat("<b>Error: Status show failed.</b><br>");
                return false;
            }
            return true;
        }
        this.mwclient.addToChat("<b>Error: Wrong campaign command from server.</b><br>");
        return false;
    }

    protected boolean setData(String command) {
        return true;
    }

    public void setBMData(String command) {
        StringTokenizer mainTokenizer = new StringTokenizer(command, "$");
        this.BlackMarket.clear();
        while (mainTokenizer.hasMoreTokens()) {
            CBMUnit currBMUnit = new CBMUnit(TokenReader.readString(mainTokenizer), this);
            this.BlackMarket.put(currBMUnit.getAuctionID(), currBMUnit);
        }
    }

    public void removeBMUnit(String command) {
        this.BlackMarket.remove(Integer.valueOf(command));
    }

    public void addBMUnit(String command) {
        CBMUnit bmUnit = new CBMUnit(command, this);
        this.BlackMarket.put(bmUnit.getAuctionID(), bmUnit);
    }

    public void changeBMUnit(String command) {
        CBMUnit bmUnit = new CBMUnit(command, this);
        this.BlackMarket.remove(bmUnit.getAuctionID());
        this.BlackMarket.put(bmUnit.getAuctionID(), bmUnit);
    }

    protected boolean showMsg(String command) {
        return true;
    }

    protected boolean showStatus(String command) {
        this.mwclient.addToChat(command);
        return true;
    }

    public void setPlayer(CPlayer tplayer) {
        this.Player = tplayer;
    }

    public CPlayer getPlayer() {
        return this.Player;
    }

    public TreeMap<Integer, CBMUnit> getBlackMarket() {
        return this.BlackMarket;
    }

    public TreeMap<String, BMEquipment> getBlackMarketParts() {
        return this.BlackMarketParts;
    }

    public TreeMap<String, ComponentToCritsConverter> getComponentConverter() {
        return this.ComponentConverter;
    }

    public void setComponentConverter(String converterData) {
        try {
            StringTokenizer st = new StringTokenizer(converterData, "#");
            this.ComponentConverter.clear();
            while (st.hasMoreTokens()) {
                ComponentToCritsConverter converter = new ComponentToCritsConverter();
                converter.setCritName(TokenReader.readString(st));
                converter.setMinCritLevel(TokenReader.readInt(st));
                converter.setComponentUsedType(TokenReader.readInt(st));
                converter.setComponentUsedWeight(TokenReader.readInt(st));
                this.ComponentConverter.put(converter.getCritName(), converter);
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }
}

