/*
 * Decompiled with CFR 0.152.
 */
package client.campaign;

import common.CampaignData;
import common.campaign.pilot.Pilot;
import common.campaign.pilot.skills.PilotSkill;
import common.util.TokenReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPersonalPilotQueues {
    private ArrayList<LinkedList<Pilot>> mekPilots = new ArrayList();
    private ArrayList<LinkedList<Pilot>> protoPilots = new ArrayList();
    private ArrayList<LinkedList<Pilot>> aeroPilots = new ArrayList();

    public CPersonalPilotQueues() {
        for (int i = 0; i <= 3; ++i) {
            this.mekPilots.add(i, new LinkedList());
            this.protoPilots.add(i, new LinkedList());
            this.aeroPilots.add(i, new LinkedList());
        }
    }

    private ArrayList<LinkedList<Pilot>> getUnitTypeQueue(int typeToGet) {
        if (typeToGet == 3) {
            return this.protoPilots;
        }
        if (typeToGet == 5) {
            return this.aeroPilots;
        }
        return this.mekPilots;
    }

    private Pilot getPilotFromString(String pilotData) {
        StringTokenizer subTokenizer = new StringTokenizer(pilotData, "#");
        String pilotname = TokenReader.readString(subTokenizer);
        int exp = TokenReader.readInt(subTokenizer);
        int gunnery = TokenReader.readInt(subTokenizer);
        int piloting = TokenReader.readInt(subTokenizer);
        Pilot pilot = new Pilot(pilotname, gunnery, piloting);
        pilot.setExperience(exp);
        int skillAmount = TokenReader.readInt(subTokenizer);
        for (int i = 0; i < skillAmount; ++i) {
            PilotSkill skill = new PilotSkill(TokenReader.readInt(subTokenizer), TokenReader.readString(subTokenizer), TokenReader.readInt(subTokenizer), TokenReader.readString(subTokenizer));
            if (skill.getName().equals("Weapon Specialist")) {
                pilot.setWeapon(TokenReader.readString(subTokenizer));
            }
            if (skill.getName().equals("Trait")) {
                pilot.setCurrentFaction(TokenReader.readString(subTokenizer));
            }
            if (skill.getName().equals("Edge")) {
                pilot.setTac(TokenReader.readBoolean(subTokenizer));
                pilot.setKO(TokenReader.readBoolean(subTokenizer));
                pilot.setHeadHit(TokenReader.readBoolean(subTokenizer));
                pilot.setExplosion(TokenReader.readBoolean(subTokenizer));
            }
            pilot.getSkills().add(skill);
        }
        pilot.setKills(TokenReader.readInt(subTokenizer));
        return pilot;
    }

    public void addPilot(StringTokenizer ST) {
        try {
            int pilotType = TokenReader.readInt(ST);
            int pilotClass = TokenReader.readInt(ST);
            Pilot pilot = this.getPilotFromString(TokenReader.readString(ST));
            this.getUnitTypeQueue(pilotType).get(pilotClass).addLast(pilot);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error while adding pilot to PPQ");
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void removePilot(StringTokenizer ST) {
        try {
            int pilotType = TokenReader.readInt(ST);
            int pilotClass = TokenReader.readInt(ST);
            int pilotPosition = TokenReader.readInt(ST);
            this.getUnitTypeQueue(pilotType).get(pilotClass).remove(pilotPosition);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Unable to remove pilot form queue");
            CampaignData.mwlog.errLog(ex);
        }
    }

    public LinkedList<Pilot> getPilotQueue(int unitType, int weightClass) {
        return this.getUnitTypeQueue(unitType).get(weightClass);
    }

    public void fromString(String stringFromServer) {
        Pilot toAdd;
        int count;
        int weightClass;
        StringTokenizer mainTokenizer = new StringTokenizer(stringFromServer, "$");
        for (LinkedList<Pilot> currList : this.mekPilots) {
            currList.clear();
        }
        for (LinkedList<Pilot> currList : this.protoPilots) {
            currList.clear();
        }
        for (LinkedList<Pilot> currList : this.aeroPilots) {
            currList.clear();
        }
        for (weightClass = 0; weightClass <= 3; ++weightClass) {
            int listSize = TokenReader.readInt(mainTokenizer);
            for (count = 0; count < listSize; ++count) {
                toAdd = this.getPilotFromString(TokenReader.readString(mainTokenizer));
                this.getUnitTypeQueue(0).get(weightClass).addLast(toAdd);
            }
        }
        for (weightClass = 0; weightClass <= 3; ++weightClass) {
            int listSize = TokenReader.readInt(mainTokenizer);
            for (count = 0; count < listSize; ++count) {
                toAdd = this.getPilotFromString(TokenReader.readString(mainTokenizer));
                this.getUnitTypeQueue(3).get(weightClass).addLast(toAdd);
            }
        }
        for (weightClass = 0; weightClass <= 3; ++weightClass) {
            int listSize = TokenReader.readInt(mainTokenizer);
            for (count = 0; count < listSize; ++count) {
                toAdd = this.getPilotFromString(TokenReader.readString(mainTokenizer));
                this.getUnitTypeQueue(5).get(weightClass).addLast(toAdd);
            }
        }
    }
}

