/*
 * Decompiled with CFR 0.152.
 */
package client.campaign;

import client.MWClient;
import common.CampaignData;
import common.House;
import common.MegaMekPilotOption;
import common.Unit;
import common.campaign.pilot.Pilot;
import common.campaign.pilot.skills.PilotSkill;
import common.util.TokenReader;
import common.util.UnitUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import megamek.common.AmmoType;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.WeaponType;

public class CUnit
extends Unit {
    protected Entity UnitEntity;
    private int BV;
    private int scrappableFor = 0;
    private boolean pilotIsRepairing = false;
    private MWClient mwclient;

    public CUnit() {
        this.init();
    }

    public CUnit(MWClient mwclient) {
        this.mwclient = mwclient;
        this.init();
    }

    private void init() {
        this.UnitEntity = null;
        this.BV = 0;
        this.setStatus(1);
        this.setProducer("unknown origin");
    }

    public boolean setData(String data) {
        String unitDamage = null;
        CampaignData.mwlog.infoLog("PDATA: " + data);
        StringTokenizer ST = new StringTokenizer(data, "$");
        String element = TokenReader.readString(ST);
        if (!element.equals("CM")) {
            return false;
        }
        this.setUnitFilename(TokenReader.readString(ST));
        this.setId(TokenReader.readInt(ST));
        this.setStatus(TokenReader.readInt(ST));
        this.setProducer(TokenReader.readString(ST));
        String pilotname = "John Denver";
        int gunnery = 4;
        int piloting = 5;
        int exp = 0;
        Pilot p = null;
        StringTokenizer STR = new StringTokenizer(TokenReader.readString(ST), "#");
        pilotname = TokenReader.readString(STR);
        exp = TokenReader.readInt(STR);
        gunnery = TokenReader.readInt(STR);
        piloting = TokenReader.readInt(STR);
        p = new Pilot(pilotname, gunnery, piloting);
        p.setExperience(exp);
        int skillAmount = TokenReader.readInt(STR);
        for (int i = 0; i < skillAmount; ++i) {
            PilotSkill skill = new PilotSkill(TokenReader.readInt(STR), TokenReader.readString(STR), TokenReader.readInt(STR), TokenReader.readString(STR));
            if (skill.getName().equals("Weapon Specialist")) {
                p.setWeapon(TokenReader.readString(STR));
            }
            if (skill.getName().equals("Trait")) {
                p.setTraitName(TokenReader.readString(STR));
            }
            if (skill.getName().equals("Edge")) {
                p.setTac(TokenReader.readBoolean(STR));
                p.setKO(TokenReader.readBoolean(STR));
                p.setHeadHit(TokenReader.readBoolean(STR));
                p.setExplosion(TokenReader.readBoolean(STR));
            }
            p.getSkills().add(skill);
        }
        p.setKills(TokenReader.readInt(STR));
        p.setHits(TokenReader.readInt(STR));
        int mmoptionsamount = TokenReader.readInt(ST);
        for (int i = 0; i < mmoptionsamount; ++i) {
            MegaMekPilotOption mo = new MegaMekPilotOption(TokenReader.readString(ST), Boolean.parseBoolean(TokenReader.readString(ST)));
            p.addMegamekOption(mo);
        }
        this.setType(TokenReader.readInt(ST));
        this.setPilot(p);
        this.BV = Math.max(TokenReader.readInt(ST), 0);
        this.setWeightclass(TokenReader.readInt(ST));
        this.setId(TokenReader.readInt(ST));
        this.createEntity();
        if (this.UnitEntity == null) {
            CampaignData.mwlog.errLog("Cannot load entity!");
            return false;
        }
        if (this.getModelName().startsWith("Error") || this.getModelName().startsWith("OMG")) {
            this.UnitEntity.setExternalId(this.getId());
            this.UnitEntity.setCrew(new megamek.common.Pilot(p.getName(), p.getGunnery(), p.getPiloting()));
            return true;
        }
        if (this.UnitEntity instanceof Mech && ST.hasMoreElements()) {
            ((Mech)this.UnitEntity).setAutoEject(Boolean.parseBoolean(TokenReader.readString(ST)));
        }
        try {
            int maxCrits = TokenReader.readInt(ST);
            ArrayList<Mounted> e = this.UnitEntity.getAmmo();
            for (int count = 0; count < maxCrits; ++count) {
                int weaponType = TokenReader.readInt(ST);
                String ammoName = TokenReader.readString(ST);
                int shots = TokenReader.readInt(ST);
                boolean hotloaded = TokenReader.readBoolean(ST);
                Mounted mWeapon = e.get(count);
                AmmoType at = this.getEntityAmmo(weaponType, ammoName);
                mWeapon.changeAmmoType(at);
                mWeapon.setShotsLeft(shots);
                mWeapon.setHotLoad(hotloaded);
            }
        }
        catch (Exception ex) {
            return true;
        }
        int maxMachineGuns = TokenReader.readInt(ST);
        for (int count = 0; count < maxMachineGuns; ++count) {
            int location = TokenReader.readInt(ST);
            int slot = TokenReader.readInt(ST);
            boolean selection = TokenReader.readBoolean(ST);
            CriticalSlot cs = this.UnitEntity.getCritical(location, slot);
            Mounted mg = this.UnitEntity.getEquipment(cs.getIndex());
            mg.setRapidfire(selection);
        }
        TokenReader.readString(ST);
        TokenReader.readString(ST);
        this.UnitEntity.setTargSysType(Math.max(0, TokenReader.readInt(ST)));
        this.scrappableFor = TokenReader.readInt(ST);
        unitDamage = TokenReader.readString(ST);
        this.pilotIsRepairing = TokenReader.readBoolean(ST);
        this.setRepairCosts(TokenReader.readInt(ST), TokenReader.readInt(ST));
        this.UnitEntity.setExternalId(this.getId());
        this.UnitEntity.setCrew(new megamek.common.Pilot(p.getName(), p.getGunnery(), p.getPiloting()));
        if (unitDamage != null) {
            UnitUtils.applyBattleDamage(this.UnitEntity, unitDamage);
        }
        this.getC3Type(this.UnitEntity);
        return true;
    }

    public void setAutoUnitData(String filename, int distance, int edge) {
        this.setUnitFilename(filename);
        this.setPilot(new Pilot("Autopilot", 4, 5));
        this.createEntity();
        if (distance > 0) {
            this.UnitEntity.setOffBoard(distance, edge);
        }
    }

    public String getSmallDescription() {
        if (this.getType() == 0 || this.getType() == 1 || this.getType() == 5) {
            return this.getModelName() + " [" + this.getPilot().getGunnery() + "/" + this.getPilot().getPiloting() + "]";
        }
        if (this.getType() == 2 || this.getType() == 4) {
            if (((Infantry)this.UnitEntity).isAntiMek()) {
                return this.getModelName() + " [" + this.getPilot().getGunnery() + "/" + this.getPilot().getPiloting() + "]";
            }
            return this.getModelName() + " [" + this.getPilot().getGunnery() + "]";
        }
        return this.getModelName() + " [" + this.getPilot().getGunnery() + "]";
    }

    public String getDisplayInfo(String armyText) {
        String capacity;
        String tinfo = "";
        tinfo = this.getType() == 0 && !this.UnitEntity.isOmni() ? "<html><body>#" + this.getId() + " " + this.UnitEntity.getChassis() + ", " + this.getModelName() : "<html><body>#" + this.getId() + " " + this.getModelName();
        tinfo = this.getType() == 0 || this.getType() == 1 || this.getType() == 5 ? tinfo + " (" + this.getPilot().getName() + ", " + this.getPilot().getGunnery() + "/" + this.getPilot().getPiloting() + ") <br>" : (this.getType() == 4 || this.getType() == 2 ? (((Infantry)this.UnitEntity).isAntiMek() ? tinfo + " (" + this.getPilot().getName() + ", " + this.getPilot().getGunnery() + "/" + this.getPilot().getPiloting() + ") <br>" : tinfo + " (" + this.getPilot().getName() + ", " + this.getPilot().getGunnery() + ") <br>") : tinfo + " (" + this.getPilot().getName() + ", " + this.getPilot().getGunnery() + ") <br>");
        if (this.getType() == 1) {
            tinfo = tinfo + " Movement: " + this.getEntity().getMovementModeAsString() + "<br>";
        }
        tinfo = tinfo + "BV: " + this.BV + " // Exp: " + this.getPilot().getExperience() + " // Kills: " + this.getPilot().getKills() + "<br> ";
        if (this.getPilot().getSkills().size() > 0) {
            tinfo = tinfo + "Skills: ";
            tinfo = tinfo + this.getPilot().getSkillString(false, this.mwclient.getData().getHouseByName(this.mwclient.getPlayer().getHouse()).getBasePilotSkill(this.getType()));
            tinfo = tinfo + "<br>";
        }
        if (this.getPilot().getHits() > 0) {
            tinfo = tinfo + "Hits: " + Integer.toString(this.getPilot().getHits()) + "<br>";
        }
        if (!armyText.equals("")) {
            tinfo = tinfo + armyText + "<br>";
        }
        if ((capacity = this.getEntity().getUnusedString()) != null && capacity.startsWith("Troops")) {
            capacity = capacity.substring(9);
            tinfo = tinfo + "Cargo: " + capacity + "<br>";
        }
        if (this.getLifeTimeRepairCost() > 0) {
            tinfo = tinfo + "Repair Costs: " + this.getCurrentRepairCost() + "/" + this.getLifeTimeRepairCost() + "<br>";
        }
        tinfo = tinfo + this.getProducer();
        if (this.scrappableFor > 0 && !Boolean.parseBoolean(this.mwclient.getserverConfigs("UseAdvanceRepair")) && !Boolean.parseBoolean(this.mwclient.getserverConfigs("UseSimpleRepair"))) {
            tinfo = tinfo + "<br><br><b>Scrap Value: " + this.mwclient.moneyOrFluMessage(true, false, this.scrappableFor) + "</b>";
        }
        tinfo = tinfo + "</body></html>";
        return tinfo;
    }

    public String getModelName() {
        if (this.getType() != 0) {
            return new String(this.getEntity().getChassis() + " " + this.getEntity().getModel()).trim();
        }
        if (this.getEntity().isOmni()) {
            return new String(this.getEntity().getChassis() + " " + this.getEntity().getModel()).trim();
        }
        if (this.getEntity().getModel().trim().length() > 0) {
            return this.getEntity().getModel().trim();
        }
        return this.getEntity().getChassis().trim();
    }

    public int getBV() {
        if (this.BV < 0) {
            return 0;
        }
        return this.BV;
    }

    public Entity getEntity() {
        return this.UnitEntity;
    }

    public void createEntity() {
        this.UnitEntity = UnitUtils.createEntity(this.getUnitFilename());
        if (this.UnitEntity == null) {
            CampaignData.mwlog.errLog("Error unit failed to load. Exiting.");
            System.exit(1);
        }
        if (this.UnitEntity.getChassis().equals("Error")) {
            this.setProducer("Unable to find " + this.getUnitFilename() + " on clients system!");
        }
        this.getC3Type(this.UnitEntity);
    }

    public boolean isOmni() {
        boolean isOmni = this.getEntity().isOmni();
        String targetChassis = this.getEntity().getChassis();
        if (this.getType() == 1 && !isOmni) {
            try {
                FileInputStream fis = new FileInputStream("./data/mechfiles/omnivehiclelist.txt");
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                while (dis.ready()) {
                    String chassie = dis.readLine();
                    if (!targetChassis.equalsIgnoreCase(chassie)) continue;
                    dis.close();
                    fis.close();
                    return true;
                }
                dis.close();
                fis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isOmni;
    }

    public int getOriginalBV() {
        return this.UnitEntity.calculateBattleValue(false, false);
    }

    public void applyRepairs(String data) {
        this.createEntity();
        UnitUtils.applyBattleDamage(this.UnitEntity, data);
    }

    public boolean getPilotIsReparing() {
        return this.pilotIsRepairing;
    }

    public static int getPriceForUnit(MWClient mwclient, int weightclass, int type_id, House producer) {
        int result = Integer.MAX_VALUE;
        try {
            String classtype = Unit.getWeightClassDesc(weightclass) + Unit.getTypeClassDesc(type_id) + "Price";
            result = type_id == 0 ? Integer.parseInt(mwclient.getserverConfigs(Unit.getWeightClassDesc(weightclass) + "Price")) : Integer.parseInt(mwclient.getserverConfigs(classtype));
            if ((result += producer.getHouseUnitPriceMod(type_id, weightclass)) < 0) {
                result = 0;
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
        return result;
    }

    public static int getInfluenceForUnit(MWClient mwclient, int weightclass, int type_id, House producer) {
        int result = Integer.MAX_VALUE;
        String classtype = Unit.getWeightClassDesc(weightclass) + Unit.getTypeClassDesc(type_id) + "Inf";
        result = type_id == 0 ? Integer.parseInt(mwclient.getserverConfigs(Unit.getWeightClassDesc(weightclass) + "Inf")) : Integer.parseInt(mwclient.getserverConfigs(classtype));
        if ((result += producer.getHouseUnitFluMod(type_id, weightclass)) < 0) {
            result = 0;
        }
        return result;
    }

    public static int getPPForUnit(MWClient mwclient, int weightclass, int type_id, House producer) {
        int result = Integer.MAX_VALUE;
        String classtype = Unit.getWeightClassDesc(weightclass) + Unit.getTypeClassDesc(type_id) + "PP";
        result = type_id == 0 ? Integer.parseInt(mwclient.getserverConfigs(Unit.getWeightClassDesc(weightclass) + "PP")) : Integer.parseInt(mwclient.getserverConfigs(classtype));
        if ((result += producer.getHouseUnitComponentMod(type_id, weightclass)) < 0) {
            result = 0;
        }
        return result;
    }

    public static double getArmorCost(Entity unit, MWClient client) {
        double cost = 0.0;
        if (Boolean.parseBoolean(client.getserverConfigs("UsePartsRepair"))) {
            return 0.0;
        }
        String armorCost = "CostPoint" + UnitUtils.getArmorShortName(unit);
        cost = Double.parseDouble(client.getserverConfigs(armorCost));
        return cost;
    }

    public static double getStructureCost(Entity unit, MWClient client) {
        double cost = 0.0;
        if (Boolean.parseBoolean(client.getserverConfigs("UsePartsRepair"))) {
            return 0.0;
        }
        String armorCost = "CostPoint" + UnitUtils.getInternalShortName(unit) + "IS";
        cost = Double.parseDouble(client.getserverConfigs(armorCost));
        return cost;
    }

    public static double getCritCost(Entity unit, MWClient client, CriticalSlot crit) {
        WeaponType weapon;
        Mounted mounted;
        double cost = 0.0;
        if (Boolean.parseBoolean(client.getserverConfigs("UsePartsRepair"))) {
            return 0.0;
        }
        if (crit == null) {
            return 0.0;
        }
        if (crit.isBreached() && !crit.isDamaged()) {
            return 0.0;
        }
        cost = UnitUtils.isEngineCrit(crit) ? Double.parseDouble(client.getserverConfigs("EngineCritRepairCost")) : (crit.getType() == 0 ? (crit.isMissing() ? Double.parseDouble(client.getserverConfigs("SystemCritReplaceCost")) : Double.parseDouble(client.getserverConfigs("SystemCritRepairCost"))) : ((mounted = unit.getEquipment(crit.getIndex())).getType() instanceof WeaponType ? ((weapon = (WeaponType)mounted.getType()).hasFlag(131072L) ? (crit.isMissing() ? Double.parseDouble(client.getserverConfigs("EnergyWeaponCritReplaceCost")) : Double.parseDouble(client.getserverConfigs("EnergyWeaponCritRepairCost"))) : (weapon.hasFlag(65536L) ? (crit.isMissing() ? Double.parseDouble(client.getserverConfigs("BallisticCritReplaceCost")) : Double.parseDouble(client.getserverConfigs("BallisticCritRepairCost"))) : (weapon.hasFlag(262144L) ? (crit.isMissing() ? Double.parseDouble(client.getserverConfigs("MissileCritReplaceCost")) : Double.parseDouble(client.getserverConfigs("MissileCritRepairCost"))) : (crit.isMissing() ? Double.parseDouble(client.getserverConfigs("EquipmentCritReplaceCost")) : Double.parseDouble(client.getserverConfigs("EquipmentCritRepairCost")))))) : (crit.isMissing() ? Double.parseDouble(client.getserverConfigs("EquipmentCritReplaceCost")) : Double.parseDouble(client.getserverConfigs("EquipmentCritRepairCost")))));
        cost = Math.max(cost, 1.0);
        return cost;
    }
}

