/*
 * Decompiled with CFR 0.152.
 */
package client.cmd;

import client.MWClient;
import client.campaign.CPlayer;
import client.campaign.CUnit;
import client.cmd.Command;
import client.gui.dialog.AdvancedRepairDialog;
import common.CampaignData;
import common.campaign.pilot.Pilot;
import common.util.TokenReader;
import common.util.UnitUtils;
import java.util.StringTokenizer;

public class PL
extends Command {
    public PL(MWClient mwclient) {
        super(mwclient);
    }

    public void execute(String input) {
        StringTokenizer st = this.decode(input);
        String cmd = TokenReader.readString(st);
        CPlayer player = this.mwclient.getPlayer();
        if (!st.hasMoreTokens()) {
            return;
        }
        if (cmd.equals("FCU")) {
            this.mwclient.updateClient();
            return;
        }
        if (cmd.equals("RA")) {
            player.removeArmy(TokenReader.readInt(st));
        } else if (cmd.equals("LA")) {
            player.playerLockArmy(TokenReader.readInt(st));
        } else if (cmd.equals("ULA")) {
            player.playerUnlockArmy(TokenReader.readInt(st));
        } else if (cmd.equals("TAD")) {
            player.toggleArmyDisabled(TokenReader.readInt(st));
        } else if (cmd.equals("SAD")) {
            player.setArmyData(TokenReader.readString(st));
        } else if (cmd.equals("SABV")) {
            player.setArmyBV(TokenReader.readString(st));
        } else if (cmd.equals("AAU")) {
            player.addArmyUnit(TokenReader.readString(st));
        } else if (cmd.equals("RAU")) {
            player.removeArmyUnit(TokenReader.readString(st));
        } else if (cmd.equals("HD")) {
            player.setHangarData(TokenReader.readString(st));
        } else if (cmd.equals("RU")) {
            player.removeUnit(TokenReader.readInt(st));
        } else if (cmd.equals("SE")) {
            player.setExp(TokenReader.readInt(st));
        } else if (cmd.equals("SM")) {
            player.setMoney(TokenReader.readInt(st));
        } else if (cmd.equals("SB")) {
            player.setBays(TokenReader.readInt(st));
        } else if (cmd.equals("SF")) {
            player.setFreeBays(TokenReader.readInt(st));
        } else if (cmd.equals("SI")) {
            player.setInfluence(TokenReader.readInt(st));
        } else if (cmd.equals("SR")) {
            player.setRating(TokenReader.readDouble(st));
        } else if (cmd.equals("SRP")) {
            player.setRewardPoints(TokenReader.readInt(st));
        } else if (cmd.equals("SH")) {
            player.setHouse(TokenReader.readString(st));
        } else if (cmd.equals("ST")) {
            player.setTechnicians(TokenReader.readInt(st));
        } else if (cmd.equals("SSN")) {
            player.setSubFaction(TokenReader.readString(st));
        } else if (cmd.equals("AAA")) {
            player.setAutoArmy(st);
        } else if (cmd.equals("AAM")) {
            player.setMines(st);
        } else if (cmd.equals("GEA")) {
            player.setAutoGunEmplacements(st);
        } else if (cmd.equals("SUS")) {
            player.setUnitStatus(TokenReader.readString(st));
        } else if (cmd.equals("RNA")) {
            player.setArmyName(TokenReader.readString(st));
        } else if (cmd.equals("SAB")) {
            player.setArmyLimit(TokenReader.readString(st));
        } else if (cmd.equals("SAL")) {
            player.setArmyLock(TokenReader.readString(st));
        } else if (cmd.equals("UU")) {
            player.updateUnitData(st);
        } else if (cmd.equals("UUMG")) {
            player.updateUnitMachineGuns(st);
        } else if (cmd.equals("BMW")) {
            if (this.mwclient.getConfig().isParam("ENABLEBMSOUND")) {
                this.mwclient.doPlaySound(this.mwclient.getConfig().getParam("SOUNDONBMWIN"));
            }
        } else if (cmd.equals("PPQ")) {
            player.getPersonalPilotQueue().fromString(TokenReader.readString(st));
        } else if (cmd.equals("PEU")) {
            player.setPlayerExcludes(TokenReader.readString(st), "$");
        } else if (cmd.equals("AEU")) {
            player.setAdminExcludes(TokenReader.readString(st), "$");
        } else if (cmd.equals("RPU")) {
            player.repositionArmyUnit(TokenReader.readString(st));
        } else if (cmd.equals("UOE")) {
            player.updateOperations(TokenReader.readString(st));
        } else if (cmd.equals("UTT")) {
            player.updateTotalTechs(TokenReader.readString(st));
        } else if (cmd.equals("UAT")) {
            player.updateAvailableTechs(TokenReader.readString(st));
        } else if (cmd.equals("GBB")) {
            this.mwclient.getConnector().closeConnection();
        } else if (cmd.equals("UB")) {
            this.mwclient.setUsingBots(TokenReader.readBoolean(st));
        } else if (cmd.equals("BOST")) {
            this.mwclient.setBotsOnSameTeam(TokenReader.readBoolean(st));
        } else if (cmd.equals("SHFF")) {
            player.setHouseFightingFor(TokenReader.readString(st));
        } else if (cmd.equals("SUL")) {
            player.setLogo(TokenReader.readString(st));
            this.mwclient.getMainFrame().getMainPanel().getPlayerPanel().refresh();
        } else if (cmd.equals("AP2PPQ")) {
            player.getPersonalPilotQueue().addPilot(st);
        } else if (cmd.equals("RPPPQ")) {
            player.getPersonalPilotQueue().removePilot(st);
        } else if (cmd.equals("RSOD")) {
            this.mwclient.retrieveOpData("short", TokenReader.readString(st));
        } else if (cmd.equals("UCP")) {
            this.mwclient.updateParam(st);
        } else if (cmd.equals("SOFL")) {
            this.mwclient.setServerOpFlags(st);
        } else if (cmd.equals("SAOFS")) {
            player.setArmyOpForceSize(TokenReader.readString(st));
        } else if (cmd.equals("FC")) {
            player.setFactionConfigs(TokenReader.readString(st));
        } else if (cmd.equals("UPBM")) {
            this.mwclient.updatePartsBlackMarket(TokenReader.readString(st));
        } else if (cmd.equals("UPPC")) {
            this.mwclient.updatePlayerPartsCache(TokenReader.readString(st));
        } else if (cmd.equals("RPPC")) {
            this.mwclient.getPlayer().getPartsCache().fromString(st);
        } else if (cmd.equals("STN")) {
            this.mwclient.getPlayer().setTeamNumber(TokenReader.readInt(st));
        } else if (cmd.equals("VUI")) {
            StringTokenizer data = new StringTokenizer(TokenReader.readString(st), "#");
            String filename = TokenReader.readString(data);
            int BV = TokenReader.readInt(data);
            int gunnery = TokenReader.readInt(data);
            int piloting = TokenReader.readInt(data);
            String damage = "";
            if (data.hasMoreElements()) {
                damage = TokenReader.readString(data);
            }
            this.mwclient.getMainFrame().getMainPanel().getHSPanel().showInfoWindow(filename, BV, gunnery, piloting, damage);
        } else if (cmd.equals("VURD")) {
            StringTokenizer data = new StringTokenizer(TokenReader.readString(st), "#");
            String filename = TokenReader.readString(data);
            String damage = TokenReader.readString(data);
            CUnit unit = new CUnit(this.mwclient);
            unit.setUnitFilename(filename);
            unit.createEntity();
            unit.setPilot(new Pilot("Jeeves", 4, 5));
            UnitUtils.applyBattleDamage(unit.getEntity(), damage);
            new AdvancedRepairDialog(this.mwclient, unit, unit.getEntity(), false);
        } else if (cmd.equals("CPPC")) {
            this.mwclient.getPlayer().getPartsCache().clear();
        } else if (cmd.equals("UDAO")) {
            this.mwclient.updateOpData(true);
            if (!this.mwclient.isDedicated()) {
                this.mwclient.getMainFrame().updateAttackMenu();
            }
        } else if (cmd.equals("RMF")) {
            this.mwclient.retrieveMul(TokenReader.readString(st));
        } else if (cmd.equals("SMFD")) {
            this.mwclient.getMainFrame().showMulFileList(TokenReader.readString(st));
        } else if (cmd.equals("CAFM")) {
            this.mwclient.getMainFrame().createArmyFromMul(TokenReader.readString(st));
        } else if (cmd.equals("USU")) {
            while (st.hasMoreTokens()) {
                boolean addSupport = TokenReader.readBoolean(st);
                String unitName = TokenReader.readString(st);
                if (unitName == null) continue;
                if (addSupport) {
                    player.getMyHouse().addUnitSupported(unitName);
                    continue;
                }
                player.getMyHouse().removeUnitSupported(unitName);
            }
            CampaignData.mwlog.infoLog(player.getMyHouse().getSupportedUnits().toString());
        } else if (cmd.equals("CSU")) {
            CampaignData.mwlog.infoLog("Clearing Supported Units");
            player.getMyHouse().supportedUnits.clear();
            player.getMyHouse().setNonFactionUnitsCostMore(Boolean.parseBoolean(this.mwclient.getserverConfigs("UseNonFactionUnitsIncreasedTechs")));
        } else if (cmd.equals("SMA")) {
            this.mwclient.getPlayer().setMULCreatedArmy(st);
        } else if (cmd.equals("ANH")) {
            this.mwclient.createNewHouse(st);
        } else if (cmd.equals("RPF")) {
            int id = TokenReader.readInt(st);
            this.mwclient.getData().removeHouse(id);
        } else if (cmd.equals("UDT")) {
            this.mwclient.addToChat(TokenReader.readString(st), this.mwclient.getConfig().getIntParam("USERDEFINDMESSAGETAB"));
        } else if (cmd.equals("CCC")) {
            this.mwclient.getCampaign().setComponentConverter(st.nextToken());
        } else if (cmd.equals("SUD")) {
            try {
                StringBuilder userData = new StringBuilder("/c sendclientdata#");
                String[] userDataSet = new String[]{"user.name", "user.language", "user.country", "user.timezone", "os.name", "os.arch", "os.version", "java.version"};
                for (int pos = 0; pos < userDataSet.length; ++pos) {
                    String property = System.getProperty(userDataSet[pos], "Unknown");
                    userData.append(property);
                    userData.append("#");
                }
                this.mwclient.sendChat(userData.toString());
            }
            catch (Exception ex) {}
        } else if (cmd.equals("ROP")) {
            this.mwclient.getPlayer().setAutoReorder(TokenReader.readBoolean(st));
        } else {
            return;
        }
        this.mwclient.refreshGUI(5);
        this.mwclient.refreshGUI(2);
        this.mwclient.refreshGUI(6);
    }
}

